/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import jetbrains.charisma.persistent.DatabaseBackupConfigImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.util.CompressBackupUtil;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.SystemPropertyUtils;

public class DatabaseBackupFolder {
    public File getRootBackupFolder() {
        String savedLocation = (String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"databaseBackupConfig")), (String)"backupLocation", String.class, null);
        String backupDir = savedLocation == null || savedLocation.isEmpty() ? "backup" : SystemPropertyUtils.resolvePlaceholders((String)savedLocation);
        File result = new File(backupDir);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getNextBackupFile() {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"databaseBackupConfig")), (String)"zipArhive", Boolean.class, null)).booleanValue()) {
            return new File(this.getRootBackupFolder(), CompressBackupUtil.getTimeStampedZipFileName());
        }
        return new File(this.getRootBackupFolder(), CompressBackupUtil.getTimeStampedTarGzFileName());
    }

    public File getBackupFile(final String name) {
        return (File)Sequence.fromIterable(this.doListBackupFiles()).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<File>(){

            public boolean accept(File it) {
                return it.getName().equals(name);
            }
        });
    }

    @NotNull
    public Iterable<File> listBackupFiles() {
        return Sequence.fromIterable(this.doListBackupFiles()).sort((_FunctionTypes._return_P1_E0)new ISelector<File, Comparable<?>>(){

            public Comparable<?> select(File it) {
                return it.lastModified();
            }
        }, false);
    }

    @NotNull
    private Iterable<File> doListBackupFiles() {
        final File backupDirectory = this.getRootBackupFolder();
        Collection files = FileUtils.listFiles((File)backupDirectory, (IOFileFilter)new AndFileFilter((IOFileFilter)new SuffixFileFilter(DatabaseBackupConfigImpl.FILE_FORMATS), CanReadFileFilter.CAN_READ), (IOFileFilter)new AbstractFileFilter(){

            public boolean accept(File file) {
                return file.getParent().equals(backupDirectory.getAbsolutePath());
            }
        });
        ArrayList fileList = new ArrayList();
        fileList.addAll(files);
        return files;
    }

    public boolean deleteBackup(String name) {
        File fileToRemove = this.getBackupFile(name);
        try {
            boolean deleted = fileToRemove.delete();
            return deleted;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

