/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.InputStream;
import java.util.Set;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.BaseCommentImpl;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.charisma.persistent.IssueCommentImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import org.jetbrains.annotations.NotNull;

public class DraftCommentImpl
extends BaseCommentImpl {
    private static String __ENTITY_TYPE__ = "DraftComment";

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor("", _entityType_);
        UndirectedAssociationSemantics.setManyToOne((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"draftComments", (String)"owner", (Entity)entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)Long.valueOf(System.currentTimeMillis()));
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"owner"), null)) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"usesMarkdown", (Comparable)Boolean.valueOf(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"owner"), (String)"User")).shouldUseMarkdown(AssociationSemantics.getToOne((Entity)entity, (String)"owner"))), Boolean.class);
        }
        return entity;
    }

    protected Entity _constructor(Entity owner, Entity issue, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        UndirectedAssociationSemantics.setManyToOne((Entity)owner, (String)"draftComments", (String)"owner", (Entity)entity);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"issue", (Entity)issue);
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"text", (String)"");
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)Long.valueOf(System.currentTimeMillis()));
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"usesMarkdown", (Comparable)Boolean.valueOf(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)owner, (String)"User")).shouldUseMarkdown(owner)), Boolean.class);
        return entity;
    }

    @Override
    public boolean isPropertyRequired(String name, Entity entity) {
        if (name.equals("text")) {
            return this.isCommentTextRequired(entity);
        }
        return false;
    }

    @Override
    public Entity getIssue(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)"issue");
    }

    @Override
    public Entity getAuthor(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)"owner");
    }

    @Override
    public void addAttachment(Entity attachment, Entity entity) {
        ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)attachment, (String)"IssueAttachment")).setDraft(true, attachment);
        UndirectedAssociationSemantics.createOneToMany((Entity)entity, (String)"attachments", (String)"comment", (Entity)attachment);
        DirectedAssociationSemantics.setToOne((Entity)attachment, (String)"issue", (Entity)((DraftCommentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"DraftComment")).getIssue(entity));
    }

    @Override
    public void removeAttachment(Entity attachment, Entity entity) {
        UndirectedAssociationSemantics.removeOneToMany((Entity)entity, (String)"attachments", (String)"comment", (Entity)attachment);
        PrimitiveAssociationSemantics.setBlob((Entity)attachment, (String)"content", (InputStream)null);
        PrimitiveAssociationSemantics.set((Entity)attachment, (String)"removed", (Comparable)Boolean.valueOf(true), Boolean.class);
    }

    @Override
    public void copy(Entity comment, Entity entity) {
        super.copy(comment, entity);
        if (DnqUtils._instanceOf((Object)comment, (String)"DraftComment")) {
            Entity c = DnqUtils.cast((Object)comment, (String)"DraftComment");
            UndirectedAssociationSemantics.setManyToOne((Entity)AssociationSemantics.getToOne((Entity)c, (String)"owner"), (String)"draftComments", (String)"owner", (Entity)c);
            DirectedAssociationSemantics.setToOne((Entity)c, (String)"issue", (Entity)AssociationSemantics.getToOne((Entity)c, (String)"issue"));
        }
    }

    public Entity report(Entity entity) {
        Entity comment = IssueCommentImpl.constructor(entity);
        this.moveAttachmentsToIssue(comment, entity);
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"Issue")).update(AssociationSemantics.getToOne((Entity)entity, (String)"issue"));
        EntityOperations.remove((Entity)entity);
        return comment;
    }

    @Override
    public boolean isAccessible(Entity user, Operation operation, Entity entity) {
        return EntityOperations.equals((Entity)user, (Object)AssociationSemantics.getToOne((Entity)entity, (String)"owner"));
    }

    private void moveAttachmentsToIssue(Entity comment, Entity entity) {
        for (Entity a : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"attachments"))) {
            ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"IssueAttachment")).setDraft(false, a);
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"Issue")).addAttachment(a, AssociationSemantics.getToOne((Entity)entity, (String)"issue"));
            UndirectedAssociationSemantics.createOneToMany((Entity)comment, (String)"attachments", (String)"comment", (Entity)a);
            PrimitiveAssociationSemantics.set((Entity)a, (String)"created", (Comparable)((Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"created", null)));
            if (!this.isSecured(entity) || ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"IssueAttachment")).isSecured(a)) continue;
            ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"IssueAttachment")).setPermitted(AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"), AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"), a);
        }
    }

    @Override
    public void checkLicense(Entity entity) {
    }

    public void update(Entity comment, Entity entity) {
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"text", (String)PrimitiveAssociationSemantics.getBlobAsString((Entity)comment, (String)"text"));
    }

    @Override
    public boolean isCommentTextRequired(Entity entity) {
        return false;
    }

    public static Entity constructor() {
        return ((DraftCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity constructor(Entity owner, Entity issue) {
        return ((DraftCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(owner, issue, __ENTITY_TYPE__);
    }

    public static Entity getOrCreate(Entity owner, Entity issue) {
        return DraftCommentImpl.findOrCreate(owner, issue, new String[]{"owner", "issue"});
    }

    public static Iterable<Entity> getEmptyDrafts(Entity owner) {
        return QueryOperations.query(null, (String)"DraftComment", (NodeBase)new And((NodeBase)new LinkEqual("owner", owner), (NodeBase)new PropertyEqual("text", (Comparable)null)));
    }

    protected static DnqUtils.QueryingEntityCreator getEntityCreator(String entityType, Entity owner, Entity issue, final Set<String> queriedParams) {
        final DnqUtils.QueryingEntityCreator parent = DnqUtils.getEntityCreator((String)entityType, queriedParams);
        final Entity __var__owner = owner;
        final Entity __var__issue = issue;
        String __var__text = "";
        final Long __var__created = System.currentTimeMillis();
        final boolean __var__usesMarkdown = ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)owner, (String)"User")).shouldUseMarkdown(owner);
        return new DnqUtils.QueryingEntityCreator(entityType){

            public Iterable<Entity> query() {
                Iterable result = parent.query();
                if (queriedParams.contains("owner")) {
                    result = QueryOperations.query((Iterable)result, (String)"DraftComment", (NodeBase)new LinkEqual("owner", __var__owner));
                }
                if (queriedParams.contains("issue")) {
                    result = QueryOperations.query((Iterable)result, (String)"DraftComment", (NodeBase)new LinkEqual("issue", __var__issue));
                }
                if (queriedParams.contains("text")) {
                    result = QueryOperations.query((Iterable)result, (String)"DraftComment", (NodeBase)new PropertyEqual("text", (Comparable)((Object)"")));
                }
                if (queriedParams.contains("created")) {
                    result = QueryOperations.query((Iterable)result, (String)"DraftComment", (NodeBase)new PropertyEqual("created", (Comparable)__var__created));
                }
                if (queriedParams.contains("usesMarkdown")) {
                    result = QueryOperations.query((Iterable)result, (String)"DraftComment", (NodeBase)new PropertyEqual("usesMarkdown", (Comparable)Boolean.valueOf(__var__usesMarkdown)));
                }
                return result;
            }

            public void created(@NotNull Entity entity) {
                parent.created(entity);
                UndirectedAssociationSemantics.setManyToOne((Entity)__var__owner, (String)"draftComments", (String)"owner", (Entity)entity);
                DirectedAssociationSemantics.setToOne((Entity)entity, (String)"issue", (Entity)__var__issue);
                PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"text", (String)"");
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)__var__created);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"usesMarkdown", (Comparable)Boolean.valueOf(__var__usesMarkdown), Boolean.class);
            }
        };
    }

    public static Entity findOrCreate(Entity owner, Entity issue, String[] queriedParams) {
        return DraftCommentImpl.getEntityCreator(__ENTITY_TYPE__, owner, issue, BasePersistentClassImpl.buildSet((Object[])queriedParams)).create((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
    }
}

