/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;

public class IssueAccessUtil {
    public static boolean isAccessibleNonDraft(Entity issue, Operation operation, Entity user, GroupsGetter permittedGroupsGetter, UsersGetter permittedUsersGetter, Entity project) {
        Entity reporter = AssociationSemantics.getToOne((Entity)issue, (String)"reporter");
        if (EntityOperations.equals((Entity)reporter, (Object)user) && (operation == Operation.READ || operation == Operation.UPDATE || operation == Operation.UPDATE_WATCHES || operation == Operation.VIEW_WATCHERS || operation == Operation.LINK) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission("Issue", Operation.CREATE, project, user)) {
            return true;
        }
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission("Issue", operation, project, user) && (EntityOperations.equals((Entity)reporter, (Object)user) || IssueAccessUtil.isSecuredIssueAccessible(issue, user, permittedGroupsGetter, permittedUsersGetter, project));
    }

    public static boolean isSecuredIssueAccessible(Entity issue, Entity user, GroupsGetter permittedGroupGetter, UsersGetter permittedUsersGetter) {
        return IssueAccessUtil.isSecuredIssueAccessible(issue, user, permittedGroupGetter, permittedUsersGetter, AssociationSemantics.getToOne((Entity)issue, (String)"project"));
    }

    public static boolean isSecuredIssueAccessible(Entity issue, Entity user, GroupsGetter permittedGroupGetter, UsersGetter permittedUsersGetter, Entity project) {
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.READ_HIDDEN_STUFF, project, user) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.READ_ISSUE, project, user)) {
            return true;
        }
        Iterable permittedUsers = permittedUsersGetter == null ? AssociationSemantics.getToMany((Entity)issue, (String)"permittedUser") : permittedUsersGetter.invoke();
        if (QueryOperations.contains((Iterable)permittedUsers, (Entity)user)) {
            return true;
        }
        Iterable permittedGroups = permittedGroupGetter == null ? AssociationSemantics.getToMany((Entity)issue, (String)"permittedGroup") : permittedGroupGetter.invoke();
        if (QueryOperations.isEmpty((Iterable)permittedGroups)) {
            return QueryOperations.isEmpty((Iterable)permittedUsers);
        }
        return QueryOperations.contains((Iterable)permittedGroups, (Entity)((Entity)ServiceLocator.getBean((String)"allUsersGroup"))) || !QueryOperations.isEmpty((Iterable)QueryOperations.intersect((Iterable)permittedGroups, (Iterable)AssociationSemantics.getToMany((Entity)user, (String)"groups")));
    }

    public static interface ProjectGetter {
        public Entity invoke();
    }

    public static interface UsersGetter {
        public Iterable<Entity> invoke();
    }

    public static interface GroupsGetter {
        public Iterable<Entity> invoke();
    }
}

