/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.util.Collection;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.BaseCommentImpl;
import jetbrains.charisma.persistent.ConstraintsErrorMessageUtil;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class IssueCommentImpl
extends BaseCommentImpl {
    private static String __ENTITY_TYPE__ = "IssueComment";
    protected static Log log = LogFactory.getLog(IssueCommentImpl.class);

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(null, _entityType_);
        return entity;
    }

    protected Entity _constructor(String text, Entity author, String _entityType_) {
        Entity entity = super._constructor(text, _entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"author", (Entity)author);
        return entity;
    }

    protected Entity _constructor(String text, Entity author, Entity issue, String _entityType_) {
        Entity entity = super._constructor(text, _entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"author", (Entity)author);
        AggregationAssociationSemantics.setManyToOne((Entity)issue, (String)"comments", (String)"issue", (Entity)entity);
        return entity;
    }

    protected Entity _constructor(Entity comment, String _entityType_) {
        Entity entity = super._constructor(PrimitiveAssociationSemantics.getBlobAsString((Entity)comment, (String)"text"), _entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"usesMarkdown", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)comment, (String)"usesMarkdown", Boolean.class, null)), Boolean.class);
        this.copy(comment, entity);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"author", (Entity)AssociationSemantics.getToOne((Entity)comment, (String)"owner"));
        AggregationAssociationSemantics.setManyToOne((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"issue"), (String)"comments", (String)"issue", (Entity)entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    @Override
    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("author".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ConstraintsErrorMessageUtil.createReportAboutComments(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComment.comment_author_in", new Object[0]), linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        if ("updatedBy".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ConstraintsErrorMessageUtil.createReportAboutComments(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComment.user_who_has_updated_comments_in", new Object[0]), linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    @Override
    public boolean isPropertyRequired(String name, Entity entity) {
        if (name.equals("text")) {
            return this.isCommentTextRequired(entity);
        }
        return false;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"), (Entity)((Entity)ServiceLocator.getBean((String)"allUsersGroup")))) {
            UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedComments");
            UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleComments");
        }
        if (!UserGroupImpl.isPermittedGroupChangeAllowed() && (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedUser") && !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser")) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedGroup") && !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")))) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComment.You_can_t_set_permitted_group_to_issue_comment_due_to_license_restrictions", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComment.You_can_t_set_permitted_group_to_issue_comment_due_to_license_restrictions", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        if (EntityOperations.isNew((Entity)entity) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"author"), (String)"User")).isService(AssociationSemantics.getToOne((Entity)entity, (String)"author"))) {
            throw new LogicException("Service users are not permitted to create comments. Consider using regular user account instead.");
        }
        if (EntityOperations.isNew((Entity)entity) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedGroup") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedUser") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"deleted")) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"Issue")).updateCommentsCount(AssociationSemantics.getToOne((Entity)entity, (String)"issue"));
        }
        if (EntityOperations.isNew((Entity)entity) && ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"Issue")).isDraft(AssociationSemantics.getToOne((Entity)entity, (String)"issue")) && !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"Issue")).becomesReported(AssociationSemantics.getToOne((Entity)entity, (String)"issue"))) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComment.Comment_cannot_be_added_to_draft", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComment.Comment_cannot_be_added_to_draft", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"deleted")) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"Issue")).update(AssociationSemantics.getToOne((Entity)entity, (String)"issue"));
        }
    }

    @Override
    public Entity getAuthor(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)"author");
    }

    @Override
    public void addAttachment(Entity attachment, Entity entity) {
        ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)attachment, (String)"IssueAttachment")).setDraft(false, attachment);
        UndirectedAssociationSemantics.createOneToMany((Entity)entity, (String)"attachments", (String)"comment", (Entity)attachment);
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueComment")).getIssue(entity), (String)"Issue")).addAttachment(attachment, ((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueComment")).getIssue(entity));
    }

    @Override
    public void removeAttachment(Entity attachment, Entity entity) {
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueComment")).getIssue(entity), (String)"Issue")).removeAttachment(attachment, ((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueComment")).getIssue(entity));
    }

    @NotNull
    public Long getUpdated(Entity entity) {
        return DateTimeOperations.isNull((Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"updated", null))) ? (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"created", null) : (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"updated", null);
    }

    public String getText(Entity entity) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"deleted", Boolean.class, (Object)false)).booleanValue()) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueComment.Comment_was_deleted", new Object[0]);
        }
        return PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"text");
    }

    public Entity getUpdatedBy(Entity entity) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"updatedBy"), null) ? AssociationSemantics.getToOne((Entity)entity, (String)"author") : AssociationSemantics.getToOne((Entity)entity, (String)"updatedBy");
    }

    public void delete(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"deleted", (Comparable)Boolean.valueOf(true), Boolean.class);
    }

    public void restore(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"deleted", (Comparable)Boolean.valueOf(false), Boolean.class);
    }

    public void deletePermanently(Entity entity) {
        EntityOperations.remove((Entity)entity);
    }

    @Override
    public Entity getIssue(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)"issue");
    }

    public String getReplyText(Entity entity) {
        return String.format("{quote}%n%s%n{quote}%n", PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"text"));
    }

    public boolean isAccessible(Entity entity) {
        return this.isAccessible(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), Operation.READ, entity);
    }

    public boolean isAccessible(Operation operation, Entity entity) {
        return this.isAccessible(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), operation, entity);
    }

    @Override
    public boolean isAccessible(Entity user, Operation operation, Entity entity) {
        if (EntityOperations.isRemoved((Entity)user) || EntityOperations.isRemoved((Entity)entity)) {
            return false;
        }
        if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"author"), (Object)user)) {
            if (operation == Operation.READ) {
                return true;
            }
        } else {
            if (operation == Operation.READ && !((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueComment")).isSecuredCommentAccessible(user, entity)) {
                return false;
            }
            if (operation == Operation.UPDATE) {
                operation = Operation.UPDATE_NOT_OWN;
            }
            if (operation == Operation.DELETE) {
                operation = Operation.DELETE_NOT_OWN;
            }
        }
        return operation != null && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission("IssueComment", operation, AssociationSemantics.getToOne((Entity)this.getIssue(entity), (String)"project"), user);
    }

    @Override
    public boolean isSecuredCommentAccessible(Entity user, Entity entity) {
        if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"project"), null)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No project can be found for an issue comment " + entity.getId()));
            }
            return super.isSecuredCommentAccessible(user, entity);
        }
        Entity project = AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"issue"), (String)"project");
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.READ_HIDDEN_STUFF, project, user) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.READ_COMMENT, user) || super.isSecuredCommentAccessible(user, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUrl(Entity entity) {
        Entity issue = AssociationSemantics.getToOne((Entity)entity, (String)"issue");
        String url = null;
        BuilderThreadContext.initNonLocalBuilderThreadContext();
        try {
            url = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getUrl(true, issue) + "#comment=" + entity.getId();
        }
        finally {
            BuilderThreadContext.close();
        }
        return url;
    }

    public boolean isLogicallyDeleted(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"deleted", Boolean.class, null);
    }

    public static Entity constructor() {
        return ((IssueCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity constructor(String text, Entity author) {
        return ((IssueCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(text, author, __ENTITY_TYPE__);
    }

    public static Entity constructor(String text, Entity author, Entity issue) {
        return ((IssueCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(text, author, issue, __ENTITY_TYPE__);
    }

    public static Entity constructor(Entity comment) {
        return ((IssueCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(comment, __ENTITY_TYPE__);
    }
}

