/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.charisma.links.persistent.DirectedLink;
import jetbrains.charisma.misc.SerializedIdsEntityIterable;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.watchFolder.InMemoryStableSortIterable;
import jetbrains.charisma.smartui.watchFolder.ReorderIterator;
import jetbrains.charisma.smartui.watchFolder.SortIterableWithCallBack;
import jetbrains.charisma.smartui.watchFolder.WatchFolderOrderedIssuesIterable;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.SortIterable;
import jetbrains.exodus.query.StaticTypedEntityIterable;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.OrderedEntitiesListener;
import jetbrains.youtrack.core.persistent.IdsSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrderedIssuesProvider<T extends Entity> {
    protected static Log log = LogFactory.getLog(OrderedIssuesProvider.class);
    protected final T issueFolder;

    public OrderedIssuesProvider(T issueFolder) {
        this.issueFolder = issueFolder;
    }

    public T getIssueFolder() {
        return this.issueFolder;
    }

    public abstract String getQuery();

    public ReorderIterator moveIssue(@NotNull Entity moved, @Nullable Entity leading, Entity currentUser) {
        return this.moveIssue(moved, leading, currentUser, null);
    }

    public ReorderIterator moveIssue(@NotNull Entity moved, @Nullable Entity leading, Entity currentUser, @Nullable DirectedLink link) {
        ReorderIterator iterator;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Iterable<Entity> issues = this.getIssuesWithCustomOrder(currentUser, new Context(), null);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
            iterator = new WatchFolderOrderedIssuesIterable(issues, (Entity)this.issueFolder, moved, leading, link).iterator();
            ((IdsSerializer)ServiceLocator.getBean((String)"idsSerializer")).serialize1((Iterator)iterator, (OutputStream)gzipOutputStream);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PrimitiveAssociationSemantics.setBlob(this.issueFolder, (String)"customOrder", (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return iterator;
    }

    public Iterable<Entity> getIssuesWithCustomOrder(@NotNull Entity user, @NotNull IContext context, OrderedEntitiesListener callback) {
        return this.applyCustomOrder(this.getIssues(user, context, true), callback);
    }

    public Iterable<Entity> getIssues(@NotNull Entity user, @NotNull IContext context, boolean sort) {
        return this.getIssues(user, context, true, sort);
    }

    public void resetIssuePosition(Entity issue) {
        long entityId = issue.getId().getLocalId();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPInputStream gzipInputStream = new GZIPInputStream(PrimitiveAssociationSemantics.getBlob(this.issueFolder, (String)"customOrder"));
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
            ((IdsSerializer)ServiceLocator.getBean((String)"idsSerializer")).resetOrder(entityId, (InputStream)gzipInputStream, (OutputStream)gzipOutputStream);
            gzipInputStream.close();
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PrimitiveAssociationSemantics.setBlob(this.issueFolder, (String)"customOrder", (InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    public Iterable<Entity> applyCustomOrder(Iterable<Entity> allIssues, OrderedEntitiesListener orderedIssuesListener) {
        if (EntityOperations.isRemoved(this.issueFolder) || PrimitiveAssociationSemantics.getBlob(this.issueFolder, (String)"customOrder") == null) {
            return allIssues;
        }
        TransientEntityStore transientStore = (TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore");
        PersistentEntityStoreImpl persistentStore = (PersistentEntityStoreImpl)transientStore.getPersistentStore();
        int typeId = persistentStore.getEntityTypeId("Issue", false);
        try {
            GZIPInputStream customOrderStream = new GZIPInputStream(PrimitiveAssociationSemantics.getBlob(this.issueFolder, (String)"customOrder"));
            customOrderStream.close();
        }
        catch (IOException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error while reading saved order", (Throwable)e);
            }
            return allIssues;
        }
        final PersistentEntity folder = ((TransientEntity)this.issueFolder).getPersistentEntity();
        if (folder.getBlob("customOrder") == null) {
            return allIssues;
        }
        SerializedIdsEntityIterable idsEntityIterable = new SerializedIdsEntityIterable((_FunctionTypes._return_P0_E0<? extends InputStream>)new _FunctionTypes._return_P0_E0<GZIPInputStream>(){

            public GZIPInputStream invoke() {
                try {
                    return new GZIPInputStream(folder.getBlob("customOrder"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, typeId);
        EntityIterableBase optimal = OrderedIssuesProvider.getOptimalIterable(allIssues);
        if (optimal == null) {
            return new InMemoryStableSortIterable((PersistentEntityStore)persistentStore, transientStore, idsEntityIterable, allIssues, typeId, orderedIssuesListener);
        }
        if (optimal.getSource() == EntityIterableBase.EMPTY) {
            return transientStore.getThreadSession().createPersistentEntityIterableWrapper((EntityIterable)EntityIterableBase.EMPTY);
        }
        EntityIterable source = new SortIterable(optimal.getTransaction(), (EntityIterableBase)idsEntityIterable, optimal, typeId, true).asSortResult();
        return transientStore.getThreadSession().createPersistentEntityIterableWrapper((EntityIterable)new SortIterableWithCallBack((EntityIterableBase)source, orderedIssuesListener));
    }

    public abstract Iterable<Entity> getIssues(@NotNull Entity var1, @NotNull IContext var2, boolean var3, boolean var4);

    public static EntityIterableBase getOptimalIterable(Iterable<Entity> issues) {
        if (issues instanceof EntityIterableBase) {
            return (EntityIterableBase)issues;
        }
        if (issues instanceof StaticTypedEntityIterable) {
            EntityIterableBase source;
            Iterable instance = ((StaticTypedEntityIterable)issues).instantiate();
            if (issues instanceof TreeKeepingEntityIterable && instance instanceof EntityIterable && (source = ((EntityIterableBase)instance).getSource()) instanceof EntityIterableBase) {
                return source;
            }
            if (instance instanceof EntityIterableBase) {
                return (EntityIterableBase)instance;
            }
        }
        return null;
    }
}

