/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.charisma.main.SingleSmtpAdressWrapper;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.ProjectImpl;

public abstract class ProjectBuilder {
    private String myName;
    private String myShortName;
    private Entity myLeader;
    private Entity myCreatedBy;
    private String myDescription;
    private SingleSmtpAdressWrapper myFromEmailWrapper;
    private Long myStartingNumber;

    public ProjectBuilder withName(String name) {
        ProjectBuilder builder = this.createCopy();
        builder.setName(name);
        return builder;
    }

    public ProjectBuilder withShortName(String shortName) {
        ProjectBuilder builder = this.createCopy();
        builder.setShortName(shortName);
        return builder;
    }

    public ProjectBuilder withLeader(Entity leader) {
        ProjectBuilder builder = this.createCopy();
        builder.setLeader(leader);
        return builder;
    }

    public ProjectBuilder withCreatedBy(Entity createdBy) {
        ProjectBuilder builder = this.createCopy();
        builder.setCreatedBy(createdBy);
        return builder;
    }

    public ProjectBuilder withDescription(String descrption) {
        ProjectBuilder builder = this.createCopy();
        builder.setDescription(descrption);
        return builder;
    }

    public ProjectBuilder withFromEmailWrapper(SingleSmtpAdressWrapper fromEmailWrapper) {
        ProjectBuilder builder = this.createCopy();
        builder.setFromEmailWrapper(fromEmailWrapper);
        return builder;
    }

    public ProjectBuilder withStartingNumber(Long startingNumber) {
        ProjectBuilder createCopy = this.createCopy();
        createCopy.setStartingNumber(startingNumber);
        return createCopy;
    }

    protected abstract ProjectBuilder createCopy();

    protected void copyFrom(ProjectBuilder builder) {
        this.setName(builder.getName());
        this.setShortName(builder.getShortName());
        this.setCreatedBy(builder.getCreatedBy());
        this.setLeader(builder.getLeader());
        this.setDescription(builder.getDescription());
        this.setFromEmailWrapper(builder.getFromEmailWrapper());
        this.setStartingNumber(builder.getStartingNumber());
    }

    public Entity buildProject() {
        Entity project = ProjectImpl.constructor((String)this.getName(), (String)this.getShortName(), (Entity)this.getCreatedBy());
        if (this.getDescription() != null) {
            PrimitiveAssociationSemantics.set((Entity)project, (String)"description", (Comparable)((Object)this.getDescription()), String.class);
        }
        DirectedAssociationSemantics.setToOne((Entity)project, (String)"leader", (Entity)this.getLeader());
        if (this.getStartingNumber() != null) {
            ((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project, (String)"Project")).setNextIssueNumber(this.getStartingNumber().longValue(), project);
        }
        if (this.getFromEmailWrapper() != null) {
            PrimitiveAssociationSemantics.set((Entity)project, (String)"fromEmail", (Comparable)((Object)this.getFromEmailWrapper().getAddress()), String.class);
            PrimitiveAssociationSemantics.set((Entity)project, (String)"fromPersonal", (Comparable)((Object)this.getFromEmailWrapper().getPersonal()), String.class);
        }
        return project;
    }

    public String getName() {
        return this.myName;
    }

    private void setName(String value) {
        this.myName = value;
    }

    public String getShortName() {
        return this.myShortName;
    }

    private void setShortName(String value) {
        this.myShortName = value;
    }

    public Entity getLeader() {
        return this.myLeader;
    }

    private void setLeader(Entity value) {
        this.myLeader = value;
    }

    public Entity getCreatedBy() {
        return this.myCreatedBy;
    }

    private void setCreatedBy(Entity value) {
        this.myCreatedBy = value;
    }

    public String getDescription() {
        return this.myDescription;
    }

    private void setDescription(String value) {
        this.myDescription = value;
    }

    public SingleSmtpAdressWrapper getFromEmailWrapper() {
        return this.myFromEmailWrapper;
    }

    private void setFromEmailWrapper(SingleSmtpAdressWrapper value) {
        this.myFromEmailWrapper = value;
    }

    public Long getStartingNumber() {
        return this.myStartingNumber;
    }

    private void setStartingNumber(Long value) {
        this.myStartingNumber = value;
    }
}

