/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

public class UserUIActionsContainer {
    private static final int USER_UI_ACTIONS_COMMIT_PERIOD = 3000;
    protected static Log log = LogFactory.getLog(UserUIActionsContainer.class);
    @NotNull
    private Map<Entity, Pair<BeanContainer, List<_FunctionTypes._void_P0_E0>>> deferredActions = new HashMap();
    @NotNull
    private final Object syncObject;
    protected final JobProcessor asyncJobProcessor;

    public UserUIActionsContainer(JobProcessor jobProcessor) {
        this.asyncJobProcessor = jobProcessor;
        this.syncObject = new Object();
        new ExecuteActionsJob();
    }

    public void addAction(@NotNull _FunctionTypes._void_P0_E0 action) {
        Entity currentUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        if (EntityOperations.equals((Entity)currentUser, null)) {
            throw new IllegalStateException("loggedInUser == null");
        }
        this.addActionBy(currentUser, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionBy(@NotNull Entity currentUser, @NotNull _FunctionTypes._void_P0_E0 action) {
        BeanContainer beanContainer = WebLocalScope.getContainer();
        Object object = this.syncObject;
        synchronized (object) {
            Pair actions = this.deferredActions.get(currentUser);
            if (actions == null) {
                actions = new Pair((Object)beanContainer, new ArrayList(4));
                this.deferredActions.put(currentUser, (Pair<BeanContainer, List<_FunctionTypes._void_P0_E0>>)actions);
            }
            ((List)actions.getSecond()).add(action);
        }
    }

    private class ExecuteActionsJob
    extends Job {
        private ExecuteActionsJob() {
            this.queueThis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() throws Throwable {
            block18: {
                try {
                    Map actions;
                    Object object = UserUIActionsContainer.this.syncObject;
                    synchronized (object) {
                        actions = UserUIActionsContainer.this.deferredActions;
                        UserUIActionsContainer.this.deferredActions = (Map)new HashMap();
                    }
                    if (actions.isEmpty()) break block18;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing user UI actions for " + actions.size() + " users..."));
                    }
                    BeanContainer oldContainer = WebLocalScope.getContainerDontCreate();
                    try {
                        for (final Entity user : actions.keySet()) {
                            final Pair userActions = (Pair)actions.get(user);
                            BeanContainer container = (BeanContainer)userActions.getFirst();
                            WebLocalScope.setLocalBeanContainer((BeanContainer)container);
                            try {
                                _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                                    public void invoke() {
                                        try {
                                            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)user);
                                            for (_FunctionTypes._void_P0_E0 action : (List)userActions.getSecond()) {
                                                action.invoke();
                                            }
                                        }
                                        finally {
                                            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
                                        }
                                    }
                                });
                            }
                            catch (Throwable t) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)"Failed to execute user UI action", t);
                            }
                            finally {
                                WebLocalScope.removeLocalBeanContainer();
                            }
                        }
                    }
                    finally {
                        if (oldContainer != null) {
                            WebLocalScope.setLocalBeanContainer((BeanContainer)oldContainer);
                        } else {
                            WebLocalScope.removeLocalBeanContainer();
                        }
                    }
                }
                finally {
                    this.queueThis();
                }
            }
        }

        private void queueThis() {
            UserUIActionsContainer.this.asyncJobProcessor.queueIn((Job)this, 3000L);
        }
    }
}

