/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.parser.search.RequestBuilderFactory;
import jetbrains.charisma.smartui.persistent.IssueTagImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.RequestBuilder;
import jetbrains.youtrack.api.service.MarkupRenderFactory;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Operation;
import org.jetbrains.annotations.Nullable;

public class WF_IssueImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "WF_Issue";

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        return entity;
    }

    private static Entity constructor() {
        return ((WF_IssueImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static String wikify(String text, Entity issue) {
        return WF_IssueImpl.wikify(text, (Boolean)PrimitiveAssociationSemantics.get((Entity)issue, (String)"usesMarkdown", Boolean.class, null), issue);
    }

    public static String wikify(String text, @Nullable boolean usingMarkdown, Entity issue) {
        return ((MarkupRenderFactory)ServiceLocator.getBean((String)"markupRenderFactory")).createBuilder().noJs().absoluteLinks().markdown(usingMarkdown).contextIssue(issue).render(text);
    }

    public static void voteIssue(Entity issue, Entity user) {
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).vote(user, issue);
    }

    public static boolean isVisibleTo(Entity user, Entity issue) {
        return !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isBanned(user) && ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.READ, user, issue);
    }

    public static void unvoteIssue(Entity issue, Entity user) {
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).unvote(user, issue);
    }

    public static boolean canVoteIssue(Entity issue, Entity user) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).canVote(user, issue);
    }

    public static boolean canUnvoteIssue(Entity issue, Entity user) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).canUnvote(user, issue);
    }

    public static Iterable<Entity> search(Entity folder, String query) {
        return WF_IssueImpl.search(folder, query, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<Entity> search(Entity folder, String query, Entity user) {
        Iterable<Entity> issues;
        if (EntityOperations.equals((Entity)user, null)) {
            return QueryOperations.empty((String)"Issue");
        }
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)user);
            RequestBuilder requestBuilder = ((RequestBuilderFactory)ServiceLocator.getBean((String)"requestBuilderFactory")).newRequestBuilder(query, folder);
            issues = requestBuilder.secure().sort().issues();
            if (!EntityOperations.equals((Entity)folder, null)) {
                issues = IssueFolderUtil.getOrderedIssuesProvider(folder).applyCustomOrder(issues, null);
            }
        }
        finally {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        }
        return issues;
    }

    public static Entity addTag(String name, Entity issue) {
        return IssueTagImpl.addTag(issue, name);
    }

    public static Entity removeTag(final String name, final Entity issue) {
        TreeKeepingEntityIterable ownedTags = QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"tags"), (String)"IssueTag", (NodeBase)new And((NodeBase)new LinkEqual("owner", ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()), (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
        Entity targetTag = !QueryOperations.isEmpty((Iterable)ownedTags) ? QueryOperations.getFirst((Iterable)ownedTags) : QueryOperations.getFirst((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"tags")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())).equals(name) && ((IssueTagImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"IssueTag")).canTagUntagIssue(issue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), it);
            }
        }));
        if (!EntityOperations.equals((Entity)targetTag, null)) {
            ((IssueTagImpl)DnqUtils.getPersistentClassInstance((Entity)targetTag, (String)"IssueTag")).untag(issue, targetTag);
        }
        return targetTag;
    }

    public static Iterable<Entity> getEditedComments(Entity issue) {
        return Sequence.fromIterable(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getAccessibleComments(false, issue)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isNew((Entity)it) && (EntityOperations.hasChangesExcepting((TransientEntity)((TransientEntity)it), (String[])new String[]{"deleted"}) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)it), (String)"deleted") && (Boolean)PrimitiveAssociationSemantics.get((Entity)it, (String)"deleted", Boolean.class, (Object)false) == false);
            }
        });
    }
}

