/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.plugins;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.plugins.UserMergeHandler;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class UserMergeHandlers {
    protected static Log log = LogFactory.getLog(UserMergeHandlers.class);
    private List<UserMergeHandler> handlers = new ArrayList<UserMergeHandler>();

    public void merge(final @NotNull Entity from, final @NotNull Entity into) {
        if (EntityOperations.equals((Entity)from, (Object)into)) {
            throw EntityOperations.isRemoved((Entity)from) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Can't merge a user with itself")) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Can't merge a user with itself", (Entity)((TransientEntity)from)));
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)from, (String)"User")).isGuest(from)) {
            throw EntityOperations.isRemoved((Entity)from) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Guest user can't be merged into other user")) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Guest user can't be merged into other user", (Entity)((TransientEntity)from)));
        }
        ListSequence.fromList(this.handlers).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<UserMergeHandler>(){

            public void visit(UserMergeHandler it) {
                it.userMerged(from, into);
                try {
                    DnqUtils.getCurrentTransientSession().flush();
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"An error occured during user merge", (Throwable)e);
                    }
                    DnqUtils.getCurrentTransientSession().revert();
                }
            }
        });
        EntityOperations.remove((Entity)from);
    }

    public void deleteWithSuccessor(final @NotNull Entity toDelete, final @NotNull Entity succesor) {
        if (EntityOperations.equals((Entity)toDelete, (Object)succesor)) {
            throw EntityOperations.isRemoved((Entity)toDelete) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("A user can't be its own successor")) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("A user can't be its own successor", (Entity)((TransientEntity)toDelete)));
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)toDelete, (String)"User")).isGuest(toDelete)) {
            throw EntityOperations.isRemoved((Entity)toDelete) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Guest user can't be deleted")) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Guest user can't be deleted", (Entity)((TransientEntity)toDelete)));
        }
        ListSequence.fromList(this.handlers).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<UserMergeHandler>(){

            public void visit(UserMergeHandler it) {
                it.userDeleted(toDelete, succesor);
                try {
                    DnqUtils.getCurrentTransientSession().flush();
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"An error occured during user removal", (Throwable)e);
                    }
                    DnqUtils.getCurrentTransientSession().revert();
                }
            }
        });
        EntityOperations.remove((Entity)toDelete);
    }

    public void setHandlers(Collection<UserMergeHandler> handlers) {
        ListSequence.fromList(this.handlers).addSequence((ISequence)CollectionSequence.fromCollection(handlers));
        Collections.sort(this.handlers, new Comparator<UserMergeHandler>(){

            @Override
            public int compare(UserMergeHandler p0, UserMergeHandler p1) {
                return p0.priority().compareTo(p1.priority());
            }
        });
    }
}

