/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.charisma.smartui.persistent.IssueTagImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefactoringMergeStarAndZvezdaFlags
extends Refactoring {
    private static String KEY_TO_ENABLE = "jetbrains.youtrack.refacroring.mergeStarAndZvezda";
    protected static Log log = LogFactory.getLog(RefactoringMergeStarAndZvezdaFlags.class);
    private String myStarTagName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Entity a) {
        IListSequence zvezdaTags = Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)this.getStarTagName())))).toListSequence();
        for (Entity tag : Sequence.fromIterable((Iterable)zvezdaTags)) {
            try {
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)AssociationSemantics.getToOne((Entity)tag, (String)"owner"));
                if (log.isInfoEnabled()) {
                    log.info((Object)("Removing tag for user " + (String)PrimitiveAssociationSemantics.get((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"login", String.class, (Object)"<no user>")));
                }
                Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)tag, (String)"issues")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                    public void visit(Entity it) {
                        String name = RefactoringMergeStarAndZvezdaFlags.this.getStarTagName();
                        IssueTagImpl.removeTag(it, name);
                        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).watch(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), it);
                    }
                });
            }
            finally {
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
            }
            EntityOperations.remove((Entity)tag);
        }
        ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"ApplicationMetaData")).saveAsAppliedRefactoring(this.getName(), a);
    }

    @Override
    public boolean shouldApply(Entity a) {
        return super.shouldApply(a) && Boolean.getBoolean(KEY_TO_ENABLE);
    }

    public String getStarTagName() {
        return this.myStarTagName;
    }

    public void setStarTagName(String value) {
        this.myStarTagName = value;
    }
}

