/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.charisma.smartui.watchFolder.SpecialFolders;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

@XmlRootElement(name="user")
@XmlType(name="User")
public class User {
    @XmlAttribute(name="filterFolder")
    private String filterFolder;
    @XmlAttribute(name="lastCreatedProject")
    private String lastCreatedProject;
    @XmlAttribute(name="login")
    private String login;
    @XmlAttribute(name="email")
    private String email;
    @XmlAttribute(name="jabber")
    private String jabber;
    @XmlAttribute(name="fullName")
    private String fullName;
    @XmlAttribute(name="avatar")
    private String avatar;
    @XmlAttribute(name="guest")
    private boolean guest;

    public User() {
    }

    public User(Entity user, boolean includePermissions) {
        this.filterFolder = this.evalFilterFolder(user, includePermissions);
        this.lastCreatedProject = this.evalLastCreatedProject(user, includePermissions);
        this.login = this.evalLogin(user, includePermissions);
        this.email = this.evalEmail(user, includePermissions);
        this.jabber = this.evalJabber(user, includePermissions);
        this.fullName = this.evalFullName(user, includePermissions);
        this.avatar = this.evalAvatar(user, includePermissions);
        this.guest = this.evalGuest(user, includePermissions);
    }

    public String getFilterFolder() {
        return this.filterFolder;
    }

    public String getLastCreatedProject() {
        return this.lastCreatedProject;
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getJabber() {
        return this.jabber;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public boolean getGuest() {
        return this.guest;
    }

    private String evalFilterFolder(Entity user, boolean includePermissions) {
        Entity folder = AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)user, (String)"profile"), (String)"filterFolder");
        return EntityOperations.equals((Entity)folder, null) ? null : SpecialFolders.getFqFolderId(folder);
    }

    private String evalLastCreatedProject(Entity user, boolean includePermissions) {
        Entity issue = !EntityOperations.equals((Entity)user, null) ? ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getGeneralUserProfile(user).getLastCreatedIssue() : null;
        return !EntityOperations.equals(issue, null) ? (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"project"), (String)"shortName", String.class, null) : null;
    }

    private String evalLogin(Entity user, boolean includePermissions) {
        return (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>");
    }

    private String evalEmail(Entity user, boolean includePermissions) {
        return (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"email", String.class, null);
    }

    private String evalJabber(Entity user, boolean includePermissions) {
        return (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"jabberAccountName", String.class, null);
    }

    private String evalFullName(Entity user, boolean includePermissions) {
        return (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"fullName", String.class, null);
    }

    private String evalAvatar(Entity user, boolean includePermissions) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getAvatarUrl(user);
    }

    private boolean evalGuest(Entity user, boolean includePermissions) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isGuest(user);
    }
}

