/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.restInternal;

import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.Property;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.service.MarkupRenderFactory;

@Path(value="/wiki")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class WikiResource
implements Resource {
    @POST
    @Path(value="/wiki/{contextIssue}")
    @Produces(value={"text/plain;charset=UTF-8"})
    public String post_WikiContextIssue(@Transformer(value="issueById") @PathParam(value="contextIssue") Entity contextIssue, @QueryParam(value="text") String text) {
        IsLoggedInSecurityConstraint.check();
        return ((MarkupRenderFactory)ServiceLocator.getBean((String)"markupRenderFactory")).createBuilder().contextIssue(contextIssue).render(text);
    }

    @POST
    @Path(value="/wikifyText")
    @Produces(value={"application/json"})
    public Property post_WikifyText(Map<String, String> data) {
        IsLoggedInSecurityConstraint.check();
        String text = data.get("text");
        String result = text == null ? "" : ((MarkupRenderFactory)ServiceLocator.getBean((String)"markupRenderFactory")).createBuilder().render(text);
        return new Property("wikifiedText", result);
    }
}

