/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartadmin.rest;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.ProjectBuilder;
import jetbrains.charisma.persistent.ProjectTemplate;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.charisma.smartadmin.rest.EntityGetterUtil;
import jetbrains.charisma.smartadmin.rest.ProjectBean;
import jetbrains.charisma.smartadmin.rest.ProjectRef;
import jetbrains.charisma.smartadmin.rest.RequirePermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartadmin.rest.RestAdminUrls;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;

@Path(value="/admin/project")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class AdminProjectResource
implements Resource {
    @GET
    public List<ProjectRef> get() {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.READ_PROJECT, null);
        List projects = ((Security)ServiceLocator.getBean((String)"security")).getProjects(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), Permission.READ_PROJECT, ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.ADMIN_READ_APP, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()));
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable((Iterable)projects).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, ProjectRef>(){

            public ProjectRef select(Entity it) {
                return new ProjectRef((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"shortName", String.class, null));
            }
        }));
    }

    @GET
    @Path(value="/{project}")
    public ProjectBean get_Project(@PathParam(value="project") String project) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.READ_PROJECT, project);
        return new ProjectBean(EntityGetterUtil.getProject(project, true));
    }

    @PUT
    @Path(value="/{projectId}")
    public Response put_ProjectId(@PathParam(value="projectId") String projectId, @QueryParam(value="projectName") String projectName, @QueryParam(value="startingNumber") Integer startingNumber, @QueryParam(value="projectLeadLogin") String projectLeadLogin, @QueryParam(value="description") String description) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.CREATE_PROJECT, null);
        ResponseUtil.ensure("projectId", projectId.indexOf("-") < 0, "Dash is not allowed in [projectId].");
        ResponseUtil.isRequired("projectName", projectName);
        ResponseUtil.isRequired("projectLeadLogin", projectLeadLogin);
        ResponseUtil.ensure("startingNumber", startingNumber == null || startingNumber > 0, "Next issue number should be a positive integer.");
        return this.createProject(projectId, projectName, projectLeadLogin, description, startingNumber);
    }

    @PUT
    @Consumes(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public Response put(ProjectBean project) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.CREATE_PROJECT, null);
        String projectName = project.getName();
        ResponseUtil.isRequired("name", projectName);
        String projectId = project.getId();
        ResponseUtil.isRequired("id", projectId);
        ResponseUtil.ensure("id", projectId.indexOf("-") < 0, "Dash is not allowed in [id].");
        String leadLogin = project.getLead();
        ResponseUtil.isRequired("lead", leadLogin);
        String startingNumber = project.getStartingNumber();
        int parsedNumber = 1;
        if (startingNumber != null) {
            parsedNumber = Integer.parseInt(startingNumber);
            ResponseUtil.ensure("startingNumber", parsedNumber > 0, "Next issue number should be a positive integer.");
        }
        return this.createProject(projectId, projectName, leadLogin, project.getDescription(), parsedNumber);
    }

    @DELETE
    @Path(value="/{project}")
    public Response delete_Project(@PathParam(value="project") String project) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.DELETE_PROJECT, project);
        Entity p = EntityGetterUtil.getProject(project, true);
        ProjectImpl.deleteProject((Entity)p);
        RestUtil.waitForPermissionCacheRecalculation();
        return Response.ok().build();
    }

    private Response createProject(String projectId, String projectName, String projectLeadLogin, String description, Integer startingNumber) {
        EntityGetterUtil.getProject(projectId, false);
        Entity projectLead = UserImpl.findUser(projectLeadLogin);
        ResponseUtil.assertExist("User", projectLead, projectLeadLogin, true);
        ProjectBuilder builder = ((ProjectTemplate)ServiceLocator.getBean((String)"defaultProjectTemplate")).getProjectBuilder().withName(projectName).withShortName(projectId).withCreatedBy(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()).withLeader(projectLead).withDescription(description);
        if (startingNumber != null) {
            builder.withStartingNumber(startingNumber.longValue() - 1L);
        }
        builder.buildProject();
        DnqUtils.getCurrentTransientSession().flush();
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtil.created(RestAdminUrls.getProjectUrl(projectId));
    }
}

