/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartadmin.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.charisma.smartadmin.rest.EntityGetterUtil;
import jetbrains.charisma.smartadmin.rest.RequirePermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.RequirePermissionToCreateUpdateUserProfileSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartadmin.rest.RestAdminUrls;
import jetbrains.charisma.smartadmin.rest.UserBean;
import jetbrains.charisma.smartadmin.rest.UserGroupRef;
import jetbrains.charisma.smartadmin.rest.UserHelper;
import jetbrains.charisma.smartadmin.rest.UserRef;
import jetbrains.charisma.smartadmin.rest.UserRole;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.user.PasswordGenerator;

@Path(value="/admin/user")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class AdminUserResource
implements Resource {
    @GET
    public List<UserRef> get(@QueryParam(value="group") String group, @QueryParam(value="role") String role, @QueryParam(value="project") String project, @QueryParam(value="permission") String permission, @QueryParam(value="start") Integer start) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.READ_USER, null);
        Object users = this.find(group, role, project, permission);
        users = QueryOperations.query(users, (String)"User", (NodeBase)new SortByProperty(null, "login", true));
        if (start != null && start > 0) {
            users = QueryOperations.skip((Iterable)users, (int)start);
        }
        users = QueryOperations.take((Iterable)users, (int)10);
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable((Iterable)users).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, UserRef>(){

            public UserRef select(Entity u) {
                return new UserRef(u);
            }
        }));
    }

    @GET
    @Path(value="/{login}")
    public UserBean get_Login(@PathParam(value="login") String login) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.READ_USER, null);
        RequirePermissionSecurityConstraint.check(Permission.READ_NOT_OWN_PROFILE, null);
        RequirePermissionSecurityConstraint.check(Permission.READ_PROFILE, null);
        return new UserBean(EntityGetterUtil.getUser(login, true));
    }

    @PUT
    @Path(value="/{login}")
    public Response put_Login(@PathParam(value="login") String login, @QueryParam(value="fullName") String fullName, @QueryParam(value="email") String email, @QueryParam(value="jabber") String jabber, @QueryParam(value="password") String password) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.CREATE_USER, null);
        EntityGetterUtil.getUser(login, false);
        ResponseUtil.isRequired("email", email);
        Entity user = UserImpl.constructor(login);
        PrimitiveAssociationSemantics.setHashed((Entity)user, (String)"password", (String)(password != null && password.length() > 0 ? password : PasswordGenerator.generate()));
        PrimitiveAssociationSemantics.set((Entity)user, (String)"fullName", (Comparable)((Object)(fullName != null && fullName.length() > 0 ? fullName : login)), String.class);
        PrimitiveAssociationSemantics.set((Entity)user, (String)"email", (Comparable)((Object)email), String.class);
        PrimitiveAssociationSemantics.set((Entity)user, (String)"jabberAccountName", (Comparable)((Object)jabber), String.class);
        ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).fixLogin(user);
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtil.created(RestAdminUrls.getUserUrl((String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>")));
    }

    @POST
    public UserBean post(@QueryParam(value="login") String login, @QueryParam(value="fullName") String fullName, @QueryParam(value="email") String email, @QueryParam(value="jabber") String jabber) {
        IsLoggedInSecurityConstraint.check();
        ResponseUtil.isRequired("login", login);
        Object u = null;
        Entity user = UserImpl.findUser(login);
        RequirePermissionToCreateUpdateUserProfileSecurityConstraint.check(user);
        if (EntityOperations.equals((Entity)user, null)) {
            ResponseUtil.isRequired("email", email);
            user = UserImpl.constructor(login);
            PrimitiveAssociationSemantics.setHashed((Entity)user, (String)"password", (String)PasswordGenerator.generate());
        }
        if (fullName != null && fullName.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)user, (String)"fullName", (Comparable)((Object)fullName), String.class);
        }
        if (email != null) {
            PrimitiveAssociationSemantics.set((Entity)user, (String)"email", (Comparable)((Object)email), String.class);
        }
        if (jabber != null && jabber.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)user, (String)"jabberAccountName", (Comparable)((Object)jabber), String.class);
        }
        DnqUtils.getCurrentTransientSession().flush();
        return new UserBean(user);
    }

    @GET
    @Path(value="/{login}/group")
    public List<UserGroupRef> get_LoginGroup(@PathParam(value="login") String login) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.READ_USER, null);
        RequirePermissionSecurityConstraint.check(Permission.READ_USERGROUP, null);
        Entity user = EntityGetterUtil.getUser(login, true);
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable((Iterable)QueryOperations.query(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getUserGroups(user), (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true))).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, UserGroupRef>(){

            public UserGroupRef select(Entity it) {
                return new UserGroupRef(it);
            }
        }));
    }

    @POST
    @Path(value="/{login}/group/{group}")
    public Response post_LoginGroupGroup(@PathParam(value="login") String login, @PathParam(value="group") String group) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USER, null);
        RequirePermissionSecurityConstraint.check(Permission.READ_USERGROUP, null);
        Entity user = EntityGetterUtil.getUser(login, true);
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).addGroup(ug, user);
        RestUtil.waitForPermissionCacheRecalculation();
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{login}/group/{group}")
    public Response delete_LoginGroupGroup(@PathParam(value="login") String login, @PathParam(value="group") String group) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USER, null);
        RequirePermissionSecurityConstraint.check(Permission.READ_USERGROUP, null);
        Entity user = EntityGetterUtil.getUser(login, true);
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).removeGroup(ug, user);
        RestUtil.waitForPermissionCacheRecalculation();
        return Response.ok().build();
    }

    @GET
    @Path(value="/{login}/role")
    public List<UserRole> get_LoginRole(@PathParam(value="login") String login) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(Permission.READ_USER, null);
        RequirePermissionSecurityConstraint.check(Permission.READ_ROLE, null);
        Entity user = EntityGetterUtil.getUser(login, true);
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable(UserHelper.getUserRolesLegacy(user)).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, UserRole>(){

            public UserRole select(Entity it) {
                IMapSequence projects = MapSequence.fromMap(new HashMap());
                Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)it, (String)"projects")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Map)projects){
                    final /* synthetic */ Map val$projects;
                    {
                        this.val$projects = map;
                    }

                    public void visit(Entity it) {
                        MapSequence.fromMap((Map)this.val$projects).put(PrimitiveAssociationSemantics.get((Entity)it, (String)"shortName", String.class, null), PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
                    }
                });
                return new UserRole((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)it, (String)"role"), (String)"name", String.class, (Object)"<no role>"), (Map<String, String>)projects);
            }
        }));
    }

    private Iterable<Entity> find(String group, String role, String project, String permission) {
        Entity g = null;
        if (group != null && group.length() > 0) {
            g = UserGroupImpl.findUserGroup(group);
            ResponseUtil.assertExist("Group", g, group, true);
        }
        Entity r = null;
        if (role != null && role.length() > 0) {
            r = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)role))));
            ResponseUtil.assertExist("Role", r, role, true);
        }
        Entity p = null;
        if (project != null && project.length() > 0) {
            p = ProjectImpl.findProject((String)project);
            ResponseUtil.assertExist("Project", p, project, true);
        }
        Permission perm = null;
        if (permission != null && permission.length() > 0) {
            perm = Enum.valueOf(Permission.class, permission);
            ResponseUtil.assertExist("Permission", perm, permission, true);
        }
        return UserHelper.getFilteredUsers(g, r, p, perm);
    }
}

