/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.content;

import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.plugins.IssueAction;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.statistics.StatisticsService;

public class VoteIssueActionProvider {
    private static IssueAction[] actions = new IssueAction[]{new VoteIssueAction(), new UnvoteIssueAction()};

    public Iterable<IssueAction> getActions() {
        return Sequence.fromArray((Object[])actions);
    }

    private static class UnvoteIssueAction
    implements IssueAction {
        private UnvoteIssueAction() {
        }

        @Override
        public String getName() {
            return PredefinedCommandType.unvote.getName(ApplicationMetaDataImpl.getLocale());
        }

        @Override
        public String getCommand() {
            return this.getName();
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("VoteIssueActionProvider.Take_your_vote_back", new Object[0]);
        }

        @Override
        public void execute(Entity issue) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).unvote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), issue);
        }

        @Override
        public boolean isApplicable(Entity issue) {
            return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).canUnvote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), issue);
        }
    }

    private static class VoteIssueAction
    implements IssueAction {
        private VoteIssueAction() {
        }

        @Override
        public String getName() {
            return PredefinedCommandType.vote.getName(ApplicationMetaDataImpl.getLocale());
        }

        @Override
        public String getCommand() {
            return this.getName();
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("VoteIssueActionProvider.Cast_a_vote", new Object[0]);
        }

        @Override
        public void execute(Entity issue) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).vote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), issue);
            ((StatisticsService)ServiceLocator.getBean((String)"statService")).incForInstance((StatisticsFeatureDescription)ServiceLocator.getBean((String)"featureFsiToolbarVote"));
        }

        @Override
        public boolean isApplicable(Entity issue) {
            return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).canVote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), issue);
        }
    }
}

