/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.dto;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IssuesDTO {
    protected static Log log = LogFactory.getLog(IssuesDTO.class);
    public final List<Entity> issuesAtLeast;
    public final EntityIdSet allFound;
    public final int size;
    public final boolean isNotEmpty;
    public final EntityIterableHandle handle;
    public int roughCount;
    public final Entity lastIssueOnPrevPage;
    public final int offset;
    public final int orderedIssues;
    public final int pageSize;
    public final FilterData filterData;

    public IssuesDTO(FilterData filterData, int from, int pageSize, int atLeast, boolean hierarchyMode) {
        this.pageSize = pageSize;
        this.filterData = filterData;
        Iterable<Entity> source = filterData.getIssues(true, true);
        Iterable iterable = ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).toEntityIterable(source);
        if (iterable instanceof EntityIterableBase) {
            EntityIterableBase it = (EntityIterableBase)iterable;
            this.handle = it.getHandle();
            this.roughCount = (int)it.getRoughCount();
            if (hierarchyMode) {
                EntityIterableBase unwrapped = it.getSource();
                if (unwrapped == EntityIterableBase.EMPTY) {
                    this.allFound = EntityIdSetFactory.newSet();
                } else if (unwrapped instanceof EntityIterableBase) {
                    this.allFound = unwrapped.toSet((PersistentStoreTransaction)DnqUtils.getCurrentPersistentSession());
                } else {
                    EntityIdSet set = EntityIdSetFactory.newSet();
                    for (Entity e : iterable) {
                        set = set.add(e.getId());
                    }
                    this.allFound = set;
                }
            } else {
                this.allFound = null;
            }
        } else {
            this.handle = null;
            if (log.isWarnEnabled()) {
                log.warn((Object)("In-memory sequence detected for query: " + filterData.getFilter().getInputQuery()));
            }
            this.roughCount = -1;
            this.allFound = null;
        }
        IListSequence pageData = Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)Sequence.fromIterable((Iterable)QueryOperations.skip(source, (int)(from > 0 ? from - 1 : from))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isRemoved((Entity)it);
            }
        }), (int)Math.max(from + pageSize, atLeast))).toListSequence();
        this.lastIssueOnPrevPage = from > 0 ? (Entity)ListSequence.fromList((List)pageData).removeElementAt(0) : null;
        this.isNotEmpty = !QueryOperations.isEmpty((Iterable)pageData);
        this.offset = from;
        this.orderedIssues = (int)filterData.getNumberOfOrderedIssues();
        this.size = from + QueryOperations.getSize((Iterable)pageData);
        this.issuesAtLeast = pageData;
    }

    public int getSize() {
        Long existingCount;
        if (this.roughCount >= 0) {
            return this.roughCount;
        }
        if (this.handle != null && (existingCount = ((QueryEngine)ServiceLocator.getBean((String)"queryEngine")).getPersistentStore().getEntityIterableCache().getCachedCount(this.handle)) != null && existingCount >= 0L) {
            int updatedCount;
            this.roughCount = updatedCount = existingCount.intValue();
            return updatedCount;
        }
        return QueryOperations.roughSize(this.filterData.getIssues(true, false));
    }

    public boolean isNotEmpty() {
        return this.isNotEmpty;
    }
}

