/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.filter;

import java.util.ArrayList;
import jetbrains.charisma.smartui.filter.FiltersSideBar_HtmlTemplateComponent;
import jetbrains.charisma.smartui.parser.filterCreator.BaseFieldValue;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.util.ContentBuilder;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.core.security.Permissions;
import webr.framework.function.HtmlStringUtil;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

public class FilterParam {
    private IField filterGroup;
    private boolean queried;
    private boolean found;
    private Iterable<IFieldValue> filterFields;
    private Entity owner;
    private IParseResult parseResult;
    private Iterable<Entity> issuesFilter;
    private Iterable<Entity> intersectedIssues;
    private String id;

    public FilterParam(IField filterGroup, boolean queried, boolean found, Iterable<IFieldValue> filterFields, IParseResult parseResult, Entity owner) {
        this.filterGroup = filterGroup;
        this.queried = queried;
        this.found = found;
        this.filterFields = filterFields;
        this.parseResult = parseResult;
        this.owner = owner;
    }

    public IField getFilterGroup() {
        return this.filterGroup;
    }

    public String getGroupName() {
        return ((FieldAlias)Sequence.fromIterable((Iterable)this.filterGroup.getAliases()).first()).getAlias();
    }

    public IParseResult getParseResult() {
        return this.parseResult;
    }

    public Entity getOwner() {
        return this.owner;
    }

    public Iterable<Entity> getIssuesFilter() {
        if (this.issuesFilter == null) {
            for (IFieldValue filterField : Sequence.fromIterable(this.filterFields)) {
                this.issuesFilter = QueryOperations.union(this.issuesFilter, (Iterable)this.filterGroup.filter(filterField, (IContext)new Context(), this.owner));
            }
        }
        return this.issuesFilter;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getGroupName() + String.valueOf(this.hashCode()).replace('-', '$');
        }
        return this.id;
    }

    public boolean equals(Object p) {
        return FilterParam.eq_6bah2i_a0a0g(this.getId(), ((FilterParam)p).getId());
    }

    public int hashCode() {
        if (this.getFilterField() == null) {
            return 0;
        }
        return this.getFilterField().hashCode();
    }

    public String getDisplayName() {
        BaseFieldValue baseIssueFilterCreator = FilterParam.as_6bah2i_a0a0a8(Sequence.fromIterable(this.filterFields).first(), BaseFieldValue.class);
        return baseIssueFilterCreator != null ? baseIssueFilterCreator.getDisplayName(this.getFilterGroup()) : this.getFilterField().getName();
    }

    public String getTooltip() {
        BaseFieldValue baseIssueFilterCreator = FilterParam.as_6bah2i_a0a0a9(Sequence.fromIterable(this.filterFields).first(), BaseFieldValue.class);
        return baseIssueFilterCreator != null ? baseIssueFilterCreator.getTooltip(this.getFilterGroup()) : this.getFilterField().getName();
    }

    public IFieldValue getFilterField() {
        return (IFieldValue)Sequence.fromIterable(this.filterFields).first();
    }

    public Iterable<Entity> getIntersectedIssues() {
        if (this.intersectedIssues == null) {
            this.intersectedIssues = QueryOperations.intersect(this.parseResult.getIssues(new Context(), this.owner), this.getIssuesFilter());
            this.intersectedIssues = ((Permissions)ServiceLocator.getBean((String)"permissions")).apply(this.owner, this.intersectedIssues);
        }
        return this.intersectedIssues;
    }

    public String getCountSpanId() {
        return "countSpan" + this.getId();
    }

    public String getFilterCountString(final int count, final boolean highlight) {
        if (count >= 0) {
            return ContentBuilder.toString((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(){

                public void invoke(TBuilderContext builderContext) {
                    builderContext.appendIndent();
                    builderContext.append("<span id=\"");
                    builderContext.append(HtmlStringUtil.html((Object)FilterParam.this.getCountSpanId()));
                    builderContext.append("\" class=\"vert-list-item-counter ");
                    if (highlight) {
                        builderContext.append("vert-item_highlight");
                    }
                    builderContext.append("\">");
                    builderContext.append(HtmlStringUtil.html((Object)count));
                    builderContext.append("</span>");
                    builderContext.appendNewLine();
                }
            }, (boolean)false);
        }
        return ContentBuilder.toString((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(){

            public void invoke(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<span id=\"");
                builderContext.append(HtmlStringUtil.html((Object)FilterParam.this.getCountSpanId()));
                builderContext.append("\" class=\"vert-list-item-counter ");
                if (highlight) {
                    builderContext.append("vert-item_highlight");
                }
                builderContext.append("\">?</span>");
                builderContext.appendNewLine();
            }
        }, (boolean)false);
    }

    public void evalUpdateCountJs(FiltersSideBar_HtmlTemplateComponent tpl, final int count) {
        tpl.addCommandResponse((JsCommandResponse)ResponseFactory.getJsResponseFactory().getEvalResponse(ContentBuilder.toString((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(){

            public void invoke(TBuilderContext builderContext) {
                LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromList(new ArrayList()));
                builderContext.appendIndent();
                builderContext.append("var l = document.getElementById(\"");
                builderContext.append(JsStringUtil.stringLiteral((Object)FilterParam.this.getCountSpanId()));
                builderContext.append("\");");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("l.className = \"vert-list-item-counter\";");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.append("l.innerHTML = \"");
                builderContext.append(JsStringUtil.stringLiteral((Object)String.valueOf(count)));
                builderContext.append("\";");
                builderContext.appendNewLine();
            }
        }, (boolean)false, (TemplateComponent)tpl)));
    }

    public boolean isFound() {
        return this.found;
    }

    public boolean isQueried() {
        return this.queried;
    }

    private static boolean eq_6bah2i_a0a0g(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static <T> T as_6bah2i_a0a0a8(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_6bah2i_a0a0a9(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

