/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.filter;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.smartui.filter.FilterParam;
import jetbrains.charisma.smartui.filter.FilterParams;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.search.ParseResultUtil;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.MultiThreadDelegatingJobProcessor;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BeanContainerAwareSingleThreadDelegatingJobProcessor;

public abstract class LazyLoadFilterParams
extends FilterParams {
    protected static final Log log = LogFactory.getLog(LazyLoadFilterParams.class);
    private boolean calculated = false;
    private FilterParams source;

    public LazyLoadFilterParams() {
        this(true);
    }

    public LazyLoadFilterParams(boolean lazy) {
        if (((MultiThreadDelegatingJobProcessor)ServiceLocator.getBean((String)"reportJobProcessor")).isDispatcherThread() || !lazy) {
            this.doCalculateUnlimited();
        }
    }

    @Override
    public void loadMore() {
        if (this.source != null) {
            this.source.loadMore();
        }
    }

    @Override
    public void loadMore(boolean limited) {
        if (this.source != null) {
            this.source.loadMore(limited);
        }
    }

    @Override
    public boolean isCalculated() {
        return this.calculated;
    }

    @Override
    public void calculate() {
        if (this.isCalculated()) {
            return;
        }
        final Entity loggedInUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        final String name = ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)loggedInUser, (String)"User")).getVisibleName(loggedInUser);
        final String location = ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getLocation();
        new Job((JobProcessor)((BeanContainerAwareSingleThreadDelegatingJobProcessor)ServiceLocator.getBean((String)"asyncUIJobProcessor"))){

            protected void execute() throws Throwable {
                try {
                    ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)loggedInUser);
                    LazyLoadFilterParams.this.doCalculate();
                }
                finally {
                    ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
                }
            }

            public String getName() {
                return name;
            }

            public String getGroup() {
                return location;
            }
        };
    }

    public void doCalculate() {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                LazyLoadFilterParams.this.source = LazyLoadFilterParams.this.calculateImpl();
                if (LazyLoadFilterParams.this.filterParamsCalculation != null) {
                    LazyLoadFilterParams.this.filterParamsCalculation.updateFilterParams(LazyLoadFilterParams.this);
                }
                LazyLoadFilterParams.this.calculated = true;
            }
        });
    }

    public void doCalculateUnlimited() {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                LazyLoadFilterParams.this.source = LazyLoadFilterParams.this.calculateImpl();
                LazyLoadFilterParams.this.source.loadMore(false);
                if (LazyLoadFilterParams.this.filterParamsCalculation != null) {
                    LazyLoadFilterParams.this.filterParamsCalculation.updateFilterParams(LazyLoadFilterParams.this);
                }
                LazyLoadFilterParams.this.calculated = true;
            }
        });
    }

    @Override
    public int getTotal() {
        return this.source == null ? -1 : this.source.getTotal();
    }

    @Override
    public boolean getHasQueriedInFound() {
        return this.source == null ? false : this.source.getHasQueriedInFound();
    }

    @Override
    public Set<FilterParam> getFoundParams() {
        return this.source == null ? SetSequence.fromSet(new HashSet()) : this.source.getFoundParams();
    }

    public abstract FilterParams calculateImpl();

    public static FilterParams createFilterParams(Iterable<Entity> issues, Entity singleProject, IField filterGroup, Entity me, boolean useMeValue, IParseResult parseResult, boolean lazy) {
        LinkedHashSet result = new LinkedHashSet();
        LazyLoadFilterParams lazyParams = new LazyLoadFilterParams(lazy, (Set)result, filterGroup, issues, singleProject, me, useMeValue, lazy, parseResult){
            final /* synthetic */ Set val$result;
            final /* synthetic */ IField val$filterGroup;
            final /* synthetic */ Iterable val$issues;
            final /* synthetic */ Entity val$singleProject;
            final /* synthetic */ Entity val$me;
            final /* synthetic */ boolean val$useMeValue;
            final /* synthetic */ boolean val$lazy;
            final /* synthetic */ IParseResult val$parseResult;
            {
                this.val$result = set;
                this.val$filterGroup = iField;
                this.val$issues = iterable;
                this.val$singleProject = entity;
                this.val$me = entity2;
                this.val$useMeValue = bl;
                this.val$lazy = bl2;
                this.val$parseResult = iParseResult;
                super(lazy);
            }

            @Override
            public FilterParams calculateImpl() {
                FilterParams filterParams = new FilterParams(this.val$result){

                    @Override
                    public void loadMore(boolean limited) {
                        int paramsSize;
                        Iterable usedValues = val$filterGroup.getUsedValues(val$issues, val$singleProject, val$me, val$useMeValue);
                        IMapSequence nameToFoundValues = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
                        int total = 0;
                        for (IFieldValue value : Sequence.fromIterable((Iterable)usedValues).where((_FunctionTypes._return_P1_E0)new IWhereFilter<IFieldValue>(){

                            public boolean accept(IFieldValue it) {
                                return it != null;
                            }
                        })) {
                            String lowerCaseName = value.getName().toLowerCase();
                            Iterable filterFieldValues = (Iterable)MapSequence.fromMap((Map)nameToFoundValues).get((Object)lowerCaseName);
                            if (filterFieldValues == null) {
                                ++total;
                            }
                            filterFieldValues = Sequence.fromIterable((Iterable)filterFieldValues).concat(Sequence.fromIterable((Iterable)Sequence.singleton((Object)value)));
                            MapSequence.fromMap((Map)nameToFoundValues).put((Object)lowerCaseName, (Object)filterFieldValues);
                        }
                        int maxShown = val$lazy && limited ? ((paramsSize = SetSequence.fromSet(this.getFoundParams()).count()) == 0 ? 10 : paramsSize + 42) : Integer.MAX_VALUE;
                        LinkedHashSet _res = new LinkedHashSet();
                        this.setHasQueriedInFound(LazyLoadFilterParams.onLoadMore(val$filterGroup, (Map)nameToFoundValues, val$me, val$parseResult, maxShown, (_FunctionTypes._void_P1_E0<? super FilterParam>)((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<FilterParam>((Set)_res){
                            final /* synthetic */ Set val$_res;
                            {
                                this.val$_res = set;
                            }

                            public void invoke(FilterParam param) {
                                this.val$_res.add(param);
                            }
                        })));
                        this.setTotal(total);
                        this.foundParams = _res;
                        if (this.filterParamsCalculation != null) {
                            this.filterParamsCalculation.updateFilterParams(this);
                        }
                    }
                };
                filterParams.setFilterParamsCalculation(this.filterParamsCalculation);
                filterParams.loadMore();
                return filterParams;
            }
        };
        lazyParams.setHasQueriedInFound(true);
        return lazyParams;
    }

    private static boolean onLoadMore(IField filterGroup, Map<String, Iterable<IFieldValue>> nameToFoundValues, Entity user, IParseResult parseResult, int maxShow, _FunctionTypes._void_P1_E0<? super FilterParam> found) {
        ISetSequence queriedValues = SetSequence.fromSet(new HashSet());
        ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).collectSearchedValues(parseResult, filterGroup, (Set<IFieldValue>)queriedValues);
        boolean hasQueriedInFound = false;
        for (String name : SetSequence.fromSet((Set)MapSequence.fromMap(nameToFoundValues).keySet()).take(maxShow)) {
            Iterable values = (Iterable)MapSequence.fromMap(nameToFoundValues).get((Object)name);
            boolean queriedInFound = Sequence.fromIterable((Iterable)values).any((_FunctionTypes._return_P1_E0)new IWhereFilter<IFieldValue>((Set)queriedValues){
                final /* synthetic */ Set val$queriedValues;
                {
                    this.val$queriedValues = set;
                }

                public boolean accept(IFieldValue it) {
                    return SetSequence.fromSet((Set)this.val$queriedValues).contains((Object)it);
                }
            });
            FilterParam filterParam = new FilterParam(filterGroup, queriedInFound, true, values, parseResult, user);
            found.invoke((Object)filterParam);
            hasQueriedInFound = hasQueriedInFound || queriedInFound;
        }
        return hasQueriedInFound;
    }
}

