/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.keyword;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.charisma.smartui.keyword.CategorizedFieldService;
import jetbrains.charisma.smartui.keyword.PredefinedFieldService;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.AliasFlag;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IField;

public class FieldPoolUtil {
    public static Iterable<IField> getFeaturedFields(Entity user, Iterable<Entity> filterProjects, AliasFlag flag) {
        return FieldPoolUtil.mergeSortedByName(((PredefinedFieldService)ServiceLocator.getBean((String)"predefinedFieldService")).getFeaturedFields(flag), ((CategorizedFieldService)ServiceLocator.getBean((String)"categorizedFieldService")).getFeaturedFields(user, filterProjects, flag), flag);
    }

    public static Iterable<IField> getOneLinerVisibleFields(Entity user) {
        return Sequence.fromIterable(((PredefinedFieldService)ServiceLocator.getBean((String)"predefinedFieldService")).getOneLineVisibleFields()).concat(Sequence.fromIterable(((CategorizedFieldService)ServiceLocator.getBean((String)"categorizedFieldService")).getOneLineVisibleFields()));
    }

    public static Iterable<IField> getAccessibleFilterFields(Entity user) {
        return FieldPoolUtil.getAccessibleFilterFields(user, false);
    }

    public static Iterable<IField> getAccessibleFilterFields(Entity user, boolean includeNonFilterFields) {
        return FieldPoolUtil.getAccessibleFilterFields(user, null, includeNonFilterFields);
    }

    public static Iterable<IField> getAccessibleFilterFields(Entity user, String valueType, boolean includeNonFilterFields) {
        return Sequence.fromIterable(((PredefinedFieldService)ServiceLocator.getBean((String)"predefinedFieldService")).getAccessibleFilterFields(user, valueType, includeNonFilterFields)).concat(Sequence.fromIterable(((CategorizedFieldService)ServiceLocator.getBean((String)"categorizedFieldService")).getAccessibleFilterFields(user, valueType, includeNonFilterFields)));
    }

    private static Iterable<IField> mergeSortedByName(Iterable<IField> seq1, Iterable<IField> seq2, final AliasFlag flag) {
        return new MergeIterable<IField>(seq1, seq2, new Comparator<IField>(){

            @Override
            public int compare(IField f1, IField f2) {
                FieldAlias a1 = (FieldAlias)Sequence.fromIterable((Iterable)f1.getAliases()).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<FieldAlias>(){

                    public boolean accept(FieldAlias it) {
                        return it.is(flag);
                    }
                });
                FieldAlias a2 = (FieldAlias)Sequence.fromIterable((Iterable)f2.getAliases()).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<FieldAlias>(){

                    public boolean accept(FieldAlias it) {
                        return it.is(flag);
                    }
                });
                if (a1 != null && a2 != null) {
                    return a1.getAlias().compareToIgnoreCase(a2.getAlias());
                }
                if (a1 != null) {
                    return -1;
                }
                if (a2 != null) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static class MergeIterable<T>
    implements Iterable<T> {
        private Iterable<T> seq1;
        private Iterable<T> seq2;
        private Comparator<T> comparator;

        public MergeIterable(Iterable<T> seq1, Iterable<T> seq2, Comparator<T> comparator) {
            this.seq1 = seq1;
            this.seq2 = seq2;
            this.comparator = comparator;
        }

        @Override
        public Iterator<T> iterator() {
            return new MergeIterator();
        }

        private class MergeIterator
        implements Iterator<T> {
            private Iterator<T> i1;
            private Iterator<T> i2;
            private T cur1;
            private T cur2;
            private boolean h1;
            private boolean h2;

            private MergeIterator() {
                this.i1 = Sequence.fromIterable((Iterable)MergeIterable.this.seq1).iterator();
                this.i2 = Sequence.fromIterable((Iterable)MergeIterable.this.seq2).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.h1 || this.h2 || this.i1.hasNext() || this.i2.hasNext();
            }

            @Override
            public T next() {
                if (!this.h1 && this.i1.hasNext()) {
                    this.h1 = true;
                    this.cur1 = this.i1.next();
                }
                if (!this.h2 && this.i2.hasNext()) {
                    this.h2 = true;
                    this.cur2 = this.i2.next();
                }
                if (this.h1 && this.h2) {
                    if (MergeIterable.this.comparator.compare(this.cur1, this.cur2) <= 0) {
                        this.h1 = false;
                        return this.cur1;
                    }
                    this.h2 = false;
                    return this.cur2;
                }
                if (this.h1 && !this.h2) {
                    this.h1 = false;
                    return this.cur1;
                }
                if (!this.h1 && this.h2) {
                    this.h2 = false;
                    return this.cur2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

