/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.pager;

import java.util.ArrayList;
import java.util.Iterator;
import jetbrains.charisma.smartui.dto.IssuesDTO;
import jetbrains.mps.baseLanguage.closures.runtime.YieldingIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequenceClosure;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;

public class PagerInfo {
    public static final Iterable<Integer> PAGE_SIZES = ListSequence.fromListAndArray(new ArrayList(), (Object[])new Integer[]{10, 25, 50, 100});
    public static final int BUTTONS_COUNT = 4;
    private int firstRow;
    private int totalSize;
    private int pageSize;
    private int pageButtonMaxCount;
    private boolean exactTotalSize = true;
    private _FunctionTypes._return_P1_E0<? extends IssuesDTO, ? super PagerInfo> update;
    private IssuesDTO issuesDTO;

    public PagerInfo() {
    }

    public PagerInfo(int firstRow, int totalSize, int pageSize, int pageButtonMaxCount) {
        this.init(firstRow, totalSize, pageSize, pageButtonMaxCount);
    }

    public void init(int firstRow, int totalSize, int pageSize, int pageButtonMaxCount) {
        this.firstRow = firstRow < 0 ? 0 : (firstRow >= totalSize ? Math.max(0, (totalSize - 1) / pageSize) : firstRow - firstRow % pageSize);
        this.totalSize = totalSize;
        this.pageSize = pageSize;
        this.pageButtonMaxCount = pageButtonMaxCount;
    }

    public void setExactTotalSize(boolean value) {
        this.exactTotalSize = value;
    }

    public boolean isExactTotalSize() {
        return this.exactTotalSize;
    }

    public boolean hasPrevPage() {
        return this.firstRow > 0;
    }

    public boolean hasNextPage() {
        return this.firstRow + this.pageSize < this.totalSize;
    }

    public int getNextPageFirstRow() {
        return this.firstRow + this.pageSize;
    }

    public int getPrevPageFirstRow() {
        return Math.max(0, this.firstRow - this.pageSize);
    }

    public int getLastPageFirstRow() {
        int pagesCount = this.getPagesCount();
        return pagesCount > 0 ? (pagesCount - 1) * this.pageSize : 0;
    }

    public int getLastPageFirstRow(int size) {
        int pagesCount = this.getPagesCount(size);
        return pagesCount > 0 ? (pagesCount - 1) * this.pageSize : 0;
    }

    public int getCurrentPage() {
        return this.firstRow / this.pageSize;
    }

    public int getPageButtonFirstRow(int pageButtonIndex) {
        int currentPageIndex = this.getCurrentPageButtonIndex();
        return this.firstRow + (pageButtonIndex - currentPageIndex) * this.pageSize;
    }

    public int getPageButtonPage(int pageButtonIndex) {
        return this.getPageButtonFirstRow(pageButtonIndex) / this.pageSize + 1;
    }

    public boolean isCurrentPageButton(int pageButtonIndex) {
        return pageButtonIndex == this.getCurrentPageButtonIndex();
    }

    private int getCurrentPageButtonIndex() {
        int currentPageButtonIndex = (this.getPageButtonsCount() - 1) / 2;
        currentPageButtonIndex = Math.min(currentPageButtonIndex, this.getCurrentPage());
        currentPageButtonIndex = Math.max(currentPageButtonIndex, this.getCurrentPage() + this.getPageButtonsCount() - this.getPagesCount());
        return currentPageButtonIndex;
    }

    public boolean hasInvisibleLeadingPageButtons() {
        return this.getPageButtonFirstRow(0) > 0;
    }

    public boolean hasInvisibleTrailingPageButtons() {
        return this.getPageButtonFirstRow(this.pageButtonMaxCount) < this.totalSize || !this.isExactTotalSize();
    }

    public int getPagesCount() {
        return this.getPagesCount(this.totalSize);
    }

    public int getPagesCount(int size) {
        int pageCount = size > 0 ? (size - 1) / this.pageSize + 1 : 0;
        return pageCount;
    }

    public int getPageButtonsCount() {
        return Math.min(this.getPagesCount(), this.pageButtonMaxCount);
    }

    public Iterable<Integer> getPageButtonsIndexes() {
        return Sequence.fromClosure((_FunctionTypes._return_P0_E0)new ISequenceClosure<Integer>(){

            public Iterable<Integer> iterable() {
                return new Iterable<Integer>(){

                    @Override
                    public Iterator<Integer> iterator() {
                        return new YieldingIterator<Integer>(){
                            private int __CP__ = 0;
                            private int _2_i;

                            protected boolean moveToNext() {
                                block9: while (true) {
                                    switch (this.__CP__) {
                                        case -1: {
                                            assert (false) : "Internal error";
                                            return false;
                                        }
                                        case 2: {
                                            this._2_i = 0;
                                        }
                                        case 3: {
                                            if (this._2_i >= PagerInfo.this.getPageButtonsCount()) {
                                                this.__CP__ = 1;
                                                continue block9;
                                            }
                                            this.__CP__ = 4;
                                            continue block9;
                                        }
                                        case 5: {
                                            ++this._2_i;
                                            this.__CP__ = 3;
                                            continue block9;
                                        }
                                        case 6: {
                                            this.__CP__ = 5;
                                            this.yield(this._2_i);
                                            return true;
                                        }
                                        case 0: {
                                            this.__CP__ = 2;
                                            continue block9;
                                        }
                                        case 4: {
                                            this.__CP__ = 6;
                                            continue block9;
                                        }
                                    }
                                    break;
                                }
                                return false;
                            }
                        };
                    }
                };
            }
        });
    }

    public int getCurrentFirstRow() {
        return this.firstRow;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public IssuesDTO getIssuesDTO() {
        return this.issuesDTO;
    }

    public void update() {
        if (this.update != null) {
            this.issuesDTO = (IssuesDTO)this.update.invoke((Object)this);
        }
    }

    public void setUpdate(_FunctionTypes._return_P1_E0<? extends IssuesDTO, ? super PagerInfo> update) {
        this.update = update;
    }
}

