/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.panel.attachment;

import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.InputStream;
import jetbrains.charisma.persistent.UserUIActionsContainer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.FileMeta;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.misc.ImageSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentThumbnailImpl
extends PersistentFileImpl {
    private static String __ENTITY_TYPE__ = "AttachmentThumbnail";
    private static int MAX_THUMBNAILS_FOR_ATTACHMENT = 2;
    protected static Log log = LogFactory.getLog(AttachmentThumbnailImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(Entity file, int width, int height, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"imageFile", (Entity)file);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"width", (Comparable)Integer.valueOf(width), Integer.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"height", (Comparable)Integer.valueOf(height), Integer.class);
        this.createThumbnail(file, entity);
        return entity;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (AttachmentThumbnailImpl.isEmpty_k4b9ec_a0b0c((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null))) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)"thumbnail"), String.class);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Empty name for thumbnail " + entity.toIdString()));
            }
        }
    }

    private void createThumbnail(Entity file, Entity entity) {
        FileMeta meta = new FileMeta(file);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)file, (String)"PersistentFile")).getThumbnail(((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"width", Integer.class, null)).intValue(), ((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"height", Integer.class, null)).intValue(), true, meta, file));
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)file, (String)"PersistentFile")).getName(file)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)Long.valueOf(meta.getSize()), Long.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)file, (String)"mimeType", String.class, null)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"charset", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)file, (String)"charset", String.class, null)), String.class);
    }

    public void resize(int maxWidth, int maxHeight, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"width", (Comparable)Integer.valueOf(maxWidth), Integer.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"height", (Comparable)Integer.valueOf(maxHeight), Integer.class);
        super.resize(maxWidth, maxHeight, true, entity);
    }

    public static Entity constructor(Entity file, int width, int height) {
        return ((AttachmentThumbnailImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(file, width, height, __ENTITY_TYPE__);
    }

    public static Entity getThumbnail(final Entity file, final int width, final int height) {
        TreeKeepingEntityIterable thumbs = QueryOperations.query(null, (String)"AttachmentThumbnail", (NodeBase)new LinkEqual("imageFile", file));
        Entity thumb = null;
        for (Entity it : Sequence.fromIterable((Iterable)thumbs)) {
            if ((Integer)PrimitiveAssociationSemantics.get((Entity)it, (String)"height", Integer.class, null) != height || (Integer)PrimitiveAssociationSemantics.get((Entity)it, (String)"width", Integer.class, null) != width) continue;
            thumb = it;
            break;
        }
        if (EntityOperations.equals(thumb, null)) {
            if (((ImageSupport)ServiceLocator.getBean((String)"imageSupport")).canResize(file)) {
                ((UserUIActionsContainer)ServiceLocator.getBean((String)"userUIActionsContainer")).addAction(new _FunctionTypes._void_P0_E0(){

                    public void invoke() {
                        TreeKeepingEntityIterable thumbs = QueryOperations.query(null, (String)"AttachmentThumbnail", (NodeBase)new LinkEqual("imageFile", file));
                        if (QueryOperations.getSize((Iterable)thumbs) >= MAX_THUMBNAILS_FOR_ATTACHMENT - 1) {
                            Sequence.fromIterable((Iterable)QueryOperations.skip((Iterable)thumbs, (int)(MAX_THUMBNAILS_FOR_ATTACHMENT - 1))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                                public void visit(Entity it) {
                                    EntityOperations.remove((Entity)it);
                                }
                            });
                        }
                        AttachmentThumbnailImpl.constructor(file, width, height);
                    }
                });
            }
            return file;
        }
        return thumb;
    }

    public static boolean isEmpty_k4b9ec_a0b0c(String str) {
        return str == null || str.length() == 0;
    }
}

