/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.panel.attachment;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.HashSet;
import java.util.Set;
import jetbrains.charisma.maintenance.MaintenanceUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyContainer;
import jetbrains.mps.webr.runtime.util.UserAgentUtil;
import jetbrains.mps.webr.runtime.util.UserBrowser;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class AttachmentUtils {
    private static final double PASTE_MIN_CHROME_VERSION = 31.0;
    private static final double PASTE_MIN_OPERA_VERSION = 15.0;
    private static final Set<String> IMAGE_TOOL_SUPPORTED_FORMATS = SetSequence.fromSetAndArray(new HashSet(), (Object[])new String[]{"jpeg", "jpg", "png", "bmp"});

    public String pasteHotkeyRepresentation() {
        return this.webkitPasteSupport() ? ((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("HTML5Paste").getPresentation() : ((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("PasteFromClipboardNoPreview").getPresentation();
    }

    public String pasteWithPreviewHotkeyRepresentation() {
        return ((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("PasteFromClipboard").getPresentation() + ", " + ((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("TakeScreenshot").getPresentation();
    }

    public boolean webkitPasteSupport() {
        String browserVersionString = UserAgentUtil.getKnownBrowserVersion();
        if (browserVersionString == null || browserVersionString.length() == 0) {
            return false;
        }
        double browserVersion = AttachmentUtils.getBrowserVersion();
        return UserAgentUtil.getUserBrowser() == UserBrowser.CHROME && browserVersion >= 31.0 || UserAgentUtil.getUserBrowser() == UserBrowser.OPERA && browserVersion >= 15.0;
    }

    public String getAttachButtonDescription() {
        UserBrowser userBrowser = UserAgentUtil.getUserBrowser();
        if (userBrowser == UserBrowser.CHROME || userBrowser == UserBrowser.FIREFOX) {
            if (((AttachmentUtils)ServiceLocator.getBean((String)"attachmentUtils")).webkitPasteSupport()) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ImageAttachmentUtils.drag_files_or_paste_image", new Object[]{((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("HTML5Paste").getPresentation()});
            }
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AttachmentPanel.or_drag_your_files_here", new Object[0]);
        }
        return this.getMaxUploadSizeDescription();
    }

    public String getMaxUploadSizeDescription() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AttachmentPanel.Maximum_file_size", new Object[]{MaintenanceUtil.formatFileSizeNoParenthesis((Long)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"maxUploadFileSize", Long.class, null))});
    }

    public boolean isEditableImage(Entity attachmant) {
        if (!((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)attachmant, (String)"PersistentFile")).isImage(attachmant)) {
            return false;
        }
        int separatorIdx = ((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)attachmant, (String)"PersistentFile")).getMimeType(attachmant).indexOf(47);
        if (separatorIdx < 0) {
            return false;
        }
        String format = ((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)attachmant, (String)"PersistentFile")).getMimeType(attachmant).substring(separatorIdx + 1).toLowerCase();
        return SetSequence.fromSet(IMAGE_TOOL_SUPPORTED_FORMATS).contains((Object)format);
    }

    private static double getBrowserVersion() {
        String knownBrowserVersion = UserAgentUtil.getKnownBrowserVersion();
        if (knownBrowserVersion == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(knownBrowserVersion);
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }
}

