/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.parser.date;

import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.smartui.parser.date.DatePeriod;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;

public abstract class AbstractDatePeriod
implements DatePeriod {
    @Override
    public boolean matches(Long date) {
        boolean result = false;
        if (DateTimeOperations.compare((Long)date, (CompareType)CompareType.NE, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            result = true;
            Long to = this.getTo();
            Long from = this.getFrom();
            if (DateTimeOperations.compare((Long)from, (CompareType)CompareType.NE, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
                result = DateTimeOperations.compare((Long)from, (CompareType)CompareType.LE, (Long)date, (DateTimeFieldType)DateTimeFieldType.millisOfSecond());
            }
            if (DateTimeOperations.compare((Long)to, (CompareType)CompareType.NE, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
                result = result && DateTimeOperations.compare((Long)date, (CompareType)CompareType.LE, (Long)to, (DateTimeFieldType)DateTimeFieldType.millisOfSecond());
            }
        }
        return result;
    }

    protected static DateTime getNowInCurrentUserTimeZone() {
        return new DateTime(AbstractDatePeriod.getCurrentTimeZone());
    }

    protected static DateTime getTodayStartInUtcTimeZone() {
        DateTimeZone currentTimeZone = AbstractDatePeriod.getCurrentTimeZone();
        DateTime todayStartInUserTimeZone = new DateTime(currentTimeZone).withTimeAtStartOfDay();
        DateTime sameDayStartInUtc = todayStartInUserTimeZone.withZoneRetainFields(DateTimeZone.UTC);
        return sameDayStartInUtc;
    }

    protected static DateTimeZone getCurrentTimeZone() {
        return ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).isPresent() ? ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone() : ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getTimeZone((Entity)ServiceLocator.getBean((String)"applicationMetaData"));
    }
}

