/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.parser.filterCreator;

import jetbrains.charisma.smartui.parser.filterCreator.ProjectContextual;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.util.StringInterner;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.api.parser.LocalContext;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.api.parser.SuggestionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFieldValue<T>
implements IFieldValue<T>,
ProjectContextual {
    private final T entity;
    protected final String name;
    protected final String description;
    protected final int matchingStart;
    private final boolean shouldSuggest;

    protected BaseFieldValue() {
        this(null, null, null, 0);
    }

    protected BaseFieldValue(String name, int matchingStart) {
        this(null, name, null, matchingStart);
    }

    protected BaseFieldValue(T entity, String name, String description, int matchingStart) {
        this(entity, name, description, matchingStart, true);
    }

    protected BaseFieldValue(T entity, String name, String description, int matchingStart, boolean shouldSuggest) {
        this.entity = entity;
        this.name = name == null ? null : StringInterner.intern((String)name);
        this.description = description == null ? null : StringInterner.intern((String)description);
        this.matchingStart = matchingStart;
        this.shouldSuggest = shouldSuggest;
    }

    public Suggestion getSuggestion(@NotNull LocalContext context, String matching, int completionStart, int completionEnd) {
        Suggestion suggestion = this.createFieldValueSuggestion(context);
        suggestion.setCompletionStart(completionStart);
        suggestion.setCompletionEnd(completionEnd);
        suggestion.setMatchingStart(this.matchingStart);
        suggestion.setMatchingEnd(this.matchingStart + matching.length());
        suggestion.setType(this.getSuggestionType());
        suggestion.setMultiValueDescription(this.getMultiValueDescription());
        this.specifySuggestion(context, suggestion);
        return suggestion;
    }

    protected Suggestion createFieldValueSuggestion(@NotNull LocalContext context) {
        return new Suggestion(this.getName(), this.getDescription());
    }

    protected void specifySuggestion(@NotNull LocalContext context, Suggestion suggestion) {
    }

    @Nullable
    protected IField getCommandField(IField field) {
        return field != null ? field : this.getAloneField();
    }

    protected SuggestionType getSuggestionType() {
        return SuggestionType.CATEGORY_VALUE;
    }

    protected boolean containMatchingProject(Iterable<Entity> contextProjects) {
        return QueryOperations.isEmpty(contextProjects) || QueryOperations.contains(contextProjects, (Entity)this.getMatchingProject());
    }

    protected boolean containProjects(Iterable<Entity> contextProjects, Iterable<Entity> projects) {
        return QueryOperations.isEmpty(contextProjects) || QueryOperations.isEmpty(projects) || !QueryOperations.isEmpty((Iterable)QueryOperations.intersect(contextProjects, projects));
    }

    public boolean matchesContext(@NotNull IContext context) {
        return true;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public IField getAloneField() {
        return null;
    }

    public String getName(T value) {
        return value.toString();
    }

    public String getRangeEndName() {
        return null;
    }

    public String getDisplayName(IField filterGroup) {
        return this.getName();
    }

    public boolean isUnintersectable() {
        return false;
    }

    public String getTooltip(IField filterGroup) {
        return this.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public String getMultiValueDescription() {
        return null;
    }

    public boolean isPrimary() {
        return this.matchingStart == 0;
    }

    public T getFieldValue() {
        return this.entity;
    }

    @Override
    public Entity getMatchingProject() {
        return null;
    }

    protected boolean compareCommandTypes(PredefinedCommandType existed, PredefinedCommandType created) {
        if (created == null && existed == null) {
            return true;
        }
        if (existed == null) {
            return PredefinedCommandType.add.equals((Object)created);
        }
        if (created == null) {
            return PredefinedCommandType.add.equals((Object)existed);
        }
        return existed.equals((Object)created);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        BaseFieldValue that = (BaseFieldValue)o;
        return this.getFieldValue() == that.getFieldValue() || this.getFieldValue() != null && this.getFieldValue().equals(that.getFieldValue());
    }

    public int hashCode() {
        int result = this.getFieldValue() != null ? this.getFieldValue().hashCode() : 0;
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public boolean shouldSuggest() {
        return this.shouldSuggest;
    }

    public boolean shouldSuggest(@Nullable PredefinedCommandType command) {
        return this.shouldSuggest();
    }

    public BaseFieldValue getCategorizedSynonym() {
        return this;
    }
}

