/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.parser.search;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.smartui.filter.FilterParam;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.search.ParseResultUtil;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import org.jetbrains.annotations.NotNull;

public class CheckedOptions {
    private IParseResult parseResult;
    private Map<IField, Set<IFieldValue>> checkedParams;

    public CheckedOptions(IParseResult parseResult) {
        this.parseResult = parseResult;
    }

    public void reset() {
        this.checkedParams = null;
    }

    public boolean isChecked(@NotNull IField field, @NotNull IFieldValue value) {
        Set p;
        boolean checked = false;
        if (this.checkedParams != null && (p = (Set)MapSequence.fromMap(this.checkedParams).get((Object)field)) != null) {
            checked = SetSequence.fromSet((Set)p).contains((Object)value);
        }
        return checked;
    }

    public String setChecked(Iterable<FilterParam> filterParams, boolean checked) {
        for (FilterParam filterParam : Sequence.fromIterable(filterParams)) {
            if (checked) {
                this.check(filterParam.getFilterGroup(), filterParam.getFilterField());
                continue;
            }
            this.uncheck(filterParam.getFilterGroup(), filterParam.getFilterField());
        }
        return this.applyFilterParams();
    }

    private void check(@NotNull IField field, @NotNull IFieldValue value) {
        Set values;
        if (this.checkedParams == null) {
            this.checkedParams = MapSequence.fromMap(new HashMap());
        }
        if ((values = (Set)MapSequence.fromMap(this.checkedParams).get((Object)field)) == null) {
            values = SetSequence.fromSet(new LinkedHashSet());
            MapSequence.fromMap(this.checkedParams).put((Object)field, (Object)values);
        }
        SetSequence.fromSet((Set)values).addElement((Object)value);
    }

    private void uncheck(@NotNull IField field, @NotNull IFieldValue value) {
        if (this.checkedParams == null) {
            return;
        }
        Set values = (Set)MapSequence.fromMap(this.checkedParams).get((Object)field);
        if (values == null) {
            return;
        }
        SetSequence.fromSet((Set)values).removeElement((Object)value);
    }

    public boolean areAllChecked(@NotNull IField field) {
        if (this.checkedParams == null) {
            return true;
        }
        Set values = (Set)MapSequence.fromMap(this.checkedParams).get((Object)field);
        return SetSequence.fromSet((Set)values).isEmpty();
    }

    public String setAllChecked(@NotNull IField field) {
        if (this.checkedParams != null) {
            MapSequence.fromMap(this.checkedParams).removeKey((Object)field);
        }
        return this.applyFilterParams();
    }

    public boolean isAnyChecked() {
        return MapSequence.fromMap(this.checkedParams).isNotEmpty();
    }

    private String applyFilterParams() {
        return ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).conjugate(this.parseResult, this.checkedParams);
    }
}

