/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.links.persistent.DirectedLink;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeUtil;
import jetbrains.charisma.persistence.security.VisibilityOptionsProviderFactory;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.watchFolder.WatchFolderImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.OrderedEntitiesListener;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.YouTrackQueryEngine;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Context
implements IContext {
    protected static Log log = LogFactory.getLog(Context.class);
    private Set<Entity> enclosingIssueFolders = null;
    private Iterable<Entity> selectedIssues = null;
    private Set<Entity> tagsOfSelectedIssues;
    private Map<Operation, Boolean> cachedOperations;
    private Map<Entity, Map<Operation, Boolean>> cachedProjectOperations;
    private Map<String, Boolean> cachedPermissions;
    private Boolean isReporterOfAllSelectedIssues;
    private Boolean isSelectedIssuesFromSameProject;
    private Set<Entity> selectedProjects;
    private IContext.Activity activity;
    private Map<String, Set> cachedUsers;
    private Set<Entity> cachedGroups;
    private Set<Entity> cachedGroupsSuggestions;
    private Set<Entity> cachedAllCustomFieldPrototypes;
    private Boolean canReadUsers = null;
    private Iterable<Entity> contextFolders;
    private EntityIdSet usersInBundlesSet = null;
    private List<Entity> userBundlesWithAllUsers = null;
    private YouTrackQueryEngine.MultiValueGetter userBundlesGetter = null;
    private List<Entity> readPermittedAllUsersBundleProjectCustomFields = null;
    private final IField predefinedFieldStar = (IField)ServiceLocator.getBean((String)"predefinedFieldStar");
    private final IField predefinedFieldVisibleTo = (IField)ServiceLocator.getBean((String)"predefinedFieldVisibleTo");
    private List<Entity> contextProjects;
    private boolean quotedValue;
    private OrderedEntitiesListener orderedEntitiesListener;

    public Context() {
    }

    public Context(OrderedEntitiesListener numberOfOrderedCallback) {
        this.orderedEntitiesListener = numberOfOrderedCallback;
    }

    public Iterable<Entity> getContextFolders() {
        return this.contextFolders;
    }

    public void setContextFolder(@Nullable Iterable<Entity> contextFolders) {
        if (contextFolders == null || EntityOperations.equals((Entity)QueryOperations.getFirst(contextFolders), null)) {
            return;
        }
        this.contextFolders = contextFolders;
        this.contextProjects = Sequence.fromIterable(contextFolders).translate((_FunctionTypes._return_P1_E0)new ITranslator2<Entity, Entity>(){

            public Iterable<Entity> translate(Entity it) {
                return ((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"IssueFolder")).getQueryProjects(it);
            }
        }).toListSequence();
    }

    @NotNull
    public Set<Entity> getSelectedProjects() {
        if (this.selectedProjects == null) {
            Object projects = this.selectedIssues == null ? QueryOperations.queryGetAll((String)"Project") : (!QueryOperations.isEmpty(this.selectedIssues) ? QueryOperations.selectDistinct(this.selectedIssues, (String)"project") : SetSequence.fromSet(new HashSet()));
            this.selectedProjects = SetSequence.fromSetWithValues(new HashSet(), (Iterable)projects);
        }
        return this.selectedProjects;
    }

    public Set<EntityId> getPositiveProjectIds() {
        if (this.contextProjects == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<EntityId> result = new HashSet<EntityId>();
        for (Entity project : this.contextProjects) {
            result.add(project.getId());
        }
        return result;
    }

    public void setSelectedProjects(Iterable<Entity> selectedProjects) {
        this.selectedProjects = null;
        this.selectedProjects = SetSequence.fromSetWithValues(new HashSet(), selectedProjects);
    }

    public Iterable<Entity> getSelectedIssues() {
        return this.selectedIssues == null ? QueryOperations.empty((String)"Issue") : this.selectedIssues;
    }

    public void setSelectedIssues(Iterable<Entity> selectedIssues) {
        this.selectedIssues = selectedIssues;
        this.selectedProjects = null;
    }

    public void setCurrentActivity(IContext.Activity activity) {
        this.activity = activity;
    }

    @Nullable
    public IContext.Activity getCurrentActivity() {
        return this.activity;
    }

    public void pushEnclosingIssueFolder(Entity issueFolder) {
        if (this.enclosingIssueFolders == null) {
            this.enclosingIssueFolders = new HashSet<Entity>();
        }
        this.enclosingIssueFolders.add(issueFolder);
    }

    public void popEnclosingIssueFolder(Entity issueFolder) {
        if (this.enclosingIssueFolders != null) {
            this.enclosingIssueFolders.remove(issueFolder);
        }
    }

    public boolean isEncloseByIssueFolder(Entity savedQuery) {
        return this.enclosingIssueFolders != null && this.enclosingIssueFolders.contains(savedQuery);
    }

    public boolean hasPermissionForSelectedIssuesProjects(Permission p) {
        return this.hasPermissionForSelectedIssuesProjects(p, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    public boolean hasPermissionForSelectedIssuesProjects(Permission p, Entity u) {
        Boolean res = this.getCachedPermission(u, p);
        if (res == null) {
            res = true;
            for (Entity project : SetSequence.fromSet((Set)this.getSelectedProjects())) {
                if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)u, (String)"User")).hasPermission(p, project, u)) continue;
                res = false;
                break;
            }
            this.putCachedPermission(u, p, res);
        }
        return res;
    }

    public boolean allSelectedProjects(_FunctionTypes._return_P1_E0<? extends Boolean, ? super Entity> matches) {
        Iterable selectedProjects = this.getSelectedProjects();
        if (selectedProjects == null) {
            return true;
        }
        return SetSequence.fromSet((Set)selectedProjects).all(matches);
    }

    public boolean allSelectedIssues(_FunctionTypes._return_P1_E0<? extends Boolean, ? super Entity> matches) {
        if (this.selectedIssues == null) {
            return true;
        }
        return Sequence.fromIterable(this.selectedIssues).all(matches);
    }

    public Collection<Entity> getContextProjects() {
        return this.contextProjects;
    }

    public boolean isSelectedIssuesFromSameProject() {
        if (this.isSelectedIssuesFromSameProject == null) {
            this.calculateIsSelectedIssuesFromSameProject();
        }
        return this.isSelectedIssuesFromSameProject;
    }

    public boolean isReporterOfAllSelectedIssues() {
        if (this.isReporterOfAllSelectedIssues == null) {
            final Entity user = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
            this.isReporterOfAllSelectedIssues = this.allSelectedIssues((_FunctionTypes._return_P1_E0<? extends Boolean, ? super Entity>)new _FunctionTypes._return_P1_E0<Boolean, Entity>(){

                public Boolean invoke(Entity i) {
                    return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)i, (String)"reporter"), (Object)user);
                }
            });
        }
        return this.isReporterOfAllSelectedIssues;
    }

    public boolean selectedIssuesContainTag(Entity tag) {
        if (this.tagsOfSelectedIssues == null) {
            this.calculateTagsOfSelectedIssues();
        }
        return this.tagsOfSelectedIssues.contains(tag);
    }

    public boolean canTagUntagSelectedIssues(Entity issueTag) {
        Entity user = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        if (EntityOperations.equals((Entity)issueTag, null)) {
            return false;
        }
        if (((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)issueTag, (String)"WatchFolder")).isAccessible(Operation.READ, user, issueTag)) {
            if (((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)issueTag, (String)"WatchFolder")).isAccessible(Operation.UPDATE, user, issueTag)) {
                return true;
            }
            if (this.hasPermissionForSelectedIssuesProjects(Permission.PRIVATE_UPDATE_ISSUE, user)) {
                return true;
            }
        }
        return false;
    }

    private void calculateTagsOfSelectedIssues() {
        this.tagsOfSelectedIssues = SetSequence.fromSet(new HashSet());
        for (Entity i : Sequence.fromIterable(this.getSelectedIssues())) {
            SetSequence.fromSet(this.tagsOfSelectedIssues).addSequence(Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)i, (String)"tags")));
        }
    }

    private void calculateIsSelectedIssuesFromSameProject() {
        Entity p = null;
        if (this.selectedIssues != null) {
            for (Entity i : Sequence.fromIterable(this.selectedIssues)) {
                if (EntityOperations.equals(p, null)) {
                    p = AssociationSemantics.getToOne((Entity)i, (String)"project");
                    continue;
                }
                if (EntityOperations.equals((Entity)p, (Object)AssociationSemantics.getToOne((Entity)i, (String)"project"))) continue;
                this.isSelectedIssuesFromSameProject = false;
                return;
            }
        }
        this.isSelectedIssuesFromSameProject = true;
    }

    public boolean isSelectedIssuesAccessible(final Operation o) {
        Boolean res = this.getCachedOperation(o);
        if (res == null) {
            if (this.selectedIssues == null || QueryOperations.isEmpty(this.selectedIssues)) {
                res = true;
            } else {
                Iterable<Entity> selectedIssues = this.selectedIssues;
                res = this.isIssuesAccessible(selectedIssues, o);
            }
            this.putCachedOperation(o, res);
            if (res.booleanValue()) {
                SetSequence.fromSet(this.selectedProjects).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                    public void visit(Entity it) {
                        Context.this.putCachedOperation(it, o, true);
                    }
                });
            }
        }
        return res;
    }

    private Boolean isIssuesAccessible(Iterable<Entity> selectedIssues, Operation o) {
        Boolean res = true;
        Entity currentUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        for (Entity i : Sequence.fromIterable(selectedIssues)) {
            if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).isAccessible(o, currentUser, i)) continue;
            res = false;
            break;
        }
        return res;
    }

    public boolean isSelectedIssuesAccessible(Map<Entity, Operation> operations) {
        boolean res = true;
        for (Entity project : SetSequence.fromSet((Set)this.getSelectedProjects())) {
            if (!operations.containsKey(project)) {
                return false;
            }
            Operation op = operations.get(project);
            Boolean result = this.getCachedOperation(project, op);
            if (result == null) {
                TreeKeepingEntityIterable projectIssues = QueryOperations.query(this.selectedIssues, (String)"Issue", (NodeBase)new LinkEqual("project", project));
                result = this.isIssuesAccessible((Iterable<Entity>)projectIssues, op);
                this.putCachedOperation(project, op, result);
            }
            if (res = res && result != false) continue;
            return false;
        }
        return res;
    }

    public Boolean getCachedOperation(Entity project, Operation op) {
        if (this.cachedProjectOperations == null) {
            return null;
        }
        Map operations = (Map)MapSequence.fromMap(this.cachedProjectOperations).get((Object)project);
        if (operations == null) {
            return null;
        }
        return (Boolean)operations.get(op);
    }

    public void putCachedOperation(Entity project, Operation op, boolean res) {
        Map operations;
        if (this.cachedProjectOperations == null) {
            this.cachedProjectOperations = MapSequence.fromMap(new HashMap());
        }
        if ((operations = (Map)MapSequence.fromMap(this.cachedProjectOperations).get((Object)project)) == null) {
            operations = MapSequence.fromMap(new HashMap());
            MapSequence.fromMap(this.cachedProjectOperations).put((Object)project, (Object)MapSequence.fromMap(new HashMap()));
        }
        MapSequence.fromMap((Map)operations).put((Object)op, (Object)res);
    }

    private Boolean getCachedOperation(Operation o) {
        if (this.cachedOperations == null) {
            return null;
        }
        return (Boolean)MapSequence.fromMap(this.cachedOperations).get((Object)o);
    }

    private void putCachedOperation(Operation o, boolean res) {
        if (this.cachedOperations == null) {
            this.cachedOperations = MapSequence.fromMap(new HashMap());
        }
        MapSequence.fromMap(this.cachedOperations).put((Object)o, (Object)res);
    }

    private Boolean getCachedPermission(Entity user, Permission p) {
        if (this.cachedPermissions == null) {
            return null;
        }
        return (Boolean)MapSequence.fromMap(this.cachedPermissions).get((Object)((String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>") + p.getKey()));
    }

    private void putCachedPermission(Entity user, Permission p, boolean res) {
        if (this.cachedPermissions == null) {
            this.cachedPermissions = MapSequence.fromMap(new HashMap());
        }
        MapSequence.fromMap(this.cachedPermissions).put((Object)((String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>") + p.getKey()), (Object)res);
    }

    public Set<Entity> getAllCustomFieldPrototypes() {
        if (this.cachedAllCustomFieldPrototypes == null) {
            HashSet<Entity> allProtos = new HashSet<Entity>();
            for (Entity proto : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"CustomFieldPrototype"))) {
                allProtos.add(proto);
            }
            this.cachedAllCustomFieldPrototypes = allProtos;
        }
        return this.cachedAllCustomFieldPrototypes;
    }

    public void forEach(final _FunctionTypes._void_P1_E0<? super Entity> f) {
        Sequence.fromIterable(this.getSelectedIssues()).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                f.invoke((Object)it);
            }
        });
    }

    public Iterable<Entity> getLinkedIssues(Entity linkPrototype, boolean outward) {
        Iterable linkedIssues = null;
        for (Entity i : Sequence.fromIterable(this.getSelectedIssues())) {
            if (linkedIssues == null) {
                linkedIssues = this.getLinkedIssues(i, linkPrototype, outward);
                continue;
            }
            linkedIssues = QueryOperations.intersect(linkedIssues, this.getLinkedIssues(i, linkPrototype, outward));
        }
        return linkedIssues;
    }

    private Iterable<Entity> getLinkedIssues(Entity issue, Entity linkPrototype, boolean outward) {
        if (EntityOperations.equals((Entity)linkPrototype, null)) {
            return IssueLinkPrototypeUtil.getAllLinkedIssues(issue);
        }
        return IssueLinkPrototypeUtil.getLinkedIssues(issue, new DirectedLink(linkPrototype, outward));
    }

    public Set getChanedUsersForPrototype(Entity prototype) {
        return this.cachedUsers == null ? null : (Set)MapSequence.fromMap(this.cachedUsers).get(PrimitiveAssociationSemantics.get((Entity)prototype, (String)"name", String.class, null));
    }

    public void setChanedUsersForPrototype(Entity prototype, Set users) {
        if (this.cachedUsers == null) {
            this.cachedUsers = MapSequence.fromMap(new HashMap());
        }
        MapSequence.fromMap(this.cachedUsers).put(PrimitiveAssociationSemantics.get((Entity)prototype, (String)"name", String.class, null), (Object)users);
    }

    public boolean canReadUsers() {
        Boolean result = this.canReadUsers;
        if (result == null) {
            this.canReadUsers = result = Boolean.valueOf(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.READ_USER_BASIC, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()));
        }
        return result;
    }

    public boolean isVisibleGroup(Entity group) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            return true;
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.READ_USERGROUP, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
            return true;
        }
        if (this.cachedGroups == null) {
            this.cachedGroups = SetSequence.fromSetWithValues(new HashSet(), ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).getUserGroups(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()));
        }
        return QueryOperations.contains(this.cachedGroups, (Entity)group);
    }

    public boolean canBeSetAsVisibleFor(Entity group) {
        if (((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            return true;
        }
        if (this.cachedGroupsSuggestions == null) {
            this.cachedGroupsSuggestions = SetSequence.fromSetWithValues(new HashSet(), ((VisibilityOptionsProviderFactory)ServiceLocator.getBean((String)"visibilityOptionsProviderFactory")).getProvider().getAllGroupsForVisibility(this));
        }
        return QueryOperations.contains(this.cachedGroupsSuggestions, (Entity)group);
    }

    public boolean containsDrafts() {
        Iterator iterator = Sequence.fromIterable(this.getSelectedIssues()).iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Entity issue = (Entity)iterator.next();
        if (iterator.hasNext() || EntityOperations.isRemoved((Entity)issue)) {
            this.disposeIteratorIfNecessary(iterator);
            return false;
        }
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isDraft(issue);
    }

    public boolean isUserInSomeBundle(Entity user) {
        EntityIdSet set = this.getUsersInBundlesSet();
        return set.contains(user.getId());
    }

    public Iterable<EntityId> getUserBundles(Entity user) {
        YouTrackQueryEngine.MultiValueGetter getter = this.userBundlesGetter;
        if (getter == null) {
            EntityIterableBase iterable = this.getUsersInBundlesIterable();
            this.userBundlesGetter = getter = (YouTrackQueryEngine.MultiValueGetter)iterable.getOrCreateCachedInstance(iterable.getTransaction());
        }
        return getter.getValue(user.getId());
    }

    public List<Entity> getUserBundlesWithAllUsers() {
        IListSequence result = this.userBundlesWithAllUsers;
        if (result == null) {
            this.userBundlesWithAllUsers = result = Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"UsersBundle", (NodeBase)new PropertyEqual("containsAllUsersGroup", (Comparable)Boolean.TRUE))).toListSequence();
        }
        return result;
    }

    public List<Entity> getReadPermittedAllUsersBundleProjectCustomFields() {
        IListSequence result = this.readPermittedAllUsersBundleProjectCustomFields;
        if (result == null) {
            Iterable<Object> found = Collections.emptyList();
            for (Entity bundle : ListSequence.fromList(this.getUserBundlesWithAllUsers())) {
                found = QueryOperations.union(found, (Iterable)((Security)ServiceLocator.getBean((String)"security")).getPermittedProjectCustomFields(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), bundle, Security.CustomFieldsAccess.SORTED_READ));
            }
            this.readPermittedAllUsersBundleProjectCustomFields = result = Sequence.fromIterable(found).toListSequence();
        }
        return result;
    }

    private EntityIdSet getUsersInBundlesSet() {
        EntityIdSet result = this.usersInBundlesSet;
        if (result == null) {
            EntityIterableBase bundles = this.getUsersInBundlesIterable();
            result = bundles.toSet(bundles.getTransaction());
            if (result.count() > 10000 && log.isWarnEnabled()) {
                log.warn((Object)"More than 10000 users are used in some bundle, this is suboptimal");
            }
            this.usersInBundlesSet = result;
        }
        return result;
    }

    private EntityIterableBase getUsersInBundlesIterable() {
        YouTrackQueryEngine queryEngine = (YouTrackQueryEngine)ServiceLocator.getBean((String)"queryEngine");
        return queryEngine.getAllUsersInUserBundles();
    }

    private void disposeIteratorIfNecessary(Iterator iterator) {
        if (iterator instanceof EntityIteratorBase) {
            ((EntityIteratorBase)iterator).disposeIfShouldBe();
        }
    }

    public boolean isQuotedValue() {
        return this.quotedValue;
    }

    public void setQuotedValue(boolean quotedValue1) {
        this.quotedValue = quotedValue1;
    }

    public IField getPredefinedFieldVisibleTo() {
        return this.predefinedFieldVisibleTo;
    }

    public IField getPredefinedFieldStar() {
        return this.predefinedFieldStar;
    }

    public OrderedEntitiesListener getOrderedIssuesListener() {
        return this.orderedEntitiesListener;
    }
}

