/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.persistent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.charisma.smartui.persistent.StringUtils;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.parser.runtime.base.SuggestItem;
import jetbrains.youtrack.api.parser.LocalizedSuggestItemSeparator;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.api.parser.SuggestionType;
import webr.framework.controller.BaseApplication;

public class RecentQueryCache
implements Serializable {
    public static final int NUMBER_OF_SAVED_QUERIES = 10;
    private static final Iterable<SuggestItem> SEPARATOR = Sequence.singleton((Object)new LocalizedSuggestItemSeparator("RecentQueryCache.Recent_Searches"));
    private static final String SESSION_FIELD = "recentQueryCache";
    private List<String> recentQueries = ListSequence.fromList(new ArrayList());
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Lock readLock = this.readWriteLock.readLock();
    private Lock writeLock = this.readWriteLock.writeLock();

    private RecentQueryCache() {
    }

    private void updateMemory(final String query) {
        this.writeLock.lock();
        try {
            ListSequence.fromList(this.recentQueries).removeWhere((_FunctionTypes._return_P1_E0)new IWhereFilter<String>(){

                public boolean accept(String it) {
                    return it.equalsIgnoreCase(query);
                }
            });
            ListSequence.fromList(this.recentQueries).addElement((Object)query);
            while (ListSequence.fromList(this.recentQueries).count() > 10) {
                ListSequence.fromList(this.recentQueries).removeElementAt(0);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static RecentQueryCache get() {
        RecentQueryCache cache = (RecentQueryCache)BaseApplication.getSessionField((String)SESSION_FIELD);
        if (cache == null) {
            cache = new RecentQueryCache();
            BaseApplication.setSessionField((String)SESSION_FIELD, (Object)cache);
        }
        return cache;
    }

    public static void addQuery(String query) {
        RecentQueryCache recentQueryCache = RecentQueryCache.get();
        if (recentQueryCache == null) {
            return;
        }
        String string = query = query == null ? null : query.trim();
        if (query != null && query.length() > 0) {
            recentQueryCache.updateMemory(query);
        }
    }

    public static Iterable<String> getRecentQueries(boolean sortAsc) {
        RecentQueryCache recentQueryCache = RecentQueryCache.get();
        if (recentQueryCache == null) {
            return Sequence.fromIterable(Collections.emptyList());
        }
        IListSequence result = null;
        try {
            recentQueryCache.readLock.lock();
            result = ListSequence.fromListWithValues(new ArrayList(), recentQueryCache.recentQueries);
        }
        finally {
            recentQueryCache.readLock.unlock();
        }
        if (!sortAsc) {
            Collections.reverse(result);
        }
        return result;
    }

    public static Iterable<SuggestItem> getSuggests(final String query, final int caret) {
        ISequence recentQueries = RecentQueryCache.getRecentQueries(true);
        if (RecentQueryCache.isNotEmpty_c76fcq_a0b0d(StringUtils.substring(query, 0, caret))) {
            recentQueries = Sequence.fromIterable(recentQueries).where((_FunctionTypes._return_P1_E0)new IWhereFilter<String>(){

                public boolean accept(String it) {
                    return it.toLowerCase().contains(StringUtils.substring(query, 0, caret).toLowerCase());
                }
            });
        }
        ISequence recentSuggestions = Sequence.fromIterable(recentQueries).select((_FunctionTypes._return_P1_E0)new ISelector<String, SuggestItem>(){

            public SuggestItem select(String it) {
                int completionEnd = query != null && query.length() > 0 ? query.length() : 0;
                int matchStart = query != null && query.length() > 0 ? it.toLowerCase().indexOf(StringUtils.substring(query, 0, caret).toLowerCase()) : 0;
                Suggestion suggestion = new Suggestion(it, "&nbsp;", 0, completionEnd, matchStart, matchStart + caret, SuggestionType.CATEGORY_VALUE);
                suggestion.setHtmlDescription(true);
                return suggestion;
            }
        });
        if (Sequence.fromIterable((Iterable)recentQueries).isNotEmpty()) {
            recentSuggestions = Sequence.fromIterable(SEPARATOR).concat(Sequence.fromIterable((Iterable)recentSuggestions));
        }
        return recentSuggestions;
    }

    public static boolean isNotEmpty_c76fcq_a0b0d(String str) {
        return str != null && str.length() > 0;
    }
}

