/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.shortcuts;

import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.smartui.shortcuts.Shortcuts;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.htmlComponent.runtime.IKey;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyContainer;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyStrokeMapping;
import jetbrains.mps.webr.htmlComponent.runtime.Key;
import jetbrains.mps.webr.htmlComponent.runtime.KeyCode;
import jetbrains.mps.webr.htmlComponent.runtime.KeyStrokeMapping;
import jetbrains.mps.webr.htmlComponent.runtime.KeyType;
import jetbrains.mps.webr.htmlComponent.runtime.LocalizedKeyStroke;
import jetbrains.mps.webr.runtime.util.UserBrowser;
import jetbrains.mps.webr.runtime.util.UserOS;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class ShortcutsDecoderEncoder {
    private static UserOS decodeOS(String os) {
        try {
            return UserOS.valueOf((String)os.toUpperCase());
        }
        catch (Exception e) {
            return UserOS.UNKNOWN;
        }
    }

    private static UserBrowser decodeBrowser(String browser) {
        try {
            return UserBrowser.valueOf((String)browser.toUpperCase());
        }
        catch (Exception e) {
            return UserBrowser.UNKNOWN;
        }
    }

    private static KeyType decodeKeyType(boolean keyType) {
        if (keyType) {
            return KeyType.TRUE;
        }
        return KeyType.FALSE;
    }

    public static LocalizedKeyStroke getLocalizedKeyStroke(Shortcuts.Shortcut shc) {
        LocalizedKeyStroke lks = (LocalizedKeyStroke)((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke(shc.getName());
        if (lks == null) {
            return null;
        }
        IListSequence ksms = ListSequence.fromList(new ArrayList());
        for (Shortcuts.Variant variant : shc.getVariants()) {
            KeyStrokeMapping ksm = new KeyStrokeMapping();
            IListSequence oses = ListSequence.fromList(new ArrayList());
            if (ListSequence.fromList(variant.getOs()).isNotEmpty()) {
                for (String string : variant.getOs()) {
                    oses.add(ShortcutsDecoderEncoder.decodeOS(string));
                }
            } else {
                oses.add(null);
            }
            ksm.setOses((List)oses);
            IListSequence browsers = ListSequence.fromList(new ArrayList());
            if (ListSequence.fromList(variant.getBrowser()).isNotEmpty()) {
                for (String browser : variant.getBrowser()) {
                    browsers.add(ShortcutsDecoderEncoder.decodeBrowser(browser));
                }
            } else {
                browsers.add(null);
            }
            ksm.setBrowsers((List)browsers);
            Shortcuts.KeyStroke keyStroke = variant.getKeyStroke();
            if (keyStroke == null) continue;
            Key key = new Key();
            key.setAlt(ShortcutsDecoderEncoder.decodeKeyType(keyStroke.getAlt()));
            key.setCtrl(ShortcutsDecoderEncoder.decodeKeyType(keyStroke.getCtrl()));
            key.setMeta(ShortcutsDecoderEncoder.decodeKeyType(keyStroke.getMeta()));
            key.setShift(ShortcutsDecoderEncoder.decodeKeyType(keyStroke.getShift()));
            KeyCode keyCode = new KeyCode();
            keyCode.setCode(keyStroke.getKeyCode());
            if (keyStroke.getKeyCode() != 0) {
                keyCode.setName(keyStroke.getName());
                keyCode.setMacName(keyStroke.getMacName() == null ? keyCode.getName() : keyStroke.getMacName());
            }
            key.setKeyCode(keyCode);
            ksm.setKey((IKey)key);
            ksms.add(ksm);
        }
        lks.setMappings((List)ksms);
        return lks;
    }

    public static Shortcuts.Shortcut getShortcut(LocalizedKeyStroke lks) {
        Shortcuts.Shortcut shc = new Shortcuts.Shortcut();
        shc.setName(lks.getName());
        shc.setVariants((List<Shortcuts.Variant>)ListSequence.fromList(new ArrayList()));
        for (IKeyStrokeMapping ksm : lks.getMappings()) {
            Shortcuts.Variant variant = new Shortcuts.Variant();
            variant.setOs((List<String>)ListSequence.fromList(new ArrayList()));
            for (UserOS os : ShortcutsDecoderEncoder.as_s3n3n6_a0a2a3a4(ksm, KeyStrokeMapping.class).getOses()) {
                if (os == null) continue;
                variant.getOs().add(os.toString().toLowerCase());
            }
            variant.setBrowser((List<String>)ListSequence.fromList(new ArrayList()));
            for (UserBrowser browser : ShortcutsDecoderEncoder.as_s3n3n6_a0a4a3a4(ksm, KeyStrokeMapping.class).getBrowsers()) {
                if (browser == null) continue;
                variant.getBrowser().add(browser.toString().toLowerCase());
            }
            Shortcuts.KeyStroke keyStroke = new Shortcuts.KeyStroke();
            IKey key = ksm.getKey();
            keyStroke.setAlt(key.getAlt().equals((Object)KeyType.TRUE));
            keyStroke.setCtrl(key.getCtrl().equals((Object)KeyType.TRUE));
            keyStroke.setMeta(key.getMeta().equals((Object)KeyType.TRUE));
            keyStroke.setShift(key.getShift().equals((Object)KeyType.TRUE));
            keyStroke.setKeyCode(key.getKeyCode().getCode());
            keyStroke.setName(key.getKeyCode().getName());
            keyStroke.setMacName(key.getKeyCode().getMacName());
            variant.setKeyStroke(keyStroke);
            shc.getVariants().add(variant);
        }
        return shc;
    }

    private static <T> T as_s3n3n6_a0a2a3a4(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_s3n3n6_a0a4a3a4(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

