/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.update;

import java.util.List;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.smartui.update.Feature;
import jetbrains.charisma.smartui.update.FeatureType;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permission;

public class FeatureList {
    private Iterable<Feature> features;

    public Iterable<Feature> getAllFeaturesSorted(Entity user) {
        return this.getFeatures(user, null, true, null);
    }

    public Iterable<Feature> getAllFeaturesSorted(Entity user, String product) {
        return this.getFeatures(user, null, true, product);
    }

    public Iterable<Feature> getUnseenFeatures(final Entity user) {
        return this.getFeatures(user, (_FunctionTypes._return_P1_E0<? extends Boolean, ? super Feature>)new _FunctionTypes._return_P1_E0<Boolean, Feature>(){

            public Boolean invoke(Feature it) {
                return it.isUnseen(user);
            }
        }, false, null);
    }

    public Iterable<Feature> getUnseenFeatures(final Entity user, String product) {
        return this.getFeatures(user, (_FunctionTypes._return_P1_E0<? extends Boolean, ? super Feature>)new _FunctionTypes._return_P1_E0<Boolean, Feature>(){

            public Boolean invoke(Feature it) {
                return it.isUnseen(user);
            }
        }, true, product);
    }

    public Iterable<Feature> getFeatures(Entity user, boolean all, String product) {
        Iterable<Feature> features = all ? this.getAllFeaturesSorted(user, product) : this.getUnseenFeatures(user, product);
        return features;
    }

    public Iterable<String> getProducts(boolean all) {
        if (((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).isGuest()) {
            return null;
        }
        return Sequence.fromIterable(this.getFeatures(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), all, null)).select((_FunctionTypes._return_P1_E0)new ISelector<Feature, String>(){

            public String select(Feature it) {
                return it.getProduct();
            }
        }).distinct();
    }

    public Iterable<Feature> getFeatures(Entity user, _FunctionTypes._return_P1_E0<? extends Boolean, ? super Feature> filterPredicat, boolean sorted, final String product) {
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isGuest(user)) {
            return null;
        }
        ISequence features = this.features;
        if (product != null) {
            features = Sequence.fromIterable(features).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Feature>(){

                public boolean accept(Feature it) {
                    return it.getProduct().equals(product);
                }
            });
        }
        if (!this.hasReadProjectPermissions(user)) {
            features = Sequence.fromIterable(features).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Feature>(){

                public boolean accept(Feature it) {
                    return it.getType() != FeatureType.ADMIN;
                }
            });
        }
        if (filterPredicat != null) {
            features = Sequence.fromIterable(features).where(filterPredicat);
        }
        ISequence result = Sequence.fromIterable(features).sort((_FunctionTypes._return_P1_E0)new ISelector<Feature, Comparable<?>>(){

            public Comparable<?> select(Feature it) {
                return it.getOrder();
            }
        }, true);
        return sorted ? Sequence.fromIterable((Iterable)result).sort((_FunctionTypes._return_P1_E0)new ISelector<Feature, Comparable<?>>(){

            public Comparable<?> select(Feature it) {
                return it.getReleaseDate();
            }
        }, false) : result;
    }

    private boolean hasReadProjectPermissions(Entity user) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.ADMIN_READ_APP, user) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.READ_PROJECT, user);
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }
}

