/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.watchFolder;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.regex.Pattern;
import jetbrains.charisma.persistent.Constraints;
import jetbrains.charisma.persistent.FieldRelatedUserConstraintValidationException;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;

public class ProjectNameChangeListener
extends EntityAdapter<Entity> {
    public void updatedSyncBeforeConstraints(Entity old, Entity current) {
        if (ProjectNameChangeListener.isNotEmpty_3prc6c_a0a0a0((String)PrimitiveAssociationSemantics.get((Entity)current, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())) && ProjectNameChangeListener.isNotEmpty_3prc6c_a0a0a0_0((String)PrimitiveAssociationSemantics.get((Entity)current, (String)"shortName", String.class, null))) {
            if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)current), (String)"name")) {
                this.assertName(current);
            }
            Constraints.assertNoForbiddenPathChars(current, "name", ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Project.name", new Object[0]));
            if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)current), (String)"shortName")) {
                this.assertShortName(current);
            }
        }
    }

    public void addedSyncBeforeConstraints(Entity current) {
        if (ProjectNameChangeListener.isNotEmpty_3prc6c_a0a0a1((String)PrimitiveAssociationSemantics.get((Entity)current, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())) && ProjectNameChangeListener.isNotEmpty_3prc6c_a0a0a1_0((String)PrimitiveAssociationSemantics.get((Entity)current, (String)"shortName", String.class, null))) {
            this.assertName(current);
            Constraints.assertNoForbiddenPathChars(current, "name", ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ProjectNameChangeListener.name1", new Object[0]));
            this.assertShortName(current);
        }
    }

    private void assertShortName(Entity project) throws ConstraintsValidationException {
        boolean matches = Pattern.compile("[a-zA-Z0-9_]+").matcher(ProjectNameChangeListener.trim_3prc6c_a0a0a0a0c((String)PrimitiveAssociationSemantics.get((Entity)project, (String)"shortName", String.class, null))).matches();
        if (!matches) {
            throw new ConstraintsValidationException((DataIntegrityViolationException)new FieldRelatedUserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Project.Forbidden_characters_in_project_ID_Only_letters_digits_and_underscore_are_allowed", new Object[0]), (TransientEntity)project, "shortName"));
        }
    }

    private void assertName(Entity project) throws ConstraintsValidationException {
        String name = ProjectNameChangeListener.trim_3prc6c_a0a0a3((String)PrimitiveAssociationSemantics.get((Entity)project, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
        if (name.startsWith("$t$-") || name.startsWith("$s$-")) {
            throw new ConstraintsValidationException((DataIntegrityViolationException)new FieldRelatedUserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Project.Project_name_can_not_start_with_{0}-_or_with_{1}-", new Object[]{"$t$", "$s$"}), (TransientEntity)project, "name"));
        }
    }

    public static boolean isNotEmpty_3prc6c_a0a0a0(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_3prc6c_a0a0a0_0(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_3prc6c_a0a0a1(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_3prc6c_a0a0a1_0(String str) {
        return str != null && str.length() > 0;
    }

    public static String trim_3prc6c_a0a0a0a0c(String str) {
        return str == null ? null : str.trim();
    }

    public static String trim_3prc6c_a0a0a3(String str) {
        return str == null ? null : str.trim();
    }
}

