/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.user.apiKey;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import java.security.SecureRandom;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiKeyImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "ApiKey";
    private static final SecureRandom API_KEY_RANDOM_GENERATOR = new SecureRandom();
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static Log log = LogFactory.getLog(ApiKeyImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String key, Entity owner, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"key", (Comparable)((Object)key), String.class);
        UndirectedAssociationSemantics.setManyToOne((Entity)owner, (String)"apiKeys", (String)"owner", (Entity)entity);
        return entity;
    }

    static Entity constructor(String key, Entity owner) {
        return ((ApiKeyImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(key, owner, __ENTITY_TYPE__);
    }

    @NotNull
    public static Entity create(@NotNull Entity user) {
        byte[] randomBytes = new byte[16];
        API_KEY_RANDOM_GENERATOR.nextBytes(randomBytes);
        long time = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder(48);
        int i = 0;
        do {
            sb.append(DIGITS[(int)(time & 0xFL)]);
            ++i;
        } while ((time >>>= 4) != 0L);
        while (i < 16) {
            ++i;
            sb.append(0);
        }
        for (int idx = 0; idx < 16; ++idx) {
            byte b = randomBytes[idx];
            sb.append(DIGITS[(b & 0xF0) >> 4]);
            sb.append(DIGITS[b & 0xF]);
        }
        String result = sb.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)("Allocated an API key: " + result.substring(8) + "..."));
        }
        return ApiKeyImpl.constructor(result, user);
    }

    @Nullable
    public static Entity create(@NotNull String key, @NotNull Entity user) {
        return ApiKeyImpl.constructor(key, user);
    }

    @Nullable
    public static Entity find(String key) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"ApiKey", (NodeBase)new PropertyEqual("key", (Comparable)((Object)key))));
    }
}

