charisma.smartui.Tooltip = function (anchor, text, direction, closeByClick, showDelay, hideDelay) {
  this.shift = 4;
  this.marginLeft = 0;
  this.showTimer = 0;
  this.hideTimer = 0;
  this.current_state = null;
  this.anchor = anchor;
  this.text = text;
  this.direction = direction || charisma.smartui.TooltipDirection.TOP;
  this.showDelay = showDelay || 400;
  this.hideDelay = hideDelay || 100;
  this.closeByClick = closeByClick ?closeByClick :true;
  this.bindEvents();
  this.current_state = charisma.smartui.Tooltip.state_HIDDEN;
};
charisma.smartui.Tooltip.prototype.bindEvents = function () {
  var it = this;
  this.anchor.mouseover(function () {
    it.mouseOver();
  }).mouseout(function () {
    it.mouseOut();
  });
  if (this.closeByClick) {
    this.anchor.click(function () {
      it.hide();
    });
  }

};
charisma.smartui.Tooltip.prototype.create = function () {
  if (!this.container) {
    this.arrow = $(document.createElement("span"));
    this.container = $(document.createElement("div")).html(this.text).addClass(charisma.smartui.Tooltip.CSS).append(this.arrow);
    $("body").append(this.container);
    this.containerDim = {width: this.container.outerWidth(), height: this.container.outerHeight()};
    this.marginLeft = parseInt(this.anchor.css("margin-left"));
  }

};
charisma.smartui.Tooltip.prototype._show = function () {
  charisma.smartui.Tooltip.SHOWN && charisma.smartui.Tooltip.SHOWN.hide();
  var parentPositioned = this.parentIsPositioned();
  if (!parentPositioned || parentPositioned.fixed) {
    return false;
  }

    

  this.create();
  var options = this.getOptions(parentPositioned);
  this.container.css(options.pos);
  this.arrow.removeClass().addClass(charisma.smartui.Tooltip.ARROW_CSS[options.dir]);
  if (options.css) {
    this.arrow.addClass(options.css);
  }

  this.container.fadeIn(150);
  charisma.smartui.Tooltip.SHOWN = this;
};
charisma.smartui.Tooltip.prototype._hide = function () {
  this.container && this.container.fadeOut(100);
  charisma.smartui.Tooltip.SHOWN = null;
};
charisma.smartui.Tooltip.prototype.getOptions = function (parentPositioned) {
  var options;
  var anchorPos = {};
  if (parentPositioned) {
    var parentPos = this.anchor.parent().offset();
    anchorPos = this.anchor.position();
    anchorPos.top += parentPos.top;
    anchorPos.left += parentPos.left;
  } else {
    anchorPos = this.anchor.offset();
  }

  if (this.direction != undefined) {
    //obligatory position
    switch (this.direction) {
    case charisma.smartui.TooltipDirection.TOP:
      options = this.getTopBottom(anchorPos);
            break;

    case charisma.smartui.TooltipDirection.RIGHT:
      options = this.getLeftRigth(anchorPos, true);
            break;

    case charisma.smartui.TooltipDirection.BOTTOM:
      options = this.getTopBottom(anchorPos, true);
            break;

    case charisma.smartui.TooltipDirection.LEFT:
      options = this.getLeftRigth(anchorPos);
    }

  } else {
    //flexible position
    if (anchorPos.top > this.containerDim.height) {
      //top
      options = this.getTopBottom(anchorPos);
    } else {
      if (anchorPos.left < this.containerDim.width) {
        if (($(window).width() - anchorPos.left - this.anchor.outerWidth()) < this.containerDim.width) {
          //bottom
          options = this.getTopBottom(anchorPos, true);
        } else {
          //right
          options = this.getLeftRigth(anchorPos, true);
        }

      } else {
        //left
        options = this.getLeftRigth(anchorPos);
      }

    }

  }

    

  return options;
};
charisma.smartui.Tooltip.prototype.parentIsPositioned = function () {
  var parent = this.anchor.offsetParent();
  if (parent.length > 0) {
    var position = parent.css("position");
    return {fixed: position.indexOf("fixed") != -1, relative: position.indexOf("fixed") != -1};
  }

  return false;
};
charisma.smartui.Tooltip.prototype.getTopBottom = function (anchorPos, bottom) {
  var obj = this.getLeftPosition(anchorPos, anchorPos.left + this.marginLeft + (this.anchor.outerWidth() - this.containerDim.width) / 2);
  return {pos: {top: bottom ?anchorPos.top + this.anchor.outerHeight() + this.shift :anchorPos.top - this.containerDim.height - this.shift, left: obj.left}, dir: bottom ?charisma.smartui.TooltipDirection.BOTTOM :charisma.smartui.TooltipDirection.TOP, css: obj.css};
};
charisma.smartui.Tooltip.prototype.getLeftPosition = function (anchorPos, leftPos) {
  var d = 6;
  var css;
  var scrollLeft = $(window).scrollLeft();
  var maxLeft = $(window).width() + scrollLeft;
  this.arrow.removeAttr("style");
  if (leftPos < 0) {
    leftPos = 0;
    css = charisma.smartui.Tooltip.ARROW_CSS[4];
    this.arrow.css("left", d);
        

  } else if (leftPos < scrollLeft) {
    leftPos = scrollLeft;
    css = charisma.smartui.Tooltip.ARROW_CSS[4];
    this.arrow.css("left", d);
        

  } else if ((leftPos + this.containerDim.width) > maxLeft) {
    leftPos = maxLeft - this.containerDim.width;
    css = charisma.smartui.Tooltip.ARROW_CSS[5];
    this.arrow.css("right", d).css("left", "auto");
  }

  return {left: leftPos, css: css};
};
charisma.smartui.Tooltip.prototype.getLeftRigth = function (anchorPos, right) {
  return {pos: {top: anchorPos.top, left: right ?anchorPos.left + this.anchor.outerWidth() + this.shift :anchorPos.left - this.containerDim.width - this.shift}, dir: right ?charisma.smartui.TooltipDirection.RIGHT :charisma.smartui.TooltipDirection.LEFT};
};
charisma.smartui.Tooltip.prototype.startTimer = function (timer, delay) {
  if (!timer) {
    this.stopTimer(timer);
    var it = this;
    timer = window.setTimeout(function () {
      it.tick();
    }, delay);
  }

};
charisma.smartui.Tooltip.prototype.stopTimer = function (timer) {
  if (timer) {
    window.clearInterval(timer);
    timer = null;
  }

};
charisma.smartui.Tooltip.prototype.tick = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "tick", arguments);
};
charisma.smartui.Tooltip.prototype.show = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "show", arguments);
};
charisma.smartui.Tooltip.prototype.hide = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "hide", arguments);
};
charisma.smartui.Tooltip.prototype.mouseOut = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseOut", arguments);
};
charisma.smartui.Tooltip.prototype.mouseOver = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseOver", arguments);
};
charisma.smartui.Tooltip.CSS = "toolbar-tootip";
charisma.smartui.Tooltip.ARROW_CSS = ["toolbar-tootip-arrow", "toolbar-tootip-arrow-l", "toolbar-tootip-arrow-b", "toolbar-tootip-arrow-r"];
charisma.smartui.Tooltip.state_HIDDEN = {name: "HIDDEN", mouseOver: function () {
  if (true) {
        

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.Tooltip.state_BEFORE_SHOW);
    }

    return charisma.smartui.Tooltip.state_BEFORE_SHOW;
  }

  return false;
}, show: function () {
  if (true) {
    this._show();
    return charisma.smartui.Tooltip.state_SHOWN;
  }

  return false;
}};
charisma.smartui.Tooltip.state_BEFORE_SHOW = {name: "BEFORE_SHOW", onenter: function () {
  this.startTimer(this.showTimer, this.showDelay);
}, onexit: function () {
  this.stopTimer(this.showTimer);
}, mouseOut: function () {
  if (true) {
        

        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Tooltip.state_BEFORE_SHOW);
    }

    return charisma.smartui.Tooltip.state_HIDDEN;
  }

  return false;
}, tick: function () {
  if (true) {
    this._show();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Tooltip.state_BEFORE_SHOW);
    }

    return charisma.smartui.Tooltip.state_SHOWN;
  }

  return false;
}, hide: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Tooltip.state_BEFORE_SHOW);
    }

    return charisma.smartui.Tooltip.state_HIDDEN;
  }

  return false;
}};
charisma.smartui.Tooltip.state_SHOWN = {name: "SHOWN", mouseOut: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.Tooltip.state_BEFORE_HIDE);
    }

    return charisma.smartui.Tooltip.state_BEFORE_HIDE;
  }

  return false;
}, hide: function () {
  if (true) {
    this._hide();
    return charisma.smartui.Tooltip.state_HIDDEN;
  }

  return false;
}};
charisma.smartui.Tooltip.state_BEFORE_HIDE = {name: "BEFORE_HIDE", onenter: function () {
  this.startTimer(this.hideTimer, this.hideDelay);
}, onexit: function () {
  this.stopTimer(this.hideTimer);
}, mouseOver: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Tooltip.state_BEFORE_HIDE);
    }

    return charisma.smartui.Tooltip.state_SHOWN;
  }

  return false;
}, show: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Tooltip.state_BEFORE_HIDE);
    }

    return charisma.smartui.Tooltip.state_SHOWN;
  }

  return false;
}, hide: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Tooltip.state_BEFORE_HIDE);
    }

    return charisma.smartui.Tooltip.state_HIDDEN;
  }

  return false;
}, tick: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Tooltip.state_BEFORE_HIDE);
    }

    return charisma.smartui.Tooltip.state_HIDDEN;
  }

  return false;
}};


charisma.smartui.TooltipOptions = function () {
};
charisma.smartui.TooltipDirection = function () {
};
charisma.smartui.TooltipDirection.TOP = 0;
charisma.smartui.TooltipDirection.LEFT = 1;
charisma.smartui.TooltipDirection.BOTTOM = 2;
charisma.smartui.TooltipDirection.RIGHT = 3;
