charisma.UsernameSuggest = function (input) {
  if (input.tagName !== 'TEXTAREA') {
    input = $(input).find('textarea').first().get(0);
  }

  if (input) {
    if ($(input).css('direction') === 'rtl') {
      return ;
    }

    charisma.UsernameSuggest.superclass.constructor.call(this, input);
    this.config.propogateImplicitComplete = false;
    this.input.suggester = this;
    this.input.setAutoComplete(false);
  }

  this.decorator = function () {
    $(this.suggestDiv).addClass("username-suggester");
  };
};
{
  var F = new Function();
  F.prototype = Webr.component.Suggest.prototype;
  charisma.UsernameSuggest.prototype = new F();
  charisma.UsernameSuggest.prototype.constructor = charisma.UsernameSuggest;
  charisma.UsernameSuggest.superclass = Webr.component.Suggest.prototype;
}

charisma.UsernameSuggest.prototype.create = function () {
  charisma.UsernameSuggest.superclass.create.call(this);
  if (this.decorator) {
    this.decorator();
    delete this.decorator;
  }

};
charisma.UsernameSuggest.prototype.beforeSuggest = function () {
  this.focus();
};
charisma.UsernameSuggest.prototype.initHandlers = function () {
  var self = this;
  var timer;
  var textarea = $(this.input);
  this.handleEsc = function (e) {
    if (Webr.util.Key.isApplicable(e, SuggestKeyStrokes["Close"]) && self.visible) {
      self.blur();
      return false;
    }

  };
    

  charisma.UsernameSuggest.superclass.initHandlers.call(this);
    

  textarea.bind('valuechange.usernameSuggest mouseup.usernameSuggest', function (e) {
    self.trySuggest();
        

  }).blur(function () {
    self.clone && self.clone.empty();
        

  }).on('keydown.usernameSuggest', function (e) {
    window.clearTimeout(timer);
    if ((Webr.util.Key.isApplicable(e, SmartUIShortCuts["Submit"]))) {
      self.blur();
      return true;
    }

    if (!(Webr.util.Key.isApplicable(e, SuggestKeyStrokes["Close"]))) {
      timer = window.setTimeout(function () {
        self.trySuggest();
      }, 50);
    }

  });
};
charisma.UsernameSuggest.prototype.setPosition = function (data) {
  var input = $(this.input);
  if (!(this.clone)) {
    this.clone = $(document.createElement('div')).css({'font-size': input.css('font-size'), 'font-family': input.css('font-family'), 'line-height': input.css('line-height'), 'font-weight': input.css('font-weight'), 'font-variant': input.css('font-variant'), 'text-align': input.css('text-align'), 'letter-spacing': input.css('letter-spacing'), 'margin': input.css('margin'), 'padding': input.css('padding'), 'width': input.width()}).addClass("username-suggest__clone");
    input.after(this.clone);
  }

  this.position = this.getPosition();
  if (this.position) {
    $(this.suggestDiv).css("top", Math.ceil(this.position.top)).css("left", this.position.left).css('maxWidth', $(window).width() - this.position.left);
  }

};
charisma.UsernameSuggest.prototype.getPosition = function () {
  if (this.userName != undefined) {
    var span;
    var pos;
    var shift = 0;
    var caretPos = this.input.getCaretPosition();
    var textarea = $(this.input);
    var parts = [this.input.value.substr(0, caretPos - this.userName.length - 1), this.input.value.substr(caretPos, this.input.value.length)];
    var clonedHtml = charisma.UsernameSuggest.eliminateXSSDangerousSymbols(parts[0]) + '<span>' + charisma.UsernameSuggest.KEY + charisma.UsernameSuggest.eliminateXSSDangerousSymbols(this.userName) + '</span>' + charisma.UsernameSuggest.eliminateXSSDangerousSymbols(parts[1]);
    this.clone.html(clonedHtml);
    this.clone.height(textarea.height()).width(textarea.width()).offset(textarea.offset());
    span = this.clone.find('span');
    pos = span.offset();
    var input = $(this.input);
    return {"top": pos.top + span.height() - input.scrollTop(), "left": pos.left - input.scrollLeft()};
  }

  return null;
};
charisma.UsernameSuggest.prototype.complete = function (itemIndex, substitute) {
  var item = this.data.items[itemIndex];
  var value = this.input.value;
  var currPos = this.input.getCaretPosition();
  var pre = value.substr(0, currPos - this.data.query.length);
  var post;
  var after = value.substr(currPos);
    

  if (substitute) {
    var spacePos = after.indexOf(' ');
    var nextLinePos = after.indexOf('\n');
    var separatorPos = Math.min(spacePos, nextLinePos);
    if (spacePos == -1) {
      separatorPos = nextLinePos;
    } else if (nextLinePos == -1) {
      separatorPos = spacePos;
    }

    if (separatorPos >= 0) {
      post = after.substr(separatorPos, after.length);
    } else {
      post = ' ';
    }

  } else {
    //here was check for space or linebreak. i removed it for a little while
    post = ' ' + after;
  }

  var preWithName = pre + item.o;
  var newValue = preWithName + post;
  this.input.value = newValue;
  this.input.setCaretPosition(preWithName.length + 1);
};
charisma.UsernameSuggest.prototype.trySuggest = function () {
  var line = this.input.value.substring(0, this.input.getCaretPosition()).split('\n').pop();
  if (line.length == 0) {
    this.blur();
    return ;
  }

  this.userName = this.getUserName(line);
  if (this.userName !== null) {
    var self = this;
    charisma.Rest.get("comment/reply/suggest", {optionsLimit: 10, prefix: self.userName, issueIds: charisma.smartui.IssueId.encodeIssueIds(commonController.getSelectedIssuesIds())}, function (data) {
      data.items = data.items || [];
      if ($(self.input).is(":focus")) {
        self.suggest(data);
        this.userName = null;
      }

    }, charisma.RestMethods.id(this.input));
  } else {
    this.blur();
  }

};
charisma.UsernameSuggest.prototype.getUserName = function (line) {
  var textAfterAt = '';
  var userName;
  var lastAtIndex;
  while (1) {
    lastAtIndex = line.lastIndexOf(charisma.UsernameSuggest.KEY);
    if (lastAtIndex != -1 && line.slice(-1) !== ' ') {
      userName = line.substr(lastAtIndex + 1, line.length) + textAfterAt;
    } else {
      userName = null;
            break;

    }

    if (this.isSuggestRequired(line, lastAtIndex, userName)) {
            break;

    }

    textAfterAt = textAfterAt + line.substr(lastAtIndex, line.length);
    line = line.substr(0, lastAtIndex);
  }

  return userName;
};
charisma.UsernameSuggest.prototype.isSuggestRequired = function (line, lastAtIndex, name) {
  if (lastAtIndex == -1 || name === ' ') {
    return false;
  }

  if (lastAtIndex != 0) {
    var symbolBeforeAt = line.charAt(lastAtIndex - 1);
    if (/^A-Za-z0-9_\$\+\.\|-=@/.test(symbolBeforeAt)) {
      return false;
    }

  }

  return true;
};
charisma.UsernameSuggest.prototype.isSuggestCompatible = function () {
  return true;
};
charisma.UsernameSuggest.prototype.targetVisible = function () {
  var input = $(this.input);
  var offsetTop = input.offset().top;
  return (this.position.top > offsetTop) && (this.position.top < (offsetTop + input.outerHeight()));
};
charisma.UsernameSuggest.prototype.setVisible = function (visible) {
  if (visible && !this.targetVisible()) {
    visible = false;
  }

  charisma.UsernameSuggest.superclass.setVisible.call(this, visible);
  this.handleScrollResizeAndEsc(visible);
  this.visible = visible;
};
charisma.UsernameSuggest.prototype.isBinded = function () {
  return $(this.input).hasClass("username-suggest-bind");
};
charisma.UsernameSuggest.prototype.handleScrollResizeAndEsc = function (visible) {
  var self = this;
  if (visible) {
    $(window).bind('resize.usernameSuggest', function () {
      self.blur();
    });
    if (this.isBinded()) {
      $(window).bind('scroll.usernameSuggest', function () {
        self.blur();
      });
    }

    $(this.input).bind('scroll.usernameSuggest', function () {
      self.blur();
    }).bind("keydown.usernameSuggest", self.handleEsc);
        

  } else {
    $(this.input).unbind('scroll.usernameSuggest keydown.usernameSuggest');
    $(window).unbind('resize.usernameSuggest scroll.usernameSuggest');
  }

};
charisma.UsernameSuggest.KEY = '@';
charisma.UsernameSuggest.attach = function () {
  $(document).delegate(".username-suggest, .username-suggest-bind", "focus", function (e) {
    var id = $(this).attr('id');
    if (id !== undefined) {
      var suggest = 'usernameSuggest-' + id;
      if ($(this).data(suggest) !== true) {
        new charisma.UsernameSuggest(this);
        $(this).data(suggest, true);
      } else {
        $(this).trigger('valuechange.usernameSuggest');
      }

    }

  });
};
charisma.UsernameSuggest.eliminateXSSDangerousSymbols = function (html) {
  return (html || '').replace(new RegExp("[<>'\"]", "g"), '□');
};
