cr.setTemplateBind("AddComment", function (path) {
  cr.ach(path, "commentTextarea", "keydown", function (event, data) {
    if (event.isKey(Webr.util.Key.TAB) && !(cr.findInHandler(event, "" + "." + "commentTextarea", []).suggester.visible)) {
      if (cr.findInHandler(event, "" + "." + "cs" + "." + "permittedGroup", []).inputElement) {
        cr.findInHandler(event, "" + "." + "cs" + "." + "permittedGroup", []).makeVisible();
      } else {
        $(cr.findInHandler(event, "" + "." + "cs" + "." + "permittedGroupAnchor", [])).click();
      }

      return false;
    }

    return true;
  });
  cr.ach(path, "cs" + "." + "permittedGroup", "keydown", function (event, data) {
    if (event.isKey(Webr.util.Key.TAB)) {
      cr.findInHandler(event, "" + "." + "cs" + "." + "permittedGroup", []).makeHidden();
      //ensure that combobox is closed
      var f = cr.findInHandler(event, "" + "." + "addComment", []);
      window.setTimeout(function () {
        f.focus();
      }, 20);
      return false;
    }

    if (event.isShift(Webr.util.Key.TAB)) {
      cr.findInHandler(event, "" + "." + "cs" + "." + "permittedGroup", []).makeHidden();
      //ensure that combobox is closed
      var f = cr.findInHandler(event, "" + "." + "commentTextarea", []);
      window.setTimeout(function () {
        f.focus();
      }, 20);
      return false;
    }

  });
  cr.ach(path, "addComment", "keydown", function (event, data) {
    if (event.isShift(Webr.util.Key.TAB)) {
      cr.findInHandler(event, "" + "." + "cs" + "." + "permittedGroup", []).makeVisible();
      return false;
    }

    if (event.isKey(Webr.util.Key.TAB)) {
      var link = cr.findInHandler(event, "" + "." + "closeCommentsLink", []);
      if (link) {
        link.focus();
        return false;
      }

    }

  });
  cr.ach(path, "commentTextarea", "keydown", function (event, data) {
    if (event.isKey(Webr.util.Key.ESC)) {
      cr.findInHandler(event, "" + "." + "commentTextarea", []).focus();
      return false;
    }

  });
  cr.ach(path, "newComment", "keydown", function (event, data) {
    if ((Webr.util.Key.isApplicable(event, SmartUIShortCuts["Submit"]) || Webr.util.Key.isApplicable(event, SmartUIShortCuts["Submit_Mac"])) && !Webr.component.panel.Dialog.isModalVisible()) {
      $(cr.findInHandler(event, "" + "." + "addComment", [])).click();
      return false;
    }

  });
  cr.ach(path, "addComment", "click", function (event, data) {
    var txt = cr.findInHandler(event, "" + "." + "commentTextarea", []).value;
    var markdownToggle = cr.findInHandler(event, "" + "." + "markdownToggle", []);
    var usesMarkdown = markdownToggle && markdownToggle.checked;
    if (jQuery.trim(txt) != "" || usesMarkdown) {
      cr.findInHandler(event, "" + "." + "addComment", []).disabled = true;
      cr.findInHandler(event, "" + "." + "commentTextarea", []).detachWatcher();
      cr.serverMethodCallInHandler(event, "" + "." + "methodCall_save", {__param__text: txt, __param__usesMarkdown: usesMarkdown}, {preventDoubleSubmit: true});
      var mb = cr.findInHandler(event, "" + "." + "cs" + "." + "permittedGroup", []);
      if (mb.reset) {
        mb.reset();
      }

    } else {
      Webr.event.PopupMessage.ERROR.show(l10n('${l10n("AddComment.Please_enter_some_text")}'), 4000);
    }

  });
  cr.ash(path, "commentTextarea", "valuechange", {preventDoubleSubmit: true, hideLoadingPopup: true});
  cr.ash(path, "markdownToggle", "click", null);
  cr.forEach(path, "commentTextarea", function () {
    this.attachWatcher(false);
  });
  cr.forEach(path, "commentTextarea", function () {
    Webr.component.ElementExpander.addExpandListener(this, 200);
  });
  regmn(path, "addFileMenu");
});
