cr.setTemplateBind("CommentSettings", function (path) {
  cr.ach(path, "permittedGroup", "change", function (event, data) {
    //workaround for https://webr-dnq.myjetbrains.com/youtrack/issue/WD-1672
    var anchor = $(cr.findInHandler(event, "" + "." + "permittedGroupAnchor", []));
    var mb = cr.findInHandler(event, "" + "." + "permittedGroup", []);
    var currentIds = mb.currentCheckedIds;
    var dataListItems = mb.dataList.options;
    var first = true;
    var count = 0;
    var updatedText = '';
    var titleText = '';
    for (var i = 0; i < dataListItems.length; i = i + 1) {
      var option = dataListItems[i].option;
      if (currentIds.indexOf(option.id) >= 0) {
        if (first) {
          first = false;
          updatedText += option.text;
        } else {
          count = count + 1;
          titleText += ', ';
        }

        titleText += option.text;
      }

    }

    if (count > 0) {
      updatedText += (' +' + count);
    }

    var text = anchor.text();
    anchor.find('.comment-visibility-text-placeholder').text(updatedText || l10n('${l10n("CommentSettings.Same_as_issue2")}'));
    var title = cr.findInHandler(event, "" + "." + "permittedGroupAnchor", []).title.replace(text, titleText);
    anchor.title(title);
  });
  cr.ash(path, "permittedGroup", "change", null);
  cr.ash(path, "permittedGroup", "Load", {collectFormElements: false, hideLoadingPopup: true, processRecentOnly: true, preventDoubleSubmit: false});
});
