charisma.smartui.CommentsList = function (config) {
  charisma.smartui.CommentsList.superclass.constructor.call(this);
  this.scrollable = false;
  this.commentItems = [];
  this.commentItemMap = {};
  this.selected = -1;
  this.focused = false;
  this.newCommentTextAreaFocused = false;
  var element = config.contentDiv;
  this.content = element;
  this.mainDivElement = $(element).children("div." + "comment-list").get(0);
  this.selectedItemClass = config.selectedItemClass;
  this.mouseoverItemClass = config.mouseOverItemClass;
  this.scrollable = config.scrollable;
  this.init();
};
{
  var F = new Function();
  F.prototype = Webr.component.Component.prototype;
  charisma.smartui.CommentsList.prototype = new F();
  charisma.smartui.CommentsList.prototype.constructor = charisma.smartui.CommentsList;
  charisma.smartui.CommentsList.superclass = Webr.component.Component.prototype;
}

charisma.smartui.CommentsList.prototype.init = function () {
  var it = this;
  var content = $(this.content);
  this.keyHandler = function (event) {
    return it.keyhandler(event);
  };
  this.mouseHandler = function (event) {
    if (!content.ancestorOf(event.target)) {
      it.unhandleKeys();
    }

  };
  this.refreshList();
    

  this.newCommentTexArea = content.find("." + "add-comment" + " :input").get(0);
  if (this.newCommentTexArea) {
        

    this.newCommentTexArea.attachWatcher();
    this.newCommentTexArea.setWatcherDelay(200);
        

    $(this.newCommentTexArea).focus(function () {
      it.focusOnTextArea();
      $(this).parent().addClass("comment-textarea_focus");
    }).blur(function () {
      it.unFocusOnTextArea();
      $(this).parent().removeClass("comment-textarea_focus");
    });
        

    $(document).delegate(".comment-reply", 'mouseover', function () {
      //save the selected text before click removes a selection
      it.updateTextSelectionData();
    }).delegate(".comment-reply", 'mouseout', function () {
      it.updateTextSelectionData(true);
    });
  }

};
charisma.smartui.CommentsList.prototype.setToolbar = function (toolbar) {
  this.toolbar = toolbar;
};
charisma.smartui.CommentsList.prototype.handleKeys = function (item) {
  if (!this.focused) {
    this.focused = true;
    var doc = Webr.util.Util.isIE ?document.body :document;
    $(doc).mousedown(this.mouseHandler);
    Webr.util.Util.addKeyHandler(doc, this.keyHandler);
    this.fireCommentItemSelected(item);
  }

};
charisma.smartui.CommentsList.prototype.unhandleKeys = function () {
  if (this.focused) {
    this.focused = false;
    var doc = Webr.util.Util.isIE ?document.body :document;
    $(doc).unbind("mousedown", this.mouseHandler);
    Webr.util.Util.removeKeyHandler(doc, this.keyHandler);
  }

};
charisma.smartui.CommentsList.prototype.refreshList = function () {
  var it = this;
  $(this.content).find(".comment-row").each(function () {
    it.addOrUpdate(this);
  });
};
charisma.smartui.CommentsList.prototype.addOrUpdate = function (selector) {
  var query = $(selector);
  var tr = selector;
  if (!tr) {
    throw "Can't find div for selector [" + selector + "]";
  }

  var id = query.attr("_id");
  var comment = this.commentItemMap[id];
  if (comment == null) {
    comment = new charisma.smartui.CommentItem(this, selector);
    this.commentItems.push(comment);
    this.commentItemMap[id] = comment;
  }

  comment.collect();
  return comment;
};
charisma.smartui.CommentsList.prototype.fireCommentItemSelected = function (i) {
  this.fire(function (listener) {
    if (listener.commentItemFocused) {
      listener.commentItemFocused(i);
    }

    return true;
  });
};
charisma.smartui.CommentsList.prototype.keyhandler = function (event) {
  if (this.newCommentTextAreaFocused) {
    switch (event.keyCode) {
    case Webr.util.Key.ESC:
      return this.throwToUp(event);
    case Webr.util.Key.UP:
      if (this.prevInsideInput()) {
        return true;
      } else {
        if (!this.empty()) {
          this.prev();
          $(this.newCommentTexArea).blur();
          return false;
        }

      }

      return this.throwToUp(event);
    case Webr.util.Key.DOWN:
      return this.nextInsideInput() ?true :this.throwToUp(event);
    case Webr.util.Key.LEFT:
      if (this.prevInsideInput()) {
        return true;
      } else {
        return this.throwToUp(event);
      }

    }

  }

  if (Webr.util.Util.targetIsInput(event)) {
    return true;
  }

  switch (event.keyCode) {
  case Webr.util.Key.UP:
    return this.prev() ?false :this.throwToUp(event);
  case Webr.util.Key.DOWN:
    return this.next() ?false :this.throwToUp(event);
  case Webr.util.Key.LEFT:
    var selected = this.getSelected();
    if (selected && selected.attachmentsExpanded) {
      selected.toggleAttachments();
    } else {
      this.throwToUp(event);
    }

    return false;
  case Webr.util.Key.RIGHT:
    var selected = this.getSelected();
    if (selected && !selected.attachmentsExpanded) {
      selected.toggleAttachments();
    }

    return false;
  case Webr.util.Key.PAGEUP:
    this.first();
    return false;
  case Webr.util.Key.PAGEDOWN:
    this.last();
    return false;
  }

  if (event.isKey(Webr.util.Key.F2)) {
    this.getSelected().edit();
    return false;
  }

  if (event.isKey(Webr.util.Key.DELETE)) {
    this.getSelected().del();
    return false;
  }

  if (event.isKey(Webr.util.Key.ENTER)) {
    return true;
  }

  return this.throwToUp(event);
};
charisma.smartui.CommentsList.prototype.throwToUp = function (event) {
  var keyDown = this.fireKeyDown(event);
  if (!keyDown) {
    this.unhandleKeys();
  }

  return keyDown;
};
charisma.smartui.CommentsList.prototype.isFocused = function () {
  return this.focused;
};
charisma.smartui.CommentsList.prototype.empty = function () {
  return this.commentItems.length <= 0;
};
charisma.smartui.CommentsList.prototype.size = function () {
  return this.commentItems.length;
};
charisma.smartui.CommentsList.prototype.focusOnTextArea = function () {
  this.handleKeys(null);
  if (this.getSelected()) {
    this.getSelected().unselect();
    this.selected = -1;
  }

  this.newCommentTextAreaFocused = true;
};
charisma.smartui.CommentsList.prototype.unFocusOnTextArea = function () {
  this.newCommentTextAreaFocused = false;
};
charisma.smartui.CommentsList.prototype.focus = function () {
  try {
    var it = this;
    var item = this.getSelected();
    this.handleKeys(item);
    if (item) {
      item.select();
    } else {
      //TimeOuts is setted for not loosing focus back to IssueListItem
      if (!this.empty()) {
        window.setTimeout(function () {
          it.selected = it.size() - 1;
          it.getSelected().select();
        }, 35);
      } else {
        window.setTimeout(function () {
          var area = it.newCommentTexArea;
          area && area.focus();
        }, 35);
      }

    }

  } catch (err) {
  }

    

};
charisma.smartui.CommentsList.prototype.unfocus = function () {
  try {
    this.unhandleKeys();
  } catch (e) {
  }

};
charisma.smartui.CommentsList.prototype.clearSelection = function () {
  if (this.getSelected()) {
    this.getSelected().unselect();
    this.selected = -1;
  }

};
charisma.smartui.CommentsList.prototype.mousedown = function (item) {
  this.handleKeys(item);
  if (this.getSelected() === item) {
    item.select(true, true);
  } else {
    this.clearSelection();
    this.setSelected(item);
    item.select(true);
    info("comment selected");
  }

};
charisma.smartui.CommentsList.prototype.focusHashComment = function () {
  var commentId = Webr.util.PageStateStore.getInstance().get("comment");
  if (commentId) {
    var item = this.commentItemMap[commentId];
    if (item) {
      this.handleKeys(item);
      this.clearSelection();
      this.setSelected(item);
      item.select(false, true);
            

      var it = this;
      window.setTimeout(function () {
        //CAUTION! the toolbar indent summarize with the sctoll position because getDimention() returns a negative value
        $(window).scrollTop($(item.element).offset().top + it.getToolbarIndents()[1]);
      }, 100);
    }

  }

};
charisma.smartui.CommentsList.prototype.getToolbarIndents = function () {
  return this.toolbar ?this.toolbar.getDimension() :[0, 0];
};
charisma.smartui.CommentsList.prototype.next = function () {
  if (this.getSelected() && this.selected < this.size() - 1) {
    this.getSelected().unselect();
    this.selected += 1;
    this.getSelected().select();
    return true;
  } else {
    if (this.getSelected() && this.selected == this.size() - 1 && this.newCommentTexArea) {
      this.getSelected().unselect();
      this.selected = -1;
      $(this.newCommentTexArea).focus();
      return true;
    }

  }

  return false;
};
charisma.smartui.CommentsList.prototype.prev = function () {
  if (this.getSelected() && this.selected > 0) {
    this.getSelected().unselect();
    this.selected -= 1;
    this.getSelected().select();
    return true;
  } else {
    if (this.newCommentTextAreaFocused && !this.empty()) {
      this.selected = this.size() - 1;
      this.getSelected().select();
      return true;
    }

  }

  return false;
};
charisma.smartui.CommentsList.prototype.last = function () {
  if (this.getSelected() && this.selected < this.size() - 1) {
    this.getSelected().unselect();
    this.selected = this.size() - 1;
    this.getSelected().select();
  }

};
charisma.smartui.CommentsList.prototype.first = function () {
  if (this.getSelected() && this.selected > 0) {
    this.getSelected().unselect();
    this.selected = 0;
    this.getSelected().select();
  }

};
charisma.smartui.CommentsList.prototype.nextInsideInput = function () {
  if (this.newCommentTexArea.value.length <= 0) {
    return false;
  }

  return true;
};
charisma.smartui.CommentsList.prototype.prevInsideInput = function () {
  if (this.newCommentTexArea.value.length <= 0) {
    return false;
  }

  return true;
};
charisma.smartui.CommentsList.prototype.getSelected = function () {
  if (this.empty() || this.selected == -1 || this.selected >= this.size()) {
    return null;
  }

  return this.commentItems[this.selected];
};
charisma.smartui.CommentsList.prototype.setSelected = function (item) {
  this.selected = jQuery.inArray(item, this.commentItems);
};
charisma.smartui.CommentsList.prototype.reply = function (userLogin) {
  if (this.newCommentTexArea) {
    var name = charisma.UsernameSuggest.KEY;
    var commentText = this.newCommentTexArea.value;
    if (userLogin) {
      name = name + userLogin;
    }

    if (commentText.length != 0 && !(common.util.Util.isLineBreakOrSpace(commentText.slice(-1)))) {
      commentText += ' ';
    }

    this.newCommentTexArea.focus();
    this.newCommentTexArea.value = commentText + this.getReplyText() + name + ' ';
    this.newCommentTexArea.setCaretPosition(this.newCommentTexArea.value.length);
    this.updateTextSelectionData(true);
    var textarea = $(this.newCommentTexArea);
    textarea.keyup().scrollTop(this.newCommentTexArea.scrollHeight).trigger('valuechange');
    textarea.scrollTo();
  }

};
charisma.smartui.CommentsList.prototype.getReplyText = function () {
  if (this.selectedText.length > 0) {
    var prefix = this.newCommentTexArea.value.length != 0 ?'\n>' :'>';
    var lines = this.selectedText.split(/\r\n|\n|\r/g);
    var notEmptyLines = [];
    for (var i = 0; i < lines.length; i += 1) {
      if (lines[i].trim() !== '') {
        notEmptyLines.push(lines[i]);
      }

    }

    this.selectedText = prefix + notEmptyLines.join('\n>') + '\n';
  }

  return this.selectedText;
};
charisma.smartui.CommentsList.prototype.updateTextSelectionData = function (reset) {
  if (reset) {
    this.selectedText = '';
  } else {
    this.selectedText = common.util.Util.getSelection();
  }

};
charisma.smartui.CommentsList.prototype.highlightCommentDraftVisibility = function (id) {
  var target = $('#' + common.util.Util.escapeDots(id)).parent();
  if (target[0]) {
    var highlighted = target.closest(".commentVisibilityEdit");
    highlighted.addClass("commentVisibilityEdit__group_change");
    $(document).one('keydown', function () {
      highlighted.addClass("commentVisibilityEdit__group_hide").removeClass("commentVisibilityEdit__group_change");
    });
  }

};
charisma.smartui.CommentsList.toogleLongCommentAreaPresentation = function (container, maxHeight) {
  if (container.height() >= maxHeight) {
    container.addClass("comment-list_many");
  } else {
    container.removeClass("comment-list_many");
  }

};
charisma.smartui.CommentsListConfig = function () {
};
charisma.smartui.CommentsListConfig.prototype.toggleEdit = function (id) {
};
charisma.smartui.CommentsListListener = function () {
  charisma.smartui.CommentsListListener.superclass.constructor.call(this);
};
{
  var F = new Function();
  F.prototype = Webr.component.ComponentListener.prototype;
  charisma.smartui.CommentsListListener.prototype = new F();
  charisma.smartui.CommentsListListener.prototype.constructor = charisma.smartui.CommentsListListener;
  charisma.smartui.CommentsListListener.superclass = Webr.component.ComponentListener.prototype;
}

charisma.smartui.CommentsListListener.prototype.commentItemFocused = function (item) {
};
