charisma.smartui.UserToolbarTagCombo = function (anchor, div, tooltipText, addTag) {
  this.anchor = anchor;
  this.addTag = addTag;
  var it = this;
  this.anchor.one("click", function () {
    it.combo = $(div).data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE);
    it.overrideAnchorEvents();
    it.bindScroll();
    it.addCommandDialogOption();
  });
  new charisma.smartui.Tooltip($(anchor), tooltipText, charisma.smartui.TooltipDirection.TOP, true);
};
charisma.smartui.UserToolbarTagCombo.prototype.addCommandDialogOption = function () {
  var it = this;
  var a = $(document.createElement("a")).addClass("toolbar-user-tags-add").html(l10n('${l10n("UserToolbarTagCombo.js.Add_tag_with_command")}')).attr("href", "javascript:void(0)");
  this.combo.renderer.getInputElement().parent().before(a.click(function () {
    //hide combo
    it.combo.blur();
    window.setTimeout(function () {
      //show dialog with a delay to guarantee a focus
      //TODO: localize a command
      commandDialog.show(l10n('${l10n("UserToolbarTagCombo.js.add_tag")}'));
    }, 10);
  }));
};
charisma.smartui.UserToolbarTagCombo.prototype.overrideAnchorEvents = function () {
  var it = this;
  this.anchor.unbind("click").click(function () {
    it.combo.toggle();
  });
    

  this.combo.mainElement.bind("change", function (e) {
    var packagedIssueIds = commandDialog.getPackagedIssueIds();
    it.addTag(it.combo.currentOption.id, it.combo.currentOption.text, commandDialog.allFoundIssuesAreSelected(), packagedIssueIds);
  });
};
charisma.smartui.UserToolbarTagCombo.prototype.bindScroll = function () {
  var toolbar = commonController.getToolbar();
  if (toolbar) {
    var it = this;
    var togglePosition = function () {
      it.combo.renderer.getMainElement().toggleClass("toolbar-user-tags-combo-fix");
    };
    //first check if a toolbar is already unpinned
    if (toolbar.container.hasClass("toolbar-unpined")) {
      togglePosition();
    }

        

    //process position on window scroll
    toolbar.container.bind(charisma.smartui.Toolbar.EVENT_SHOW, togglePosition).bind(charisma.smartui.Toolbar.EVENT_HIDE, function () {
      togglePosition();
      var top = toolbar.container.offset().top + it.anchor.outerHeight();
      it.combo.renderer.getMainElement().css("top", top);
    });
        

  }

};
