cr.setTemplateBind("FilterContent", function (path) {
  cr.ach(path, "allCheckbox", "click", function (event, data) {
    cr.getTarget(event).disabled = true;
    cr.getTarget(event).checked = true;
    cr.serverMethodCallInHandler(event, "" + "." + "methodCall_checkAll", {__param__anchorId: cr.getTarget(event).id});
    jQuery.each(charisma.smartui.Filter.getFilter(cr.getTarget(event)).options, function () {
      this.checked = false;
      $(this).parent().removeClass("selected");
    });
    $(cr.getTarget(event)).parent().parent().parent().children("a:first").removeClass("vert-item_highlight");
    charisma.smartui.Filter.swapLastChecked(null);
  });
  cr.ach(path, "filterCheckbox", "click", function (event, data) {
    var lastChecked = charisma.smartui.Filter.swapLastChecked(cr.getTarget(event));
    var rangeOperation = event.shiftKey && lastChecked;
    var checked = cr.getTarget(event).checked;
    var allCheckbox = cr.findInHandler(event, "" + "." + "allCheckbox", []);
    var uncheckedLast = false;
        

    var checkboxesToToggle;
    if (rangeOperation) {
      checkboxesToToggle = charisma.smartui.Filter.getCheckboxRange(lastChecked, cr.getTarget(event));
    } else {
      checkboxesToToggle = $(cr.getTarget(event));
    }

        

    //set presentation
    if (checked) {
      checkboxesToToggle.parent().addClass("vert-item_highlight");
    } else {
      checkboxesToToggle.parent().removeClass("vert-item_highlight");
    }

        

    checkboxesToToggle.attr("checked", checked);
        

    if (allCheckbox.checked) {
      if (checked) {
        //enable and uncheck All
        allCheckbox.disabled = false;
        allCheckbox.checked = false;
      }

    } else {
      if (!checked) {
        //check if quantity of inputs is empty
        uncheckedLast = $(charisma.smartui.Filter.getFilter(cr.getTarget(event)).options).filter(function () {
          return this.checked;
        }).length == 0;
      }

    }

    if (uncheckedLast) {
      //initial state, nothing checked
      allCheckbox.disabled = true;
      allCheckbox.checked = true;
      cr.serverMethodCallInHandler(event, "" + "." + "methodCall_checkAll", {__param__anchorId: cr.getTarget(event).id});
      charisma.smartui.Filter.getGroupHeader(cr.getTarget(event)).removeClass("vert-item_highlight");
    } else {
      //enable necessary filters in order to search query
      var ids = checkboxesToToggle.map(function (index, domElement) {
        return domElement.id;
      }).get();
      cr.serverMethodCallInHandler(event, "" + "." + "methodCall_checkFilterParam", {__param__filterParam: ids, __param__checked: checked, __param__anchorId: cr.getTarget(event).id});
      charisma.smartui.Filter.getGroupHeader(cr.getTarget(event)).addClass("vert-item_highlight");
    }

  });
  cr.ash(path, "showMoreFilters", "click", null);
});
