charisma.smartui.AttachFileRest = function (selector, onUpload, windowId) {
  this.dropZone = document.createElement('div');
  if (('draggable' in this.dropZone) || ('ondragstart') in this.dropZone && 'ondrop' in this.dropZone) {
    this.selector = selector;
    if (typeof onUpload === 'boolean') {
      this.onUpload = this.showInlineSuccessMessage;
    } else {
      this.onUpload = onUpload;
    }

    this.bind();
  } else {
    delete this.dropZone;
  }

  this.windowId = windowId;
};
charisma.smartui.AttachFileRest.prototype.bind = function () {
  var self = this;
  $(document).delegate(self.getSelector(), "dragover", function (e) {
    self.stopEvent(e);
    if (self.dragFromInside === true || !self.isDataIsFile(e.originalEvent) || self.issueExpanded($(this))) {
      return ;
    }

    self.init();
    if (e.originalEvent.dataTransfer) {
      e.originalEvent.dataTransfer.effectAllowed = "copy";
      e.originalEvent.dataTransfer.dropEffect = "copy";
    }

    self.target = $(this);
    self.setIssue($(this));
    self.show($(this));
  });
    

  //download with DnD in Chrome
  $(document).delegate("a.attach-lnk", "dragstart", function (e) {
    if (e.originalEvent.dataTransfer && e.originalEvent.dataTransfer.constructor) {
      self.dragFromInside = true;
      var href = this.href;
      var name = href.split('/_persistent/').pop().split('?file')[0];
      var mimeType = common.util.Util.getMimeType(name.split('.').pop());
      if (mimeType) {
        var dataUrl = mimeType + ":" + name + ":" + viewImageAttachment.baseUrl + $(e.target).attr('href');
        e.originalEvent.dataTransfer.setData("DownloadURL", dataUrl);
      }

    }

  }).delegate("a.attach-lnk", "dragend", function () {
    self.dragFromInside = false;
  });
};
charisma.smartui.AttachFileRest.prototype.getSelector = function () {
  if (this.selector && this.selector.charAt(0) === '#') {
    return this.selector.replace(/\./g,"\\.");
  }

  return this.selector;
};
charisma.smartui.AttachFileRest.prototype.init = function () {
  if (!this.input) {
    this.createDomElements();
    this.restClient = new Webr.rest.Client(Webr.Event.rootUrl, Ajax.ajaxSettings());
        

    var self = this;
    this.input.change(function () {
      if (this.files[0].size > 0) {
        self.attach();
      } else {
        Webr.event.PopupMessage.ERROR.show(l10n('${l10n("AttachFileRest.js.Can_not_attach_a_zero-size_file")}'));
      }

    });
    this.dropZone.bind("dragleave drop", function () {
      self.hide();
    });
  }

};
charisma.smartui.AttachFileRest.prototype.isDataIsFile = function (e) {
  var fileType = false;
  jQuery.each(e.dataTransfer.types, function (k, v) {
    if (v.toLowerCase() === "files") {
      fileType = true;
      return ;
    }

  });
  return fileType;
};
charisma.smartui.AttachFileRest.prototype.createDomElements = function () {
  var self = this;
  var id = '__' + (new Date()).getTime();
  this.dropZone = $(this.dropZone);
  this.dropZone.addClass("upload__drop-area");
  this.input = $(document.createElement('input')).attr('id', id).attr('type', 'file').attr('multiple', true).addClass("upload__input");
  this.dropZone.append(this.input);
  $(document.body).append(this.dropZone);
  this.delta = parseInt(this.dropZone.css('borderTopWidth'));
};
charisma.smartui.AttachFileRest.prototype.setIssue = function (target) {
  this.issue = commonController.newIssueId != undefined ?commonController.newIssueId :target.attr('iid');
};
charisma.smartui.AttachFileRest.prototype.stopEvent = function (e) {
  e.preventDefault();
  e.stopPropagation();
  return false;
};
charisma.smartui.AttachFileRest.prototype.show = function (target) {
  this.dropZone.css(this.getPositionAndDimention(target));
  this.dropZone.show();
};
charisma.smartui.AttachFileRest.prototype.hide = function () {
  this.dropZone.hide();
};
charisma.smartui.AttachFileRest.prototype.getPositionAndDimention = function (target) {
  var styles;
  var pos;
  var fix = this.getDimentionFix(target);
  if (typeof fix === 'number') {
    pos = target.offset();
    styles = {"width": target.outerWidth() - this.delta, "height": fix - this.delta * 2, "top": pos.top, "left": pos.left - 2 + parseInt(target.css("marginLeft"))};
  } else {
    pos = fix.pos;
    styles = {"width": fix.dim.width - this.delta, "height": fix.dim.height - this.delta * 2, "top": pos.top, "left": pos.left - this.delta};
  }

  return styles;
};
charisma.smartui.AttachFileRest.prototype.getDimentionFix = function (target) {
  if (target.hasClass("sb-task")) {
    var children = target.children();
    var firstChild = children.first();
    var dim = {width: firstChild.outerWidth(), height: 0};
    var pos = firstChild.offset();
    children.each(function () {
      dim['height'] += $(this).outerHeight();
    });
    return {pos: pos, dim: dim};
  }

  return target.outerHeight();
};
charisma.smartui.AttachFileRest.prototype.issueExpanded = function (eventTarget) {
  return commonController.issuesList && eventTarget.children(".issue-comments").length > 0;
};
charisma.smartui.AttachFileRest.prototype.attach = function () {
  var self = this;
  this.restClient.resource({p: ["issue"]}).method("post", {p: ["issue", null, "attachment"]}).call({p: ["issue", self.issue, "attachment"], q: {window_id: self.windowId}, f: $(self.input), u: {success: function () {
    self.onUpload(self.issue, commonController.newIssueId != undefined);
    self.input.val('');
  }, error: function (textStatus) {
    self.showError(textStatus);
  }, timeout: 180000}});
};
charisma.smartui.AttachFileRest.prototype.showError = function (error) {
  Webr.event.PopupMessage.ERROR.show(l10n('${l10n("AttachFileRest.js.Can_not_attach_file_{0}")}', error));
};
charisma.smartui.AttachFileRest.prototype.showInlineSuccessMessage = function () {
  if (this.target) {
    if (!this.inlineMessage) {
      this.inlineMessage = $(document.createElement('div')).text(l10n('${l10n("AttachFileRest.js.Successfully_attached")}')).addClass("upload__inline-msg");
      $(document.body).append(this.inlineMessage);
      this.delta = {"width": this.inlineMessage.outerWidth(), "height": this.inlineMessage.outerHeight()};
    }

    var pos = this.target.offset();
    this.inlineMessage.css({top: pos.top + this.target.height() / 2 - this.delta.height / 2, left: pos.left + this.target.width() / 2 - this.delta.width / 2}).fadeIn(300).delay(1200).fadeOut(60);
  }

};
charisma.smartui.AttachFileToComment = function (selector, onUpload, commentDraftGetter) {
  charisma.smartui.AttachFileToComment.superclass.constructor.call(this, selector, onUpload);
  this.commentDraftGetter = commentDraftGetter;
};
{
  var F = new Function();
  F.prototype = charisma.smartui.AttachFileRest.prototype;
  charisma.smartui.AttachFileToComment.prototype = new F();
  charisma.smartui.AttachFileToComment.prototype.constructor = charisma.smartui.AttachFileToComment;
  charisma.smartui.AttachFileToComment.superclass = charisma.smartui.AttachFileRest.prototype;
}

charisma.smartui.AttachFileToComment.prototype.attach = function () {
  this.commentDraftGetter();
};
charisma.smartui.AttachFileToComment.prototype.doAttach = function (draft) {
  var self = this;
  var settings = {success: function () {
    self.onUpload();
    self.input.val("");
  }, error: function (textStatus) {
    self.showError(textStatus);
  }, timeout: 180000};
  new Webr.rest.Client(Webr.Event.rootUrl, Ajax.ajaxSettings()).resource({p: ["comment"]}).method("post", {p: ["comment", null, null, "attachment"]}).call({p: ["comment", self.issue, draft, "attachment"], f: $(self.input), u: settings});
};
charisma.smartui.AttachFileToComment.prototype.setIssue = function () {
  var textarea = this.target[0].tagName !== 'TEXTAREA' ?this.target.children('textarea').first() :this.target;
  this.issue = textarea.closest(".issueContainer").attr('iid') || $(".issueContainer").attr('iid');
};
charisma.smartui.AttachFileToComment.prototype.issueExpanded = function (eventTarget) {
  return false;
};
charisma.smartui.AttachFileToComment.getInstance = function (selector, onUpload, commentDraftGetter) {
  if (!charisma.smartui.AttachFileToComment.INSTANCE) {
    charisma.smartui.AttachFileToComment.INSTANCE = [];
  }

  if (selector) {
    if (charisma.smartui.AttachFileToComment.INSTANCE[selector]) {
      return charisma.smartui.AttachFileToComment.INSTANCE[selector];
    } else {
      charisma.smartui.AttachFileToComment.INSTANCE[selector] = new charisma.smartui.AttachFileToComment(selector, onUpload, commentDraftGetter);
    }

  }

};
