charisma.smartui.IssueListConfig = function () {
};
charisma.smartui.IssueListConfig.prototype.toggleEditMode = function (issueId) {
};
charisma.smartui.IssueList = function (config) {
  charisma.smartui.IssueList.superclass.constructor.call(this);
  this.focused = false;
  this.allFoundIssuesAreSelected = false;
  this.ch = true;
  this.listListeners = new Webr.util.Set();
  this.selectAllClickFunction = Function;
  this.current_state = null;
  var focused = this.init(config);
  this.current_state = charisma.smartui.IssueList.state_NOT_SHIFTED;
};
{
  var F = new Function();
  F.prototype = Webr.component.Component.prototype;
  charisma.smartui.IssueList.prototype = new F();
  charisma.smartui.IssueList.prototype.constructor = charisma.smartui.IssueList;
  charisma.smartui.IssueList.superclass = Webr.component.Component.prototype;
}

charisma.smartui.IssueList.prototype.setToolbar = function (toolbar) {
  this.toolbar = toolbar;
};
charisma.smartui.IssueList.prototype.init = function (config) {
  config.selectAll = config.selectAll || $("." + "selectAll").children("input");
    

  var it = this;
  var oldConfig = this.config;
    

  this.config = config;
  this.content = $(config.content);
  this.selectAll = $(config.selectAll);
  this.focused = false;
    

  if (oldConfig) {
    $(oldConfig.selectAll).unbind("clickSelectAll", this.selectAllClickFunction);
  } else {
    //bind to doc only first time list initied
    var doc = $(Webr.util.Util.isIE ?document.body :document);
    //focus/blur handler
    doc.mousedown(function (e) {
      return it.mousedownHandler(e);
    });
    doc.keydown(function (e) {
      return it.keyDownHandler(e);
    });
    //navigation and stuff
    doc.keyrepeatable(function (e) {
      return it.navigationKeysHandler(e);
    });
    doc.keyup(function (e) {
      return it.keyUpHandler(e);
    });
  }

  //selectAll click on Ctrl-A
  this.selectAll.on("clickSelectAll", this.selectAllClickFunction = function (e, data) {
    it.toggleSelectAll(data);
    return it.selectAllClickHandler(data);
  });
  //issues
  this.getIssues().each(function () {
    it.addIssueHandlers($(this));
  });
    

  //Collect all checked issues
  this.updateCheckedIssuesParam();
    

  if (this.config.focusOnLoad === true) {
    this.focus();
  }

    

  var issueIdToFocus = this.getIssueIdToFocus(config);
  if (issueIdToFocus) {
    this.focus();
    //find persistentId
    jQuery.each(this.getIssues(), function () {
      var issue = $(this);
      if (it.getVisibleIssueId(issue) == issueIdToFocus) {
        it.issueRedrawn(it.getIssueId(issue), true);
        if (it.config.outlineIssueId) {
          it.outlineIssue(issue);
        }

        return issue;
      }

    });
  }

    

  this.restoreCheckboxesStates();
};
charisma.smartui.IssueList.prototype.toggleSelectAll = function (data) {
  if (data != null) {
    this.selectAll.prop("checked", !this.isSelectedAll());
  }

  var next = this.selectAll.next();
    

  next.toggleClass("jt-custom-checkbox-checked");
  next.toggleClass("jt-custom-checkbox-checked-rg");
};
charisma.smartui.IssueList.prototype.getIssueIdToFocus = function (config) {
  return (Webr.util.PageStateStore.getInstance().get("issueid") || config.outlineIssueId) || this.lastFocusedVisibleIssueId;
};
charisma.smartui.IssueList.prototype.restoreCheckboxesStates = function () {
  var it = this;
  jQuery.each(this.getIssues(), function () {
    var issue = $(this);
    if (it.isIssueWasChecked(it.getIssueId(issue))) {
      it.setIssueChecked(issue, true, false);
    }

  });
};
charisma.smartui.IssueList.prototype.mousedownHandler = function (event) {
  if (this.content.ancestorOf(event.target)) {
    //click inside issues list
    //do nothing because issue set focus in addIssueHandlers
    //?WTF?
  } else {
    this.blur();
  }

};
charisma.smartui.IssueList.prototype.isFocusedIssueHasCheckbox = function () {
  return this.getIssueCheckbox(this.getFocusedIssue()).length > 0;
};
charisma.smartui.IssueList.prototype.keyDownHandler = function (event) {
  if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SelectAll"]) && !event.targetIsInput()) {
    this.selectAll.trigger("clickSelectAll", {checked: !this.isSelectedAll()});
    return false;
  }

  if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["StarIssue"])) {
    this.toggleStar();
    return false;
  }

    

  if (!this.focused) {
    return true;
  }

    

  if ((event.isKey(16) || event.isShift(16)) && this.isFocusedIssueHasCheckbox()) {
    this.shiftDown();
  }

  if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["EditIssue"])) {
    if (!$(event.target).hasClass("yt-search-box")) {
      this.edit();
      return false;
    }

  }

    

  if (event.isKey(Webr.util.Key.ENTER)) {
    if (!event.targetIsInput() && this.hasFocusedIssue()) {
      this.enterIssue(this.getFocusedIssue());
      return false;
    }

  }

    

  if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SelectIssueIdSummary"])) {
    charisma.smartui.TextSelector.selectText(this.getIssueAnchor(this.getFocusedIssue()).get(0), this.getIssueSummary(this.getFocusedIssue()).get(0));
  }

  if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SelectIssueId"]) && !event.targetIsInput()) {
    var selection = Webr.util.Util.getSelection();
    if (!(selection && selection != "")) {
      charisma.smartui.TextSelector.setSelection(this.getIssueAnchor(this.getFocusedIssue()).get(0));
      return false;
    }

  }

  if (!event.targetIsInput()) {
    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["DeleteIssue"]) || (Webr.util.Util.isMac && (Webr.util.Key.isApplicable(event, SmartUIShortCuts["DeleteIssue_Backspace"])))) {
      event.preventDefault();
      event.stopPropagation();
      commandDialog && commandDialog.show(commonController.deleteCommand);
      return false;
    }

  }

  return true;
};
charisma.smartui.IssueList.prototype.toggleStar = function () {
  var starred;
  if (this.getCheckedCount() > 0) {
    starred = true;
    var ids = this.getSelectedIssuesIds();
    for (var i = 0; i < ids.length; i += 1) {
      if (!this.isStarred(this.getIssueById(ids[i]))) {
        starred = false;
                break;

      }

    }

  } else {
    starred = this.isStarred(this.getFocusedIssue());
  }

  commandDialog.execute(starred ?commonController.unstarCommand + " " + commonController.meCommand :commonController.starCommand + " " + commonController.meCommand);
};
charisma.smartui.IssueList.prototype.isStarred = function (issue) {
  return issue.find("." + "star").hasClass("active");
};
charisma.smartui.IssueList.prototype.enterIssue = function (issue) {
  var issueHref = issue.find("a." + "issueIdAnchor").get(0);
  if (issueHref) {
    //See JT-13798 (click instead of redirect)
    issueHref.click();
    Webr.event.ResponseServerEventListener.PAGE_CHANGED = true;
  }

};
charisma.smartui.IssueList.prototype.openInNewWindow = function (issue) {
  var issueHref = issue.find("a." + "issueIdAnchor");
  window.open(issueHref.attr("href"), "_blank");
};
charisma.smartui.IssueList.prototype.commentItemFocused = function (item) {
  this.blur();
};
charisma.smartui.IssueList.prototype.keyUpHandler = function (event) {
  if (!this.focused) {
    return true;
  }

    

  if ((event.isKey(16) || event.isShift(16)) && this.isFocusedIssueHasCheckbox()) {
    this.shiftUp();
  }

    

  return true;
};
charisma.smartui.IssueList.prototype.getIssues = function () {
  return this.content.find("." + "issueContainer");
};
charisma.smartui.IssueList.prototype.isIssueChecked = function (issue) {
  return this.getIssueCheckbox(issue).is(":checked");
};
charisma.smartui.IssueList.prototype.getIssueId = function (issue) {
  return issue.attr("iid");
};
charisma.smartui.IssueList.prototype.getVisibleIssueId = function (issue) {
  return this.getIssueAnchor(issue).text();
};
charisma.smartui.IssueList.prototype.isIssueExpanded = function (issue) {
  return issue.hasClass("issue-expanded");
};
charisma.smartui.IssueList.prototype.getIssueCheckbox = function (issue) {
  return issue.find("div." + "issue-controls" + " > input");
};
charisma.smartui.IssueList.prototype.setIssueChecked = function (issue, checked, fire) {
  if (this.isIssueChecked(issue) != checked) {
    this.toggleCheckState(issue, fire);
  }

};
charisma.smartui.IssueList.prototype.getIssueAnchor = function (issue) {
  return issue.find("a." + "issueIdAnchor");
};
charisma.smartui.IssueList.prototype.getIssueSummary = function (issue) {
  return issue.find("." + "issue-summary");
};
charisma.smartui.IssueList.prototype.getIssueDescription = function (issue) {
  return issue.find("." + "description");
};
charisma.smartui.IssueList.prototype.addListListener = function (listener) {
  this.listListeners.add(listener);
};
charisma.smartui.IssueList.prototype.removeListListener = function (listener) {
  this.listListeners.remove(listener);
};
charisma.smartui.IssueList.prototype.fireCheckedItemsChanged = function () {
  this.listListeners.forEach(function (listener) {
    listener.checkedItemsUpdated();
    return true;
  });
};
charisma.smartui.IssueList.prototype.navigationKeysHandler = function (e) {
  //do not handle keys if not in focus
  if (!this.focused) {
    return true;
  }

    

  if (e.isKey(Webr.util.Key.ESC)) {
    //if no issue in edit mode
    if (!(this.isIssueInEditMode(this.getFocusedIssue()))) {
      //clear all selections
      if (this.isSelectedAll()) {
        this.clearSelectedAll();
        return false;
      } else if (this.getCheckedCount()) {
        this.setCheckedForAll(false);
        return false;
      }

    }

  }

    

  if (e.targetIsInput()) {
    return true;
  }

  //TODO: return key Enter action here after WD-1426 fix
  //Key Enter action moved to keydown due to issue WD-1426
  if (e.isKey(Webr.util.Key.UP)) {
    if (!this.prev()) {
      return false;
    }

  }

  //Is made for purpose when shift is met from unknow event, i.e. switch to another application
  if (e.isShift(Webr.util.Key.UP)) {
    this.kup();
    this.prev();
    return false;
  }

  if (e.isKey(Webr.util.Key.DOWN)) {
    if (!this.next()) {
      return false;
    }

  }

  if (e.isShift(Webr.util.Key.DOWN)) {
    this.kdown();
    this.next();
    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["CollapseIssue"])) {
    this.collapse();
    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["ExpandIssue"])) {
    this.expand();
    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["SelectIssue"])) {
    this.toggleCheckState(this.getFocusedIssue());
    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["GoToFirst"])) {
    this.first();
    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["GoToLast"])) {
    this.last();
    return false;
  }

  return this.fireKeyPressed(e);
};
charisma.smartui.IssueList.prototype.keyDown = function (source, e) {
  if (source instanceof charisma.smartui.CommentsList) {
    if (e.isKey(Webr.util.Key.UP)) {
      this.focus();
      return false;
    }

    if (e.isKey(Webr.util.Key.DOWN)) {
      this.focus();
      this.next();
      return false;
    }

    if (e.isKey(Webr.util.Key.LEFT, Webr.util.Key.ESC)) {
      this.focus();
      this.collapse();
      return false;
    }

  }

  var propagate = this.navigationKeysHandler(e);
  if (!propagate) {
    this.focus();
  }

  return propagate;
};
charisma.smartui.IssueList.prototype.getIssueById = function (issueId) {
  return this.content.find("[iid='" + issueId + "']");
};
charisma.smartui.IssueList.prototype.issueRedrawn = function (issueId, focus) {
  var issue = this.getIssueById(issueId);
  var visibleId = this.getVisibleIssueId(issue);
  trace("issueRedrawn: " + visibleId);
    

  this.addIssueHandlers(issue);
    

  if (this.isIssueExpanded(issue)) {
    this.addTextCopierHandlersToExpandedIssue(issue);
  }

    

  if (this.isIssueWasChecked(issueId)) {
    this.setIssueChecked(issue, true, false);
  }

    

  if (focus || this.lastFocusedVisibleIssueId == visibleId) {
    this.unselectIssue(this.getFocusedIssue());
    this.selectIssue(issue, true);
  }

};
charisma.smartui.IssueList.prototype.addIssueHandlers = function (issue) {
  var it = this;
    

  var checkbox = this.getIssueCheckbox(issue);
  checkbox.click(function () {
    it.issueCheckboxClick(issue);
  });
    

  //return focus to issue
  checkbox.focus(function () {
    if (it.getIssueId(it.getFocusedIssue()) !== it.getIssueId(issue)) {
      it.mousedown(issue);
    }

    it.focusIssue(issue);
  });
    

  //Double click has been removed from here!
  issue.click(function (e) {
    it.mousedown(issue);
    return true;
  });
    

};
charisma.smartui.IssueList.prototype.addTextCopierHandlersToExpandedIssue = function (issue) {
  var it = this;
    

  var issueDescription = this.getIssueDescription(issue);
  var issueSummary = this.getIssueSummary(issue);
  var issueAnchor = this.getIssueAnchor(issue);
    

  issueDescription.mouseover(function () {
    it.showTextCopier(issue, issueDescription, null);
  }).mouseout(function () {
    charisma.smartui.TextCopier.hideCopier();
  });
    

  issueSummary.mouseover(function () {
    it.showTextCopier(issue, issueAnchor, issueSummary);
  }).mouseout(function () {
    charisma.smartui.TextCopier.hideCopier();
  });
    

  issueAnchor.mouseout(function () {
    it.showTextCopier(issue, issueAnchor, issueSummary);
  }).mouseout(function () {
    charisma.smartui.TextCopier.hideCopier();
  });
};
charisma.smartui.IssueList.prototype.showTextCopier = function (issue, target, target2) {
  charisma.smartui.TextCopier.showCopier(target, target2, this.getIssueId(issue));
};
charisma.smartui.IssueList.prototype.focus = function () {
  if (this.focused) {
    return ;
  }

    

  this.select();
  this.focusIssue(this.getFocusedIssue());
};
charisma.smartui.IssueList.prototype.blur = function () {
  this.focused = false;
};
charisma.smartui.IssueList.prototype.select = function () {
  if (this.hasFocusedIssue()) {
    this.selectIssue(this.getFocusedIssue());
  } else {
    var items = this.getIssues();
    if (items.length > 0) {
      this.selectIssue(items.first());
    }

  }

};
charisma.smartui.IssueList.prototype.selectIssue = function (issue, focus) {
  if (!issue) {
    issue = this.getFocusedIssue();
  }

    

  this.addSelectedOrFocusedClass(issue);
  this.lastFocusedVisibleIssueId = this.getVisibleIssueId(issue);
  if (focus == true) {
    this.focusIssue(issue);
  }

};
charisma.smartui.IssueList.prototype.unselectIssue = function (issue) {
  issue.removeClass("issue-selected");
  issue.removeClass("issue-focused");
};
charisma.smartui.IssueList.prototype.focusIssue = function (issue) {
  if (issue.length <= 0) {
    return ;
  }

    

  //Very bad design, but if it used earlier, we will use it
  var indents = this.toolbar ?this.toolbar.getDimension() :[0, 0];
  //real performance issue in IE
  if (Webr.util.Util.isIE) {
    issue.scrollToFast(null, indents);
  } else {
    issue.scrollTo(null, indents);
  }

    

  this.getIssueAnchor(issue).focus();
  this.lastFocusedVisibleIssueId = this.getVisibleIssueId(issue);
  this.focused = true;
};
charisma.smartui.IssueList.prototype.addSelectedOrFocusedClass = function (issue) {
  if (this.getCheckedCount()) {
    issue.addClass("issue-focused");
  } else {
    issue.addClass("issue-selected");
  }

};
charisma.smartui.IssueList.prototype.outlineIssue = function (issue) {
  issue.addClass("issue-created");
};
charisma.smartui.IssueList.prototype.clearSelection = function () {
  var focused = this.getFocusedIssue();
  this.unselectIssue(focused);
  var comments = this.getComments(focused);
  if (comments) {
    comments.unfocus();
  }

};
charisma.smartui.IssueList.prototype.mousedown = function (issue) {
  var focused = this.getFocusedIssue();
  if (this.getIssueId(focused) == this.getIssueId(issue)) {
    this.selectIssue(focused);
  } else {
    this.clearSelection();
    this.selectIssue(issue);
  }

  if (!(this.isCommentsExpanded(issue) && this.getComments(issue).isFocused())) {
    this.focused = true;
  }

};
charisma.smartui.IssueList.prototype.toggleCheckState = function (issue, fire) {
  var checkbox = this.getIssueCheckbox(issue);
  //emulate click
  checkbox.prop("checked", !checkbox.prop("checked"));
  checkbox.next().toggleClass("jt-custom-checkbox-checked");
  checkbox.next().toggleClass("jt-custom-checkbox-checked-rg");
  this.issueCheckboxClick(issue, fire);
};
charisma.smartui.IssueList.prototype.issueCheckboxClick = function (issue, fire) {
  var checked = this.isIssueChecked(issue);
  if (checked) {
    issue.addClass("issue-checked");
    if (issue == this.getFocusedIssue()) {
      issue.addClass("issue-focused");
    }

  } else {
    issue.removeClass("issue-checked");
    if (fire == undefined || fire == true) {
      this.clearSelectedAllNoFireClick();
    }

  }

  if (fire == undefined || fire == true) {
    this.updateCheckedIssuesParam();
  }

  this.toggleIeCustomCheckbox(issue, checked);
};
charisma.smartui.IssueList.prototype.toggleIeCustomCheckbox = function (issue, checked) {
  if (Webr.util.Util.isIE && Webr.util.Util.browserVersion < 9) {
    var customCheckbox = this.getIssueCheckbox(issue).next();
    if (checked) {
      customCheckbox.addClass("jt-custom-checkbox-checked");
      customCheckbox.addClass("jt-custom-checkbox-checked-rg");
    } else {
      customCheckbox.removeClass("jt-custom-checkbox-checked");
      customCheckbox.removeClass("jt-custom-checkbox-checked-rg");
    }

  }

};
charisma.smartui.IssueList.prototype.next = function () {
  var focused = this.getFocusedIssue();
  var nextIssue = this.getNextPrevIssue(true, focused);
  if (nextIssue.length > 0) {
    this.unselectIssue(focused);
    this.selectIssue(nextIssue, true);
    return false;
  } else {
    $(window).scrollTop($(document).height());
  }

  return true;
};
charisma.smartui.IssueList.prototype.prev = function () {
  var focused = this.getFocusedIssue();
  var prevIssue = this.getNextPrevIssue(false, focused);
  if (prevIssue.length > 0) {
    this.unselectIssue(focused);
    this.selectIssue(prevIssue, true);
    return false;
  } else {
    $(window).scrollTop(0);
  }

  return true;
};
charisma.smartui.IssueList.prototype.getNextPrevIssue = function (next, focused) {
  var fn = next ?"next" :"prev";
  var prevIssue = focused[fn]("." + "issueContainer");
  if (prevIssue.length > 0) {
    return prevIssue;
  } else {
    var hs = "." + "hierarchy";
    var hierarchy = focused.parent()[fn](hs);
    var nodes = hierarchy.children();
    while (hierarchy.length > 0 && nodes.length <= 0) {
      hierarchy = hierarchy[fn](hs);
      nodes = hierarchy.children();
    }

    return next ?nodes.first() :nodes.last();
  }

};
charisma.smartui.IssueList.prototype.first = function () {
  var focused = this.getFocusedIssue();
  var firstIssue = this.getIssues().first();
  if (focused.get(0) != firstIssue) {
    this.unselectIssue(focused);
    this.selectIssue(firstIssue, true);
    return false;
  } else {
    $(window).scrollTop(0);
  }

  return true;
};
charisma.smartui.IssueList.prototype.last = function () {
  var focused = this.getFocusedIssue();
  var lastIssue = this.getIssues().last();
  if (focused.get(0) != lastIssue) {
    this.unselectIssue(focused);
    this.selectIssue(lastIssue, true);
    return false;
  } else {
    $(window).scrollTop($(document).height());
  }

  return true;
};
charisma.smartui.IssueList.prototype.expand = function () {
  this.expandIssue(this.getFocusedIssue());
};
charisma.smartui.IssueList.prototype.expandIssue = function (issue) {
  if (!this.isIssueExpanded(issue)) {
    //in case user quickly press an expand control of another issue
    charisma.smartui.TextCopier.hideCopier(true);
    this.getExpandToggleAnchor(issue).click();
    return false;
  }

  if (!this.isCommentsExpanded(issue)) {
    this.getCommentsToggleAnchor(issue).click();
    return false;
  }

  this.blur();
  var list = this.getComments(issue);
  list && list.focus();
};
charisma.smartui.IssueList.prototype.collapse = function () {
  this.collapseIssue(this.getFocusedIssue());
};
charisma.smartui.IssueList.prototype.isCommentsExpanded = function (issue) {
  return issue.find("." + "issue-comments").length > 0;
};
charisma.smartui.IssueList.prototype.getCommentsToggleAnchor = function (issue) {
  return issue.find("." + "toggleCommentsAnchor");
};
charisma.smartui.IssueList.prototype.getExpandToggleAnchor = function (issue) {
  return issue.find("a." + "toggleDescrAnchor");
};
charisma.smartui.IssueList.prototype.collapseIssue = function (issue) {
  if (this.isCommentsExpanded(issue)) {
    var comments = this.getComments(issue);
    comments && comments.unfocus();
    this.getCommentsToggleAnchor(issue).click();
    return false;
  }

  if (this.isIssueExpanded(issue)) {
    charisma.smartui.TextCopier.hideCopier(true);
    this.getExpandToggleAnchor(issue).click();
    return false;
  }

};
charisma.smartui.IssueList.prototype.edit = function () {
  charisma.smartui.TextCopier.hideCopier(true);
  if (this.config.toggleEditMode) {
    this.config.toggleEditMode(this.getIssueId(this.getFocusedIssue()));
  }

};
charisma.smartui.IssueList.prototype.getFocusedIssue = function () {
  var res = this.content.find("." + "issue-focused");
  if (res.length <= 0) {
    res = this.content.find("." + "issue-selected");
  }

  var issueId = this.getIssueId(res);
  if (issueId) {
    this.lastFocusedVisibleIssueId = this.getVisibleIssueId(res);
  }

  return res;
};
charisma.smartui.IssueList.prototype.hasFocusedIssue = function () {
  return this.getFocusedIssue().length > 0;
};
charisma.smartui.IssueList.prototype.isIssueInEditMode = function (issue) {
  return issue.hasClass("listEditIssue");
};
charisma.smartui.IssueList.prototype.getComments = function (issue) {
  return issue.data("commentList");
};
charisma.smartui.IssueList.prototype.setComments = function (issue, comments) {
  var commentsList = this.getComments(issue);
  if (commentsList) {
    commentsList.removeListener(this);
    commentsList.unhandleKeys();
  }

  issue.data("commentList", comments);
  comments.addListener(this);
};
charisma.smartui.IssueList.prototype.isSelectedAll = function () {
  return this.selectAll.prop("checked");
};
charisma.smartui.IssueList.prototype.clearSelectedAllNoFireClick = function () {
  if (this.isSelectedAll()) {
    //click forces call to selectAllClickHandler
    this.selectAll.trigger("clickSelectAll", {ignore: true});
  }

  this.allFoundIssuesAreSelected = false;
};
charisma.smartui.IssueList.prototype.clearSelectedAll = function () {
  if (this.isSelectedAll()) {
    //click forces call to selectAllClickHandler
    this.selectAll.trigger("clickSelectAll", {checked: false});
  }

  this.allFoundIssuesAreSelected = false;
};
charisma.smartui.IssueList.prototype.selectAllClickHandler = function (data) {
  if (data && data["ignore"]) {
    return ;
  }

  var checked = data ?data["checked"] :this.isSelectedAll();
  this.setCheckedForAll(checked);
  //focus to issues list
  this.focus();
};
charisma.smartui.IssueList.prototype.setCheckedForAll = function (checked) {
  var it = this;
  jQuery.each(this.getIssues(), function () {
    it.setIssueChecked($(this), checked, false);
  });
  this.updateCheckedIssuesParam();
};
charisma.smartui.IssueList.prototype.updateCheckedIssuesParam = function () {
  this.createCheckedIssuesInput();
  var res = "";
  var first = true;
  var it = this;
  jQuery.each(this.getIssues(), function () {
    if (it.isIssueChecked($(this))) {
      if (first) {
        first = false;
      } else {
        res += ",";
      }

      res += it.getIssueId($(this));
    }

  });
  this.checkedIssuesInput.value = res;
  this.fireCheckedItemsChanged();
};
charisma.smartui.IssueList.prototype.getSelectedIssuesIds = function () {
  var issueIds = [];
  var it = this;
  jQuery.each(this.getIssues(), function () {
    if (it.isIssueChecked($(this))) {
      issueIds.push(it.getIssueId($(this)));
    }

  });
  if (issueIds.length == 0) {
    //no checked - add focused issue
    issueIds.push(it.getIssueId(it.getFocusedIssue()));
  }

    

  return issueIds;
};
charisma.smartui.IssueList.prototype.isIssueWasChecked = function (issueId) {
  var v = this.checkedIssuesInput.value;
  var res = v.indexOf(issueId + ",") >= 0 || (v.lastIndexOf(issueId) == v.length - issueId.length);
  return res;
};
charisma.smartui.IssueList.prototype.createCheckedIssuesInput = function () {
  if (!this.checkedIssuesInput) {
    this.checkedIssuesInput = document.createElement("input");
    this.checkedIssuesInput.type = "hidden";
    this.checkedIssuesInput.name = "hiddenCheckedIssue";
    document.body.appendChild(this.checkedIssuesInput);
  }

};
charisma.smartui.IssueList.prototype.getCheckedCount = function () {
  var value = this.checkedIssuesInput.value;
  return value == "" ?0 :value.split(",").length;
};
charisma.smartui.IssueList.prototype.shiftDown = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "shiftDown", arguments);
};
charisma.smartui.IssueList.prototype.shiftUp = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "shiftUp", arguments);
};
charisma.smartui.IssueList.prototype.kdown = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "kdown", arguments);
};
charisma.smartui.IssueList.prototype.kup = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "kup", arguments);
};
charisma.smartui.IssueList.state_NOT_SHIFTED = {name: "NOT_SHIFTED", onexit: function () {
  this.ch = !(this.isIssueChecked(this.getFocusedIssue()));
}, shiftDown: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.IssueList.state_NOT_SHIFTED);
    }

    return charisma.smartui.IssueList.state_INITIAL;
  }

  return false;
}};
charisma.smartui.IssueList.state_SHIFTED = {name: "SHIFTED"};
charisma.smartui.IssueList.state_INITIAL = {name: "INITIAL", parentState: charisma.smartui.IssueList.state_SHIFTED, kdown: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.IssueList.state_MOVE_DOWN);
    }

    return charisma.smartui.IssueList.state_MOVE_DOWN;
  }

  return false;
}, kup: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.IssueList.state_MOVE_UP);
    }

    return charisma.smartui.IssueList.state_MOVE_UP;
  }

  return false;
}, shiftUp: function () {
  if (true) {
    return charisma.smartui.IssueList.state_NOT_SHIFTED;
  }

  return false;
}};
charisma.smartui.IssueList.state_MOVE_DOWN = {name: "MOVE_DOWN", parentState: charisma.smartui.IssueList.state_SHIFTED, onenter: function () {
  this.setIssueChecked(this.getFocusedIssue(), this.ch);
}, kdown: function () {
  if (true) {
    this.setIssueChecked(this.getFocusedIssue(), this.ch);
    return ;
  }

  return false;
}, kup: function () {
  if (true) {
    this.ch = !this.ch;
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.IssueList.state_MOVE_UP);
    }

    return charisma.smartui.IssueList.state_MOVE_UP;
  }

  return false;
}, shiftUp: function () {
  if (true) {
    return charisma.smartui.IssueList.state_NOT_SHIFTED;
  }

  return false;
}};
charisma.smartui.IssueList.state_MOVE_UP = {name: "MOVE_UP", parentState: charisma.smartui.IssueList.state_SHIFTED, onenter: function () {
  this.setIssueChecked(this.getFocusedIssue(), this.ch);
}, kup: function () {
  if (true) {
    this.setIssueChecked(this.getFocusedIssue(), this.ch);
    return ;
  }

  return false;
}, kdown: function () {
  if (true) {
    this.ch = !this.ch;
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.IssueList.state_MOVE_DOWN);
    }

    return charisma.smartui.IssueList.state_MOVE_DOWN;
  }

  return false;
}, shiftUp: function () {
  if (true) {
    return charisma.smartui.IssueList.state_NOT_SHIFTED;
  }

  return false;
}};
