charisma.smartui.PropertySelector = function () {
  this.currentShown = false;
  this.inited = false;
  var it = this;
  this.handler = function (e) {
    if (e.isKey(Webr.util.Key.TAB)) {
      e.preventDefault();
      return it.select(++it.current);
    } else if (e.isShift(Webr.util.Key.TAB)) {
      e.preventDefault();
      return it.select(--it.current);
    }

    return it.submit(e);
  };
  this.listener = {afterRefresh: function (templatePath, root) {
    if (root.getAttribute("id") == it.rootId) {
      it.refreshRoot();
      it.update();
    }

  }, beforeRefresh: function (templatePath, root) {
    if (root == it.root.get(0)) {
      it.unbind();
    }

    it.finalize(templatePath);
  }};
};
charisma.smartui.PropertySelector.prototype.finalize = function (templatePath) {
  if (this.newIssueTemplateRootId && this.newIssueTemplateRootId.indexOf(templatePath) == 0) {
    Webr.event.RefreshCommandProcessor.removeListener(this.listener);
    this.unbind();
    this.deinit();
  }

};
charisma.smartui.PropertySelector.prototype.init = function (rootId, newIssueRootId, head, tail, submit) {
  info("Initing...");
  this.newIssueTemplateRootId = newIssueRootId.substring(3);
  this.rootId = rootId;
  this.refreshRoot();
  this.head = head;
  this.tail = tail;
  this.submit = submit;
  this.inited = true;
};
charisma.smartui.PropertySelector.prototype.deinit = function () {
  if (this.inited) {
    info("Deiniting...");
    delete this.head;
    delete this.tail;
    delete this.submit;
    this.inited = false;
  }

};
charisma.smartui.PropertySelector.prototype.unbind = function () {
  if (this.inited) {
    info("Unbinding...");
    this.combos.unbind("ShowOptions").unbind("HideOptions");
    delete this.combos;
    delete this.fields;
    Webr.util.Util.removeKeyHandler(this.root, this.handler);
  }

};
charisma.smartui.PropertySelector.prototype.update = function () {
  if (this.inited) {
    info("Updating current selected...");
    if (this.current) {
      if (this.current < 0 || this.current >= charisma.smartui.PropertySelector.LAST) {
        //nothing selected, do not touch
        return ;
      }

      if (this.currentShown) {
        this.show(this.current);
      } else {
        this.focus(this.current);
      }

    }

  }

};
charisma.smartui.PropertySelector.prototype.bind = function () {
  var it = this;
  this.fields = this.combos.prev();
  this.combos.bind("ShowOptions", function () {
    it.onShowCombo(it.combos.index(this));
  }).bind("HideOptions", function () {
    it.onHideCombo(it.combos.index(this));
  });
  Webr.util.Util.addKeyHandler(this.root, this.handler);
};
charisma.smartui.PropertySelector.prototype.refreshRoot = function () {
  info("Refreshing root...");
  var rootElement = document.getElementById(this.rootId);
  if (rootElement) {
    this.root = $(rootElement);
    Webr.event.RefreshCommandProcessor.addListener(this.listener);
    this.combos = this.root.find("div." + "combobox");
    var len = this.combos.length;
    if (len <= 0) {
      charisma.smartui.PropertySelector.LAST = 0;
      return ;
    }

    charisma.smartui.PropertySelector.LAST = len;
        

    this.bind();
  }

};
charisma.smartui.PropertySelector.prototype.select = function (index) {
  if (this.inited) {
    if (index < 0) {
      this.current = 0;
      info("Calling head...");
      this.head();
      return true;
    } else if (index >= charisma.smartui.PropertySelector.LAST) {
      this.current = charisma.smartui.PropertySelector.LAST;
      info("Calling tail...");
      this.tail();
      return true;
    }

    this.current = index;
    var it = this;
    //Avoid TAB that will be recieved in Combo on open/close
    //Wait for focus and other shit happened with combo
    window.setTimeout(function () {
      it.show(index);
    }, 250);
    return true;
  }

  return false;
};
charisma.smartui.PropertySelector.prototype.onShowCombo = function (n) {
  info("Shown " + n);
  this.current = n;
  this.currentShown = true;
  Webr.util.Util.addKeyHandler(this.combos.eq(n).data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE).renderer.getMainElement(), this.handler);
};
charisma.smartui.PropertySelector.prototype.onHideCombo = function (n) {
  info("Hidden " + n);
  this.currentShown = false;
  Webr.util.Util.removeKeyHandler(this.combos.eq(n).data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE).renderer.getMainElement(), this.handler);
};
charisma.smartui.PropertySelector.prototype.show = function (index) {
  info("Click on " + index);
  this.currentShown = true;
  this.fields.eq(index).trigger("click");
};
charisma.smartui.PropertySelector.prototype.focus = function (index) {
  info("Focusing on " + index);
  this.fields.eq(index).children().eq(0).focus();
};
charisma.smartui.PropertySelector._INSTANCE_ = null;
charisma.smartui.PropertySelector.LAST = 0;
charisma.smartui.PropertySelector.getInstance = function () {
  if (charisma.smartui.PropertySelector._INSTANCE_ == null) {
    charisma.smartui.PropertySelector._INSTANCE_ = new charisma.smartui.PropertySelector();
  }

  return charisma.smartui.PropertySelector._INSTANCE_;
};
