charisma.smartui.SortController = function (config) {
  this.issueMoved = false;
  this.list = $(config.content);
  this.sortData = config.sortData;
  this.listLeftPos = this.list.offset().left;
  this.hintMsg = [l10n('${l10n("SortController.js.Remove_from_order")}'), this.sortData.subtaskTypeName + " ", l10n('${l10n("SortController.js.Move_to_root_level")}'), "", l10n('${l10n("SortController.js.Sorry_can_t_move_issue_within_a_hierachy")}')];
  this.hierarchy = this.sortData.isHierarchyMode();
  this.init();
};
charisma.smartui.SortController.prototype.init = function () {
  var it = this;
  this.resetSortable();
  this.list.sortable({items: "div." + charisma.smartui.SortController.SORT_ITEM, cursor: "move", tolerance: 'pointer', handle: "." + "drag-control", placeholder: "sort-placeholder", start: function (e, ui) {
    it.start(ui);
  }, sort: function (e, ui) {
    it.moveHint(ui);
  }, beforeStop: function (e, ui) {
    it.beforeStop(ui);
  }});
};
charisma.smartui.SortController.prototype.resetSortable = function () {
  if (this.list.is(":ui-sortable")) {
    this.list.sortable("destroy");
  }

};
charisma.smartui.SortController.prototype.start = function (ui) {
  //select issue to get commands work properly
  var issueList = issues.issuesList;
  if (issueList) {
    issueList.unselectIssue(issueList.getFocusedIssue());
    issueList.selectIssue(ui.item, true);
  }

  //save previous element for further check if position is changed
  var prev = ui.item.prev("div." + charisma.smartui.SortController.SORT_ITEM);
  if (prev.get(0)) {
    this.prevIssue = prev;
  } else {
    this.prevIssue = this.getPrevIssue(ui);
  }

  this.initDrag(ui);
};
charisma.smartui.SortController.prototype.initDrag = function (ui) {
  ui.placeholder.height(ui.helper.outerHeight());
  this.toggleHelperView(ui.helper, true);
    

  if (this.hierarchy && this.isRoot(ui.helper)) {
    ui.helper.data(charisma.smartui.SortController.CHILDREN, ui.helper.nextUntil("." + "h-level-0").not("." + "sort-placeholder"));
    this.toggleHierarchy(ui.helper, false);
  }

};
charisma.smartui.SortController.prototype.beforeStop = function (ui) {
  this.toggleHelperView(ui.helper, false);
  this.processPosition(ui);
};
charisma.smartui.SortController.prototype.toggleHelperView = function (issue, start) {
  if (start) {
    issue.addClass("sort-helper");
  } else {
    issue.removeClass("sort-helper");
  }

};
charisma.smartui.SortController.prototype.toggleHierarchy = function (root, show) {
  var children = root.data(charisma.smartui.SortController.CHILDREN);
  if (children) {
    if (show) {
      children.addClass(charisma.smartui.SortController.SORT_ITEM).show();
    } else {
      children.removeClass(charisma.smartui.SortController.SORT_ITEM).hide();
    }

    this.list.sortable("refresh");
  }

};
charisma.smartui.SortController.prototype.isUnrelatedRoot = function (issue) {
  var unrelatedRoot = issue.hasClass("issue-unrelated") && issue.hasClass("h-level-0");
  if (unrelatedRoot) {
    Webr.event.PopupMessage.SYSTEM.show(l10n('${l10n("SortController.js.Issue_you_ve_dragged_doesn_t_match_search_criteria_and_can_t_be_re-ordered")}'));
  }

  return unrelatedRoot;
};
charisma.smartui.SortController.prototype.moveIssue = function (ui) {
  var leading = this.getPrevIssue(ui);
  if ((leading.attr("id") == this.prevIssue.attr("id") && this.prevIssue.get(0)) || this.isUnrelatedRoot(ui.helper)) {
    this.list.sortable("cancel");
    this.toggleHierarchy(ui.helper, true);
    return ;
  }

  var it = this;
  var data = this.sortData;
  var leadingId = this.getVisibleId(leading);
  if (leadingId == null) {
    leadingId = data.lastIssueOnPrevPage;
  }

  if (leadingId != null && data.brandNewIssues.indexOf("," + leadingId + ",") != -1) {
    //leading issue's just been created. Do not want to allow to use it as a leading one
    leadingId = null;
  }

    

  var moved = ui.item;
  var query = data.wfId == "" ?data.queryString :"";
  var movedId = this.getVisibleId(moved);
  charisma.RestMethods.moveIssue(data.wfId ?data.wfId :"<fake>", movedId, leadingId, query, data.orderExpected, function (response) {
    var code = response.messageCode;
    if (code == 200) {
      it.issueMoved = true;
      data.wfId = response.id;
      data.orderExpected = true;
            

      //restore hierarchy
      var children = ui.helper.data(charisma.smartui.SortController.CHILDREN);
      if (children && children.length > 0) {
        it.sortData.refreshList(true);
      } else {
        if ($(".marked").length < 1) {
          it.customOrderCreatedCallBack();
        }

                

        //mark ordered issues
        it.markIssues(moved);
      }

            

      it.list.find("." + "reset-order").removeClass("hidden");
      trace("Issue " + movedId + (leadingId ?" placed after " + leadingId :" placed first"));
            

    } else {
      it.list.sortable("cancel");
      if (code == 406) {
        data.wfId = response.id;
        Webr.event.PopupMessage.SYSTEM.show(l10n('${l10n("SortController.js.Issues_custom_order_has_been_removed")}', "<a id='refreshIssues' href='javascript:void(0)'>", "</a>"));
        $("#refreshIssues").click(function () {
          window.location.reload();
        });
      } else if (code == 500) {
        Webr.event.PopupMessage.ERROR.show(l10n('${l10n("SortController.js.Internal_server_error")}', response.params[0].value));
      } else if (code == 418 || code == 400) {
        Webr.event.PopupMessage.ERROR.show(response.params[0].value);
      } else if (code == 403) {
        var message = l10n('${l10n("SortController.js.You_don_t_have_permissions_to_reorder_issues_in")}', response.params[0].value);
        if (response.params[1].value == "user") {
          message += l10n('${l10n("SortController.js.Only_project_leader_with_login_{0}_is_allowed_to_do_it")}', response.params[2].value);
        } else {
          message += l10n('${l10n("SortController.js.Only_members_of_{0}_are_allowed_to_do_it")}', response.params[2].value);
        }

        Webr.event.PopupMessage.SYSTEM.show(message);
      } else if (code == 404) {
        Webr.event.PopupMessage.ERROR.show(l10n('${l10n("SortController.js.Could_not_find_a_context_under_id")}', data.wfId));
      }

    }

  });
};
charisma.smartui.SortController.prototype.markIssues = function (moved) {
  moved.addClass("marked");
  moved.prevAll("." + charisma.smartui.SortController.SORT_ITEM).addClass("marked");
};
charisma.smartui.SortController.prototype.removeIssue = function (issue) {
  var data = this.sortData;
  var issueId = this.getVisibleId(issue);
  charisma.RestMethods.resetIssuePosition(data.wfId, issueId, function (response) {
    var code = response.messageCode;
    if (code != 200) {
      //TODO error text
      Webr.event.PopupMessage.ERROR.show(l10n('${l10n("SortController.js.Error")}'));
    } else {
      issue.remove();
      trace("Issue " + issueId + " removed from the custom order");
      data.refreshList(true);
    }

  });
};
charisma.smartui.SortController.prototype.linkCommand = function (ui, targetIssue, unlink) {
  var it = this;
  var command;
  var source = this.getVisibleId(ui.helper);
  var target = this.getVisibleId(targetIssue);
  if (unlink) {
    command = commonController.removeCommand + " " + this.sortData.subtaskTypeName + " " + target;
  } else {
    command = this.sortData.subtaskTypeName + " " + target;
  }

    

  commandDialog.execute(command);
};
charisma.smartui.SortController.prototype.processPosition = function (ui) {
  var prevIssue;
  if (this.state == 1) {
    //TODO: move if into getState method
    prevIssue = this.getPrevIssue(ui);
    if (!prevIssue.get(0)) {
      //issue goes first
      this.state = 3;
    }

  }

  switch (this.state) {
  case 0:
    trace("Issue " + this.getVisibleId(ui.item) + " was removed from the custom order");
    this.removeIssue(ui.item);
        break;

  case 1:
    this.linkCommand(ui, prevIssue);
    ui.helper.addClass(this.getHierarchyCss(prevIssue));
        break;

  case 2:
    this.linkCommand(ui, this.getParentIssue(ui.helper), true);
        break;

  case 3:
    this.moveIssue(ui);
        break;

  case null:
    this.toggleHierarchy(ui.helper, true);
    this.list.sortable("cancel");
  }

  this.hideHint();
};
charisma.smartui.SortController.prototype.getParentIssue = function (issue) {
  if (this.hierarchy && !this.isRoot(issue)) {
    var prevAll = issue.prevAll("." + "issueContainer");
    var selfLevel = this.getIssueLevel(issue);
    var prev = this.prevIssue;
    while (this.getIssueLevel(prev) >= selfLevel) {
      prev = prev.prev();
    }

    return prev;
  }

  return issue.prev();
};
charisma.smartui.SortController.prototype.getIssueLevel = function (issue) {
  return parseInt(this.getHierarchyCss(issue, true).split("h-level-").pop());
};
charisma.smartui.SortController.prototype.getState = function (ui) {
  var d = ui.offset.left - this.listLeftPos;
  if (d < -20) {
    if (!this.hierarchy) {
      if (ui.helper.hasClass("marked")) {
        return 0;
      } else {
        return 3;
      }

    } else {
      if (this.isRoot(ui.helper)) {
        if (ui.helper.hasClass("marked")) {
          //remove issue from order
          return 0;
        } else if (!this.isRoot(this.getNextIssue(ui))) {
          //subtask
          return 1;
        } else {
          return 3;
        }

      } else {
        //convert child to root
        return 2;
      }

    }

  }

  if (d > 44) {
    if (this.hierarchy && this.getPrevIssue(ui).get(0)) {
      //create subtask
      return 1;
    } else {
      return 3;
    }

  }

  if (d <= 44 && d > -20) {
    if (!this.hierarchy) {
      return 3;
    } else {
      if (!this.isRoot(ui.helper)) {
        //subtask is been dragging
        if (ui.helper.parent().ancestorOf(ui.placeholder)) {
          //reorder within hierarchy unavailable
          return 1;
        } else {
          //convert child to root
          return 2;
        }

      } else {
        var next = this.getNextIssue(ui);
        if (!next.get(0) || this.isRoot(next)) {
          //move issue
          return 3;
        } else {
          return 1;
        }

      }

    }

  }

  return null;
};
charisma.smartui.SortController.prototype.createHint = function (issue) {
  if (!this.hint) {
    this.hint = $(document.createElement("div")).html("<span></span><span class='" + "sort-action-arrow" + "'></span>").addClass("sort-action-icon");
    issue.append(this.hint);
  } else if (this.hint.parent() != issue.helper) {
    var clone = this.hint.clone();
    issue.append(clone);
    this.hint.remove();
    this.hint = clone;
  }

};
charisma.smartui.SortController.prototype.hideHint = function () {
  if (this.hint) {
    this.hint.hide();
  }

};
charisma.smartui.SortController.prototype.showHint = function (ui, index, prevIssue) {
  if (this.hintMsg[index]) {
    this.createHint(ui.helper);
    var id = (prevIssue.get(0) ?this.getVisibleId(prevIssue) :"");
    var span = this.hint.children().first();
    var text = this.hintMsg[index] + id;
    if (index == 0) {
      text = "\u2190 " + text;
    }

    span.text(text);
    this.hint.show();
  }

};
charisma.smartui.SortController.prototype.resetUI = function (ui) {
  this.resetPlaceholder(ui.placeholder);
  this.hideHint();
};
charisma.smartui.SortController.prototype.resetPlaceholder = function (placeholder) {
  placeholder.attr("class", "sort-placeholder");
  return placeholder;
};
charisma.smartui.SortController.prototype.moveHint = function (ui) {
  this.state = this.getState(ui);
  var prevIssue = this.state == 1 ?this.getPrevIssue(ui) :$();
  this.resetUI(ui);
  this.showHint(ui, this.state, prevIssue);
    

  switch (this.state) {
  case null:
    this.updatePlaceholderIndent(ui, prevIssue, true);
        break;

  case 0:
    ui.placeholder.addClass("remove-from-order");
        break;

  case 1:
    this.updatePlaceholderIndent(ui, prevIssue);
        break;

  }

};
charisma.smartui.SortController.prototype.updatePlaceholderIndent = function (ui, prevIssue, sameAsPrev) {
  if (this.hierarchy && prevIssue.get(0)) {
    var css = this.getHierarchyCss(prevIssue, sameAsPrev ?true :false);
    this.resetPlaceholder(ui.placeholder).addClass(css);
  }

};
charisma.smartui.SortController.prototype.getVisibleId = function (issue) {
  if (!issue.get(0)) {
    return null;
  }

  return issue.find("a." + "issueIdAnchor").first().text();
};
charisma.smartui.SortController.prototype.getPrevIssue = function (ui) {
  var allPrev = ui.placeholder.prevAll("." + "issueContainer" + ":visible");
  var prev = allPrev.first();
  if (prev.get(0)) {
    return this.sameIssue(prev, ui) ?allPrev.eq(1) :prev;
  }

  return $();
};
charisma.smartui.SortController.prototype.getNextIssue = function (ui) {
  var allNext = ui.placeholder.nextAll("." + "issueContainer" + ":visible");
  var next = allNext.first();
  if (next.get(0)) {
    return this.sameIssue(next, ui) ?allNext.eq(1) :next;
  }

  return $();
};
charisma.smartui.SortController.prototype.sameIssue = function (issue, ui) {
  return issue.attr("id") == ui.helper.attr("id");
};
charisma.smartui.SortController.prototype.getHierarchyCss = function (issue, self) {
  var hierarchy = issue.attr("class").match(/h-level-[0-9]+/);
  if (hierarchy == null) {
    //2 & 3 view modes
    return "h-level-1";
  }

  if (self) {
    return hierarchy[0];
  }

  var parts = hierarchy[0].split("-");
  var selfLevel = parseInt(parts.pop());
  if (selfLevel < this.sortData.maxLevel) {
    ++selfLevel;
  }

  return parts.join("-") + "-" + selfLevel;
};
charisma.smartui.SortController.prototype.isRoot = function (issue) {
  return issue.hasClass("h-level-0");
};
charisma.smartui.SortController.SORT_ITEM = "sort-item";
charisma.smartui.SortController.CHILDREN = "children";
charisma.smartui.SortData = function () {
};
