var ToolbarGuard = {};
ToolbarGuard = function (toolbar) {
  var self = this;
  this.toolbar = toolbar;
  this.componentName = toolbar.container.attr("id").substring(3);
  info("ToolbarGuard[" + this.componentName + "] created");
  this.refreshListener = {beforeRefresh: function (templatePath) {
    self.onTemplateRefresh(templatePath);
  }};
  Webr.event.RefreshCommandProcessor.addListener(this.refreshListener);
};
ToolbarGuard.prototype.onTemplateRefresh = function (path) {
  if (this.componentName.indexOf(path) == 0) {
    info("ToolbarGuard[" + this.componentName + "] destroyed");
    this.componentName = null;
    Webr.event.RefreshCommandProcessor.removeListener(this.refreshListener);
    this.refreshListener = null;
    this.toolbar["guard"] = null;
    this.finalize();
  }

};
ToolbarGuard.prototype.finalize = function () {
  charisma.smartui.Toolbar.destroy(this.toolbar);
};
ToolbarGuard.get = function (toolbar) {
  if (!toolbar["guard"]) {
    toolbar["guard"] = new ToolbarGuard(toolbar);
  }

  return toolbar["guard"];
};
