package jetbrains.charisma.wiki;

/*Generated by MPS */

import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.utils.AttributeManufacture;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagStack;
import jetbrains.exodus.entitystore.Entity;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import java.io.IOException;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlTag;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.webr.wiki.processor.runtime.utils.ClosingHtmlTag;
import webr.framework.function.HtmlStringUtil;
import jetbrains.mps.webr.wiki.processor.runtime.utils.OpeningHtmlTag;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.wiki.processor.runtime.LinkAppender;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.charisma.service.UserFilterService;
import jetbrains.charisma.service.UserProfileService;
import webr.framework.url.UrlUtil;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import java.io.Reader;
import jetbrains.mps.webr.wiki.processor.runtime.TrailingCharStringReader;
import jetbrains.mps.webr.wiki.processor.runtime.utils.CommonWikiUtils;
import jetbrains.mps.webr.wiki.processor.runtime.WikiUtil;

%%

%class CharismaHtmlTextWikiProcessorMarkup
%extends BaseProcessor

%public 
%buffer 124
%final
%unicode

%{

  public AttributeManufacture HtmlTextattributeManufacture = new AttributeManufacture();
  public String HtmlTextadditionalHtmlStyleClass = "";
  private TagStack HtmlTextstack = new TagStack();
  public boolean IssueLinkuseGlobalLinks = false;
  public Entity IssueLinkissue = null;
  public boolean IssueLinkmobile = false;
  public boolean IssueLinkfromWorkflow = false;
  public List<Entity> IssueLinkmentionedUsers = ListSequence.fromList(new ArrayList<Entity>());
  public boolean QueryLinkuseGlobalLinks = false;
  public boolean QueryLinkmobile = false;
  private int NewLinesSimplenewLineCount;
  private boolean liveModePreview = false;

  public IWikiProcessor clone(String input) {
    CharismaHtmlTextWikiProcessorMarkup cloned = create(input);
    cloned.HtmlTextattributeManufacture = this.HtmlTextattributeManufacture;
    cloned.HtmlTextadditionalHtmlStyleClass = this.HtmlTextadditionalHtmlStyleClass;
    cloned.IssueLinkuseGlobalLinks = this.IssueLinkuseGlobalLinks;
    cloned.IssueLinkissue = this.IssueLinkissue;
    cloned.IssueLinkmobile = this.IssueLinkmobile;
    cloned.IssueLinkfromWorkflow = this.IssueLinkfromWorkflow;
    cloned.IssueLinkmentionedUsers = this.IssueLinkmentionedUsers;
    cloned.QueryLinkuseGlobalLinks = this.QueryLinkuseGlobalLinks;
    cloned.QueryLinkmobile = this.QueryLinkmobile;
    return cloned;
  }

  protected void processInternal() throws IOException {
    if (this.wrapWithDiv) {
      this.builderContext.append(PROLOG);
    }
    this.yylex();
    this.finish();
    if (this.wrapWithDiv) {
      this.builderContext.append(EPILOG);
    }
  }

  protected void finish() {
  }

  protected boolean readerNotExists() {
    return this.zzReader == null;
  }

  private String yytext(int prefixLength, int suffixLength) {
    return new String(this.zzBuffer, this.zzStartRead + prefixLength, this.zzMarkedPos - this.zzStartRead - suffixLength - prefixLength);
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkuseGlobalLinks(boolean value) {
    this.IssueLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkissue(Entity value) {
    this.IssueLinkissue = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkmobile(boolean value) {
    this.IssueLinkmobile = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkfromWorkflow(boolean value) {
    this.IssueLinkfromWorkflow = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkmentionedUsers(List<Entity> value) {
    this.IssueLinkmentionedUsers = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setQueryLinkuseGlobalLinks(boolean value) {
    this.QueryLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setQueryLinkmobile(boolean value) {
    this.QueryLinkmobile = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setCharismaHtmlTextWikiProcessor_attributeManufacture(AttributeManufacture value) {
    this.HtmlTextattributeManufacture = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setCharismaHtmlTextWikiProcessor_additionalHtmlStyleClass(String value) {
    this.HtmlTextadditionalHtmlStyleClass = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setLivePreviewMode(boolean value) {
    return this;
  }

  public void appendNewLines(HtmlTag tag) {
    int start = this.getText().lastIndexOf(">") + 1;
    boolean skipFirstNewLine = !(tag.getTagTitle().isInline()) && this.getText().indexOf("\n", start) != -1;
    for (int i = start; i < this.getText().length(); ++i) {
      if (this.getText().charAt(i) == '\n') {
        if (skipFirstNewLine) {
          skipFirstNewLine = false;
        } else {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("<br/>");
          }
        }
      } else if ((this.getText().charAt(i) == ' ' || this.getText().charAt(i) == '\t') && !(skipFirstNewLine)) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(BaseProcessor.characterToStringSafe(this.getText().charAt(i)));
        }
      }
    }
  }

  public int endOfTagIdx() {
    int idx = this.getText().indexOf('>');
    if (idx == -1) {
      return idx;
    }
    for (int i = idx; i < this.getText().length(); ++i) {
      if (this.getText().charAt(i) != '\r' && this.getText().charAt(i) != '\n') {
        if (this.getText().charAt(i) != ' ' && this.getText().charAt(i) != '\t') {
          return idx;
        }
      } else {
        idx = i;
      }
    }
    return idx;
  }

  public void processClosingTag() {
    ClosingHtmlTag tag = new ClosingHtmlTag(this.getText());

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(BaseProcessor.characterToStringSafe(this.getText().charAt(0))).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(StringUtils.substring(this.getText(), 1)).processSafe(builderContext);
      }
    } else {
      int stackSizeBefore = this.HtmlTextstack.size();
      this.builderContext = this.HtmlTextstack.closeTag(tag, this.builderContext, this);
      if ((stackSizeBefore > 0 && this.HtmlTextstack.isEmpty())) {
        this.endState();
        this.appendNewLines(tag);
      } else if (stackSizeBefore == this.HtmlTextstack.size()) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.getText().substring(this.getText().lastIndexOf('>') + 1)));
        }
      }
    }
  }

  public void processClosingTagNoMarkup() {
    ClosingHtmlTag tag = new ClosingHtmlTag(this.getText());

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
      return;
    }

    if (tag.isIgnoredTagWithIgnoredBody() && !(this.HtmlTextstack.isEmpty())) {
      this.builderContext = this.HtmlTextstack.closeTag(tag, this.builderContext, this, true);
      if (this.HtmlTextstack.isEmpty()) {
        this.endState();
      }
    }
    String t = this.getText();
    int idx = t.lastIndexOf(">") + 1;
    int stopIdx = t.length();
    char c = t.charAt(stopIdx - 1);
    for (int i = idx; i < stopIdx; ++i) {
      if (t.charAt(i) == ' ' || t.charAt(i) == '\n' || t.charAt(i) == '\t') {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(" ");
        }
        break;
      }
    }
  }

  public void processOpeningTag() {
    OpeningHtmlTag tag = new OpeningHtmlTag(this.getText(), this.HtmlTextattributeManufacture, this.HtmlTextadditionalHtmlStyleClass);

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(BaseProcessor.characterToStringSafe(this.getText().charAt(0))).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(StringUtils.substring(this.getText(), 1)).processSafe(builderContext);
      }
    } else {
      boolean stackWasEmpty = this.HtmlTextstack.isEmpty();
      if ((tag.isSingletonTag() || tag.getTagTitle().canBeUnclosed()) && tag.isValidTag()) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag.toString());
        }
        if (tag.getTagTitle().canBeUnclosed()) {
          this.HtmlTextstack.openTag(tag, this.builderContext);
        }
      } else if (!(tag.isSingletonTag())) {
        this.builderContext = this.HtmlTextstack.openTag(tag, this.builderContext);
      }

      if (stackWasEmpty && !(this.HtmlTextstack.isEmpty())) {
        this.beginState(this.HTML);
      }
    }
  }

  public void processOpeningTagNoMarkup() {
    OpeningHtmlTag tag = new OpeningHtmlTag(this.getText());

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else if (tag.isIgnoredTagWithIgnoredBody()) {
      boolean wasEmpty = this.HtmlTextstack.isEmpty();
      this.builderContext = this.HtmlTextstack.openTag(tag, this.builderContext);
      if (wasEmpty && !(this.HtmlTextstack.isEmpty())) {
        this.beginState(this.HTML);
      }
    }
  }

  public String getPicture() {
    String logo = ((ApplicationMetaDataImpl) DnqUtils.getPersistentClassInstance(((Entity) ServiceLocator.getBean("applicationMetaData")), "ApplicationMetaData")).getLogoUrl(((Entity) ServiceLocator.getBean("applicationMetaData")));
    int ind = logo.lastIndexOf('/');
    return "!" + logo.substring(ind + 1) + "!";
  }

  public void transformIssue() {
    Entity i = IssueImpl.fromId(this.getText());
    Entity contextUser = ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get();
    if (EntityOperations.equals(i, null) || EntityOperations.equals(contextUser, null) || !(((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).isAccessible(Operation.READ, contextUser, i))) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else {
      if (this.IssueLinkuseGlobalLinks) {
        try {
          BuilderThreadContext.initNonLocalBuilderThreadContext();
          this.appendIssueLink(i, contextUser, this.getText());
        } finally {
          BuilderThreadContext.close();
        }
      } else {
        this.appendIssueLink(i, contextUser, this.getText());
      }
    }
  }

  public void appendIssueLink(Entity i, Entity contextUser, String mentionedId) {
    LinkAppender.appendHrefForMobile(this.builderContext, this.IssueLinkmobile);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).getUrl(!(this.IssueLinkuseGlobalLinks), i) + "\"");
    }
    if (((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).isResolved(i)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" class=\"issue-resolved\"");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" target=\"_self\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" data-issue-id=\"" + ((Entity) i).getId().toString() + "\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" title=\"" + BaseHtmlStringUtil.html(PrimitiveAssociationSemantics.get(i, "summary", String.class, null)) + "\">" + mentionedId + "</a>");
    }
  }

  public void appendImage(boolean noMarkup) throws IOException {
    if (noMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(this.yytext(1, 1)).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
    } else {
      String[] result = this.yytext(1, 1).split("[|]");
      String name = null;
      int last = -1;
      if (result.length > 0) {
        last = result.length - 1;
        name = result[last];
      }

      if (EntityOperations.equals(this.IssueLinkissue, null) && this.getText().equals(this.getPicture())) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"><img src=\"");
          builderContext.append(((ApplicationMetaDataImpl) DnqUtils.getPersistentClassInstance(((Entity) ServiceLocator.getBean("applicationMetaData")), "ApplicationMetaData")).getLogoUrl(((Entity) ServiceLocator.getBean("applicationMetaData"))));
          builderContext.append("\"/></div>");
        }
        return;
      }

      Entity attach = this.getAttachment(name);

      if (EntityOperations.equals(attach, null)) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(this.yytext(1, 1)).processSafe(builderContext);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
      } else {
        String alt = null;
        String position = null;
        for (int i = 0; i < last; i++) {
          String value = result[i].trim();
          if (IssueLinkConst.POS.contains(value)) {
            position = value;
          } else {
            alt = value;
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"");
        }
        if (position != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" style=\"");
          }
          if (position.equals(IssueLinkConst.INLINE)) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("display:inline;");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html("align:"));
              builderContext.append(HtmlStringUtil.html(position));
              builderContext.append(HtmlStringUtil.html(";"));
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("><img src=\"");
          builderContext.append(((IssueAttachmentImpl) DnqUtils.getPersistentClassInstance(attach, "IssueAttachment")).getUrl(attach));
          builderContext.append("\"");
        }
        if (alt != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" alt=\"");
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(alt));
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("/></div>");
        }
      }
    }
  }

  private void fixForRTL(String str) {
    if (!(PrimitiveAssociationSemantics.get(((Entity) ServiceLocator.getBean("applicationMetaData")), "rtlEnabled", Boolean.class, null))) {
      return;
    }

    boolean flag = false;
    for (int i = 0; i < str.length(); ++i) {
      if (str.charAt(i) > '\u05BE') {
        flag = true;
      }
    }

    if (!(flag)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("&lrm;");
      }
    }
  }

  private void appendUsername() {
    Entity user = ((UserFilterService) ServiceLocator.getBean("userFilterService")).searchGreedyByLogin(StringUtils.substring(this.getText(), 1));

    int pushBackCount;
    if (!(EntityOperations.equals(user, null))) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<a href=\"");
      }
      if (this.IssueLinkfromWorkflow) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(((UserProfileService) ServiceLocator.getBean("userProfileService")).getAbsoluteProfileUrl(user));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(((UserProfileService) ServiceLocator.getBean("userProfileService")).getProfileUrl(user));
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\" title=\"");
        builderContext.append(PrimitiveAssociationSemantics.get(user, "login", String.class, "<no user>"));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\" data-user-id=\"");
        builderContext.append(((Entity) user).toIdString());
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      String displayedText = PrimitiveAssociationSemantics.get(user, "fullName", String.class, null);
      this.fixForRTL(displayedText);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(displayedText);
        builderContext.append("</a>");
      }
      pushBackCount = (this.getText().length() - 1 - PrimitiveAssociationSemantics.get(user, "login", String.class, "<no user>").length());
      ListSequence.fromList(this.IssueLinkmentionedUsers).addElement(user);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Character.toString(this.getText().charAt(0)));
      }
      pushBackCount = this.getText().length() - 1;
    }
    if (pushBackCount > 0) {
      this.yypushback(pushBackCount);
    }
  }

  public void appendAttachment(boolean removeMarkup) {
    String name = StringUtils.substring(this.getText(), 6, this.getText().length() - 1);
    Entity attach = this.getAttachment(name);
    if (!(EntityOperations.equals(attach, null))) {
      if (removeMarkup) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        if (this.IssueLinkfromWorkflow) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(UrlUtil.getRestPathUri("wikiattachment").addPathElements(((IssueImpl) DnqUtils.getPersistentClassInstance(this.IssueLinkissue, "Issue")).getId(this.IssueLinkissue), name).addQueryParameters(new QueryParameter("code", ((IssueAttachmentImpl) DnqUtils.getPersistentClassInstance(attach, "IssueAttachment")).getAccessCode(attach))).toString());
          }
        } else {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(UrlUtil.getPersistentFileUrl(attach, null, null, true));
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</a>");
        }
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.getText());
      }
    }
  }

  private Entity getAttachment(final String name) {
    Iterable<Entity> caseInsensitiveMatches = Sequence.fromIterable(IssueAttachmentImpl.applyPermissions(QueryOperations.query(AssociationSemantics.getToMany(this.IssueLinkissue, "attachments"), "IssueAttachment", new PropertyEqual("name", (String) (name))), ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get(), Operation.READ)).toListSequence();
    if (QueryOperations.isEmpty(caseInsensitiveMatches)) {
      Entity comment = QueryOperations.getFirst(QueryOperations.query(QueryOperations.query(null, "DraftComment", new LinkEqual("issue", this.IssueLinkissue)), "DraftComment", new LinkEqual("owner", ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get())));
      if (!(EntityOperations.equals(comment, null))) {
        caseInsensitiveMatches = Sequence.fromIterable(AssociationSemantics.getToMany(comment, "attachments")).where(new IWhereFilter<Entity>() {
          public boolean accept(Entity it) {
            return PrimitiveAssociationSemantics.get(it, "name", String.class, null).equalsIgnoreCase(name);
          }
        });
      }
    }
    if (QueryOperations.isEmpty(caseInsensitiveMatches)) {
      return null;
    }
    if (QueryOperations.getSize(caseInsensitiveMatches) == 1) {
      return QueryOperations.getFirst(caseInsensitiveMatches);
    }
    for (Entity attachment : caseInsensitiveMatches) {
      if (PrimitiveAssociationSemantics.get(attachment, "name", String.class, null).equals(name)) {
        return attachment;
      }
    }
    return QueryOperations.getFirst(caseInsensitiveMatches);
  }

  private void addGitHubLink(boolean skip) {
    final Wrappers._T<String> t = new Wrappers._T<String>();
    if (skip) {
      t.value = this.getText().substring(1);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(Character.toString(this.getText().charAt(0))));
      }
    } else {
      t.value = this.getText();
    }
    Iterable<WikiIssueLinkProvider> providers = ListSequence.fromList(((PluginHolder) ServiceLocator.getBean("wikiPluginHolder")).getIssueLinkProviders()).where(new IWhereFilter<WikiIssueLinkProvider>() {
      public boolean accept(WikiIssueLinkProvider it) {
        return it.canCreateLink(CharismaHtmlTextWikiProcessorMarkup.this.IssueLinkissue, t.value);
      }
    });
    if (Sequence.fromIterable(providers).isEmpty()) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t.value);
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Sequence.fromIterable(providers).first().createLink(this.IssueLinkissue, t.value));
      }
    }
  }

  public void appendQuery(boolean removeMarkup) {
    String query = this.yytext(7, 1);
    if (removeMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(query);
      }
    } else {
      LinkAppender.appendHrefForMobile(this.builderContext, this.QueryLinkmobile);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(UrlUtil.getHtmlTemplateUri("Issues", "folderId", new QueryParameter("q", query, ((TypeConvertManager) ServiceLocator.getBean("typeConvertManager")))));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(query));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</a>");
      }
    }
  }


  public static CharismaHtmlTextWikiProcessorMarkup create(String s) {
    CharismaHtmlTextWikiProcessorMarkup result;
    if (s == null) {
      Reader reader = null;
      result = new CharismaHtmlTextWikiProcessorMarkup(reader);
    } else {
      result = new CharismaHtmlTextWikiProcessorMarkup(new TrailingCharStringReader(s, '\r'));
    }
    return result;
  }
%}

%type Void

newLineTralling = ([ \t\n\r]*)
newLineLeading = ([ \t\n\r]*)
newLineTralling_old = ((([ ]*)([\n\r]+))*)
newLineLeading_old = ((([\n\r]+)([ ]*))*)
tagAttributes = (([\n\r\t ]+[^\>\<]*)?)
tagAttributes_old = (([ ]+[ =\"\'A-Za-z0-9\*-_.+():;\\\/]*)?)
all = ((.)|[\r\n])*
prefix = ([:jletterdigit:]+[:])?
separator = [ \t\,\;\.\:\"()\?#\^]
ussueStart = [#\^]
issue = [a-zA-Z0-9_]+ \- [0-9]+
hash = [a-fA-F0-9]{40}
space = [ \n\t]
attachment = "[file:"[^\]]+"]"
image = "!"[^!\n]+"!"
username = [@]([:jletterdigit:]|[\+\.\|\-\=\@]){1,32}
newline = \n
base64Symbol = ([:jletterdigit:]|[\+\/=])

%state HTML, HTML, HTML, HTML

%%

/* Tag */
<YYINITIAL> {
(\<{prefix}[a-zA-Z]+[1-6]*){tagAttributes}([\/]*)(\>) {
          try {
            this.processOpeningTag();
          } finally {
            this.text = null;
          }
}}
/* Tag */
<HTML> {
{newLineLeading}(\<{prefix}[a-zA-Z]+[1-6]*){tagAttributes}([\/]*)(\>) {
          try {
            this.processOpeningTag();
          } finally {
            this.text = null;
          }
}}
/* ClosingTag */
<YYINITIAL> {
"</"{prefix}([a-zA-Z]+)([1-6]*)([ \r\n\t]*)">" {
          try {
            this.processClosingTag();
          } finally {
            this.text = null;
          }
}}
/* ClosingTag */
<HTML> {
"</"{prefix}([a-zA-Z]+)([1-6]*)([ \r\n\t]*)">"{newLineTralling} {
          try {
            this.processClosingTag();
          } finally {
            this.text = null;
          }
}}
/* HtmlComment */
<YYINITIAL, HTML> {
"<!-"~"->"[ \r\n\t]* {
          try {
          } finally {
            this.text = null;
          }
}}
/* HtmlLink */
<HTML> {
null {
          try {
          } finally {
            this.text = null;
          }
}}
/* Doctype */
<YYINITIAL, HTML> {
"<!"([dD][oO][cC][tT][yY][pP][eE])~">"{newLineTralling} {
          try {
          } finally {
            this.text = null;
          }
}}
/* Eof */
<HTML> {
<<EOF>> {
          try {
            this.endState();
            this.builderContext = this.HtmlTextstack.closeAllTags(this.builderContext, this);
            return null;
          } finally {
            this.text = null;
          }
}}
/* EmptyHtml */
<HTML> {
"\r" {
          try {
          } finally {
            this.text = null;
          }
}}
/* TabHtml */
<HTML> {
"\t" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("\t");
            }
          } finally {
            this.text = null;
          }
}}
/* AmpHtml */
<HTML> {
"&" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&amp;");
            }
          } finally {
            this.text = null;
          }
}}
/* LtHtml */
<HTML> {
"<" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&lt;");
            }
          } finally {
            this.text = null;
          }
}}
/* GtHtml */
<HTML> {
">" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&gt;");
            }
          } finally {
            this.text = null;
          }
}}
/* DoubleQuoteHtml */
<HTML> {
[\"] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&quot;");
            }
          } finally {
            this.text = null;
          }
}}
/* SingleQuoteHtml */
<HTML> {
[\'] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&#39;");
            }
          } finally {
            this.text = null;
          }
}}
/* BreaklineHtml */
<HTML> {
"\n" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("\n");
            }
          } finally {
            this.text = null;
          }
}}
/* EscapeCharacterCode */
<HTML, YYINITIAL> {
&#[1-9][0-9]{1,3}; {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* EscapeCharacterHexCode */
<HTML, YYINITIAL> {
&#[xX][1-9a-fA-F][0-9a-fA-F]{1,3}; {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* EscapeCharacterCodeAliases */
<HTML, YYINITIAL> {
&[a-zA-Z][a-zA-Z0-9]+; {
          try {
            CommonWikiUtils.appendEscapeCodeAlias(this.getText(), builderContext, this);
          } finally {
            this.text = null;
          }
}}
/* MDash */
<YYINITIAL, HTML> {
[-]{3} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&mdash;");
            }
          } finally {
            this.text = null;
          }
}}
/* NDash */
<YYINITIAL, HTML> {
[-]{2} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&ndash;");
            }
          } finally {
            this.text = null;
          }
}}
/* HtmlIfStatement */
<HTML, YYINITIAL> {
"<!["[iI][fF][ \r\n\t]*[a-zA-Z0-9=!<>]*"]>" {
          try {
          } finally {
            this.text = null;
          }
}}
/* HtmlEndIfStatement */
<HTML, YYINITIAL> {
"<!["[eE][nN][dD][iI][fF]"]>" {
          try {
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue} {
          try {
            this.transformIssue();
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue}/([\.]?[:jletterdigit:]) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* issueAttachment */
<YYINITIAL> {
{attachment} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendAttachment(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendAttachment(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Image */
<YYINITIAL> {
{image} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendImage(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendImage(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Username */
<YYINITIAL, HTML> {
{username} {
          try {
            this.appendUsername();
          } finally {
            this.text = null;
          }
}}
/* UsernameCanNotBeInTheMiddle */
<YYINITIAL, HTML> {
[:jletterdigit:][@] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash0 */
<YYINITIAL, HTML> {
{separator}{hash} {
          try {
            this.addGitHubLink(true);
          } finally {
            this.text = null;
          }
}}
/* CommitHash1 */
<YYINITIAL, HTML> {
^{hash} {
          try {
            this.addGitHubLink(false);
          } finally {
            this.text = null;
          }
}}
/* Query */
<YYINITIAL, HTML> {
"[query:"~"]" {
          try {
            if (this.QueryLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendQuery(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendQuery(false);
            }
          } finally {
            this.text = null;
          }
}}
/* NewLineCount */
<YYINITIAL> {
{newline}+$ {
          try {
            this.NewLinesSimplenewLineCount += this.getText().length();
          } finally {
            this.text = null;
          }
}}
/* NewLineEnd */
<YYINITIAL> {
{newline}+/. {
          try {
            this.NewLinesSimplenewLineCount += this.getText().length();
            for (int i = 0; i < this.NewLinesSimplenewLineCount; i++) {
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(WikiUtil.newLine());
              }
            }
            this.NewLinesSimplenewLineCount = 0;
          } finally {
            this.text = null;
          }
}}
/* NewLineEofIgnore */
<YYINITIAL> {
({newline})+ {
          try {
            //  just ignore, newlines at the end of input are not appended
          } finally {
            this.text = null;
          }
}}
/* SkipedCharacters */
<YYINITIAL> {
[\u0000-\u0008\u000B-\u000C\u000E-\u001F] {
          try {
          } finally {
            this.text = null;
          }
}}
/* empty */
<YYINITIAL> {
\r {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("");
}}
/* tab */
<YYINITIAL> {
\t {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<span class=\"wiki tab\">&nbsp;&nbsp;&nbsp;&nbsp;</span>");
}}
/* Amp */
<YYINITIAL> {
"&" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&amp;");
}}
/* Lt */
<YYINITIAL> {
"<" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&lt;");
}}
/* Gt */
<YYINITIAL> {
">" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&gt;");
}}
/* DoubleQuote */
<YYINITIAL> {
\" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&quot;");
}}
/* SingleQuote */
<YYINITIAL> {
\' {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&#39;");
}}
/* breakline */
<YYINITIAL> {
\n {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
}}
/* LongString */
<YYINITIAL, HTML> {
{base64Symbol}{666}{base64Symbol}* {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* Finish */
<YYINITIAL, HTML, HTML, HTML, HTML> {
. {
          this.builderContext.append(BaseProcessor.characterToStringSafe(this.yycharat(0)));
}}
