package jetbrains.charisma.wiki;

/*Generated by MPS */

import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import jetbrains.exodus.entitystore.Entity;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import java.io.IOException;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import webr.framework.function.HtmlStringUtil;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.wiki.processor.runtime.LinkAppender;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.charisma.service.UserFilterService;
import jetbrains.charisma.service.UserProfileService;
import webr.framework.url.UrlUtil;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import java.io.Reader;
import jetbrains.mps.webr.wiki.processor.runtime.TrailingCharStringReader;
import jetbrains.mps.webr.wiki.processor.runtime.utils.CommonWikiUtils;

%%

%class IssueLinkProcessorMarkup
%extends BaseProcessor

%public 
%buffer 124
%final
%unicode

%{

  public boolean IssueLinkuseGlobalLinks = false;
  public Entity IssueLinkissue = null;
  public boolean IssueLinkmobile = false;
  public boolean IssueLinkfromWorkflow = false;
  public List<Entity> IssueLinkmentionedUsers = ListSequence.fromList(new ArrayList<Entity>());
  private int TextColorercolorSuffixKeyLength = "{color}".length();
  private int TextColorercolorPrefixKeyLength = "{color:".length();
  private boolean liveModePreview = false;

  public IWikiProcessor clone(String input) {
    IssueLinkProcessorMarkup cloned = create(input);
    cloned.IssueLinkuseGlobalLinks = this.IssueLinkuseGlobalLinks;
    cloned.IssueLinkissue = this.IssueLinkissue;
    cloned.IssueLinkmobile = this.IssueLinkmobile;
    cloned.IssueLinkfromWorkflow = this.IssueLinkfromWorkflow;
    cloned.IssueLinkmentionedUsers = this.IssueLinkmentionedUsers;
    return cloned;
  }

  protected void processInternal() throws IOException {
    if (this.wrapWithDiv) {
      this.builderContext.append(PROLOG);
    }
    this.yylex();
    this.finish();
    if (this.wrapWithDiv) {
      this.builderContext.append(EPILOG);
    }
  }

  protected void finish() {
  }

  protected boolean readerNotExists() {
    return this.zzReader == null;
  }

  private String yytext(int prefixLength, int suffixLength) {
    return new String(this.zzBuffer, this.zzStartRead + prefixLength, this.zzMarkedPos - this.zzStartRead - suffixLength - prefixLength);
  }

  public IssueLinkProcessorMarkup setIssueLinkuseGlobalLinks(boolean value) {
    this.IssueLinkuseGlobalLinks = value;
    return this;
  }

  public IssueLinkProcessorMarkup setIssueLinkissue(Entity value) {
    this.IssueLinkissue = value;
    return this;
  }

  public IssueLinkProcessorMarkup setIssueLinkmobile(boolean value) {
    this.IssueLinkmobile = value;
    return this;
  }

  public IssueLinkProcessorMarkup setIssueLinkfromWorkflow(boolean value) {
    this.IssueLinkfromWorkflow = value;
    return this;
  }

  public IssueLinkProcessorMarkup setIssueLinkmentionedUsers(List<Entity> value) {
    this.IssueLinkmentionedUsers = value;
    return this;
  }

  public IssueLinkProcessorMarkup setLivePreviewMode(boolean value) {
    return this;
  }

  public String getPicture() {
    String logo = ((ApplicationMetaDataImpl) DnqUtils.getPersistentClassInstance(((Entity) ServiceLocator.getBean("applicationMetaData")), "ApplicationMetaData")).getLogoUrl(((Entity) ServiceLocator.getBean("applicationMetaData")));
    int ind = logo.lastIndexOf('/');
    return "!" + logo.substring(ind + 1) + "!";
  }

  public void transformIssue() {
    Entity i = IssueImpl.fromId(this.getText());
    Entity contextUser = ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get();
    if (EntityOperations.equals(i, null) || EntityOperations.equals(contextUser, null) || !(((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).isAccessible(Operation.READ, contextUser, i))) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else {
      if (this.IssueLinkuseGlobalLinks) {
        try {
          BuilderThreadContext.initNonLocalBuilderThreadContext();
          this.appendIssueLink(i, contextUser, this.getText());
        } finally {
          BuilderThreadContext.close();
        }
      } else {
        this.appendIssueLink(i, contextUser, this.getText());
      }
    }
  }

  public void appendIssueLink(Entity i, Entity contextUser, String mentionedId) {
    LinkAppender.appendHrefForMobile(this.builderContext, this.IssueLinkmobile);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).getUrl(!(this.IssueLinkuseGlobalLinks), i) + "\"");
    }
    if (((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).isResolved(i)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" class=\"issue-resolved\"");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" target=\"_self\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" data-issue-id=\"" + ((Entity) i).getId().toString() + "\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" title=\"" + BaseHtmlStringUtil.html(PrimitiveAssociationSemantics.get(i, "summary", String.class, null)) + "\">" + mentionedId + "</a>");
    }
  }

  public void appendImage(boolean noMarkup) throws IOException {
    if (noMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(this.yytext(1, 1)).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
    } else {
      String[] result = this.yytext(1, 1).split("[|]");
      String name = null;
      int last = -1;
      if (result.length > 0) {
        last = result.length - 1;
        name = result[last];
      }

      if (EntityOperations.equals(this.IssueLinkissue, null) && this.getText().equals(this.getPicture())) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"><img src=\"");
          builderContext.append(((ApplicationMetaDataImpl) DnqUtils.getPersistentClassInstance(((Entity) ServiceLocator.getBean("applicationMetaData")), "ApplicationMetaData")).getLogoUrl(((Entity) ServiceLocator.getBean("applicationMetaData"))));
          builderContext.append("\"/></div>");
        }
        return;
      }

      Entity attach = this.getAttachment(name);

      if (EntityOperations.equals(attach, null)) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(this.yytext(1, 1)).processSafe(builderContext);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
      } else {
        String alt = null;
        String position = null;
        for (int i = 0; i < last; i++) {
          String value = result[i].trim();
          if (IssueLinkConst.POS.contains(value)) {
            position = value;
          } else {
            alt = value;
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"");
        }
        if (position != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" style=\"");
          }
          if (position.equals(IssueLinkConst.INLINE)) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("display:inline;");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html("align:"));
              builderContext.append(HtmlStringUtil.html(position));
              builderContext.append(HtmlStringUtil.html(";"));
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("><img src=\"");
          builderContext.append(((IssueAttachmentImpl) DnqUtils.getPersistentClassInstance(attach, "IssueAttachment")).getUrl(attach));
          builderContext.append("\"");
        }
        if (alt != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" alt=\"");
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(alt));
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("/></div>");
        }
      }
    }
  }

  private void fixForRTL(String str) {
    if (!(PrimitiveAssociationSemantics.get(((Entity) ServiceLocator.getBean("applicationMetaData")), "rtlEnabled", Boolean.class, null))) {
      return;
    }

    boolean flag = false;
    for (int i = 0; i < str.length(); ++i) {
      if (str.charAt(i) > '\u05BE') {
        flag = true;
      }
    }

    if (!(flag)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("&lrm;");
      }
    }
  }

  private void appendUsername() {
    Entity user = ((UserFilterService) ServiceLocator.getBean("userFilterService")).searchGreedyByLogin(StringUtils.substring(this.getText(), 1));

    int pushBackCount;
    if (!(EntityOperations.equals(user, null))) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<a href=\"");
      }
      if (this.IssueLinkfromWorkflow) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(((UserProfileService) ServiceLocator.getBean("userProfileService")).getAbsoluteProfileUrl(user));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(((UserProfileService) ServiceLocator.getBean("userProfileService")).getProfileUrl(user));
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\" title=\"");
        builderContext.append(PrimitiveAssociationSemantics.get(user, "login", String.class, "<no user>"));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\" data-user-id=\"");
        builderContext.append(((Entity) user).toIdString());
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      String displayedText = PrimitiveAssociationSemantics.get(user, "fullName", String.class, null);
      this.fixForRTL(displayedText);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(displayedText);
        builderContext.append("</a>");
      }
      pushBackCount = (this.getText().length() - 1 - PrimitiveAssociationSemantics.get(user, "login", String.class, "<no user>").length());
      ListSequence.fromList(this.IssueLinkmentionedUsers).addElement(user);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Character.toString(this.getText().charAt(0)));
      }
      pushBackCount = this.getText().length() - 1;
    }
    if (pushBackCount > 0) {
      this.yypushback(pushBackCount);
    }
  }

  public void appendAttachment(boolean removeMarkup) {
    String name = StringUtils.substring(this.getText(), 6, this.getText().length() - 1);
    Entity attach = this.getAttachment(name);
    if (!(EntityOperations.equals(attach, null))) {
      if (removeMarkup) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        if (this.IssueLinkfromWorkflow) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(UrlUtil.getRestPathUri("wikiattachment").addPathElements(((IssueImpl) DnqUtils.getPersistentClassInstance(this.IssueLinkissue, "Issue")).getId(this.IssueLinkissue), name).addQueryParameters(new QueryParameter("code", ((IssueAttachmentImpl) DnqUtils.getPersistentClassInstance(attach, "IssueAttachment")).getAccessCode(attach))).toString());
          }
        } else {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(UrlUtil.getPersistentFileUrl(attach, null, null, true));
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</a>");
        }
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.getText());
      }
    }
  }

  private Entity getAttachment(final String name) {
    Iterable<Entity> caseInsensitiveMatches = Sequence.fromIterable(IssueAttachmentImpl.applyPermissions(QueryOperations.query(AssociationSemantics.getToMany(this.IssueLinkissue, "attachments"), "IssueAttachment", new PropertyEqual("name", (String) (name))), ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get(), Operation.READ)).toListSequence();
    if (QueryOperations.isEmpty(caseInsensitiveMatches)) {
      Entity comment = QueryOperations.getFirst(QueryOperations.query(QueryOperations.query(null, "DraftComment", new LinkEqual("issue", this.IssueLinkissue)), "DraftComment", new LinkEqual("owner", ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get())));
      if (!(EntityOperations.equals(comment, null))) {
        caseInsensitiveMatches = Sequence.fromIterable(AssociationSemantics.getToMany(comment, "attachments")).where(new IWhereFilter<Entity>() {
          public boolean accept(Entity it) {
            return PrimitiveAssociationSemantics.get(it, "name", String.class, null).equalsIgnoreCase(name);
          }
        });
      }
    }
    if (QueryOperations.isEmpty(caseInsensitiveMatches)) {
      return null;
    }
    if (QueryOperations.getSize(caseInsensitiveMatches) == 1) {
      return QueryOperations.getFirst(caseInsensitiveMatches);
    }
    for (Entity attachment : caseInsensitiveMatches) {
      if (PrimitiveAssociationSemantics.get(attachment, "name", String.class, null).equals(name)) {
        return attachment;
      }
    }
    return QueryOperations.getFirst(caseInsensitiveMatches);
  }

  private void addGitHubLink(boolean skip) {
    final Wrappers._T<String> t = new Wrappers._T<String>();
    if (skip) {
      t.value = this.getText().substring(1);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(Character.toString(this.getText().charAt(0))));
      }
    } else {
      t.value = this.getText();
    }
    Iterable<WikiIssueLinkProvider> providers = ListSequence.fromList(((PluginHolder) ServiceLocator.getBean("wikiPluginHolder")).getIssueLinkProviders()).where(new IWhereFilter<WikiIssueLinkProvider>() {
      public boolean accept(WikiIssueLinkProvider it) {
        return it.canCreateLink(IssueLinkProcessorMarkup.this.IssueLinkissue, t.value);
      }
    });
    if (Sequence.fromIterable(providers).isEmpty()) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t.value);
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Sequence.fromIterable(providers).first().createLink(this.IssueLinkissue, t.value));
      }
    }
  }

  public final void appendBlank(char a) {
    switch (a) {
      case '\n':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
        }
        break;
      case '\t':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\t");
        }
        break;
      case ' ':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(" ");
        }
        break;
      default:
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("" + a);
        }
    }
  }

  public final void appendBlank(String s) {
    for (int i = 0; i < s.length(); i++) {
      this.appendBlank(s.charAt(i));
    }
  }

  public void appendTitledText() {
    int contentEnds = this.getText().lastIndexOf('|');
    String title = StringUtils.substring(this.getText(), contentEnds + 1, this.getText().length() - 2).trim();
    String content = StringUtils.substring(this.getText(), 2, contentEnds);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<span title=\"");
      builderContext.append(title.trim());
      builderContext.append("\">");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      this.clone(content).processSafe(builderContext);
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</span>");
    }
  }

  public void removeFramingMarkup(String symbol, String tag, boolean addHtml) {
    int indexOfSymbol = this.getText().indexOf(symbol);
    int indexOfLastSymbol = this.getText().lastIndexOf(symbol);
    this.appendBlank(StringUtils.substring(this.getText(), 0, indexOfSymbol));
    int delemiterIdx = indexOfSymbol + 1;
    String[] strings = StringUtils.substring(this.getText(), indexOfSymbol + 1, indexOfLastSymbol).split('\\' + symbol + "[ \t\r\n]" + '\\' + symbol);
    for (String str : strings) {
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(str).processSafe(builderContext);
      }
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      delemiterIdx += str.length() + symbol.length();
      if (str != strings[strings.length - 1]) {
        this.appendBlank(this.getText().charAt(delemiterIdx));
        delemiterIdx += symbol.length() + 1;
      }
    }
    this.appendBlank((this.getText().charAt(this.getText().length() - 1) == '\r' ?
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1, this.getText().length() - 2) :
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1)
    ));
  }


  public static IssueLinkProcessorMarkup create(String s) {
    IssueLinkProcessorMarkup result;
    if (s == null) {
      Reader reader = null;
      result = new IssueLinkProcessorMarkup(reader);
    } else {
      result = new IssueLinkProcessorMarkup(new TrailingCharStringReader(s, '\r'));
    }
    return result;
  }
%}

%type Void

separator = [ \t\,\;\.\:\"()\?#\^]
ussueStart = [#\^]
issue = [a-zA-Z0-9_]+ \- [0-9]+
hash = [a-fA-F0-9]{40}
space = [ \n\t]
attachment = "[file:"[^\]]+"]"
image = "!"[^!\n]+"!"
username = [@]([:jletterdigit:]|[\+\.\|\-\=\@]){1,32}
color = ([a-zA-Z]+)|("#"[0-9a-fA-F]{6})
nonEmptyWord = [^ \t\n\r-]
baseUnderlineRegexp = [ \t\n\r]\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)
baseAsteriskRegexp = [ \t\n\r]\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)
nonWordSymbol = [ \r\n\t\/\[\]\(\)\`\"-_.!\*$&+/:;=?@#%{}|\^~`',]

%state HTML

%%

/* Issue */
<YYINITIAL, HTML> {
{issue} {
          try {
            this.transformIssue();
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue}/([\.]?[:jletterdigit:]) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* issueAttachment */
<YYINITIAL> {
{attachment} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendAttachment(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendAttachment(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Image */
<YYINITIAL> {
{image} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendImage(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendImage(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Username */
<YYINITIAL, HTML> {
{username} {
          try {
            this.appendUsername();
          } finally {
            this.text = null;
          }
}}
/* UsernameCanNotBeInTheMiddle */
<YYINITIAL, HTML> {
[:jletterdigit:][@] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash0 */
<YYINITIAL, HTML> {
{separator}{hash} {
          try {
            this.addGitHubLink(true);
          } finally {
            this.text = null;
          }
}}
/* CommitHash1 */
<YYINITIAL, HTML> {
^{hash} {
          try {
            this.addGitHubLink(false);
          } finally {
            this.text = null;
          }
}}
/* SkipedCharacters */
<YYINITIAL> {
[\u0000-\u0008\u000B-\u000C\u000E-\u001F] {
          try {
          } finally {
            this.text = null;
          }
}}
/* empty */
<YYINITIAL> {
\r {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("");
}}
/* tab */
<YYINITIAL> {
\t {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<span class=\"wiki tab\">&nbsp;&nbsp;&nbsp;&nbsp;</span>");
}}
/* Amp */
<YYINITIAL> {
"&" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&amp;");
}}
/* Lt */
<YYINITIAL> {
"<" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&lt;");
}}
/* Gt */
<YYINITIAL> {
">" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&gt;");
}}
/* DoubleQuote */
<YYINITIAL> {
\" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&quot;");
}}
/* SingleQuote */
<YYINITIAL> {
\' {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&#39;");
}}
/* breakline */
<YYINITIAL> {
\n {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
}}
/* Coloring */
<YYINITIAL> {
"{color:"{color}"}"~"{color}" {
          try {
            int beg = this.getText().indexOf('}');
            String textToColor = CommonWikiUtils.valuableSubstring(this.getText(), beg + 1, this.getText().length() - this.TextColorercolorSuffixKeyLength);
            if ((textToColor != null && textToColor.length() > 0)) {
              String color = this.getText().substring(this.TextColorercolorPrefixKeyLength, beg);
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("<font color=\"");
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(color);
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("\">");
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                this.clone(textToColor).processSafe(builderContext);
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("</font>");
              }
            }
          } finally {
            this.text = null;
          }
}}
/* H4 */
<YYINITIAL> {
^"===="~"===="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h4>");
          this.clone(this.yytext(4, 5)).process(builderContext);
          builderContext.append("</h4>");
}}
/* H3 */
<YYINITIAL> {
^"==="~"==="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h3>");
          this.clone(this.yytext(3, 4)).process(builderContext);
          builderContext.append("</h3>");
}}
/* H2 */
<YYINITIAL> {
^"=="~"=="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h2>");
          this.clone(this.yytext(2, 3)).process(builderContext);
          builderContext.append("</h2>");
}}
/* H1 */
<YYINITIAL> {
^"="~"="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h1>");
          this.clone(this.yytext(1, 2)).process(builderContext);
          builderContext.append("</h1>");
}}
/* BoldItalic */
<YYINITIAL> {
"'''''"~"'''''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<strong><em>");
          this.clone(this.yytext(5, 5)).process(builderContext);
          builderContext.append("</em></strong>");
}}
/* Bold */
<YYINITIAL> {
"'''"~"'''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<strong>");
          this.clone(this.yytext(3, 3)).process(builderContext);
          builderContext.append("</strong>");
}}
/* Italic */
<YYINITIAL> {
"''"~"''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<em>");
          this.clone(this.yytext(2, 2)).process(builderContext);
          builderContext.append("</em>");
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<del>");
            }
            String out = "" + this.getText().charAt(2);
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(BaseHtmlStringUtil.html(out)).processSafe(builderContext);
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("</del>");
            }
          } finally {
            this.text = null;
          }
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]([^\n\r-]|([-][^-]))*[-]?[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<del>");
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(this.yytext(2, 2)).processSafe(builderContext);
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("</del>");
            }
          } finally {
            this.text = null;
          }
}}
/* Line */
<YYINITIAL> {
("-"){5}("-")*(" "*[\r\n])? {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<hr/>");
            }
          } finally {
            this.text = null;
          }
}}
/* TitledText */
<YYINITIAL> {
\~\~~\|~(\~\~) {
          try {
            this.appendTitledText();
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
{baseUnderlineRegexp}({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", true);
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
^\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", true);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
{baseAsteriskRegexp}({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", true);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
^\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", true);
          } finally {
            this.text = null;
          }
}}
/* EscapeSymbol */
<YYINITIAL> {
"\\"[+*_\-`{}\[\]\(\)#\.\!] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(1, 0));
            }
          } finally {
            this.text = null;
          }
}}
/* Finish */
<YYINITIAL, HTML> {
. {
          this.builderContext.append(BaseProcessor.characterToStringSafe(this.yycharat(0)));
}}
