(function (root, factory) {
  if (typeof define === 'function' && define.amd) {
    //Allow using this built library as an AMD module
    //in another project. That other project will only
    //see this AMD call, not the internal modules in
    //the closure below.
    define(factory);
  } else {
    //Browser globals case. Just assign the
    //result to a property on the global.
    root.ring = factory();
  }
}(this, function () {
/**
 * @license almond 0.2.9 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */
//Going sloppy to avoid 'use strict' string cost, but strict practices should
//be followed.
/*jslint sloppy: true */
/*global setTimeout: false */

var requirejs, require, define;
(function (undef) {
    var main, req, makeMap, handlers,
        defined = {},
        waiting = {},
        config = {},
        defining = {},
        hasOwn = Object.prototype.hasOwnProperty,
        aps = [].slice,
        jsSuffixRegExp = /\.js$/;

    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }

    /**
     * Given a relative module name, like ./something, normalize it to
     * a real name that can be mapped to a path.
     * @param {String} name the relative name
     * @param {String} baseName a real name that the name arg is relative
     * to.
     * @returns {String} normalized name
     */
    function normalize(name, baseName) {
        var nameParts, nameSegment, mapValue, foundMap, lastIndex,
            foundI, foundStarMap, starI, i, j, part,
            baseParts = baseName && baseName.split("/"),
            map = config.map,
            starMap = (map && map['*']) || {};

        //Adjust any relative paths.
        if (name && name.charAt(0) === ".") {
            //If have a base name, try to normalize against it,
            //otherwise, assume it is a top-level require that will
            //be relative to baseUrl in the end.
            if (baseName) {
                //Convert baseName to array, and lop off the last part,
                //so that . matches that "directory" and not name of the baseName's
                //module. For instance, baseName of "one/two/three", maps to
                //"one/two/three.js", but we want the directory, "one/two" for
                //this normalization.
                baseParts = baseParts.slice(0, baseParts.length - 1);
                name = name.split('/');
                lastIndex = name.length - 1;

                // Node .js allowance:
                if (config.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {
                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');
                }

                name = baseParts.concat(name);

                //start trimDots
                for (i = 0; i < name.length; i += 1) {
                    part = name[i];
                    if (part === ".") {
                        name.splice(i, 1);
                        i -= 1;
                    } else if (part === "..") {
                        if (i === 1 && (name[2] === '..' || name[0] === '..')) {
                            //End of the line. Keep at least one non-dot
                            //path segment at the front so it can be mapped
                            //correctly to disk. Otherwise, there is likely
                            //no path mapping for a path starting with '..'.
                            //This can still fail, but catches the most reasonable
                            //uses of ..
                            break;
                        } else if (i > 0) {
                            name.splice(i - 1, 2);
                            i -= 2;
                        }
                    }
                }
                //end trimDots

                name = name.join("/");
            } else if (name.indexOf('./') === 0) {
                // No baseName, so this is ID is resolved relative
                // to baseUrl, pull off the leading dot.
                name = name.substring(2);
            }
        }

        //Apply map config if available.
        if ((baseParts || starMap) && map) {
            nameParts = name.split('/');

            for (i = nameParts.length; i > 0; i -= 1) {
                nameSegment = nameParts.slice(0, i).join("/");

                if (baseParts) {
                    //Find the longest baseName segment match in the config.
                    //So, do joins on the biggest to smallest lengths of baseParts.
                    for (j = baseParts.length; j > 0; j -= 1) {
                        mapValue = map[baseParts.slice(0, j).join('/')];

                        //baseName segment has  config, find if it has one for
                        //this name.
                        if (mapValue) {
                            mapValue = mapValue[nameSegment];
                            if (mapValue) {
                                //Match, update name to the new value.
                                foundMap = mapValue;
                                foundI = i;
                                break;
                            }
                        }
                    }
                }

                if (foundMap) {
                    break;
                }

                //Check for a star map match, but just hold on to it,
                //if there is a shorter segment match later in a matching
                //config, then favor over this star map.
                if (!foundStarMap && starMap && starMap[nameSegment]) {
                    foundStarMap = starMap[nameSegment];
                    starI = i;
                }
            }

            if (!foundMap && foundStarMap) {
                foundMap = foundStarMap;
                foundI = starI;
            }

            if (foundMap) {
                nameParts.splice(0, foundI, foundMap);
                name = nameParts.join('/');
            }
        }

        return name;
    }

    function makeRequire(relName, forceSync) {
        return function () {
            //A version of a require function that passes a moduleName
            //value for items that may need to
            //look up paths relative to the moduleName
            return req.apply(undef, aps.call(arguments, 0).concat([relName, forceSync]));
        };
    }

    function makeNormalize(relName) {
        return function (name) {
            return normalize(name, relName);
        };
    }

    function makeLoad(depName) {
        return function (value) {
            defined[depName] = value;
        };
    }

    function callDep(name) {
        if (hasProp(waiting, name)) {
            var args = waiting[name];
            delete waiting[name];
            defining[name] = true;
            main.apply(undef, args);
        }

        if (!hasProp(defined, name) && !hasProp(defining, name)) {
            throw new Error('No ' + name);
        }
        return defined[name];
    }

    //Turns a plugin!resource to [plugin, resource]
    //with the plugin being undefined if the name
    //did not have a plugin prefix.
    function splitPrefix(name) {
        var prefix,
            index = name ? name.indexOf('!') : -1;
        if (index > -1) {
            prefix = name.substring(0, index);
            name = name.substring(index + 1, name.length);
        }
        return [prefix, name];
    }

    /**
     * Makes a name map, normalizing the name, and using a plugin
     * for normalization if necessary. Grabs a ref to plugin
     * too, as an optimization.
     */
    makeMap = function (name, relName) {
        var plugin,
            parts = splitPrefix(name),
            prefix = parts[0];

        name = parts[1];

        if (prefix) {
            prefix = normalize(prefix, relName);
            plugin = callDep(prefix);
        }

        //Normalize according
        if (prefix) {
            if (plugin && plugin.normalize) {
                name = plugin.normalize(name, makeNormalize(relName));
            } else {
                name = normalize(name, relName);
            }
        } else {
            name = normalize(name, relName);
            parts = splitPrefix(name);
            prefix = parts[0];
            name = parts[1];
            if (prefix) {
                plugin = callDep(prefix);
            }
        }

        //Using ridiculous property names for space reasons
        return {
            f: prefix ? prefix + '!' + name : name, //fullName
            n: name,
            pr: prefix,
            p: plugin
        };
    };

    function makeConfig(name) {
        return function () {
            return (config && config.config && config.config[name]) || {};
        };
    }

    handlers = {
        require: function (name) {
            return makeRequire(name);
        },
        exports: function (name) {
            var e = defined[name];
            if (typeof e !== 'undefined') {
                return e;
            } else {
                return (defined[name] = {});
            }
        },
        module: function (name) {
            return {
                id: name,
                uri: '',
                exports: defined[name],
                config: makeConfig(name)
            };
        }
    };

    main = function (name, deps, callback, relName) {
        var cjsModule, depName, ret, map, i,
            args = [],
            callbackType = typeof callback,
            usingExports;

        //Use name if no relName
        relName = relName || name;

        //Call the callback to define the module, if necessary.
        if (callbackType === 'undefined' || callbackType === 'function') {
            //Pull out the defined dependencies and pass the ordered
            //values to the callback.
            //Default to [require, exports, module] if no deps
            deps = !deps.length && callback.length ? ['require', 'exports', 'module'] : deps;
            for (i = 0; i < deps.length; i += 1) {
                map = makeMap(deps[i], relName);
                depName = map.f;

                //Fast path CommonJS standard dependencies.
                if (depName === "require") {
                    args[i] = handlers.require(name);
                } else if (depName === "exports") {
                    //CommonJS module spec 1.1
                    args[i] = handlers.exports(name);
                    usingExports = true;
                } else if (depName === "module") {
                    //CommonJS module spec 1.1
                    cjsModule = args[i] = handlers.module(name);
                } else if (hasProp(defined, depName) ||
                           hasProp(waiting, depName) ||
                           hasProp(defining, depName)) {
                    args[i] = callDep(depName);
                } else if (map.p) {
                    map.p.load(map.n, makeRequire(relName, true), makeLoad(depName), {});
                    args[i] = defined[depName];
                } else {
                    throw new Error(name + ' missing ' + depName);
                }
            }

            ret = callback ? callback.apply(defined[name], args) : undefined;

            if (name) {
                //If setting exports via "module" is in play,
                //favor that over return value and exports. After that,
                //favor a non-undefined return value over exports use.
                if (cjsModule && cjsModule.exports !== undef &&
                        cjsModule.exports !== defined[name]) {
                    defined[name] = cjsModule.exports;
                } else if (ret !== undef || !usingExports) {
                    //Use the return value from the function.
                    defined[name] = ret;
                }
            }
        } else if (name) {
            //May just be an object definition for the module. Only
            //worry about defining if have a module name.
            defined[name] = callback;
        }
    };

    requirejs = require = req = function (deps, callback, relName, forceSync, alt) {
        if (typeof deps === "string") {
            if (handlers[deps]) {
                //callback in this case is really relName
                return handlers[deps](callback);
            }
            //Just return the module wanted. In this scenario, the
            //deps arg is the module name, and second arg (if passed)
            //is just the relName.
            //Normalize module name, if it contains . or ..
            return callDep(makeMap(deps, callback).f);
        } else if (!deps.splice) {
            //deps is a config object, not an array.
            config = deps;
            if (config.deps) {
                req(config.deps, config.callback);
            }
            if (!callback) {
                return;
            }

            if (callback.splice) {
                //callback is an array, which means it is a dependency list.
                //Adjust args if there are dependencies
                deps = callback;
                callback = relName;
                relName = null;
            } else {
                deps = undef;
            }
        }

        //Support require(['a'])
        callback = callback || function () {};

        //If relName is a function, it is an errback handler,
        //so remove it.
        if (typeof relName === 'function') {
            relName = forceSync;
            forceSync = alt;
        }

        //Simulate async callback;
        if (forceSync) {
            main(undef, deps, callback, relName);
        } else {
            //Using a non-zero value because of concern for what old browsers
            //do, and latest browsers "upgrade" to 4 if lower value is used:
            //http://www.whatwg.org/specs/web-apps/current-work/multipage/timers.html#dom-windowtimers-settimeout:
            //If want a value immediately, use require('id') instead -- something
            //that works in almond on the global level, but not guaranteed and
            //unlikely to work in other AMD implementations.
            setTimeout(function () {
                main(undef, deps, callback, relName);
            }, 4);
        }

        return req;
    };

    /**
     * Just drops the config on the floor, but returns req in case
     * the config return value is used.
     */
    req.config = function (cfg) {
        return req(cfg);
    };

    /**
     * Expose module registry for debugging and tooling
     */
    requirejs._defined = defined;

    define = function (name, deps, callback) {

        //This module may not have dependencies
        if (!deps.splice) {
            //deps is not an array, so probably means
            //an object literal or factory function for
            //the value. Adjust args.
            callback = deps;
            deps = [];
        }

        if (!hasProp(defined, name) && !hasProp(waiting, name)) {
            waiting[name] = [name, deps, callback];
        }
    };

    define.amd = {
        jQuery: true
    };
}());

define("../components/almond/almond", function(){});

define('jquery',[],function () {
  return jQuery;
});
define('global/global__events',['jquery'], function($) {
  

  // Event constructor
  var uid = 1;
  var events = {
    EVENTS_DELIM: ' ',
    NAMESPACE_DELIM: '::',
    MODULE_DELIM: ':',
    EVENT_SELECTOR: '.ring-js-event',
    EVENT_DATA_ATTR: 'ring-event',
    DEFAULT_EVENT: 'click'
  };


  var parseSignature = function(signature, module, handler, one) {
    if (typeof signature !== 'string') {
      return false;
    }

    var eventsList = $.map(signature.split(events.EVENTS_DELIM), function(eventSignature) {
      var event = {};

      if (!module.global) {
        eventSignature = module.name + events.MODULE_DELIM + eventSignature;
      }

      var parts = eventSignature.split(events.NAMESPACE_DELIM);

      event.name = parts[0];
      event.namespace = parts[1] || null;
      event.uid = uid++;

      if (handler) {
        event.handler = one ? runAndRemove(event, handler) : handler;
      }

      return event;
    });

    return eventsList;
  };


  // Internal methods
  var cache = {};

  var add = function(eventsList) {
    if (!eventsList[0]) {
      return false;
    }

    for (var event, i = eventsList.length - 1; i >= 0; i--) {
      event = eventsList[i];

      if (!cache[event.name]) {
        cache[event.name] = [];
      }

      cache[event.name].push(event);
    }

    return true;
  };

  var remove = function(event, useUid) {
    var ret = false;
    var paramName = useUid ? 'uid' : 'namespace';
    var param = event[paramName];
    var subscriptions = cache[event.name];

    if (param) {
      for (var i = subscriptions.length - 1; i >= 0; i--) {
        if (subscriptions[i][paramName] === param) {
          subscriptions.splice(i, 1);
          ret = true;
        }
      }

      if (!subscriptions.length) {
        delete cache[event.name];
      }
    } else {
      ret = delete cache[event.name];
    }

    return ret;
  };

  var runAndRemove = function(event, handler) {
    return function(data) {
      remove(event, true);
      handler(data);
    };
  };

  // Public
  var methods = {};

  methods.on = function(scope, signature, handler, one) {
    if (typeof handler !== 'function') {
      return false;
    } else {
      return add(parseSignature(signature, scope, handler, one));
    }
  };

  methods.one = function(scope, signature, handler) {
    return this.on(signature, handler, true);
  };

  methods.off = function(scope, signature) {
    var ret = false;
    var eventsList = parseSignature(signature, scope);

    for (var event, i = eventsList.length - 1; i >= 0; i--) {
      event = eventsList[i];

      if (cache[event.name]) {
        ret = remove(event, false);
      }
    }

    return ret;
  };

  methods.when = function(scope, signature) {
    var dfd = $.Deferred();

    this.on(signature, $.proxy(dfd, 'resolve'), true);

    return dfd;
  };

  methods.trigger = function(scope, signature, data, e) {
    var ret = true;
    var event = parseSignature(signature, scope)[0];
    var subscriptions = cache[event.name];

    if (subscriptions) {
      for (var i = subscriptions.length; i--; i > 0) {
        ret = subscriptions[i].handler(data, e);
      }
    }

    return ret;
  };

  methods.stateTrigger = function(scope, method, state) {
    var signature = method + events.MODULE_DELIM + state;
    var trigger = this.trigger;

    return function(result) {
      trigger(signature, result);
    };
  };

  var eventsMap = {
    'mouseenter': 'hover',
    'mouseleave': 'hover'
  };

  // Events from DOM
  var domEventHandler = function(e) {
    var $target = $(e.currentTarget);
    var type = eventsMap[e.type] || e.type || events.DEFAULT_EVENT;
    var storedEvents = $target.data(events.EVENT_DATA_ATTR);

    var fire = function(event) {
      if (event && (!event.type && type === events.DEFAULT_EVENT || event.type === type)) {
        return methods.trigger({global: true}, event.name || event, event.data, e);
      }
    };

    if ($.isArray(storedEvents)) {
      return $.map(storedEvents, fire).pop();
    } else {
      return fire(storedEvents);
    }
  };

  // Using delegate because of compatibility with YouTrack's jQuery 1.5.1
  $(document).delegate(events.EVENT_SELECTOR, 'click.ring-event', domEventHandler);

  events.methods = methods;
  events.domEventHandler = domEventHandler;

  return events;
});

define('global/global__utils',['jquery'], function($) {
  

  // Utils
  var utils = {};

  // Ported from Chai as Promised
  utils.isDeferred = function(obj) {
    return obj != null &&
      typeof obj.always === 'function' &&
      typeof obj.done === 'function' &&
      typeof obj.fail === 'function' &&
      typeof obj.pipe === 'function' &&
      typeof obj.progress === 'function' &&
      typeof obj.state === 'function';
  };

  utils.isPromise = function(obj) {
    return obj != null && typeof obj.then === 'function';
  };

  utils.wrapPromise = function(obj) {
    if (utils.isPromise(obj) && !utils.isDeferred(obj)) {
      var dfd = $.Deferred();

      obj.then(function(result) {
        dfd.resolve(result);
      }, function(error) {
        dfd.reject(error);
      });

      return dfd.promise();
    }

    return $.when(obj);
  };

  utils.isNode = function(obj) {
    return typeof Node === 'object' ? obj instanceof Node : obj && typeof obj === 'object' && typeof obj.nodeType === 'number';
  };

  utils.isEmptyString = function(str) {
    return str.replace(/\s+/, '') === '';
  };

  // Ported from jQuery to support contentEditable
  utils.isFocused = function(elem) {
    elem = elem[0] || elem;

    return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex || elem.contentEditable === 'true');
  };

  utils.throttle = function(fn, threshhold, scope) {
    var last,
      deferTimer;
    threshhold = threshhold || 250;

    return function () {
      var context = scope || this;

      var now = +new Date(),
        args = arguments;
      if (last && now < last + threshhold) {
        clearTimeout(deferTimer);
        deferTimer = setTimeout(function () {
          last = now;
          fn.apply(context, args);
        }, threshhold);
      } else {
        last = now;
        fn.apply(context, args);
      }
    };
  };

  utils.uuid = function () {
    var d = new Date().getTime(),
        uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
          var r = (d + Math.random()*16)%16 | 0;
          d = Math.floor(d/16);
          return (c==='x' ? r : (r&0x7|0x8)).toString(16);
        });
    return uuid;
  };

  return utils;
});
define('global/global__modules',['jquery', 'global/global__events', 'global/global__utils'], function ($, events, utils) {
  

  // Function.prototype.bind polyfill
  // TODO include as component
  if (!Function.prototype.bind || Function.prototype.bind.toString().indexOf('[native code]') === -1) {
    Function.prototype.bind = function (oThis) {
      if (typeof this !== 'function') {
        // closest thing possible to the ECMAScript 5 internal IsCallable function
        throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');
      }

      var aArgs = Array.prototype.slice.call(arguments, 1),
        fToBind = this,
        Noop = function () {
      },
        fBound = function () {
          return fToBind.apply(this instanceof Noop && oThis ? this : oThis,
            aArgs.concat(Array.prototype.slice.call(arguments)));
        };

      Noop.prototype = this.prototype;
      fBound.prototype = new Noop();

      return fBound;
    };
  }

  var modules = {};
  var methodsList = [];

  var Module = function (props, name) {
    var scope = {
      methods: {},
      properties: {},
      global: name === Module.GLOBAL,
      name: name
    };

    // Setup API defined module methods
    this.set(scope, props);

    for (var i = methodsList.length, method; i--; i > 0) {
      method = methodsList[i];
      // Encapsulate scope in base methods
      this[method] = this[method].bind(this, scope);
      // Pretend invoke is module itself
      this.invoke[method] = this[method];
    }
  };

  // Mixin events
  $.extend(Module.prototype, events.methods);

  // Instance
  Module.prototype.invoke = function (scope, name) {
    var dfd, ret, action;

    var method = this.get(name);
    var func = method.method || method;
    var override = !!method.override;

    if (typeof func === 'function') {
      ret = func.apply(null, Array.prototype.slice.call(arguments, 2));
      action = 'resolve';
    } else {
      ret = null;
      action = 'reject';
    }

    if (utils.isDeferred(ret)) {
      dfd = ret;
      action = null;
    } else {
      dfd = $.Deferred();
    }

    this.trigger(name);

    dfd
      .done(this.stateTrigger(name, 'done'))
      .fail(this.stateTrigger(name, 'fail'));

    if (typeof dfd.always === 'function') {
      dfd.always(this.stateTrigger(name, 'always'));
    }

    if (action) {
      dfd[action](ret);
    }

    return override ? ret : dfd.promise();
  };

  Module.prototype.set = function (scope, props) {
    var field;
    var methods = scope.methods;
    var properties = scope.properties;

    for (var name in props) {
      field = props[name];
      if (typeof field === 'function' || typeof field.method === 'function') {
        methods[name] = field;
      } else {
        properties[name] = field;
      }
    }

    return true;
  };

  Module.prototype.update = function (scope, name) {
    var part, path, data, newData, pathParts;
    var props = this.get(name);
    var args = Array.prototype.slice.call(arguments, 2);

    if (props) {
      var extenders = [true, props];

      while (args.length) {
        path = args[0];
        data = args[1];

        if (path === '.') {
          newData = data;
        } else {
          pathParts = args[0].split('.');

          while ((part = pathParts.pop())) {
            if (isNaN(Number(part))) {
              newData = {};
            } else {
              newData = [];
            }
            newData[part] = data;
            data = newData;
          }
        }

        extenders.push(newData);
        args.splice(0, 2);
      }

      $.extend.apply($, extenders);
    } else {
    }

    return props;
  };

  Module.prototype.get = function (scope, name) {
    if (typeof name !== 'string') {
      return $.noop;
    }

    var methods = scope.methods;
    var properties = scope.properties;

    if (methods[name]) {
      return methods[name];
    } else if (properties[name]) {
      return properties[name];
    } else {
      return $.noop;
    }
  };

  // Form methods list
  (function (obj, primary) {
    // Collect methods
    for (var method in obj) {
      if (obj.hasOwnProperty(method)) {
        methodsList.push(method);
      }
    }

    // Move primary method to the end of list
    methodsList.push(methodsList.splice($.inArray(primary, methodsList), 1)[0]);
  }(Module.prototype, 'invoke'));

  // Static
  Module.add = function (name, props) {
    if (typeof name !== 'string') {
      return false;
    }

    if (typeof props !== 'object') {
      return false;
    }

    if (modules[name]) {
      modules[name].set(props);
      return false;
    }

    modules[name] = new Module(props, name);
    return true;
  };

  Module.remove = function (name) {
    if (typeof name !== 'string') {
      return false;
    }

    if (!modules[name]) {
      return false;
    }

    if (name === Module.GLOBAL) {
      return false;
    }

    return delete modules[name];
  };

  Module.get = function (name) {
    if (!modules[name]) {
      return $.noop;
    } else {
      return modules[name].invoke;
    }
  };

  Module.has = function (name) {
    return !!modules[name];
  };

  Module.multi = function (method, list) {
    var promises = [];

    if (typeof list !== 'object') {
      return $.Deferred().reject().promise();
    }

    $.each(list, function (name, data) {
      var promise, ret;
      var module = modules[name];

      if (!module) {
        ret = null;
      } else {
        ret = module.invoke(method, data);
      }

      if (utils.isDeferred(ret)) {
        promise = ret;
      } else {
        promise = $.Deferred();
        promise.resolve(ret);
      }

      promises.push(promise);
    });

    return $.when.apply($, promises);
  };

  // Global module name
  Module.GLOBAL = 'root';

  // Global module
  Module.add(Module.GLOBAL, {
    add: {
      method: Module.add,
      override: true
    },
    remove: {
      method: Module.remove,
      override: true
    },
    config: function (data) {
      return Module.get(Module.GLOBAL).set({
        config: data
      });
    },
    init: Module.multi.bind(Module, 'init'),
    update: Module.multi.bind(Module, 'update')
  });

  return Module;
});

define('global/global',['global/global__modules'], function(Module) {
  

  // Ring
  var ring = function(module, method) {
    // Get method
    if (module && method) {
      var mdl = Module.get(module);
      return mdl.bind(mdl, method);

    // Get module
    } else if (module) {
      return Module.get(module);

    // Get global module
    } else {
      return Module.get(Module.GLOBAL);
    }
  };

  return ring;
});

/*!

 handlebars v1.3.0

Copyright (C) 2011 by Yehuda Katz

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

@license
*/
/* exported Handlebars */
var Handlebars = (function() {
// handlebars/safe-string.js
var __module3__ = (function() {
  
  var __exports__;
  // Build out our basic SafeString type
  function SafeString(string) {
    this.string = string;
  }

  SafeString.prototype.toString = function() {
    return "" + this.string;
  };

  __exports__ = SafeString;
  return __exports__;
})();

// handlebars/utils.js
var __module2__ = (function(__dependency1__) {
  
  var __exports__ = {};
  /*jshint -W004 */
  var SafeString = __dependency1__;

  var escape = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': "&quot;",
    "'": "&#x27;",
    "`": "&#x60;"
  };

  var badChars = /[&<>"'`]/g;
  var possible = /[&<>"'`]/;

  function escapeChar(chr) {
    return escape[chr] || "&amp;";
  }

  function extend(obj, value) {
    for(var key in value) {
      if(Object.prototype.hasOwnProperty.call(value, key)) {
        obj[key] = value[key];
      }
    }
  }

  __exports__.extend = extend;var toString = Object.prototype.toString;
  __exports__.toString = toString;
  // Sourced from lodash
  // https://github.com/bestiejs/lodash/blob/master/LICENSE.txt
  var isFunction = function(value) {
    return typeof value === 'function';
  };
  // fallback for older versions of Chrome and Safari
  if (isFunction(/x/)) {
    isFunction = function(value) {
      return typeof value === 'function' && toString.call(value) === '[object Function]';
    };
  }
  var isFunction;
  __exports__.isFunction = isFunction;
  var isArray = Array.isArray || function(value) {
    return (value && typeof value === 'object') ? toString.call(value) === '[object Array]' : false;
  };
  __exports__.isArray = isArray;

  function escapeExpression(string) {
    // don't escape SafeStrings, since they're already safe
    if (string instanceof SafeString) {
      return string.toString();
    } else if (!string && string !== 0) {
      return "";
    }

    // Force a string conversion as this will be done by the append regardless and
    // the regex test will do this transparently behind the scenes, causing issues if
    // an object's to string has escaped characters in it.
    string = "" + string;

    if(!possible.test(string)) { return string; }
    return string.replace(badChars, escapeChar);
  }

  __exports__.escapeExpression = escapeExpression;function isEmpty(value) {
    if (!value && value !== 0) {
      return true;
    } else if (isArray(value) && value.length === 0) {
      return true;
    } else {
      return false;
    }
  }

  __exports__.isEmpty = isEmpty;
  return __exports__;
})(__module3__);

// handlebars/exception.js
var __module4__ = (function() {
  
  var __exports__;

  var errorProps = ['description', 'fileName', 'lineNumber', 'message', 'name', 'number', 'stack'];

  function Exception(message, node) {
    var line;
    if (node && node.firstLine) {
      line = node.firstLine;

      message += ' - ' + line + ':' + node.firstColumn;
    }

    var tmp = Error.prototype.constructor.call(this, message);

    // Unfortunately errors are not enumerable in Chrome (at least), so `for prop in tmp` doesn't work.
    for (var idx = 0; idx < errorProps.length; idx++) {
      this[errorProps[idx]] = tmp[errorProps[idx]];
    }

    if (line) {
      this.lineNumber = line;
      this.column = node.firstColumn;
    }
  }

  Exception.prototype = new Error();

  __exports__ = Exception;
  return __exports__;
})();

// handlebars/base.js
var __module1__ = (function(__dependency1__, __dependency2__) {
  
  var __exports__ = {};
  var Utils = __dependency1__;
  var Exception = __dependency2__;

  var VERSION = "1.3.0";
  __exports__.VERSION = VERSION;var COMPILER_REVISION = 4;
  __exports__.COMPILER_REVISION = COMPILER_REVISION;
  var REVISION_CHANGES = {
    1: '<= 1.0.rc.2', // 1.0.rc.2 is actually rev2 but doesn't report it
    2: '== 1.0.0-rc.3',
    3: '== 1.0.0-rc.4',
    4: '>= 1.0.0'
  };
  __exports__.REVISION_CHANGES = REVISION_CHANGES;
  var isArray = Utils.isArray,
      isFunction = Utils.isFunction,
      toString = Utils.toString,
      objectType = '[object Object]';

  function HandlebarsEnvironment(helpers, partials) {
    this.helpers = helpers || {};
    this.partials = partials || {};

    registerDefaultHelpers(this);
  }

  __exports__.HandlebarsEnvironment = HandlebarsEnvironment;HandlebarsEnvironment.prototype = {
    constructor: HandlebarsEnvironment,

    logger: logger,
    log: log,

    registerHelper: function(name, fn, inverse) {
      if (toString.call(name) === objectType) {
        if (inverse || fn) { throw new Exception('Arg not supported with multiple helpers'); }
        Utils.extend(this.helpers, name);
      } else {
        if (inverse) { fn.not = inverse; }
        this.helpers[name] = fn;
      }
    },

    registerPartial: function(name, str) {
      if (toString.call(name) === objectType) {
        Utils.extend(this.partials,  name);
      } else {
        this.partials[name] = str;
      }
    }
  };

  function registerDefaultHelpers(instance) {
    instance.registerHelper('helperMissing', function(arg) {
      if(arguments.length === 2) {
        return undefined;
      } else {
        throw new Exception("Missing helper: '" + arg + "'");
      }
    });

    instance.registerHelper('blockHelperMissing', function(context, options) {
      var inverse = options.inverse || function() {}, fn = options.fn;

      if (isFunction(context)) { context = context.call(this); }

      if(context === true) {
        return fn(this);
      } else if(context === false || context == null) {
        return inverse(this);
      } else if (isArray(context)) {
        if(context.length > 0) {
          return instance.helpers.each(context, options);
        } else {
          return inverse(this);
        }
      } else {
        return fn(context);
      }
    });

    instance.registerHelper('each', function(context, options) {
      var fn = options.fn, inverse = options.inverse;
      var i = 0, ret = "", data;

      if (isFunction(context)) { context = context.call(this); }

      if (options.data) {
        data = createFrame(options.data);
      }

      if(context && typeof context === 'object') {
        if (isArray(context)) {
          for(var j = context.length; i<j; i++) {
            if (data) {
              data.index = i;
              data.first = (i === 0);
              data.last  = (i === (context.length-1));
            }
            ret = ret + fn(context[i], { data: data });
          }
        } else {
          for(var key in context) {
            if(context.hasOwnProperty(key)) {
              if(data) { 
                data.key = key; 
                data.index = i;
                data.first = (i === 0);
              }
              ret = ret + fn(context[key], {data: data});
              i++;
            }
          }
        }
      }

      if(i === 0){
        ret = inverse(this);
      }

      return ret;
    });

    instance.registerHelper('if', function(conditional, options) {
      if (isFunction(conditional)) { conditional = conditional.call(this); }

      // Default behavior is to render the positive path if the value is truthy and not empty.
      // The `includeZero` option may be set to treat the condtional as purely not empty based on the
      // behavior of isEmpty. Effectively this determines if 0 is handled by the positive path or negative.
      if ((!options.hash.includeZero && !conditional) || Utils.isEmpty(conditional)) {
        return options.inverse(this);
      } else {
        return options.fn(this);
      }
    });

    instance.registerHelper('unless', function(conditional, options) {
      return instance.helpers['if'].call(this, conditional, {fn: options.inverse, inverse: options.fn, hash: options.hash});
    });

    instance.registerHelper('with', function(context, options) {
      if (isFunction(context)) { context = context.call(this); }

      if (!Utils.isEmpty(context)) return options.fn(context);
    });

    instance.registerHelper('log', function(context, options) {
      var level = options.data && options.data.level != null ? parseInt(options.data.level, 10) : 1;
      instance.log(level, context);
    });
  }

  var logger = {
    methodMap: { 0: 'debug', 1: 'info', 2: 'warn', 3: 'error' },

    // State enum
    DEBUG: 0,
    INFO: 1,
    WARN: 2,
    ERROR: 3,
    level: 3,

    // can be overridden in the host environment
    log: function(level, obj) {
      if (logger.level <= level) {
        var method = logger.methodMap[level];
        if (typeof console !== 'undefined' && console[method]) {
          console[method].call(console, obj);
        }
      }
    }
  };
  __exports__.logger = logger;
  function log(level, obj) { logger.log(level, obj); }

  __exports__.log = log;var createFrame = function(object) {
    var obj = {};
    Utils.extend(obj, object);
    return obj;
  };
  __exports__.createFrame = createFrame;
  return __exports__;
})(__module2__, __module4__);

// handlebars/runtime.js
var __module5__ = (function(__dependency1__, __dependency2__, __dependency3__) {
  
  var __exports__ = {};
  var Utils = __dependency1__;
  var Exception = __dependency2__;
  var COMPILER_REVISION = __dependency3__.COMPILER_REVISION;
  var REVISION_CHANGES = __dependency3__.REVISION_CHANGES;

  function checkRevision(compilerInfo) {
    var compilerRevision = compilerInfo && compilerInfo[0] || 1,
        currentRevision = COMPILER_REVISION;

    if (compilerRevision !== currentRevision) {
      if (compilerRevision < currentRevision) {
        var runtimeVersions = REVISION_CHANGES[currentRevision],
            compilerVersions = REVISION_CHANGES[compilerRevision];
        throw new Exception("Template was precompiled with an older version of Handlebars than the current runtime. "+
              "Please update your precompiler to a newer version ("+runtimeVersions+") or downgrade your runtime to an older version ("+compilerVersions+").");
      } else {
        // Use the embedded version info since the runtime doesn't know about this revision yet
        throw new Exception("Template was precompiled with a newer version of Handlebars than the current runtime. "+
              "Please update your runtime to a newer version ("+compilerInfo[1]+").");
      }
    }
  }

  __exports__.checkRevision = checkRevision;// TODO: Remove this line and break up compilePartial

  function template(templateSpec, env) {
    if (!env) {
      throw new Exception("No environment passed to template");
    }

    // Note: Using env.VM references rather than local var references throughout this section to allow
    // for external users to override these as psuedo-supported APIs.
    var invokePartialWrapper = function(partial, name, context, helpers, partials, data) {
      var result = env.VM.invokePartial.apply(this, arguments);
      if (result != null) { return result; }

      if (env.compile) {
        var options = { helpers: helpers, partials: partials, data: data };
        partials[name] = env.compile(partial, { data: data !== undefined }, env);
        return partials[name](context, options);
      } else {
        throw new Exception("The partial " + name + " could not be compiled when running in runtime-only mode");
      }
    };

    // Just add water
    var container = {
      escapeExpression: Utils.escapeExpression,
      invokePartial: invokePartialWrapper,
      programs: [],
      program: function(i, fn, data) {
        var programWrapper = this.programs[i];
        if(data) {
          programWrapper = program(i, fn, data);
        } else if (!programWrapper) {
          programWrapper = this.programs[i] = program(i, fn);
        }
        return programWrapper;
      },
      merge: function(param, common) {
        var ret = param || common;

        if (param && common && (param !== common)) {
          ret = {};
          Utils.extend(ret, common);
          Utils.extend(ret, param);
        }
        return ret;
      },
      programWithDepth: env.VM.programWithDepth,
      noop: env.VM.noop,
      compilerInfo: null
    };

    return function(context, options) {
      options = options || {};
      var namespace = options.partial ? options : env,
          helpers,
          partials;

      if (!options.partial) {
        helpers = options.helpers;
        partials = options.partials;
      }
      var result = templateSpec.call(
            container,
            namespace, context,
            helpers,
            partials,
            options.data);

      if (!options.partial) {
        env.VM.checkRevision(container.compilerInfo);
      }

      return result;
    };
  }

  __exports__.template = template;function programWithDepth(i, fn, data /*, $depth */) {
    var args = Array.prototype.slice.call(arguments, 3);

    var prog = function(context, options) {
      options = options || {};

      return fn.apply(this, [context, options.data || data].concat(args));
    };
    prog.program = i;
    prog.depth = args.length;
    return prog;
  }

  __exports__.programWithDepth = programWithDepth;function program(i, fn, data) {
    var prog = function(context, options) {
      options = options || {};

      return fn(context, options.data || data);
    };
    prog.program = i;
    prog.depth = 0;
    return prog;
  }

  __exports__.program = program;function invokePartial(partial, name, context, helpers, partials, data) {
    var options = { partial: true, helpers: helpers, partials: partials, data: data };

    if(partial === undefined) {
      throw new Exception("The partial " + name + " could not be found");
    } else if(partial instanceof Function) {
      return partial(context, options);
    }
  }

  __exports__.invokePartial = invokePartial;function noop() { return ""; }

  __exports__.noop = noop;
  return __exports__;
})(__module2__, __module4__, __module1__);

// handlebars.runtime.js
var __module0__ = (function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__) {
  
  var __exports__;
  /*globals Handlebars: true */
  var base = __dependency1__;

  // Each of these augment the Handlebars object. No need to setup here.
  // (This is done to easily share code between commonjs and browse envs)
  var SafeString = __dependency2__;
  var Exception = __dependency3__;
  var Utils = __dependency4__;
  var runtime = __dependency5__;

  // For compatibility and usage outside of module systems, make the Handlebars object a namespace
  var create = function() {
    var hb = new base.HandlebarsEnvironment();

    Utils.extend(hb, base);
    hb.SafeString = SafeString;
    hb.Exception = Exception;
    hb.Utils = Utils;

    hb.VM = runtime;
    hb.template = function(spec) {
      return runtime.template(spec, hb);
    };

    return hb;
  };

  var Handlebars = create();
  Handlebars.create = create;

  __exports__ = Handlebars;
  return __exports__;
})(__module1__, __module3__, __module4__, __module2__, __module5__);

  return __module0__;
})();

define("handlebars", (function (global) {
    return function () {
        var ret, fn;
       fn = function (){
        /* globals Handlebars */
        return Handlebars;
      };
        ret = fn.apply(global, arguments);
        return ret;
    };
}(this)));

/*
    json2.js
    2014-02-04

    Public Domain.

    NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.

    See http://www.JSON.org/js.html


    This code should be minified before deployment.
    See http://javascript.crockford.com/jsmin.html

    USE YOUR OWN COPY. IT IS EXTREMELY UNWISE TO LOAD CODE FROM SERVERS YOU DO
    NOT CONTROL.


    This file creates a global JSON object containing two methods: stringify
    and parse.

        JSON.stringify(value, replacer, space)
            value       any JavaScript value, usually an object or array.

            replacer    an optional parameter that determines how object
                        values are stringified for objects. It can be a
                        function or an array of strings.

            space       an optional parameter that specifies the indentation
                        of nested structures. If it is omitted, the text will
                        be packed without extra whitespace. If it is a number,
                        it will specify the number of spaces to indent at each
                        level. If it is a string (such as '\t' or '&nbsp;'),
                        it contains the characters used to indent at each level.

            This method produces a JSON text from a JavaScript value.

            When an object value is found, if the object contains a toJSON
            method, its toJSON method will be called and the result will be
            stringified. A toJSON method does not serialize: it returns the
            value represented by the name/value pair that should be serialized,
            or undefined if nothing should be serialized. The toJSON method
            will be passed the key associated with the value, and this will be
            bound to the value

            For example, this would serialize Dates as ISO strings.

                Date.prototype.toJSON = function (key) {
                    function f(n) {
                        // Format integers to have at least two digits.
                        return n < 10 ? '0' + n : n;
                    }

                    return this.getUTCFullYear()   + '-' +
                         f(this.getUTCMonth() + 1) + '-' +
                         f(this.getUTCDate())      + 'T' +
                         f(this.getUTCHours())     + ':' +
                         f(this.getUTCMinutes())   + ':' +
                         f(this.getUTCSeconds())   + 'Z';
                };

            You can provide an optional replacer method. It will be passed the
            key and value of each member, with this bound to the containing
            object. The value that is returned from your method will be
            serialized. If your method returns undefined, then the member will
            be excluded from the serialization.

            If the replacer parameter is an array of strings, then it will be
            used to select the members to be serialized. It filters the results
            such that only members with keys listed in the replacer array are
            stringified.

            Values that do not have JSON representations, such as undefined or
            functions, will not be serialized. Such values in objects will be
            dropped; in arrays they will be replaced with null. You can use
            a replacer function to replace those with JSON values.
            JSON.stringify(undefined) returns undefined.

            The optional space parameter produces a stringification of the
            value that is filled with line breaks and indentation to make it
            easier to read.

            If the space parameter is a non-empty string, then that string will
            be used for indentation. If the space parameter is a number, then
            the indentation will be that many spaces.

            Example:

            text = JSON.stringify(['e', {pluribus: 'unum'}]);
            // text is '["e",{"pluribus":"unum"}]'


            text = JSON.stringify(['e', {pluribus: 'unum'}], null, '\t');
            // text is '[\n\t"e",\n\t{\n\t\t"pluribus": "unum"\n\t}\n]'

            text = JSON.stringify([new Date()], function (key, value) {
                return this[key] instanceof Date ?
                    'Date(' + this[key] + ')' : value;
            });
            // text is '["Date(---current time---)"]'


        JSON.parse(text, reviver)
            This method parses a JSON text to produce an object or array.
            It can throw a SyntaxError exception.

            The optional reviver parameter is a function that can filter and
            transform the results. It receives each of the keys and values,
            and its return value is used instead of the original value.
            If it returns what it received, then the structure is not modified.
            If it returns undefined then the member is deleted.

            Example:

            // Parse the text. Values that look like ISO date strings will
            // be converted to Date objects.

            myData = JSON.parse(text, function (key, value) {
                var a;
                if (typeof value === 'string') {
                    a =
/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}(?:\.\d*)?)Z$/.exec(value);
                    if (a) {
                        return new Date(Date.UTC(+a[1], +a[2] - 1, +a[3], +a[4],
                            +a[5], +a[6]));
                    }
                }
                return value;
            });

            myData = JSON.parse('["Date(09/09/2001)"]', function (key, value) {
                var d;
                if (typeof value === 'string' &&
                        value.slice(0, 5) === 'Date(' &&
                        value.slice(-1) === ')') {
                    d = new Date(value.slice(5, -1));
                    if (d) {
                        return d;
                    }
                }
                return value;
            });


    This is a reference implementation. You are free to copy, modify, or
    redistribute.
*/

/*jslint evil: true, regexp: true */

/*members "", "\b", "\t", "\n", "\f", "\r", "\"", JSON, "\\", apply,
    call, charCodeAt, getUTCDate, getUTCFullYear, getUTCHours,
    getUTCMinutes, getUTCMonth, getUTCSeconds, hasOwnProperty, join,
    lastIndex, length, parse, prototype, push, replace, slice, stringify,
    test, toJSON, toString, valueOf
*/


// Create a JSON object only if one does not already exist. We create the
// methods in a closure to avoid creating global variables.

if (typeof JSON !== 'object') {
    JSON = {};
}

(function () {
    

    function f(n) {
        // Format integers to have at least two digits.
        return n < 10 ? '0' + n : n;
    }

    if (typeof Date.prototype.toJSON !== 'function') {

        Date.prototype.toJSON = function () {

            return isFinite(this.valueOf())
                ? this.getUTCFullYear()     + '-' +
                    f(this.getUTCMonth() + 1) + '-' +
                    f(this.getUTCDate())      + 'T' +
                    f(this.getUTCHours())     + ':' +
                    f(this.getUTCMinutes())   + ':' +
                    f(this.getUTCSeconds())   + 'Z'
                : null;
        };

        String.prototype.toJSON      =
            Number.prototype.toJSON  =
            Boolean.prototype.toJSON = function () {
                return this.valueOf();
            };
    }

    var cx,
        escapable,
        gap,
        indent,
        meta,
        rep;


    function quote(string) {

// If the string contains no control characters, no quote characters, and no
// backslash characters, then we can safely slap some quotes around it.
// Otherwise we must also replace the offending characters with safe escape
// sequences.

        escapable.lastIndex = 0;
        return escapable.test(string) ? '"' + string.replace(escapable, function (a) {
            var c = meta[a];
            return typeof c === 'string'
                ? c
                : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
        }) + '"' : '"' + string + '"';
    }


    function str(key, holder) {

// Produce a string from holder[key].

        var i,          // The loop counter.
            k,          // The member key.
            v,          // The member value.
            length,
            mind = gap,
            partial,
            value = holder[key];

// If the value has a toJSON method, call it to obtain a replacement value.

        if (value && typeof value === 'object' &&
                typeof value.toJSON === 'function') {
            value = value.toJSON(key);
        }

// If we were called with a replacer function, then call the replacer to
// obtain a replacement value.

        if (typeof rep === 'function') {
            value = rep.call(holder, key, value);
        }

// What happens next depends on the value's type.

        switch (typeof value) {
        case 'string':
            return quote(value);

        case 'number':

// JSON numbers must be finite. Encode non-finite numbers as null.

            return isFinite(value) ? String(value) : 'null';

        case 'boolean':
        case 'null':

// If the value is a boolean or null, convert it to a string. Note:
// typeof null does not produce 'null'. The case is included here in
// the remote chance that this gets fixed someday.

            return String(value);

// If the type is 'object', we might be dealing with an object or an array or
// null.

        case 'object':

// Due to a specification blunder in ECMAScript, typeof null is 'object',
// so watch out for that case.

            if (!value) {
                return 'null';
            }

// Make an array to hold the partial results of stringifying this object value.

            gap += indent;
            partial = [];

// Is the value an array?

            if (Object.prototype.toString.apply(value) === '[object Array]') {

// The value is an array. Stringify every element. Use null as a placeholder
// for non-JSON values.

                length = value.length;
                for (i = 0; i < length; i += 1) {
                    partial[i] = str(i, value) || 'null';
                }

// Join all of the elements together, separated with commas, and wrap them in
// brackets.

                v = partial.length === 0
                    ? '[]'
                    : gap
                    ? '[\n' + gap + partial.join(',\n' + gap) + '\n' + mind + ']'
                    : '[' + partial.join(',') + ']';
                gap = mind;
                return v;
            }

// If the replacer is an array, use it to select the members to be stringified.

            if (rep && typeof rep === 'object') {
                length = rep.length;
                for (i = 0; i < length; i += 1) {
                    if (typeof rep[i] === 'string') {
                        k = rep[i];
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            } else {

// Otherwise, iterate through all of the keys in the object.

                for (k in value) {
                    if (Object.prototype.hasOwnProperty.call(value, k)) {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            }

// Join all of the member texts together, separated with commas,
// and wrap them in braces.

            v = partial.length === 0
                ? '{}'
                : gap
                ? '{\n' + gap + partial.join(',\n' + gap) + '\n' + mind + '}'
                : '{' + partial.join(',') + '}';
            gap = mind;
            return v;
        }
    }

// If the JSON object does not yet have a stringify method, give it one.

    if (typeof JSON.stringify !== 'function') {
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
        meta = {    // table of character substitutions
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"' : '\\"',
            '\\': '\\\\'
        };
        JSON.stringify = function (value, replacer, space) {

// The stringify method takes a value and an optional replacer, and an optional
// space parameter, and returns a JSON text. The replacer can be a function
// that can replace values, or an array of strings that will select the keys.
// A default replacer method can be provided. Use of the space parameter can
// produce text that is more easily readable.

            var i;
            gap = '';
            indent = '';

// If the space parameter is a number, make an indent string containing that
// many spaces.

            if (typeof space === 'number') {
                for (i = 0; i < space; i += 1) {
                    indent += ' ';
                }

// If the space parameter is a string, it will be used as the indent string.

            } else if (typeof space === 'string') {
                indent = space;
            }

// If there is a replacer, it must be a function or an array.
// Otherwise, throw an error.

            rep = replacer;
            if (replacer && typeof replacer !== 'function' &&
                    (typeof replacer !== 'object' ||
                    typeof replacer.length !== 'number')) {
                throw new Error('JSON.stringify');
            }

// Make a fake root object containing our value under the key of ''.
// Return the result of stringifying the value.

            return str('', {'': value});
        };
    }


// If the JSON object does not yet have a parse method, give it one.

    if (typeof JSON.parse !== 'function') {
        cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
        JSON.parse = function (text, reviver) {

// The parse method takes a text and an optional reviver function, and returns
// a JavaScript value if the text is a valid JSON text.

            var j;

            function walk(holder, key) {

// The walk method is used to recursively walk the resulting structure so
// that modifications can be made.

                var k, v, value = holder[key];
                if (value && typeof value === 'object') {
                    for (k in value) {
                        if (Object.prototype.hasOwnProperty.call(value, k)) {
                            v = walk(value, k);
                            if (v !== undefined) {
                                value[k] = v;
                            } else {
                                delete value[k];
                            }
                        }
                    }
                }
                return reviver.call(holder, key, value);
            }


// Parsing happens in four stages. In the first stage, we replace certain
// Unicode characters with escape sequences. JavaScript handles many characters
// incorrectly, either silently deleting them, or treating them as line endings.

            text = String(text);
            cx.lastIndex = 0;
            if (cx.test(text)) {
                text = text.replace(cx, function (a) {
                    return '\\u' +
                        ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                });
            }

// In the second stage, we run the text against regular expressions that look
// for non-JSON patterns. We are especially concerned with '()' and 'new'
// because they can cause invocation, and '=' because it can cause mutation.
// But just to be safe, we want to reject all unexpected forms.

// We split the second stage into 4 regexp operations in order to work around
// crippling inefficiencies in IE's and Safari's regexp engines. First we
// replace the JSON backslash pairs with '@' (a non-JSON character). Second, we
// replace all simple value tokens with ']' characters. Third, we delete all
// open brackets that follow a colon or comma or that begin the text. Finally,
// we look to see that the remaining characters are only whitespace or ']' or
// ',' or ':' or '{' or '}'. If that is so, then the text is safe for eval.

            if (/^[\],:{}\s]*$/
                    .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
                        .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
                        .replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {

// In the third stage we use the eval function to compile the text into a
// JavaScript structure. The '{' operator is subject to a syntactic ambiguity
// in JavaScript: it can begin a block or an object literal. We wrap the text
// in parens to eliminate the ambiguity.

                j = eval('(' + text + ')');

// In the optional fourth stage, we recursively walk the new structure, passing
// each name/value pair to a reviver function for possible transformation.

                return typeof reviver === 'function'
                    ? walk({'': j}, '')
                    : j;
            }

// If the text is not JSON parseable, then a SyntaxError is thrown.

            throw new SyntaxError('JSON.parse');
        };
    }
}());

define("json", function(){});

define('global/global__helpers',['handlebars', 'json'], function(Handlebars) {
  

  Handlebars.registerHelper('stringify', function(items) {
    return typeof items === 'string' ? items : JSON.stringify(items);
  });

  // Example: {{#ifEqual type 'gradient'}} ring-menu_gradient{{/ifEqual}}"
  Handlebars.registerHelper('ifEqual', function(a, b, context) {
    if(a === b) {
      return context.fn(this);
    } else {
      return context.inverse(this);
    }
  });

  Handlebars.registerHelper('copyright', function(year) {
    var currentYear = (new Date()).getUTCFullYear();

    var ret = '© ';

    if (year >= currentYear) {
      ret += year;
    } else {
      ret += year + '—' + currentYear;
    }

    return ret;
  });

  // Example: {{#ifOr this 'string'}} {{this}}{{/typeof}}"
  Handlebars.registerHelper('ifOr', function() {
    // Al arguments except content
    var args = Array.prototype.slice.call(arguments, 0, arguments.length - 1);
    var context = arguments[arguments.length - 1];

    for (var i = args.length - 1; i >= 0; i--) {
      if (args[i]) {
        return context.fn(this);
      }
    }

    return context.inverse(this);
  });
});
define('global/_global__class.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("global__class", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var buffer = "", stack1, functionType="function", escapeExpression=this.escapeExpression, self=this;

function program1(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " ";
  if (helper = helpers.className) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.className); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1);
  return buffer;
  }

function program3(depth0,data) {
  
  
  return " ring-js-event";
  }

function program5(depth0,data) {
  
  
  return " active";
  }

  stack1 = helpers['if'].call(depth0, (depth0 && depth0.className), {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.event), {hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.active), {hash:{},inverse:self.noop,fn:self.program(5, program5, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }));

});
define('global/_global__attributes.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("global__attributes", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var stack1, functionType="function", escapeExpression=this.escapeExpression, helperMissing=helpers.helperMissing, self=this, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "", stack1;
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.target), {hash:{},inverse:self.noop,fn:self.program(2, program2, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.tabIndex), {hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.title), {hash:{},inverse:self.noop,fn:self.program(6, program6, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.event), {hash:{},inverse:self.noop,fn:self.program(8, program8, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }
function program2(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " target=\"";
  if (helper = helpers.target) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.target); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\"";
  return buffer;
  }

function program4(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " target=\"";
  if (helper = helpers.tabIndex) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.tabIndex); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\"";
  return buffer;
  }

function program6(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " title=\"";
  if (helper = helpers.title) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.title); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\"";
  return buffer;
  }

function program8(depth0,data) {
  
  var buffer = "", helper, options;
  buffer += " data-ring-event=\""
    + escapeExpression((helper = helpers.stringify || (depth0 && depth0.stringify),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0.event), options) : helperMissing.call(depth0, "stringify", (depth0 && depth0.event), options)))
    + "\"";
  return buffer;
  }

  stack1 = ((stack1 = (typeof depth0 === functionType ? depth0.apply(depth0) : depth0)),blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}));
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }));

});
define('global/global__views',[
  'jquery',
  'handlebars',
  'global/global__modules',
  'global/global__utils',
  'global/global__helpers',
  'global/_global__class.hbs',
  'global/_global__attributes.hbs'
], function($, Handlebars, Module, utils) {
  

  var views = {};

  // TODO Refactor
  var View = function($element) {
    this.$element = $element;
  };

  View.prototype.update = function($element) {
    if (!($element instanceof $)) {
      $element = $($element);
    }

    this.$element.replaceWith($element);
    this.$element = $element;
  };

  View.prototype.hide = function() {
    this.$element.hide();
  };

  View.prototype.show = function() {
    this.$element.show();
  };

  View.render = function(template, data) {
    var html = Handlebars.partials[template](data);

    if (!utils.isEmptyString(html)) {
      return html;
    } else {
      return '';
    }
  };

  var pipe = function(process, data) {
    var newData = $.extend(true, {}, data);

    if (typeof process === 'function') {
      return process(newData);
    } else {
      return newData;
    }
  };

  var $body;
  var methods = {
    append: 'appendTo',
    prepend: 'prependTo',
    before: 'insertBefore',
    after: 'insertAfter',
    replace: 'replaceWith',
    'default': 'appendTo'
  };

  var addElement = function addElement($html, $element, method, dfd, counter) {
    counter = counter || 0;
    var $target;

    if (typeof $element === 'string' || utils.isNode($element )) {
      $target = $($element);
    } else if (!($element instanceof $)) {
      // TODO Lazy DOM cache
      $target = $body && $body[0] ? $body : ($body = $('body'));
    } else {
      $target = $element;
    }

    if (!$target[0] && counter < 300) {
      setTimeout(addElement.bind(null, $html, $element, method, dfd, ++counter), 10);
      return;
    } else if (!$target[0] && counter >= 300) {
      // give up
      dfd.reject();
      return;
    }

    method = methods[method] || methods['default'];
    var ret;

    if (method === 'replaceWith')  {
      $target[method]($html);
      ret = $html;
    } else {
      ret = $html[method]($target);
    }

    dfd.resolve(ret);
  };

  View.update = function(name) {
    var view = views[name];

    if (!view) {
      return null;
    }

    var module = Module.get(name);
    var args = Array.prototype.slice.call(arguments, 1);
    args.unshift('view');
    var data = module.update.apply(module, args);

    var html = View.render(name, pipe(module.get('process'), data));

    if (html) {
      view.update(html);
      return(view.$element);
    } else {
      return null;
    }
  };

  View.hide = function(name) {
    var view = views[name];

    if (!view) {
      return null;
    }

    view.hide();
  };

  View.show = function(name) {
    var view = views[name];

    if (!view) {
      return null;
    }

    view.show();
  };

  View.init = function(name, $element, method, process, data) {
    var dfd = $.Deferred();
    var module = Module.get(name);
    module.set({
      view: data,
      process: process
    });

    var html = View.render(name, pipe(process, data));

    if (html) {
      var $html = $(html);

      addElement($html, $element, method, dfd);

      dfd.done(function(view) {
        views[name] = new View(view);
      });

    } else {
      dfd.reject();
    }

    return dfd;
  };

  // Add render to global module
  Module.add(Module.GLOBAL, {
    render: {
      method: View.render,
      override: true
    }
  });

  return View;
});
/*global define:false */
/**
 * Copyright 2013 Craig Campbell
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Mousetrap is a simple keyboard shortcut library for Javascript with
 * no external dependencies
 *
 * @version 1.4.6
 * @url craig.is/killing/mice
 */
(function(window, document, undefined) {

    /**
     * mapping of special keycodes to their corresponding keys
     *
     * everything in this dictionary cannot use keypress events
     * so it has to be here to map to the correct keycodes for
     * keyup/keydown events
     *
     * @type {Object}
     */
    var _MAP = {
            8: 'backspace',
            9: 'tab',
            13: 'enter',
            16: 'shift',
            17: 'ctrl',
            18: 'alt',
            20: 'capslock',
            27: 'esc',
            32: 'space',
            33: 'pageup',
            34: 'pagedown',
            35: 'end',
            36: 'home',
            37: 'left',
            38: 'up',
            39: 'right',
            40: 'down',
            45: 'ins',
            46: 'del',
            91: 'meta',
            93: 'meta',
            224: 'meta'
        },

        /**
         * mapping for special characters so they can support
         *
         * this dictionary is only used incase you want to bind a
         * keyup or keydown event to one of these keys
         *
         * @type {Object}
         */
        _KEYCODE_MAP = {
            106: '*',
            107: '+',
            109: '-',
            110: '.',
            111 : '/',
            186: ';',
            187: '=',
            188: ',',
            189: '-',
            190: '.',
            191: '/',
            192: '`',
            219: '[',
            220: '\\',
            221: ']',
            222: '\''
        },

        /**
         * this is a mapping of keys that require shift on a US keypad
         * back to the non shift equivelents
         *
         * this is so you can use keyup events with these keys
         *
         * note that this will only work reliably on US keyboards
         *
         * @type {Object}
         */
        _SHIFT_MAP = {
            '~': '`',
            '!': '1',
            '@': '2',
            '#': '3',
            '$': '4',
            '%': '5',
            '^': '6',
            '&': '7',
            '*': '8',
            '(': '9',
            ')': '0',
            '_': '-',
            '+': '=',
            ':': ';',
            '\"': '\'',
            '<': ',',
            '>': '.',
            '?': '/',
            '|': '\\'
        },

        /**
         * this is a list of special strings you can use to map
         * to modifier keys when you specify your keyboard shortcuts
         *
         * @type {Object}
         */
        _SPECIAL_ALIASES = {
            'option': 'alt',
            'command': 'meta',
            'return': 'enter',
            'escape': 'esc',
            'mod': /Mac|iPod|iPhone|iPad/.test(navigator.platform) ? 'meta' : 'ctrl'
        },

        /**
         * variable to store the flipped version of _MAP from above
         * needed to check if we should use keypress or not when no action
         * is specified
         *
         * @type {Object|undefined}
         */
        _REVERSE_MAP,

        /**
         * a list of all the callbacks setup via Mousetrap.bind()
         *
         * @type {Object}
         */
        _callbacks = {},

        /**
         * direct map of string combinations to callbacks used for trigger()
         *
         * @type {Object}
         */
        _directMap = {},

        /**
         * keeps track of what level each sequence is at since multiple
         * sequences can start out with the same sequence
         *
         * @type {Object}
         */
        _sequenceLevels = {},

        /**
         * variable to store the setTimeout call
         *
         * @type {null|number}
         */
        _resetTimer,

        /**
         * temporary state where we will ignore the next keyup
         *
         * @type {boolean|string}
         */
        _ignoreNextKeyup = false,

        /**
         * temporary state where we will ignore the next keypress
         *
         * @type {boolean}
         */
        _ignoreNextKeypress = false,

        /**
         * are we currently inside of a sequence?
         * type of action ("keyup" or "keydown" or "keypress") or false
         *
         * @type {boolean|string}
         */
        _nextExpectedAction = false;

    /**
     * loop through the f keys, f1 to f19 and add them to the map
     * programatically
     */
    for (var i = 1; i < 20; ++i) {
        _MAP[111 + i] = 'f' + i;
    }

    /**
     * loop through to map numbers on the numeric keypad
     */
    for (i = 0; i <= 9; ++i) {
        _MAP[i + 96] = i;
    }

    /**
     * cross browser add event method
     *
     * @param {Element|HTMLDocument} object
     * @param {string} type
     * @param {Function} callback
     * @returns void
     */
    function _addEvent(object, type, callback) {
        if (object.addEventListener) {
            object.addEventListener(type, callback, false);
            return;
        }

        object.attachEvent('on' + type, callback);
    }

    /**
     * takes the event and returns the key character
     *
     * @param {Event} e
     * @return {string}
     */
    function _characterFromEvent(e) {

        // for keypress events we should return the character as is
        if (e.type == 'keypress') {
            var character = String.fromCharCode(e.which);

            // if the shift key is not pressed then it is safe to assume
            // that we want the character to be lowercase.  this means if
            // you accidentally have caps lock on then your key bindings
            // will continue to work
            //
            // the only side effect that might not be desired is if you
            // bind something like 'A' cause you want to trigger an
            // event when capital A is pressed caps lock will no longer
            // trigger the event.  shift+a will though.
            if (!e.shiftKey) {
                character = character.toLowerCase();
            }

            return character;
        }

        // for non keypress events the special maps are needed
        if (_MAP[e.which]) {
            return _MAP[e.which];
        }

        if (_KEYCODE_MAP[e.which]) {
            return _KEYCODE_MAP[e.which];
        }

        // if it is not in the special map

        // with keydown and keyup events the character seems to always
        // come in as an uppercase character whether you are pressing shift
        // or not.  we should make sure it is always lowercase for comparisons
        return String.fromCharCode(e.which).toLowerCase();
    }

    /**
     * checks if two arrays are equal
     *
     * @param {Array} modifiers1
     * @param {Array} modifiers2
     * @returns {boolean}
     */
    function _modifiersMatch(modifiers1, modifiers2) {
        return modifiers1.sort().join(',') === modifiers2.sort().join(',');
    }

    /**
     * resets all sequence counters except for the ones passed in
     *
     * @param {Object} doNotReset
     * @returns void
     */
    function _resetSequences(doNotReset) {
        doNotReset = doNotReset || {};

        var activeSequences = false,
            key;

        for (key in _sequenceLevels) {
            if (doNotReset[key]) {
                activeSequences = true;
                continue;
            }
            _sequenceLevels[key] = 0;
        }

        if (!activeSequences) {
            _nextExpectedAction = false;
        }
    }

    /**
     * finds all callbacks that match based on the keycode, modifiers,
     * and action
     *
     * @param {string} character
     * @param {Array} modifiers
     * @param {Event|Object} e
     * @param {string=} sequenceName - name of the sequence we are looking for
     * @param {string=} combination
     * @param {number=} level
     * @returns {Array}
     */
    function _getMatches(character, modifiers, e, sequenceName, combination, level) {
        var i,
            callback,
            matches = [],
            action = e.type;

        // if there are no events related to this keycode
        if (!_callbacks[character]) {
            return [];
        }

        // if a modifier key is coming up on its own we should allow it
        if (action == 'keyup' && _isModifier(character)) {
            modifiers = [character];
        }

        // loop through all callbacks for the key that was pressed
        // and see if any of them match
        for (i = 0; i < _callbacks[character].length; ++i) {
            callback = _callbacks[character][i];

            // if a sequence name is not specified, but this is a sequence at
            // the wrong level then move onto the next match
            if (!sequenceName && callback.seq && _sequenceLevels[callback.seq] != callback.level) {
                continue;
            }

            // if the action we are looking for doesn't match the action we got
            // then we should keep going
            if (action != callback.action) {
                continue;
            }

            // if this is a keypress event and the meta key and control key
            // are not pressed that means that we need to only look at the
            // character, otherwise check the modifiers as well
            //
            // chrome will not fire a keypress if meta or control is down
            // safari will fire a keypress if meta or meta+shift is down
            // firefox will fire a keypress if meta or control is down
            if ((action == 'keypress' && !e.metaKey && !e.ctrlKey) || _modifiersMatch(modifiers, callback.modifiers)) {

                // when you bind a combination or sequence a second time it
                // should overwrite the first one.  if a sequenceName or
                // combination is specified in this call it does just that
                //
                // @todo make deleting its own method?
                var deleteCombo = !sequenceName && callback.combo == combination;
                var deleteSequence = sequenceName && callback.seq == sequenceName && callback.level == level;
                if (deleteCombo || deleteSequence) {
                    _callbacks[character].splice(i, 1);
                }

                matches.push(callback);
            }
        }

        return matches;
    }

    /**
     * takes a key event and figures out what the modifiers are
     *
     * @param {Event} e
     * @returns {Array}
     */
    function _eventModifiers(e) {
        var modifiers = [];

        if (e.shiftKey) {
            modifiers.push('shift');
        }

        if (e.altKey) {
            modifiers.push('alt');
        }

        if (e.ctrlKey) {
            modifiers.push('ctrl');
        }

        if (e.metaKey) {
            modifiers.push('meta');
        }

        return modifiers;
    }

    /**
     * prevents default for this event
     *
     * @param {Event} e
     * @returns void
     */
    function _preventDefault(e) {
        if (e.preventDefault) {
            e.preventDefault();
            return;
        }

        e.returnValue = false;
    }

    /**
     * stops propogation for this event
     *
     * @param {Event} e
     * @returns void
     */
    function _stopPropagation(e) {
        if (e.stopPropagation) {
            e.stopPropagation();
            return;
        }

        e.cancelBubble = true;
    }

    /**
     * actually calls the callback function
     *
     * if your callback function returns false this will use the jquery
     * convention - prevent default and stop propogation on the event
     *
     * @param {Function} callback
     * @param {Event} e
     * @returns void
     */
    function _fireCallback(callback, e, combo, sequence) {

        // if this event should not happen stop here
        if (Mousetrap.stopCallback(e, e.target || e.srcElement, combo, sequence)) {
            return;
        }

        if (callback(e, combo) === false) {
            _preventDefault(e);
            _stopPropagation(e);
        }
    }

    /**
     * handles a character key event
     *
     * @param {string} character
     * @param {Array} modifiers
     * @param {Event} e
     * @returns void
     */
    function _handleKey(character, modifiers, e) {
        var callbacks = _getMatches(character, modifiers, e),
            i,
            doNotReset = {},
            maxLevel = 0,
            processedSequenceCallback = false;

        // Calculate the maxLevel for sequences so we can only execute the longest callback sequence
        for (i = 0; i < callbacks.length; ++i) {
            if (callbacks[i].seq) {
                maxLevel = Math.max(maxLevel, callbacks[i].level);
            }
        }

        // loop through matching callbacks for this key event
        for (i = 0; i < callbacks.length; ++i) {

            // fire for all sequence callbacks
            // this is because if for example you have multiple sequences
            // bound such as "g i" and "g t" they both need to fire the
            // callback for matching g cause otherwise you can only ever
            // match the first one
            if (callbacks[i].seq) {

                // only fire callbacks for the maxLevel to prevent
                // subsequences from also firing
                //
                // for example 'a option b' should not cause 'option b' to fire
                // even though 'option b' is part of the other sequence
                //
                // any sequences that do not match here will be discarded
                // below by the _resetSequences call
                if (callbacks[i].level != maxLevel) {
                    continue;
                }

                processedSequenceCallback = true;

                // keep a list of which sequences were matches for later
                doNotReset[callbacks[i].seq] = 1;
                _fireCallback(callbacks[i].callback, e, callbacks[i].combo, callbacks[i].seq);
                continue;
            }

            // if there were no sequence matches but we are still here
            // that means this is a regular match so we should fire that
            if (!processedSequenceCallback) {
                _fireCallback(callbacks[i].callback, e, callbacks[i].combo);
            }
        }

        // if the key you pressed matches the type of sequence without
        // being a modifier (ie "keyup" or "keypress") then we should
        // reset all sequences that were not matched by this event
        //
        // this is so, for example, if you have the sequence "h a t" and you
        // type "h e a r t" it does not match.  in this case the "e" will
        // cause the sequence to reset
        //
        // modifier keys are ignored because you can have a sequence
        // that contains modifiers such as "enter ctrl+space" and in most
        // cases the modifier key will be pressed before the next key
        //
        // also if you have a sequence such as "ctrl+b a" then pressing the
        // "b" key will trigger a "keypress" and a "keydown"
        //
        // the "keydown" is expected when there is a modifier, but the
        // "keypress" ends up matching the _nextExpectedAction since it occurs
        // after and that causes the sequence to reset
        //
        // we ignore keypresses in a sequence that directly follow a keydown
        // for the same character
        var ignoreThisKeypress = e.type == 'keypress' && _ignoreNextKeypress;
        if (e.type == _nextExpectedAction && !_isModifier(character) && !ignoreThisKeypress) {
            _resetSequences(doNotReset);
        }

        _ignoreNextKeypress = processedSequenceCallback && e.type == 'keydown';
    }

    /**
     * handles a keydown event
     *
     * @param {Event} e
     * @returns void
     */
    function _handleKeyEvent(e) {

        // normalize e.which for key events
        // @see http://stackoverflow.com/questions/4285627/javascript-keycode-vs-charcode-utter-confusion
        if (typeof e.which !== 'number') {
            e.which = e.keyCode;
        }

        var character = _characterFromEvent(e);

        // no character found then stop
        if (!character) {
            return;
        }

        // need to use === for the character check because the character can be 0
        if (e.type == 'keyup' && _ignoreNextKeyup === character) {
            _ignoreNextKeyup = false;
            return;
        }

        Mousetrap.handleKey(character, _eventModifiers(e), e);
    }

    /**
     * determines if the keycode specified is a modifier key or not
     *
     * @param {string} key
     * @returns {boolean}
     */
    function _isModifier(key) {
        return key == 'shift' || key == 'ctrl' || key == 'alt' || key == 'meta';
    }

    /**
     * called to set a 1 second timeout on the specified sequence
     *
     * this is so after each key press in the sequence you have 1 second
     * to press the next key before you have to start over
     *
     * @returns void
     */
    function _resetSequenceTimer() {
        clearTimeout(_resetTimer);
        _resetTimer = setTimeout(_resetSequences, 1000);
    }

    /**
     * reverses the map lookup so that we can look for specific keys
     * to see what can and can't use keypress
     *
     * @return {Object}
     */
    function _getReverseMap() {
        if (!_REVERSE_MAP) {
            _REVERSE_MAP = {};
            for (var key in _MAP) {

                // pull out the numeric keypad from here cause keypress should
                // be able to detect the keys from the character
                if (key > 95 && key < 112) {
                    continue;
                }

                if (_MAP.hasOwnProperty(key)) {
                    _REVERSE_MAP[_MAP[key]] = key;
                }
            }
        }
        return _REVERSE_MAP;
    }

    /**
     * picks the best action based on the key combination
     *
     * @param {string} key - character for key
     * @param {Array} modifiers
     * @param {string=} action passed in
     */
    function _pickBestAction(key, modifiers, action) {

        // if no action was picked in we should try to pick the one
        // that we think would work best for this key
        if (!action) {
            action = _getReverseMap()[key] ? 'keydown' : 'keypress';
        }

        // modifier keys don't work as expected with keypress,
        // switch to keydown
        if (action == 'keypress' && modifiers.length) {
            action = 'keydown';
        }

        return action;
    }

    /**
     * binds a key sequence to an event
     *
     * @param {string} combo - combo specified in bind call
     * @param {Array} keys
     * @param {Function} callback
     * @param {string=} action
     * @returns void
     */
    function _bindSequence(combo, keys, callback, action) {

        // start off by adding a sequence level record for this combination
        // and setting the level to 0
        _sequenceLevels[combo] = 0;

        /**
         * callback to increase the sequence level for this sequence and reset
         * all other sequences that were active
         *
         * @param {string} nextAction
         * @returns {Function}
         */
        function _increaseSequence(nextAction) {
            return function() {
                _nextExpectedAction = nextAction;
                ++_sequenceLevels[combo];
                _resetSequenceTimer();
            };
        }

        /**
         * wraps the specified callback inside of another function in order
         * to reset all sequence counters as soon as this sequence is done
         *
         * @param {Event} e
         * @returns void
         */
        function _callbackAndReset(e) {
            _fireCallback(callback, e, combo);

            // we should ignore the next key up if the action is key down
            // or keypress.  this is so if you finish a sequence and
            // release the key the final key will not trigger a keyup
            if (action !== 'keyup') {
                _ignoreNextKeyup = _characterFromEvent(e);
            }

            // weird race condition if a sequence ends with the key
            // another sequence begins with
            setTimeout(_resetSequences, 10);
        }

        // loop through keys one at a time and bind the appropriate callback
        // function.  for any key leading up to the final one it should
        // increase the sequence. after the final, it should reset all sequences
        //
        // if an action is specified in the original bind call then that will
        // be used throughout.  otherwise we will pass the action that the
        // next key in the sequence should match.  this allows a sequence
        // to mix and match keypress and keydown events depending on which
        // ones are better suited to the key provided
        for (var i = 0; i < keys.length; ++i) {
            var isFinal = i + 1 === keys.length;
            var wrappedCallback = isFinal ? _callbackAndReset : _increaseSequence(action || _getKeyInfo(keys[i + 1]).action);
            _bindSingle(keys[i], wrappedCallback, action, combo, i);
        }
    }

    /**
     * Converts from a string key combination to an array
     *
     * @param  {string} combination like "command+shift+l"
     * @return {Array}
     */
    function _keysFromString(combination) {
        if (combination === '+') {
            return ['+'];
        }

        return combination.split('+');
    }

    /**
     * Gets info for a specific key combination
     *
     * @param  {string} combination key combination ("command+s" or "a" or "*")
     * @param  {string=} action
     * @returns {Object}
     */
    function _getKeyInfo(combination, action) {
        var keys,
            key,
            i,
            modifiers = [];

        // take the keys from this pattern and figure out what the actual
        // pattern is all about
        keys = _keysFromString(combination);

        for (i = 0; i < keys.length; ++i) {
            key = keys[i];

            // normalize key names
            if (_SPECIAL_ALIASES[key]) {
                key = _SPECIAL_ALIASES[key];
            }

            // if this is not a keypress event then we should
            // be smart about using shift keys
            // this will only work for US keyboards however
            if (action && action != 'keypress' && _SHIFT_MAP[key]) {
                key = _SHIFT_MAP[key];
                modifiers.push('shift');
            }

            // if this key is a modifier then add it to the list of modifiers
            if (_isModifier(key)) {
                modifiers.push(key);
            }
        }

        // depending on what the key combination is
        // we will try to pick the best event for it
        action = _pickBestAction(key, modifiers, action);

        return {
            key: key,
            modifiers: modifiers,
            action: action
        };
    }

    /**
     * binds a single keyboard combination
     *
     * @param {string} combination
     * @param {Function} callback
     * @param {string=} action
     * @param {string=} sequenceName - name of sequence if part of sequence
     * @param {number=} level - what part of the sequence the command is
     * @returns void
     */
    function _bindSingle(combination, callback, action, sequenceName, level) {

        // store a direct mapped reference for use with Mousetrap.trigger
        _directMap[combination + ':' + action] = callback;

        // make sure multiple spaces in a row become a single space
        combination = combination.replace(/\s+/g, ' ');

        var sequence = combination.split(' '),
            info;

        // if this pattern is a sequence of keys then run through this method
        // to reprocess each pattern one key at a time
        if (sequence.length > 1) {
            _bindSequence(combination, sequence, callback, action);
            return;
        }

        info = _getKeyInfo(combination, action);

        // make sure to initialize array if this is the first time
        // a callback is added for this key
        _callbacks[info.key] = _callbacks[info.key] || [];

        // remove an existing match if there is one
        _getMatches(info.key, info.modifiers, {type: info.action}, sequenceName, combination, level);

        // add this call back to the array
        // if it is a sequence put it at the beginning
        // if not put it at the end
        //
        // this is important because the way these are processed expects
        // the sequence ones to come first
        _callbacks[info.key][sequenceName ? 'unshift' : 'push']({
            callback: callback,
            modifiers: info.modifiers,
            action: info.action,
            seq: sequenceName,
            level: level,
            combo: combination
        });
    }

    /**
     * binds multiple combinations to the same callback
     *
     * @param {Array} combinations
     * @param {Function} callback
     * @param {string|undefined} action
     * @returns void
     */
    function _bindMultiple(combinations, callback, action) {
        for (var i = 0; i < combinations.length; ++i) {
            _bindSingle(combinations[i], callback, action);
        }
    }

    // start!
    _addEvent(document, 'keypress', _handleKeyEvent);
    _addEvent(document, 'keydown', _handleKeyEvent);
    _addEvent(document, 'keyup', _handleKeyEvent);

    var Mousetrap = {

        /**
         * binds an event to mousetrap
         *
         * can be a single key, a combination of keys separated with +,
         * an array of keys, or a sequence of keys separated by spaces
         *
         * be sure to list the modifier keys first to make sure that the
         * correct key ends up getting bound (the last key in the pattern)
         *
         * @param {string|Array} keys
         * @param {Function} callback
         * @param {string=} action - 'keypress', 'keydown', or 'keyup'
         * @returns void
         */
        bind: function(keys, callback, action) {
            keys = keys instanceof Array ? keys : [keys];
            _bindMultiple(keys, callback, action);
            return this;
        },

        /**
         * unbinds an event to mousetrap
         *
         * the unbinding sets the callback function of the specified key combo
         * to an empty function and deletes the corresponding key in the
         * _directMap dict.
         *
         * TODO: actually remove this from the _callbacks dictionary instead
         * of binding an empty function
         *
         * the keycombo+action has to be exactly the same as
         * it was defined in the bind method
         *
         * @param {string|Array} keys
         * @param {string} action
         * @returns void
         */
        unbind: function(keys, action) {
            return Mousetrap.bind(keys, function() {}, action);
        },

        /**
         * triggers an event that has already been bound
         *
         * @param {string} keys
         * @param {string=} action
         * @returns void
         */
        trigger: function(keys, action) {
            if (_directMap[keys + ':' + action]) {
                _directMap[keys + ':' + action]({}, keys);
            }
            return this;
        },

        /**
         * resets the library back to its initial state.  this is useful
         * if you want to clear out the current keyboard shortcuts and bind
         * new ones - for example if you switch to another page
         *
         * @returns void
         */
        reset: function() {
            _callbacks = {};
            _directMap = {};
            return this;
        },

       /**
        * should we stop this event before firing off callbacks
        *
        * @param {Event} e
        * @param {Element} element
        * @return {boolean}
        */
        stopCallback: function(e, element) {

            // if the element has the class "mousetrap" then no need to stop
            if ((' ' + element.className + ' ').indexOf(' mousetrap ') > -1) {
                return false;
            }

            // stop for input, select, and textarea
            return element.tagName == 'INPUT' || element.tagName == 'SELECT' || element.tagName == 'TEXTAREA' || element.isContentEditable;
        },

        /**
         * exposes _handleKey publicly so it can be overwritten by extensions
         */
        handleKey: _handleKey
    };

    // expose mousetrap to the global object
    window.Mousetrap = Mousetrap;

    // expose mousetrap as an AMD module
    if (typeof define === 'function' && define.amd) {
        define('mousetrap',Mousetrap);
    }
}) (window, document);

define('shortcuts/shortcuts',[
  'jquery',
  'mousetrap',
  'global/global__modules'
], function($, mousetrap,  Module) {
  

  var MODULE = 'shortcuts';
  var ROOT_SCOPE = 'ROOT';
  var ALLOW_SHORTCUTS_SELECTOR = '.ring-js-shortcuts';

  var scopes = {};
  var scopeChain;

  var dispatcher = function(e, key) {
    var currentScope;

    for (var i = scopeChain.length - 1; i >= 0; i--) {
      currentScope = scopes[scopeChain[i]];

      if (currentScope && currentScope[key]) {
        var ret = currentScope[key](e, key, scopeChain[i]);

        // Fall down in chain when returning true
        if (ret !== true) {
          return ret;
        }
      }
    }
  };


  /**
   * Binds events to key
   *
   * @params Event params
   * @params.key {string | Array.<string>) Keys to bind
   * @params.handler {Function} Events handle
   * @params.scope {string} Scope (optional)
   * @params.type {string} Event type, will be passed to Mousetrap (optional)
   */
  var bind = function(params) {
    if (params == null || typeof params.handler !== 'function') {
      return;
    }

    if (!params.scope) {
      params.scope = ROOT_SCOPE;
    }

    if ($.isArray(params.key)) {
      $.each(params.key, function(i, key) {
        var prm = $.extend({}, params, {key: key});
        bind(prm);
      });

      return;
    }

    if (typeof params.key !== 'string') {
      return;
    }

    scopes[params.scope] = scopes[params.scope] || {};
    scopes[params.scope][params.key] = params.handler;

    mousetrap.bind(params.key, dispatcher, params.type);
  };

  /**
   * Binds events list to keys
   *
   * @params Event params
   * @params.handler {Function} Events handle
   * @params.scope {string} Scope (optional)
   * @params.type {string} Event type, will be passed to Mousetrap (optional)
   * @params.list {Object) Keys to handlers map
   */
  var bindList = function(options, list) {
    if (list === undefined) {
      list = options;
    }

    $.each(list, function(key, handler) {
      bind($.extend({}, options, {key: key, handler: handler}));
    });
  };

  var unBindList = function(scope) {
    scopes[scope] = null;
  };

  var getScope = function() {
    return scopeChain.slice(1);
  };

  var pushScope = function(scope) {
    if (scope) {
      var position = $.inArray(scope, scopeChain);

      if (position !== -1) {
        scopeChain.splice(position, 1);
      }

      scopeChain.push(scope);
    }
  };

  var popScope = function(scope) {
    if (scope) {
      var position = $.inArray(scope, scopeChain);

      if (position !== -1) {
        scopeChain.length = position;
      }
    }
  };

  var spliceScope = function(scope) {
    if (scope) {
      var position = $.inArray(scope, scopeChain);

      if (position !== -1) {
        scopeChain.splice(position, 1);
      }
    }
  };

  var setScope = function(scope) {
    if (scope) {
      if (typeof scope === 'string') {
        scope = [scope];
      }

      if (!$.isArray(scope)) {
        return;
      }

      scopeChain = [ROOT_SCOPE].concat(scope);
    } else {
      scopeChain = [ROOT_SCOPE];
    }
  };

  var hasKey = function(key, scope) {
    return !!(scopes[scope] && scopes[scope][key]);
  };

  var defaultFilter = function(e, element/*, key*/) {
    var $element = $(element);

    // if the element or its parents have the class "ring-js-shortcuts" then no need to stop
    if ($element.is(ALLOW_SHORTCUTS_SELECTOR) || $element.closest(ALLOW_SHORTCUTS_SELECTOR).length) {
      return false;
    }

    // stop for input, select, and textarea
    return $element.is(':input:not(:button)') || (element.contentEditable && element.contentEditable === 'true');
  };

  var setFilter = function(fn) {
    mousetrap.stopCallback = typeof fn === 'function' ? fn : defaultFilter;
  };

  // Set defaults on start
  setFilter();
  setScope();

  // Public methods
  Module.add(MODULE, {
    bind: bind,
    bindList: bindList,
    unBindList: unBindList,
    trigger: {
      method: mousetrap.trigger,
      override: true
    },
    hasKey: {
      method: hasKey,
      override: true
    },
    getScope: {
      method: getScope,
      override: true
    },
    setScope: setScope,
    pushScope: pushScope,
    popScope: popScope,
    spliceScope: spliceScope,
    setFilter: setFilter
  });

});
define('dropdown/_dropdown.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, helper, options, functionType="function", escapeExpression=this.escapeExpression, self=this, helperMissing=helpers.helperMissing, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "";
  buffer += " ring-dropdown_"
    + escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  return buffer;
  }

function program3(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  buffer += " ";
  stack1 = (helper = helpers.ifEqual || (depth0 && depth0.ifEqual),options={hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data},helper ? helper.call(depth0, depth0, "typed", options) : helperMissing.call(depth0, "ifEqual", depth0, "typed", options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program4(depth0,data) {
  
  
  return " <span class=\"ring-dropdown__item ring-dropdown__item_hint\"> <span class=\"ring-dropdown__item__type\"></span> <span class=\"ring-dropdown__item__content\">Use ↩ to complete selected item</span> </span> ";
  }

  buffer += "<div class=\"ring-dropdown";
  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.type) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.type) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"> <div class=\"ring-dropdown__i\"> ";
  if (helper = helpers.html) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.html); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  stack1 = self.invokePartial(partials.dropdown__items, 'dropdown__items', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </div> ";
  options={hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data}
  if (helper = helpers.type) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.type) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </div> </div>";
  return buffer;
  }));

});
define('dropdown/_dropdown__class.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown__class", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, helper, options, self=this, helperMissing=helpers.helperMissing, functionType="function", blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  
  return "ring-dropdown__item_action";
  }

function program3(depth0,data) {
  
  
  return "ring-link";
  }

function program5(depth0,data) {
  
  
  return " ring-dropdown__item_error";
  }

  buffer += "ring-dropdown__item";
  stack1 = self.invokePartial(partials.global__class, 'global__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  stack1 = (helper = helpers.ifOr || (depth0 && depth0.ifOr),options={hash:{},inverse:self.program(3, program3, data),fn:self.program(1, program1, data),data:data},helper ? helper.call(depth0, (depth0 && depth0.action), (depth0 && depth0.type), options) : helperMissing.call(depth0, "ifOr", (depth0 && depth0.action), (depth0 && depth0.type), options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  options={hash:{},inverse:self.noop,fn:self.program(5, program5, data),data:data}
  if (helper = helpers.error) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.error); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.error) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(5, program5, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }));

});
define('dropdown/_dropdown__items.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown__items", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var stack1, helper, options, self=this, functionType="function", escapeExpression=this.escapeExpression, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = ((stack1 = (typeof depth0 === functionType ? depth0.apply(depth0) : depth0)),blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(2, program2, data),data:data}));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program2(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.separator), {hash:{},inverse:self.program(5, program5, data),fn:self.program(3, program3, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program3(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = self.invokePartial(partials.dropdown__separator, 'dropdown__separator', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }

function program5(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.type), {hash:{},inverse:self.program(8, program8, data),fn:self.program(6, program6, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program6(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <span class=\"";
  stack1 = self.invokePartial(partials.dropdown__class, 'dropdown__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\" ";
  stack1 = self.invokePartial(partials.global__attributes, 'global__attributes', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "> <span class=\"ring-dropdown__item__type\">";
  if (helper = helpers.type) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "</span> <span class=\"ring-dropdown__item__content\">";
  stack1 = self.invokePartial(partials.dropdown__content, 'dropdown__content', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "</span> </span> ";
  return buffer;
  }

function program8(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.url), {hash:{},inverse:self.program(11, program11, data),fn:self.program(9, program9, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program9(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <a class=\"";
  stack1 = self.invokePartial(partials.dropdown__class, 'dropdown__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\" href=\"";
  if (helper = helpers.url) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.url); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\" ";
  stack1 = self.invokePartial(partials.global__attributes, 'global__attributes', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += ">";
  stack1 = self.invokePartial(partials.dropdown__content, 'dropdown__content', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "</a> ";
  return buffer;
  }

function program11(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " <span class=\"";
  stack1 = self.invokePartial(partials.dropdown__class, 'dropdown__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\" ";
  stack1 = self.invokePartial(partials.global__attributes, 'global__attributes', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += ">";
  stack1 = self.invokePartial(partials.dropdown__content, 'dropdown__content', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "</span> ";
  return buffer;
  }

  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.items) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.items); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.items) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }));

});
define('dropdown/_dropdown__content.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown__content", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var stack1, helper, options, functionType="function", escapeExpression=this.escapeExpression, self=this, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var stack1;
  stack1 = (typeof depth0 === functionType ? depth0.apply(depth0) : depth0);
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }

function program3(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  options={hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}
  if (helper = helpers.image) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.image); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.image) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  options={hash:{},inverse:self.noop,fn:self.program(6, program6, data),data:data}
  if (helper = helpers.label) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.label); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.label) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(6, program6, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }
function program4(depth0,data) {
  
  var buffer = "";
  buffer += "<img class=\"ring-dropdown__image\" src=\""
    + escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0))
    + "\">";
  return buffer;
  }

function program6(depth0,data) {
  
  var stack1;
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.type), {hash:{},inverse:self.program(9, program9, data),fn:self.program(7, program7, data),data:data});
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }
function program7(depth0,data) {
  
  var buffer = "", stack1;
  buffer += "<span class=\"ring-dropdown__"
    + escapeExpression(((stack1 = (depth0 && depth0.type)),typeof stack1 === functionType ? stack1.apply(depth0) : stack1))
    + "\">"
    + escapeExpression(((stack1 = (depth0 && depth0.label)),typeof stack1 === functionType ? stack1.apply(depth0) : stack1))
    + "</span>";
  return buffer;
  }

function program9(depth0,data) {
  
  
  return escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  }

  options={hash:{},inverse:self.program(3, program3, data),fn:self.program(1, program1, data),data:data}
  if (helper = helpers.html) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.html); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.html) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.program(3, program3, data),fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }));

});
define('dropdown/_dropdown__separator.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown__separator", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  


  return "<span class=\"ring-dropdown__separator\"> </span>";
  }));

});
define('dropdown/dropdown',[
  'jquery',
  'global/global__views',
  'global/global__modules',
  'global/global__events',
  'global/global__utils',
  'shortcuts/shortcuts',
  'dropdown/_dropdown.hbs',
  'dropdown/_dropdown__class.hbs',
  'dropdown/_dropdown__items.hbs',
  'dropdown/_dropdown__content.hbs',
  'dropdown/_dropdown__separator.hbs'
], function ($, View, Module, events, utils) {
  

  var COMPONENT_SELECTOR = '.ring-js-dropdown';
  var TOGGLE_SELECTOR = '.ring-dropdown-toggle';
  var ITEM_ACTION_SELECTOR = '.ring-dropdown__item_action';
  var MENU_ITEM_SELECTOR = '.ring-menu__item';
  var ROOT_SELECTOR = '.ring-dropdown';
  var INNER_SELECTOR = '.ring-dropdown__i';

  var ACTIVE_CLASS = 'active';
  var ACTIVE_SELECTOR = '.active';

  var $global = $(window);
  var $body;
  var $dropdown;
  var previousTarget;
  var preventRemove = false;

  var DROPDOWN_MIN_RIGHT_MARGIN = 8;
  var DROPDOWN_BORDER_WIDTH = 2;

  var MODULE = 'dropdown';
  var shortcuts = Module.get('shortcuts');

  var create = function (data, config) {
    var $target;
    var dropdown = Module.get(MODULE);

    if (typeof config === 'object' && !(config instanceof $) && !utils.isNode(config)) {
      $target = config.target;
    } else {
      $target = config;
      config = {};
    }

    if (utils.isNode($target) || typeof $target === 'string') {
      $target = $($target);
    }

    preventRemove = config.preventRemove;

    var currentTarget = $target && $target[0];
    var sameTarget = (currentTarget && previousTarget === currentTarget);

    if (!data) {
      data = $target.data('ring-dropdown');
    }

    remove();

    if (!data || sameTarget || !$target && (!config.left || !config.top)) {
      dropdown.trigger('show:fail');
      return true;
    }

    previousTarget = currentTarget;

    if (data instanceof $ || utils.isNode(data)) {
      $dropdown = $(View.render(MODULE, ''));

      $dropdown.find(INNER_SELECTOR).append(data);
    } else {

      if ($.isArray(data)) {
        data = {items: data};
      }

      if (typeof data === 'string') {
        data = {html: data};
      }

      $dropdown = $(View.render(MODULE, data));
    }

    if (!$body) {
      $body = $('body');
    }

    $dropdown.appendTo($body);

    var params;
    var targetInput = typeof data === 'object' && ($.isArray(data.type) && $.inArray(data.type, 'bound') || data.type === 'bound');

    if (previousTarget) {
      var menuToggle;
      var targetToggle = $target.is(TOGGLE_SELECTOR);
      if (targetToggle && $target.prev().is(MENU_ITEM_SELECTOR)) {
        menuToggle = true;
        $target = $target.prev();
      }

      params = $target.offset();
      var targetCenter = params.left + $target.outerWidth() / 2;
      var targetWidth = targetInput ? $target.outerWidth() : $target.width();

      var dropdownWidth = $dropdown.width();
      var dropdownCenter = dropdownWidth / 2;

      // Right aligment
      if (params.left + dropdownWidth > $global.width() - DROPDOWN_MIN_RIGHT_MARGIN) {
        params.left += targetWidth - dropdownWidth;

        // Center aligment on toggle without menu item
      } else if (targetCenter >= dropdownCenter && targetToggle && !menuToggle) {
        params.left = targetCenter - dropdownCenter;
      }

      params.top += $target.outerHeight();

      if (typeof config.left === 'number') {
        params.left = config.left;
      }

      if (typeof config.top === 'number') {
        params.top = config.top;
      }

      if (config.width) {
        params.width = config.width;
      } else if (dropdownWidth < targetWidth) {
        params.width = targetWidth - DROPDOWN_BORDER_WIDTH;
      }

    } else {
      params = config;
    }

    $dropdown
      .css(params)
      // Using delegate because of compatibility with YouTrack's jQuery 1.5.1
      .delegate(ITEM_ACTION_SELECTOR, 'mouseenter.ring-dropdown', function (e) {
        events.domEventHandler(e);

        $(e.currentTarget)
          .addClass(ACTIVE_CLASS)
          .siblings()
          .removeClass(ACTIVE_CLASS);
      })
      .delegate(ITEM_ACTION_SELECTOR, 'replace.ring-dropdown', function (e) {
        events.domEventHandler(e);
      });

    shortcuts('pushScope', MODULE);

    return false;
  };

  var remove = function () {
    if ($dropdown) {
      $dropdown.remove();
      $dropdown = null;

      previousTarget = null;

      Module.get(MODULE).trigger('hide:done');
      shortcuts('popScope', MODULE);
    } else {
      Module.get(MODULE).trigger('hide:fail');
    }
  };

  var navigate = function (e, key) {
    var up = (key === 'up');

    var $active = $dropdown.find(ACTIVE_SELECTOR);
    var $next = $active[up ? 'prev' : 'next']();

    $active.removeClass(ACTIVE_CLASS);

    if ($next.length) {
      $next.addClass(ACTIVE_CLASS);
    } else {
      $dropdown.find(ITEM_ACTION_SELECTOR)[up ? 'last' : 'first']().addClass(ACTIVE_CLASS);
    }

    return false;
  };

  var action = function (e, key) {
    var $active = $dropdown.find(ACTIVE_SELECTOR);

    if ($active.length) {
      $active.trigger(key === 'enter' ? 'click' : 'replace');
      return false;
    } else {
      return true;
    }
  };

  // Using delegate because of compatibility with YouTrack's jQuery 1.5.1
  $(document).delegate('*', 'click.ring-dropdown', function (e) {
    var $target = $(e.currentTarget).closest(COMPONENT_SELECTOR);

    if ($target.length) {
      return create(null, $target);
    } else {
      if ($dropdown && !preventRemove || !$(e.currentTarget).closest(ROOT_SELECTOR).length) {
        remove();
      }
    }
  });

  // Remove on resize
  $global.resize(remove);

  // Bind keys
  shortcuts('bindList', {scope: MODULE}, {
    'esc': remove,
    'enter': action,
    'tab': action,
    'up': navigate,
    'down': navigate
  });

  // Public methods
  Module.add(MODULE, {
    show: {
      method: create,
      override: true
    },
    hide: {
      method: remove,
      override: true
    }
  });
});
define('menu/_menu.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("menu", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, helper, options, functionType="function", escapeExpression=this.escapeExpression, self=this, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "";
  buffer += " ring-menu_"
    + escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  return buffer;
  }

function program3(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  buffer += " <span class=\"ring-menu__spacer\"></span> ";
  options={hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}
  if (helper = helpers.left) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.left); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.left) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program4(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = self.invokePartial(partials.menu__item, 'menu__item', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }

  buffer += "<div class=\"ring-menu";
  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.type) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.type) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"> <span class=\"ring-menu__background\"></span> <div class=\"ring-menu__i";
  stack1 = self.invokePartial(partials.global__class, 'global__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"> ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.left), {hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " <div class=\"ring-menu__right\"> <span class=\"ring-menu__spacer\"></span> ";
  options={hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}
  if (helper = helpers.right) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.right); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.right) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </div> </div> </div>";
  return buffer;
  }));

});
define('menu/_menu__item.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("menu__item", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var stack1, self=this, functionType="function", escapeExpression=this.escapeExpression, helperMissing=helpers.helperMissing, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  buffer += "  ";
  options={hash:{},inverse:self.program(5, program5, data),fn:self.programWithDepth(2, program2, data, depth0),data:data}
  if (helper = helpers.html) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.html); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.html) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.program(5, program5, data),fn:self.programWithDepth(2, program2, data, depth0),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  stack1 = self.invokePartial(partials['dropdown-toggle'], 'dropdown-toggle', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  stack1 = self.invokePartial(partials.menu__counter, 'menu__counter', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program2(depth0,data,depth1) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = helpers['with'].call(depth0, depth1, {hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program3(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += "  <span class=\"";
  stack1 = self.invokePartial(partials.menu__item__class, 'menu__item__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"> ";
  if (helper = helpers.html) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.html); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </span> ";
  return buffer;
  }

function program5(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  buffer += " ";
  stack1 = (helper = helpers.ifEqual || (depth0 && depth0.ifEqual),options={hash:{},inverse:self.program(8, program8, data),fn:self.program(6, program6, data),data:data},helper ? helper.call(depth0, (depth0 && depth0.type), "button", options) : helperMissing.call(depth0, "ifEqual", (depth0 && depth0.type), "button", options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program6(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = self.invokePartial(partials.btn__group, 'btn__group', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }

function program8(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  buffer += "  ";
  stack1 = (helper = helpers.ifEqual || (depth0 && depth0.ifEqual),options={hash:{},inverse:self.program(11, program11, data),fn:self.program(9, program9, data),data:data},helper ? helper.call(depth0, (depth0 && depth0.type), "search", options) : helperMissing.call(depth0, "ifEqual", (depth0 && depth0.type), "search", options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program9(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <form action=\"";
  if (helper = helpers.action) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.action); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\" class=\"ring-menu__item ring-menu__search\"> <div class=\"ring-input_wrapper\"> <input class=\"ring-menu__search__input ring-input ring-input_icon";
  stack1 = self.invokePartial(partials.global__class, 'global__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\" type=\"text\" placeholder=\"placeholder\"> <span class=\"ring-font-icon_search ring-font-icon ring-input_icon__span\"></span> </div> </form>  ";
  return buffer;
  }

function program11(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <a href=\"";
  if (helper = helpers.url) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.url); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\" class=\"ring-link";
  stack1 = self.invokePartial(partials.menu__item__class, 'menu__item__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = self.invokePartial(partials.dropdown__component, 'dropdown__component', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"";
  stack1 = self.invokePartial(partials.global__attributes, 'global__attributes', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "> ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.image), {hash:{},inverse:self.program(14, program14, data),fn:self.program(12, program12, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </a> ";
  return buffer;
  }
function program12(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <img class=\"ring-menu__logo__img\" src=\"";
  if (helper = helpers.image) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.image); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\"/> ";
  return buffer;
  }

function program14(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <span class=\"ring-menu__item__i";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.type), {hash:{},inverse:self.noop,fn:self.program(15, program15, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\">";
  if (helper = helpers.label) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.label); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "</span> ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.typeAfter), {hash:{},inverse:self.noop,fn:self.program(17, program17, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program15(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " ring-font-icon ring-font-icon_";
  if (helper = helpers.type) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1);
  return buffer;
  }

function program17(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += "<span class=\"ring-font-icon ring-font-icon_";
  if (helper = helpers.typeAfter) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.typeAfter); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\"></span>";
  return buffer;
  }

  stack1 = ((stack1 = (typeof depth0 === functionType ? depth0.apply(depth0) : depth0)),blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}));
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }));

});
define('menu/_menu__item__class.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("menu__item__class", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, helper, self=this, functionType="function", escapeExpression=this.escapeExpression;

function program1(depth0,data) {
  
  
  return " ring-menu__item_active";
  }

function program3(depth0,data) {
  
  
  return "ring-menu__logo";
  }

function program5(depth0,data) {
  
  
  return "ring-menu__item";
  }

function program7(depth0,data) {
  
  
  return " ring-menu__item_icon";
  }

  stack1 = helpers['if'].call(depth0, (depth0 && depth0.active), {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.image), {hash:{},inverse:self.program(5, program5, data),fn:self.program(3, program3, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.type), {hash:{},inverse:self.noop,fn:self.program(7, program7, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ring-menu__id_";
  if (helper = helpers.key) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.key); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1);
  stack1 = self.invokePartial(partials.global__class, 'global__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }));

});
define('menu/_menu__counter.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("menu__counter", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var stack1, helper, options, self=this, functionType="function", escapeExpression=this.escapeExpression, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <span class=\"ring-plate ring-menu__item__counter ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.attention), {hash:{},inverse:self.program(4, program4, data),fn:self.program(2, program2, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\">";
  if (helper = helpers.label) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.label); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "</span> ";
  return buffer;
  }
function program2(depth0,data) {
  
  
  return "ring-plate_red";
  }

function program4(depth0,data) {
  
  
  return "ring-plate_blue";
  }

  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.counter) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.counter); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.counter) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }));

});
define('dropdown-toggle/_dropdown-toggle.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown-toggle", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var stack1, helper, options, self=this, functionType="function", blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " <span class=\"ring-dropdown-toggle ring-font-icon ring-font-icon_caret-down";
  stack1 = self.invokePartial(partials.global__class, 'global__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = self.invokePartial(partials.dropdown__component, 'dropdown__component', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"";
  stack1 = self.invokePartial(partials.global__attributes, 'global__attributes', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "></span> ";
  return buffer;
  }

  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.toggle) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.toggle); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.toggle) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }));

});
define('dropdown/_dropdown__component.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown__component", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var buffer = "", stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;

function program1(depth0,data) {
  
  var buffer = "", helper, options;
  buffer += " ring-menu__item_noselect ring-js-dropdown\" data-ring-dropdown=\""
    + escapeExpression((helper = helpers.stringify || (depth0 && depth0.stringify),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0.items), options) : helperMissing.call(depth0, "stringify", (depth0 && depth0.items), options)))
    + escapeExpression((helper = helpers.stringify || (depth0 && depth0.stringify),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0.dropdown), options) : helperMissing.call(depth0, "stringify", (depth0 && depth0.dropdown), options)))
    + "\"";
  return buffer;
  }

function program3(depth0,data) {
  
  var buffer = "", helper, options;
  buffer += " ring-menu__item_noselect ring-js-action-list\" data-action-list=\""
    + escapeExpression((helper = helpers.stringify || (depth0 && depth0.stringify),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0.items), options) : helperMissing.call(depth0, "stringify", (depth0 && depth0.items), options)))
    + escapeExpression((helper = helpers.stringify || (depth0 && depth0.stringify),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0['action-list']), options) : helperMissing.call(depth0, "stringify", (depth0 && depth0['action-list']), options)));
  return buffer;
  }

function program5(depth0,data) {
  
  var buffer = "", helper, options;
  buffer += " ring-menu__item_noselect ring-js-dropdown-menu\" data-dropdown-menu=\""
    + escapeExpression((helper = helpers.stringify || (depth0 && depth0.stringify),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0.items), options) : helperMissing.call(depth0, "stringify", (depth0 && depth0.items), options)))
    + escapeExpression((helper = helpers.stringify || (depth0 && depth0.stringify),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0['dropdown-menu']), options) : helperMissing.call(depth0, "stringify", (depth0 && depth0['dropdown-menu']), options)));
  return buffer;
  }

  stack1 = (helper = helpers.ifOr || (depth0 && depth0.ifOr),options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data},helper ? helper.call(depth0, (depth0 && depth0.items), (depth0 && depth0.dropdown), options) : helperMissing.call(depth0, "ifOr", (depth0 && depth0.items), (depth0 && depth0.dropdown), options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = (helper = helpers.ifOr || (depth0 && depth0.ifOr),options={hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data},helper ? helper.call(depth0, (depth0 && depth0.items), (depth0 && depth0['action-list']), options) : helperMissing.call(depth0, "ifOr", (depth0 && depth0.items), (depth0 && depth0['action-list']), options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = (helper = helpers.ifOr || (depth0 && depth0.ifOr),options={hash:{},inverse:self.noop,fn:self.program(5, program5, data),data:data},helper ? helper.call(depth0, (depth0 && depth0.items), (depth0 && depth0['dropdown-menu']), options) : helperMissing.call(depth0, "ifOr", (depth0 && depth0.items), (depth0 && depth0['dropdown-menu']), options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }));

});
define('btn/_btn.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("btn", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, helper, options, functionType="function", escapeExpression=this.escapeExpression, self=this, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "";
  buffer += " ring-btn_"
    + escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  return buffer;
  }

function program3(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += "<span class=\"ring-font-icon ring-font-icon_type-after ring-font-icon_";
  if (helper = helpers.type) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\"></span>";
  return buffer;
  }

function program5(depth0,data) {
  
  var buffer = "", stack1, helper;
  if (helper = helpers.label) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.label); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1);
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.typeAfter), {hash:{},inverse:self.noop,fn:self.program(6, program6, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }
function program6(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += "<span class=\"ring-font-icon ring-font-icon_";
  if (helper = helpers.typeAfter) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.typeAfter); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\"></span>";
  return buffer;
  }

  buffer += "<button ";
  stack1 = self.invokePartial(partials.global__attributes, 'global__attributes', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " class=\"ring-btn";
  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.state) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.state); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.state) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = self.invokePartial(partials.global__class, 'global__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  stack1 = self.invokePartial(partials.dropdown__component, 'dropdown__component', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\">";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.type), {hash:{},inverse:self.program(5, program5, data),fn:self.program(3, program3, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "</button>";
  return buffer;
  }));

});
define('btn/_btn__group.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("btn__group", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, helper, options, self=this, functionType="function", blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  
  return " ring-menu__item";
  }

function program3(depth0,data) {
  
  var stack1;
  stack1 = self.invokePartial(partials.btn, 'btn', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }

  buffer += "<div class=\"ring-btn-group";
  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.type) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.type) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"> ";
  options={hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data}
  if (helper = helpers.button) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.button); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.button) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </div>";
  return buffer;
  }));

});
define('menu/menu',[
  'jquery',
  'global/global__modules',
  'global/global__views',
  'dropdown/dropdown',
  'menu/_menu.hbs',
  'menu/_menu__item.hbs',
  'menu/_menu__item__class.hbs',
  'menu/_menu__counter.hbs',
  'dropdown-toggle/_dropdown-toggle.hbs',
  'dropdown/_dropdown__component.hbs',
  'btn/_btn.hbs',
  'btn/_btn__group.hbs'
], function($, Module, View) {
  

  var ACTIVE_CLASS = 'ring-menu__item_active';
  var ACTIVE_SELECTOR =  '.' + ACTIVE_CLASS;

  var currentActivePath = '';
  var module = 'menu';

  var getActivePath = function(label, side) {
    var parts = label.split('.');

    if (parts.length === 1) {
      parts.unshift(side || 'left');
    }
    parts.push('active');

    return parts;
  };

  var getActivateSelector = function(parts) {
    var parentElem = parts[0] === 'left' ?  'i' : 'right';

    return '.ring-menu__' + parentElem + ' > .ring-menu__id_' + parts[1];
  };

  var sortByOrder = function(a, b) {
    return a.order - b.order;
  };

  // Turn order value into elements order
  var processItems = function(obj, name) {
    var items = [];
    var orderedItems = [];
    var item;

    for (var id in obj) {
      item = obj[id];

      if (item == null) {
        continue;
      }

      item.key = id;

      // Save current active path
      if (item.active) {
        currentActivePath = getActivePath(id, name).join('.');
      }

      if (item.order) {
        orderedItems.push(item);
      } else {
        items.push(item);
      }
    }

    if (orderedItems.length) {
      items = orderedItems
        .sort(sortByOrder)
        .concat(items);
    }

    return items;
  };

  var process = function(data) {
    if (data.left) {
      data.left = processItems(data.left, 'left');
    }

    if (data.right) {
      data.right = processItems(data.right, 'right');
    }

    return data;
  };

  var setActive = function(label) {
    var parts = getActivePath(label);
    var path = parts.join('.');

    if (currentActivePath === path) {
      return null;
    }

    var update = ['view', path, 1];

    if (currentActivePath) {
      update.push(currentActivePath, 0);
    }

    Module.get(module).update.apply(module, update);
    currentActivePath = path;

    $(ACTIVE_SELECTOR).removeClass(ACTIVE_CLASS);
    $(getActivateSelector(parts)).addClass(ACTIVE_CLASS);
  };

  var defaultElement = function() {
    return Module.has('header') ? '.ring-header' : 'body';
  };

  var defaultMethod = function() {
    return Module.has('header') ? 'after' : 'prepend';
  };

  Module.add(module, {
    init: function(data, element, method) {
      return View.init(module, element || defaultElement(), method || defaultMethod(), process, data);
    },
    update: View.update.bind(View, module),
    hide: View.hide.bind(View, module),
    show: View.show.bind(View, module),
    setActive: setActive
  });
});

define('footer/_footer.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("footer", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, helper, options, functionType="function", escapeExpression=this.escapeExpression, self=this, blockHelperMissing=helpers.blockHelperMissing, helperMissing=helpers.helperMissing;

function program1(depth0,data) {
  
  var buffer = "";
  buffer += " ring-footer_"
    + escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  return buffer;
  }

function program3(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  buffer += " ";
  stack1 = (helper = helpers.ifEqual || (depth0 && depth0.ifEqual),options={hash:{},inverse:self.program(6, program6, data),fn:self.program(4, program4, data),data:data},helper ? helper.call(depth0, (data == null || data === false ? data : data.key), "type", options) : helperMissing.call(depth0, "ifEqual", (data == null || data === false ? data : data.key), "type", options));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program4(depth0,data) {
  
  var buffer = "";
  return buffer;
  }

function program6(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " <div class=\"ring-footer__column ring-footer__column_"
    + escapeExpression(((stack1 = (data == null || data === false ? data : data.key)),typeof stack1 === functionType ? stack1.apply(depth0) : stack1))
    + "\"> <ul class=\"ring-footer__column__i\"> ";
  stack1 = ((stack1 = (typeof depth0 === functionType ? depth0.apply(depth0) : depth0)),blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(7, program7, data),data:data}));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </ul> </div> ";
  return buffer;
  }
function program7(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " <li class=\"ring-footer__line\"> ";
  stack1 = ((stack1 = (typeof depth0 === functionType ? depth0.apply(depth0) : depth0)),blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(8, program8, data),data:data}));
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </li> ";
  return buffer;
  }
function program8(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.url), {hash:{},inverse:self.program(11, program11, data),fn:self.program(9, program9, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }
function program9(depth0,data) {
  
  var buffer = "", stack1, helper;
  buffer += " <a class=\"ring-link";
  stack1 = self.invokePartial(partials.global__class, 'global__class', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\" ";
  stack1 = self.invokePartial(partials.global__attributes, 'global__attributes', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " href=\"";
  if (helper = helpers.url) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.url); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "\">";
  stack1 = self.invokePartial(partials.footer__item, 'footer__item', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "</a> ";
  return buffer;
  }

function program11(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = self.invokePartial(partials.footer__item, 'footer__item', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }

  buffer += "<div class=\"ring-footer";
  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.type) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.type) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"> ";
  stack1 = helpers.each.call(depth0, depth0, {hash:{},inverse:self.noop,fn:self.program(3, program3, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " </div>";
  return buffer;
  }));

});
define('footer/_footer__item.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("footer__item", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, functionType="function", self=this, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "", stack1, helper, options;
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.copyright), {hash:{},inverse:self.noop,fn:self.program(2, program2, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  options={hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}
  if (helper = helpers.label) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.label); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.label) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(4, program4, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  options={hash:{},inverse:self.noop,fn:self.program(6, program6, data),data:data}
  if (helper = helpers.middot) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.middot); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.middot) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(6, program6, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }
function program2(depth0,data) {
  
  var helper, options;
  return escapeExpression((helper = helpers.copyright || (depth0 && depth0.copyright),options={hash:{},data:data},helper ? helper.call(depth0, (depth0 && depth0.copyright), options) : helperMissing.call(depth0, "copyright", (depth0 && depth0.copyright), options)));
  }

function program4(depth0,data) {
  
  var buffer = "";
  buffer += " "
    + escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  return buffer;
  }

function program6(depth0,data) {
  
  
  return " · ";
  }

function program8(depth0,data) {
  
  
  return escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  }

  stack1 = (helper = helpers.ifOr || (depth0 && depth0.ifOr),options={hash:{},inverse:self.program(8, program8, data),fn:self.program(1, program1, data),data:data},helper ? helper.call(depth0, (depth0 && depth0.copyright), (depth0 && depth0.middot), (depth0 && depth0.label), options) : helperMissing.call(depth0, "ifOr", (depth0 && depth0.copyright), (depth0 && depth0.middot), (depth0 && depth0.label), options));
  if(stack1 || stack1 === 0) { return stack1; }
  else { return ''; }
  }));

});
define('footer/footer',[
  'jquery',
  'global/global__modules',
  'global/global__views',
  'footer/_footer.hbs',
  'footer/_footer__item.hbs'
], function($, Module, View) {
  

  var module = 'footer';

  Module.add(module, {
    init: function(data, element, method) {
      return View.init(module, element || null, method || null, {}, data || {});
    },
    update: View.update.bind(View, module)
  });

});

(function($) {
	function focus(target) {
		if (!document.activeElement || document.activeElement !== target) {
			target.focus();
		}
	}

  $.fn.caret = function(pos) {
    var target = this[0];
	var isContentEditable = target.contentEditable === 'true';
    //get
    if (arguments.length == 0) {
      //HTML5
      if (window.getSelection) {
        //contenteditable
        if (isContentEditable) {
          focus(target);
          var selection = window.getSelection();
          // Opera 12 check
          if (!selection.rangeCount) {
            return 0;
          }
          var range1 = selection.getRangeAt(0),
              range2 = range1.cloneRange();
          range2.selectNodeContents(target);
          range2.setEnd(range1.endContainer, range1.endOffset);
          return range2.toString().length;
        }
        //textarea
        return target.selectionStart;
      }
      //IE<9
      if (document.selection) {
        focus(target);
        //contenteditable
        if (isContentEditable) {
            var range1 = document.selection.createRange(),
                range2 = document.body.createTextRange();
            range2.moveToElementText(target);
            range2.setEndPoint('EndToEnd', range1);
            return range2.text.length;
        }
        //textarea
        var pos = 0,
            range = target.createTextRange(),
            range2 = document.selection.createRange().duplicate(),
            bookmark = range2.getBookmark();
        range.moveToBookmark(bookmark);
        while (range.moveStart('character', -1) !== 0) pos++;
        return pos;
      }
      //not supported
      return 0;
    }
    //set
    if (pos == -1)
      pos = this[isContentEditable? 'text' : 'val']().length;
    //HTML5
    if (window.getSelection) {
      //contenteditable
      if (isContentEditable) {
        focus(target);
        window.getSelection().collapse(target.firstChild, pos);
      }
      //textarea
      else
        target.setSelectionRange(pos, pos);
    }
    //IE<9
    else if (document.body.createTextRange) {
      var range = document.body.createTextRange();
      range.moveToElementText(target);
      range.moveStart('character', pos);
      range.collapse(true);
      range.select();
    }
    if (!isContentEditable)
      focus(target);
    return pos;
  }
})(jQuery);
define("jquery-caret", ["jquery"], function(){});

define('delayed-listener/delayed-listener',[
  'jquery',
  'global/global__views',
  'global/global__modules',
  'global/global__events',
  'global/global__utils',
  'jquery-caret'
], function ($, View, Module) {
  

  var MODULE = 'delayed-listener';
  var LISTEN_DELAY = 250;

  var init = function (config) {
    var $target = $(config.target);

    var position = {
      lastPolledCaretPosition: {},
      lastTriggeredCaretPosition: {},
      lastPolledValue: {},
      lastTriggeredValue: {}
    };

    var timeoutHandler;
    var preventLastTriggeredCaretPositionClean;

    if (!$target instanceof $) {
      Module.get(MODULE).trigger('init:fail');
    }

    var listenDelay = (config.listenDelay && !isNaN(config.listenDelay)) || LISTEN_DELAY;

    var startListen_ = function () {
      if (!preventLastTriggeredCaretPositionClean) {
        position.lastTriggeredCaretPosition = null;
        preventLastTriggeredCaretPositionClean = null;
      }
      position.lastPolledCaretPosition = null;
      timeoutHandler = setTimeout(pollCaretPosition_, listenDelay);
    };

    var stopListen_ = function (timeoutHandler) {
      if (timeoutHandler) {
        clearTimeout(timeoutHandler);
      }
    };

    $target.
      bind('focus.' + MODULE, function () {
        startListen_();
        Module.get(MODULE).trigger('focus-change focusin', true);
      }).
      bind('blur. ' + MODULE, function () {
        stopListen_(timeoutHandler);
        Module.get(MODULE).trigger('focus-change focusout', false);
      });

    if ($target.is(':focus')) {
      Module.get(MODULE).trigger('focus-change focusin', true);
      startListen_();
    }

    function pollCaretPosition_() {
      if (!$target.is(':focus')) {
        stopListen_(timeoutHandler);
        return false;
      }
      var caret = $target.caret();
      var value = $target.val() || $target.text();

      // If caret position changed during the last tick
      //   Then save it and wait for the next tick
      //   Else trigger caret-move-event
      if (position.lastPolledCaretPosition !== caret || position.lastPolledValue !== value) {
        position.lastPolledCaretPosition = caret;
        position.lastPolledValue = value;
      } else if (value !== position.lastTriggeredValue) {
        position.lastTriggeredCaretPosition = caret;
        position.lastTriggeredValue = value;
        _onDelayedChange({value: value, caret: caret});
      } else if (caret !== position.lastTriggeredCaretPosition) {
        position.lastTriggeredCaretPosition = caret;
        position.lastTriggeredValue = value;
        _onDelayedCaretMove({value: value, caret: caret});
      }

      timeoutHandler = setTimeout(pollCaretPosition_, listenDelay);
    }

    var _onDelayedCaretMove = function (data) {
      if (config.onDelayedCaretMove && typeof config.onDelayedCaretMove === 'function') {
        config.onDelayedCaretMove.call(null, data);
      }
      Module.get(MODULE).trigger('change:done', data);
    };

    var _onDelayedChange = function (data) {
      if (config.onDelayedChange && typeof config.onDelayedChange === 'function') {
        config.onDelayedChange.call(null, data);
      }
      Module.get(MODULE).trigger('change:done', data);
    };

    return {
      destroy: function () {
        $target.off(MODULE);
      },
      preventCaretPositionClean: function() {
        preventLastTriggeredCaretPositionClean = true;
      }
    };
  };

  var placeCaret = function (el) {
    if (!el[0]) {
      return;
    }

    el.focus();

    if (typeof window.getSelection !== 'undefined' && typeof document.createRange !== 'undefined') {
      var range = document.createRange();
      range.selectNodeContents(el[0]);
      range.collapse(false);
      var sel = window.getSelection();
      sel.removeAllRanges();
      sel.addRange(range);
    } else if (typeof document.body.createTextRange !== 'undefined') {
      var textRange = document.body.createTextRange();
      textRange.moveToElementText(el[0]);
      textRange.collapse(false);
      textRange.select();
    }
  };

  Module.add(MODULE, {
    init: {
      method: init,
      override: true
    },
    placeCaret: {
      method: placeCaret,
      override: true
    }
  });
});
define('popup/_popup.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("popup", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var buffer = "", stack1, helper, options, functionType="function", escapeExpression=this.escapeExpression, self=this, blockHelperMissing=helpers.blockHelperMissing;

function program1(depth0,data) {
  
  var buffer = "";
  buffer += " ring-dropdown_"
    + escapeExpression((typeof depth0 === functionType ? depth0.apply(depth0) : depth0));
  return buffer;
  }

  buffer += "<div class=\"ring-dropdown";
  options={hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}
  if (helper = helpers.type) { stack1 = helper.call(depth0, options); }
  else { helper = (depth0 && depth0.type); stack1 = typeof helper === functionType ? helper.call(depth0, options) : helper; }
  if (!helpers.type) { stack1 = blockHelperMissing.call(depth0, stack1, {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data}); }
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += "\"> <div class=\"ring-dropdown__i\"> <div class=\"transclude ring-loader\">Loading</div> </div> </div>";
  return buffer;
  }));

});
define('popup/popup',[
  'jquery',
  'global/global__views',
  'global/global__modules',
  'global/global__events',
  'global/global__utils',
  'popup/_popup.hbs'
], function ($, View, Module) {
  

  var CONTAINER_SELECTOR = '.ring-dropdown__i',
    MENU_ITEM_SELECTOR = '.ring-menu__item',
    TOGGLE_SELECTOR = '.ring-dropdown-toggle',
    WRAPPER_HOVER_CLASS = 'ring-js-hover',
    $global = $(window),
    $body = $('body'),
    $popup,
    DROPDOWN_MIN_RIGHT_MARGIN = 8,
    DROPDOWN_BORDER_WIDTH = 2,
    MODULE = 'popup';

  /**
   *
   * @param config
   * @returns { el: popup jQuery element, getPos: func for position }
   */
  var init = function (config) {
    var $target = $(config.target);

    if (!$target) {
      Module.get(MODULE).trigger('show:fail');
      return false;
    }

    if ($body && !$body.length) {
      $body = $('body');
    }

    remove();
    $popup = $(View.render(MODULE, config)).
      hover(function () {
        $(this).addClass(WRAPPER_HOVER_CLASS);
      },
      function () {
        $(this).removeClass(WRAPPER_HOVER_CLASS);
      });

    return {
      target: $target,
      el: $popup,
      getPos: _getPosition.bind(null, $target, $popup, config),
      insertHTML: insertHTML,
      appendHTML: appendHTML,
      updatePos: updatePos,
      showLoader: showLoader
    };
  };

  var remove = function (onScroll) {
    if ($popup) {
      if (onScroll && $popup.hasClass(WRAPPER_HOVER_CLASS)) {
        return false;
      }
      $popup.remove();
      $popup = null;

      Module.get(MODULE).trigger('hide:done');
    } else {
      Module.get(MODULE).trigger('hide:fail');
    }
  };

  /**
   * @param $target target DOM element
   * @param $popup jQuery popup element
   * @param config Optional css coords {top:X, left: Y}
   * @returns {Objetct} css coords
   */
  var _getPosition = function ($target, $popup, config) {
    var params,
      menuToggle,
      targetToggle,
      targetCenter,
      targetWidth,
      dropdownWidth,
      dropdownCenter;

    targetToggle = $target.is(TOGGLE_SELECTOR);
    if (targetToggle && $target.prev().is(MENU_ITEM_SELECTOR)) {
      menuToggle = true;
      $target = $target.prev();
    }
    params = $target.offset();
    targetCenter = params.left + $target.outerWidth() / 2;
    targetWidth = $target.outerWidth();

    dropdownWidth = $popup.width();
    dropdownCenter = dropdownWidth / 2;

    // Right aligment
    if (params.left + dropdownWidth > $global.width() - DROPDOWN_MIN_RIGHT_MARGIN) {
      params.left += targetWidth - dropdownWidth;

      // Center aligment on toggle without menu item
    } else if (targetCenter >= dropdownCenter && targetToggle && !menuToggle) {
      params.left = targetCenter - dropdownCenter;
    }

    params.top += $target.outerHeight();

    if (typeof config.left === 'number') {
      params.left = config.left;
    }

    if (typeof config.top === 'number') {
      params.top = config.top;
    }

    if (config.width) {
      params.width = config.width;
    } else if (dropdownWidth < targetWidth || config.limitWidth) {
      params.width = targetWidth - DROPDOWN_BORDER_WIDTH;
    }
    return params;
  };

  var insertHTML = function ($el) {
    $body.append(this.el);
    return this.el.
      find(CONTAINER_SELECTOR).
      html($el).
      parent().
      css(this.getPos());
  };

  var showLoader = function () {
    if (!$.contains(document, this.el[0])) {
      $body.append(this.el).find(CONTAINER_SELECTOR).
        parent().
        css(this.getPos());
    }
  };

  var appendHTML = function ($el) {
    if (!$.contains(document, this.el[0])) {
      $body.append(this.el).find(CONTAINER_SELECTOR).empty();
    }
    return this.el.
      find(CONTAINER_SELECTOR).
      empty().
      append($el).
      parent().
      css(this.getPos());
  };

  var updatePos = function() {
    return this.el.css(this.getPos());
  };

  // Remove on resize / scroll
  $global.
    resize(remove).
    scroll(function () {
      remove(true);
    });


  // Public methods
  Module.add(MODULE, {
    init: {
      method: init,
      override: true
    },
    remove: {
      method: remove,
      override: true
    }
  });
});
define('action-list/_action-list.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("action-list", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); partials = this.merge(partials, Handlebars.partials); data = data || {};
  var buffer = "", stack1, self=this;

function program1(depth0,data) {
  
  var buffer = "", stack1;
  buffer += " ";
  stack1 = self.invokePartial(partials.dropdown__description, 'dropdown__description', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  return buffer;
  }

  stack1 = self.invokePartial(partials.dropdown__items, 'dropdown__items', depth0, helpers, partials, data);
  if(stack1 || stack1 === 0) { buffer += stack1; }
  buffer += " ";
  stack1 = helpers['if'].call(depth0, (depth0 && depth0.description), {hash:{},inverse:self.noop,fn:self.program(1, program1, data),data:data});
  if(stack1 || stack1 === 0) { buffer += stack1; }
  return buffer;
  }));

});
define('dropdown/_dropdown__description.hbs',['handlebars'], function(Handlebars) {

Handlebars.registerPartial("dropdown__description", Handlebars.template(function (Handlebars,depth0,helpers,partials,data) {
  this.compilerInfo = [4,'>= 1.0.0'];
helpers = this.merge(helpers, Handlebars.helpers); data = data || {};
  var buffer = "", stack1, helper, functionType="function", escapeExpression=this.escapeExpression;


  buffer += "<span class=\"ring-dropdown__item ring-dropdown__item_hint\"> <span class=\"ring-dropdown__item__type\"></span> <span class=\"ring-dropdown__item__content\">";
  if (helper = helpers.description) { stack1 = helper.call(depth0, {hash:{},data:data}); }
  else { helper = (depth0 && depth0.description); stack1 = typeof helper === functionType ? helper.call(depth0, {hash:{},data:data}) : helper; }
  buffer += escapeExpression(stack1)
    + "</span> </span>";
  return buffer;
  }));

});
define('action-list/action-list',[
  'jquery',
  'global/global__views',
  'global/global__modules',
  'global/global__events',
  'shortcuts/shortcuts',
  'popup/popup',
  'action-list/_action-list.hbs',
  'dropdown/_dropdown__class.hbs',
  'dropdown/_dropdown__items.hbs',
  'dropdown/_dropdown__content.hbs',
  'dropdown/_dropdown__separator.hbs',
  'dropdown/_dropdown__description.hbs'
], function ($, View, Module, events) {
  

  var popup = Module.get('popup'),
    shortcuts = Module.get('shortcuts'),
    uid = 0;

  var MODULE = 'action-list',
    COMPONENT_SELECTOR = '.ring-js-action-list',
    CONTAINER_SELECTOR = '.ring-dropdown_' + MODULE,
    ITEM_ACTION_SELECTOR = '.ring-dropdown__item_action',
    ACTIVE_CLASS = 'active',
    ACTIVE_SELECTOR = '.active';


//  config = {
//    target:DOM,
//    type: [...,...]
//    items: [...]
//    focusTarget bool
//  }
  var init = function (config) {
    var wrapper,
      $el,
      items,
      isActive,
      actionList = Module.get(MODULE);

    var action_ = function () {
      if ($el === null) {
        return false;
      }
      var $active = $el.parent().find(ACTIVE_SELECTOR);

      if ($active.length) {
        var data = $active.data(events.EVENT_DATA_ATTR);

        actionList.trigger('check_' + uid, data && data[0] && data[0].data);

        return false;
      } else {
        return true;
      }
    };

    var getSelectedItemData = function () {
      if ($el === null) {
        return;
      }

      var data = $el.parent().find(ACTIVE_SELECTOR).data(events.EVENT_DATA_ATTR);

      return data && data[0] && data[0].data && data[0].data.data;
    };

    var navigate_ = function (e, key) {
      if ($el === null || isActive && !isActive()) {
        return false;
      }
      var up = (key === 'up'),
        $active = $el.parent().find(ITEM_ACTION_SELECTOR + ACTIVE_SELECTOR),
        $next = $active[up ? 'prev' : 'next'](ITEM_ACTION_SELECTOR);

      $active.removeClass(ACTIVE_CLASS);

      if (!$next.length) {
        $next = $el.parent().find(ITEM_ACTION_SELECTOR)[up ? 'last' : 'first']();
      }

      $next.addClass(ACTIVE_CLASS);
      // TODO Edge cases with mouse
      wrapper.el.scrollTop($next.position().top - wrapper.el.height() / 2);

      return false;
    };

    if (!config) {
      actionList.trigger('init:fail');
      return false;
    }

    if (config.dataSource && typeof config.dataSource === 'function') {
      dataSource = config.dataSource;
    }

    if (!config.items && config.target) {
      $.extend(config, $(config.target).data(MODULE));
    }

    if (config.type && $.isArray(config.type) && config.type.indexOf(MODULE) === -1) {
      config.type.push(MODULE);
    }

    if (config.isActive && typeof config.isActive === 'function') {
      isActive = config.isActive;
    }

    var keys;

    if (config.overrideNavigation) {
      keys = {};
    } else {
      keys = {
        'enter': action_,
        'up': navigate_,
        'down': navigate_
      };
    }
    uid += 1;
    shortcuts('bindList', {
      scope: MODULE
    }, keys);

    shortcuts('pushScope', MODULE);

    actionList.on('check_' + uid, function (data, evt) {
      remove();

      if (!data.error) {
        actionList.trigger('change_' + uid, data, evt);
      }
    });

    if (!config.target || !(config.target instanceof $)) {
      var renderData = $.extend(true, {}, config);

      $.each(renderData.items, function (index, item) {
        var itemData = $.extend(true, {}, item);

        if (!item.hasOwnProperty('action')) {
          item.action = true;
        }

        if (item.event !== false) {
          item.event = item.event || [];
          if (item.event instanceof Array === false) {
            item.event = [item.event];
          }
          item.event = [
            {
              'name': 'action-list:check_' + actionList('getUID'),
              'data': itemData
            }
          ];
        } else {
          item.action = false;
        }
      });

      actionList.trigger('show', config.items);
      $el = $(View.render('action-list', renderData));
      actionList.trigger('init:done_' + uid, $el);
      return $el;
    }
    wrapper = popup('init', config);

    dataSource(config).then(function (data) {
      var renderData = $.extend(true, {}, data);

      items = data.items;

      $.each(renderData.items, function (index, item) {
        var itemData = $.extend(true, {}, item);

        if (!item.hasOwnProperty('action')) {
          item.action = true;
        }

        if (item.event !== false && item.error !== true) {
          item.event = item.event || [];
          item.event.push({
            'name': 'action-list:check_' + actionList('getUID'),
            'data': itemData
          });
        } else {
          item.action = false;
        }

        if (item.error) {
          item.className = (item.className || '') + ' ring-dropdown__item_error';
        }
      });
      $el = $(View.render('action-list', renderData));
      actionList.trigger('show', renderData.items);
      wrapper.insertHTML($el);
      actionList.trigger('init:done_' + uid, $el);
    });

    $el.bind('mouseenter', function (e) {
      events.domEventHandler(e);

      $(e.currentTarget)
        .addClass(ACTIVE_CLASS)
        .siblings()
        .removeClass(ACTIVE_CLASS);
    });

    return {
      popup: wrapper,
      el: $el,
      getSelectedItemData: getSelectedItemData,
      setActive: function () {
        shortcuts('pushScope', MODULE);
      },
      getActiveItem: function () {
        var itemIndex;

        $.each($el, function () {
          if($(this).hasClass('active')) {
            itemIndex = $(this).index();
          }
        });

        return items[itemIndex] || null;
      },
      setActiveItem: function (index) {
        $el.removeClass('active');
        $($el[index]).addClass('active');
      }
    };
  };

  var dataSource = function (data) {
    var dfd = $.Deferred();

    dfd.resolve(data);

    return dfd.promise();
  };

  $(document).delegate('*', 'click' + COMPONENT_SELECTOR, function (e) {
    var $target = $(e.currentTarget).closest(COMPONENT_SELECTOR);

    if ($target.length) {
      init({
        target: $target,
        type: ['typed']
      });
      e.stopPropagation();
    } else {
      remove();
    }
  });

  var remove = function () {
    if ($(CONTAINER_SELECTOR).length) {
      shortcuts('spliceScope', MODULE);
      popup('remove');

      return true;
    }
  };

  Module.add(MODULE, {
    init: {
      method: init,
      override: true
    },
    remove: {
      method: remove,
      override: true
    },
    dataSource: {
      method: dataSource,
      override: true
    },
    getUID: {
      method: function () {
        return uid;
      },
      override: true
    }
  });
});
define('dropdown-select/dropdown-select',[
  'jquery',
  'global/global__modules',
  'global/global__utils',
  'global/global__views',
  'delayed-listener/delayed-listener',
  'action-list/action-list',
  'shortcuts/shortcuts'
], function ($, Module, utils, View) {
  

  var MODULE = 'dropdown-select';
  var RESULT_COUNT = 10;
  var LOADING_CLASS = 'ring-input_loading';
  var SELECT_ARROW_CLASS = 'ring-input_icon__span';
  var MODULE_SHORTCUTS = 'dropdown-select';
  var CONTAINER_CLASS = 'ring-dropdown-select__container';
  var ITEM_ACTION_SELECTOR = '.ring-dropdown__item_action';
  var ACTIVE_CLASS = 'active';
  var ITEM_ERROR_CLASS = 'ring-dropdown__item_error';
  var POPUP_CONTAINER_CLASS = 'ring-dropdown__i';

  var uid = 0;

  var popup = Module.get('popup');
  var actionList = Module.get('action-list');
  var shortcuts = Module.get('shortcuts');
  var delayedListener = Module.get('delayed-listener');

  var $document = $(document);
  var $window = $(window);

  /**
   * Creates Select on config.target element
   * @param {Object} config
   * @constructor
   */
  var Select = function (config) {
    if (!(this instanceof Select)) {
      return new Select(config);
    }
    var self = this;

    this.$target = $(config.target);
    this.type = ['bound'].concat(config.type);
    this.top = config.top || config.$top || RESULT_COUNT;
    this.limitWidth = config.limitWidth;
    this.skip_ = 0;
    this.description = config.description;
    this.dataSource = config.dataSource;
    this.onShow = config.onShow || $.noop;
    this.onHide = config.onHide || $.noop;
    this.onSelect = config.onSelect || $.noop;
    this.onChange = config.onChange || $.noop;
    this.onSubmit = config.onSubmit || $.noop;
    this.noErrors = false;

    if (this.type.indexOf('typed') !== -1) {
      this.type.push('typed-select');
      this.isTyped_ = true;
    }

    this.shortcutsUID_ = MODULE_SHORTCUTS + uid++;
    this.isDirty_ = false;
    this.wrapper_ = popup('init', {
      target: self.$target,
      type: self.type,
      width: self.limitWidth
    });
    this.$container_ = null;
    this.containerHeight_ = this.top * 24;
    this.top += 1;
    this.itemsCount_ = this.top;
    this.currentQuery_ = '';
    this.$body_ = $('body');
    this.activeItemIndex_ = 0;
    this.destroyHandler_ = $.proxy(this, 'destroy');

    this.$target.
      on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        self.$target.select();
      }).
      on('focus', function () {
        self.$target.addClass(LOADING_CLASS);
        shortcuts('pushScope', self.shortcutsUID_);
      }).
      on('blur', function () {
        self.$target.removeClass(LOADING_CLASS);
        shortcuts('spliceScope', self.shortcutsUID_);
      }).
      on('input', function () {
        self.isDirty_ = true;
      }).
      on('keyup', $.proxy(this, 'submitHandler'));

    this.$target.next('.' + SELECT_ARROW_CLASS).on('click', function () {
      self.$target.focus();
      self.$target.select();
    });

    shortcuts('bindList', {
      scope: self.shortcutsUID_
    }, {
      'esc': function (e) {
        e.preventDefault();
        return self.destroy();
      },
      'tab': function (e) {
        e.preventDefault();
      },
      'up': $.proxy(this, 'navigate'),
      'down': $.proxy(this, 'navigate')
    });

    delayedListener('init', {
      target: self.$target,
      onDelayedChange: function (data) {
        self.onChange(data.value);
        self.configureRequest(data.value);
      },
      onDelayedCaretMove: function (data) {
        self.configureRequest(data.value);
      }
    });
  };

  /**
   * Config request. By default should be empty request.
   * @param query {string}
   */
  Select.prototype.configureRequest = function (query) {
    if (!this.isDirty_) {
      query = '';
      this.isDirty_ = true;
    }

    this.$target.removeClass(LOADING_CLASS);
    if (this.value_ !== query) {
      this.requestData(query, this.top, this.skip_);
    }
  };

  /**
   * Invoke dataSource.
   * @param query {string}
   * @param top {number}
   * @param skip {number}
   */
  Select.prototype.requestData = function (query, top, skip) {
    var that = this;
    this.currentQuery_ = query;
    var typed = this.isTyped_;

    this.dataSource(query, top, skip).then(function (data) {
      if (data.length === 0) {
        data = [
          {
            action: false,
            error: true,
            label: 'No results'
          }
        ];

        if (typed) {
          data[0].type = 'error';
        }
      }
      that.renderComponent(data);
    }, $.proxy(that, 'errorHandler'));
  };

  /**
   * Initial render of the component. Also binding events.
   * @param data
   */
  Select.prototype.renderComponent = function (data) {
    if (!$.contains(this.$body_[0], this.wrapper_.el[0])) {
      this.$body_.append(this.wrapper_.el);
      this.onShow(true);
    }

    $window.on('resize scroll', this.destroyHandler_);
    $document.on('click ring.popup-close', this.destroyHandler_);
    this.visible_ = true;

    if (!this.$container_) {
      this.initContainer();
    } else {
      this.wrapper_.updatePos();
    }

    this.$container_.empty();

    var actionListElem = this.createActionList(data);

    actionListElem.on('mouseover', this.hoverHandler);

    this.$container_.append(actionListElem);
    $(actionListElem).siblings().eq(this.activeItemIndex_).addClass(ACTIVE_CLASS);
  };

  /**
   * Handle scroll event. Init items re-render.
   * @param e
   */
  Select.prototype.scrollHandler = function (e) {
    var $activeItem = this.$container_.find(ITEM_ACTION_SELECTOR + '.' + ACTIVE_CLASS);

    this.activeItemIndex_ = $activeItem.index();

    if ((this.$container_.get(0).scrollHeight - this.$container_.height()) - $(e.currentTarget).scrollTop() < 50) {
      this.itemsCount_ += this.top;
      this.requestData(this.currentQuery_, this.itemsCount_, this.skip_);
    }
  };

  /**
   * Handles item selection
   * @param value
   */
  Select.prototype.selectHandler = function (value) {
    this.value_ = value.label;
    this.onSelect(value);
  };


  /**
   * On item click handler. Emit onSelect(String)
   * @param e
   * @returns {boolean}
   */
  Select.prototype.clickHandler = function (e) {
    e.stopPropagation();

    var $el = $(e.target);

    if (this.type.indexOf('typed') !== -1) {
      $el = $el.parent();
    }

    if ($el.hasClass(ITEM_ERROR_CLASS)) {
      return false;
    }

    var item = this.getActiveItem();

    this.selectHandler(item);
    this.isDirty_ = true;
    this.$target.val(item.label);
    this.$target.focus();

    this.destroy();
  };

  /**
   * Submit handler for $target. Emit onSubmit(String) / selectHandler(Object)
   * @param e
   */
  Select.prototype.submitHandler = function (e) {
    if (e.keyCode === 13) {
      var activeItem = this.getActiveItem();

      if (!activeItem) {
        this.onSubmit(this.currentQuery_);
      } else {
        this.$target.val(activeItem.label);
        this.isDirty_ = true;
        this.selectHandler(activeItem);
      }

      this.destroy();
    }
  };

  /**
   * Override action-list default shortcuts. Scroll to active element.
   * @param e
   * @param key
   */
  Select.prototype.navigate = function (e, key) {
    if (this.$container_ === null) {
      return false;
    }
    var up = (key === 'up');
    var $active = this.$container_.parent().find(ITEM_ACTION_SELECTOR + '.' + ACTIVE_CLASS);
    var $next = $active[up ? 'prev' : 'next'](ITEM_ACTION_SELECTOR);
    var $container = (this.type.indexOf('typed') === -1)?this.$container_:this.wrapper_.el.find('.' + POPUP_CONTAINER_CLASS);

    $active.removeClass(ACTIVE_CLASS);

    if ($next.length) {
      if (($next.position().top >= $container.height()) || $next.position().top < 0) {
        $container.scrollTo($next);
      }
      $next.addClass(ACTIVE_CLASS);
    } else {
      $next = this.$container_.parent().find(ITEM_ACTION_SELECTOR)[up ? 'last' : 'first']();
      $next.addClass(ACTIVE_CLASS);
      $container.scrollTo($next);
    }

    e.preventDefault();
  };

  /**
   * Render action-list.
   * @param data
   * @returns {*}
   */
  Select.prototype.createActionList = function (data) {
    return actionList('init', {
      overrideNavigation: true,
      items: data
    });
  };

  /**
   * Set active state for items.
   */
  Select.prototype.hoverHandler = function () {
    $(this).siblings().each(function () {
      $(this).removeClass(ACTIVE_CLASS);
    });

    $(this).addClass(ACTIVE_CLASS);
  };

  /**
   * Return data from active item.
   * @returns {Object}
   */
  Select.prototype.getActiveItem = function () {
    if (!this.$container_) {
      return false;
    }

    var itemData = this.$container_.
      find('.' + ACTIVE_CLASS).
      data('ring-event');

    if (itemData && itemData.length && itemData[0] && itemData[0].data) {
      return itemData[0].data;
    }
  };

  /**
   * Reject handler for data source.
   */
  Select.prototype.errorHandler = function () {
    if (!this.noErrors) {
      var errorItem = [
        {
          action: false,
          error: true,
          label: 'Internal error'
        }
      ];
      errorItem.error = true;

      this.renderComponent(errorItem);
    }
  };

  /**
   * Init $container_ binding events.
   */
  Select.prototype.initContainer = function () {
    this.$container_ = $('<div class="' + CONTAINER_CLASS + '"></div>').
      on('click', $.proxy(this, 'clickHandler')).
      on('scroll', utils.throttle($.proxy(this, 'scrollHandler')));

    if (this.type.indexOf('typed') === -1) {
      this.$container_.css('max-height', this.containerHeight_);
    } else {
      this.wrapper_.el.find('.' + POPUP_CONTAINER_CLASS).css('max-height', this.containerHeight_);
    }

    this.wrapper_.appendHTML(this.$container_);

    if (this.description) {
      var $description = $(View.render('dropdown__description', {
        description: this.description
      }));

      if (this.type.indexOf('typed') === -1) {
        this.$container_.after($description);
      } else {
        this.wrapper_.el.find('.' + POPUP_CONTAINER_CLASS).after($description);
        this.wrapper_.el.find('.' + POPUP_CONTAINER_CLASS).
          on('scroll', utils.throttle($.proxy(this, 'scrollHandler')));
      }
    }
  };

  /**
   * Destroys bindings
   */
  Select.prototype.destroy = function () {
    if (this.wrapper_ && $.contains(this.$body_[0], this.wrapper_.el[0])) {
      this.wrapper_.el.detach();
      this.onHide();
    }

    $window.off('resize scroll', this.destroyHandler_);
    $document.off('click', this.destroyHandler_);

    if (this.visible_) {
      this.visible_ = false;

      return false;
    }

    return true;
  };

  /**
   * Data source factory for HUB entities.
   * @param remoteDataSourceConfig {object}
   * @returns {object} promise
   */
  var remoteDataSource = function (remoteDataSourceConfig) {
    var select = Module.get(MODULE);
    var auth = Module.get('auth');

    if (!remoteDataSourceConfig && (!remoteDataSourceConfig.hubResource || !remoteDataSourceConfig.url)) {
      select.trigger('init:fail');
      return false;
    }

    return function (query, $top) {
      var defer = $.Deferred();
      var restUrl = remoteDataSourceConfig.url;
      var substr = ['query', '$top'];
      var suggestArgs = [encodeURI(query)];

      substr.forEach(function (item, index) {
        restUrl = restUrl.replace('#{' + item  + '}', suggestArgs[index] ? suggestArgs[index] : '');
      });

      restUrl = restUrl + '&$top=' + ($top || RESULT_COUNT);

      auth('get', restUrl).then(function (data, state, jqXHR) {
        var items = [];
        if (data[remoteDataSourceConfig.hubResource]) {
          items = data[remoteDataSourceConfig.hubResource].map(function (val) {
            return {
              label: val.name
            };
          });
        }

        defer.resolve(items, state, jqXHR);
      }, function () {
        defer.reject(arguments[2]);
      });

      return defer.promise();
    };
  };

  Module.add(MODULE, {
    init: {
      method: Select,
      override: true
    },
    remoteDataSource: {
      method: remoteDataSource,
      override: true
    }
  });
});

define('ring',[
  'global/global',
  'menu/menu',
  'footer/footer',
  'dropdown-select/dropdown-select'
], function(ring) {
  return ring;
});
//The modules for your project will be inlined above
//this snippet. Ask almond to synchronously require the
//module value for 'main' here and return it as the
//value to use for the public API for the built file.
return require('ring');
}));
//# sourceMappingURL=youtrack-standalone.js.map