/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.complex.common;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.smartui.keyword.PluralUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.l10n.LocalizationService;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;

public class UniqueBundleNameUtil {
    private UniqueBundleNameUtil() {
    }

    public static String generateUniqueBundleName(Entity projectCustomField, Entity bundle2) {
        return UniqueBundleNameUtil.generateUniqueBundleName(AssociationSemantics.getToOne((Entity)projectCustomField, (String)"project"), ((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)projectCustomField, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getNamePresentation(AssociationSemantics.getToOne((Entity)projectCustomField, (String)"prototype")), bundle2);
    }

    public static String generateUniqueBundleName(Entity project2, String prototypeName, Entity bundle2) {
        String elementsName = EntityOperations.equals((Entity)bundle2, null) ? UniqueBundleNameUtil.nameFromPrototype(prototypeName) : (String)PrimitiveAssociationSemantics.get((Entity)bundle2, (String)"name", String.class, null);
        return UniqueBundleNameUtil.generateUniqueName(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UniqueBundleNameUtil.new_bundle_for_project_template", new Object[]{PrimitiveAssociationSemantics.get((Entity)project2, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()), elementsName}));
    }

    public static String nameFromPrototype(String prototypeName) {
        return ((LocalizationService)ServiceLocator.getBean((String)"localizationController")).isDefaultLocale() ? PluralUtil.getPlurals((String)prototypeName)[0] : prototypeName;
    }

    public static String generateUniqueName(String name) {
        return UniqueBundleNameUtil.generateUniqueName(new StringBuilder(name));
    }

    private static String generateUniqueName(StringBuilder name) {
        int originalLen = name.length();
        String generatedName = name.toString();
        int index = 1;
        while (!UniqueBundleNameUtil.isUniqueName(generatedName)) {
            name.setLength(originalLen);
            name.append(index++);
            generatedName = name.toString();
        }
        return name.toString();
    }

    private static boolean isUniqueName(String name) {
        return QueryOperations.isEmpty((Iterable)QueryOperations.query(null, (String)"Bundle", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name))));
    }
}

