/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.oldRest.enumeration;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.customfields.complex.common.RequireBundleIsAccessibleSecurityConstraint;
import jetbrains.charisma.customfields.oldRest.OldRestBundleServiceImplKt;
import jetbrains.charisma.customfields.oldRest.enumeration.EnumFieldBean;
import jetbrains.charisma.customfields.oldRest.enumeration.EnumFieldBundleBean;
import jetbrains.charisma.customfields.oldRest.enumeration.EnumFieldBundleRef;
import jetbrains.charisma.customfields.oldRest.enumeration.OldRestEnumsBundleResource;
import jetbrains.charisma.customfields.persistence.fields.XdEnumField;
import jetbrains.charisma.customfields.persistence.fields.XdEnumFieldsBundle;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.charisma.customfields.persistence.fields.XdFieldBundle;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.RequireAdminOrCreateProjectPermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.url.UrlUtil;

@Path(value="/admin/customfield/bundle")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u001e\u0010\u001a\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0007JQ\u0010\u001c\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J9\u0010$\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Ljetbrains/charisma/customfields/oldRest/enumeration/OldRestEnumsBundleResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteBundleName", "Ljavax/ws/rs/core/Response;", "bundleName", "", "deleteBundleNameFieldValue", "fieldValue", "get", "", "Ljetbrains/charisma/customfields/oldRest/enumeration/EnumFieldBundleRef;", "getBundle", "Ljetbrains/charisma/customfields/persistence/fields/XdEnumFieldsBundle;", "shouldExist", "", "getBundleName", "Ljetbrains/charisma/customfields/oldRest/enumeration/EnumFieldBundleBean;", "getBundleNameFieldValue", "Ljetbrains/charisma/customfields/oldRest/enumeration/EnumFieldBean;", "getField", "Ljetbrains/charisma/customfields/persistence/fields/XdEnumField;", "bundle", "getUrl", "Lwebr/framework/url/UrlUtil$Url;", "field", "postBundleName", "newName", "postBundleNameFieldValue", "newValue", "description", "localizedName", "colorIndex", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Ljavax/ws/rs/core/Response;", "put", "putBundleNameFieldValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Ljavax/ws/rs/core/Response;", "charisma-customfields"})
public final class OldRestEnumsBundleResource
implements Resource {
    @GET
    @NotNull
    public final List<EnumFieldBundleRef> get() {
        IsLoggedInSecurityConstraint.check();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)XdEnumFieldsBundle.Companion.all()), (Function1)get.1.INSTANCE));
    }

    @GET
    @Path(value="/{bundleName}")
    @NotNull
    public final EnumFieldBundleBean getBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireBundleIsAccessibleSecurityConstraint.check(bundleName);
        return new EnumFieldBundleBean(this.getBundle(bundleName, true));
    }

    /*
     * WARNING - void declaration
     */
    @PUT
    @Consumes(value={"application/xml"})
    @NotNull
    public final Response put(@NotNull EnumFieldBundleBean bundle2) {
        Intrinsics.checkParameterIsNotNull((Object)bundle2, (String)"bundle");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        String string = bundle2.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String bundleName = string;
        this.getBundle(bundleName, false);
        XdEnumFieldsBundle enumBundle2 = (XdEnumFieldsBundle)XdEnumFieldsBundle.Companion.new((Function1)new Function1<XdEnumFieldsBundle, Unit>(bundleName){
            final /* synthetic */ String $bundleName;

            public final void invoke(@NotNull XdEnumFieldsBundle $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setName(this.$bundleName);
            }
            {
                this.$bundleName = string;
                super(1);
            }
        });
        List<EnumFieldBean> list = bundle2.getValue();
        if (list != null) {
            Iterable $receiver$iv = list;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void buildBean;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                EnumFieldBean enumFieldBean = (EnumFieldBean)item$iv;
                int index = n2;
                XdEnumField.Companion.new((Function1)new Function1<XdEnumField, Unit>((EnumFieldBean)buildBean, index, enumBundle2){
                    final /* synthetic */ EnumFieldBean $buildBean;
                    final /* synthetic */ int $index;
                    final /* synthetic */ XdEnumFieldsBundle $enumBundle$inlined;
                    {
                        this.$buildBean = enumFieldBean;
                        this.$index = n;
                        this.$enumBundle$inlined = xdEnumFieldsBundle;
                        super(1);
                    }

                    public final void invoke(@NotNull XdEnumField $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                        String string = this.$buildBean.getValue();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        $receiver.setName(string);
                        $receiver.setBundle(this.$enumBundle$inlined);
                        $receiver.setDescription(this.$buildBean.getDescription());
                        Integer n = this.$buildBean.getColorIndex();
                        $receiver.setColorIndex(n != null ? n : 0);
                        $receiver.setOrdinal(this.$index);
                    }
                });
            }
        }
        Response response = ResponseUtil.created((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(enumBundle2));
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.created(old\u2026ervice.urlOf(enumBundle))");
        return response;
    }

    @POST
    @Path(value="/{bundleName}")
    @NotNull
    public final Response postBundleName(@PathParam(value="bundleName") @NotNull String bundleName, @QueryParam(value="newName") @Nullable String newName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdEnumFieldsBundle xdEnumFieldsBundle = this.getBundle(bundleName, true);
        if (xdEnumFieldsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdEnumFieldsBundle bundle2 = xdEnumFieldsBundle;
        ResponseUtil.isRequired((String)"newName", (String)newName);
        String oldName = bundle2.getName();
        if (Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            String string = newName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.getBundle(string, false);
            bundle2.setName(newName);
        }
        Response response = ResponseUtil.updated((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(bundle2), (String)oldName, (String)newName);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.updated(old\u2026undle), oldName, newName)");
        return response;
    }

    @DELETE
    @Path(value="/{bundleName}")
    @NotNull
    public final Response deleteBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdEnumFieldsBundle xdEnumFieldsBundle = this.getBundle(bundleName, true);
        if (xdEnumFieldsBundle == null) {
            Intrinsics.throwNpe();
        }
        Response response = ResponseUtil.deleted((Entity)xdEnumFieldsBundle.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.deleted(get\u2026ndleName, true)!!.entity)");
        return response;
    }

    @GET
    @Path(value="/{bundleName}/{fieldValue}")
    @NotNull
    public final EnumFieldBean getBundleNameFieldValue(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="fieldValue") @NotNull String fieldValue) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)fieldValue, (String)"fieldValue");
        IsLoggedInSecurityConstraint.check();
        XdEnumFieldsBundle xdEnumFieldsBundle = this.getBundle(bundleName, true);
        if (xdEnumFieldsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdEnumField xdEnumField = this.getField(xdEnumFieldsBundle, fieldValue, true);
        if (xdEnumField == null) {
            Intrinsics.throwNpe();
        }
        return new EnumFieldBean(xdEnumField);
    }

    @PUT
    @Path(value="/{bundleName}/{fieldValue}")
    @Consumes(value={"application/xml", "text/plain"})
    @NotNull
    public final Response putBundleNameFieldValue(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="fieldValue") @NotNull String fieldValue, @QueryParam(value="description") @Nullable String description, @QueryParam(value="colorIndex") @Nullable Integer colorIndex) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)fieldValue, (String)"fieldValue");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdEnumFieldsBundle xdEnumFieldsBundle = this.getBundle(bundleName, true);
        if (xdEnumFieldsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdEnumFieldsBundle bundle2 = xdEnumFieldsBundle;
        this.getField(bundle2, fieldValue, false);
        XdEnumField field2 = (XdEnumField)XdEnumField.Companion.new((Function1)new Function1<XdEnumField, Unit>(fieldValue, bundle2, description, colorIndex){
            final /* synthetic */ String $fieldValue;
            final /* synthetic */ XdEnumFieldsBundle $bundle;
            final /* synthetic */ String $description;
            final /* synthetic */ Integer $colorIndex;

            public final void invoke(@NotNull XdEnumField $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setName(this.$fieldValue);
                $receiver.setBundle(this.$bundle);
                $receiver.setDescription(this.$description);
                Integer n = this.$colorIndex;
                $receiver.setColorIndex(n != null ? n : 0);
            }
            {
                this.$fieldValue = string;
                this.$bundle = xdEnumFieldsBundle;
                this.$description = string2;
                this.$colorIndex = n;
                super(1);
            }
        });
        Response response = ResponseUtil.created((UrlUtil.Url)this.getUrl(field2));
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.created(getUrl(field))");
        return response;
    }

    @POST
    @Path(value="/{bundleName}/{fieldValue}")
    @NotNull
    public final Response postBundleNameFieldValue(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="fieldValue") @NotNull String fieldValue, @QueryParam(value="newValue") @Nullable String newValue, @QueryParam(value="description") @Nullable String description, @QueryParam(value="localizedName") @Nullable String localizedName, @QueryParam(value="colorIndex") @Nullable Integer colorIndex) {
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)fieldValue, (String)"fieldValue");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdEnumFieldsBundle xdEnumFieldsBundle = this.getBundle(bundleName, true);
        if (xdEnumFieldsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdEnumFieldsBundle bundle2 = xdEnumFieldsBundle;
        XdEnumField xdEnumField = this.getField(bundle2, fieldValue, true);
        if (xdEnumField == null) {
            Intrinsics.throwNpe();
        }
        XdEnumField field2 = xdEnumField;
        if (localizedName != null && (charSequence2 = (CharSequence)localizedName).length() > 0) {
            if (field2.canBeLocalized()) {
                field2.setLocalizedName(localizedName);
            } else {
                throw (Throwable)new BadRequestException("Field can't be localized");
            }
        }
        if (description != null) {
            field2.setDescription(description);
        }
        if (colorIndex != null) {
            field2.setColorIndex(colorIndex);
        }
        String oldValue = field2.getName();
        if (newValue != null && (charSequence = (CharSequence)newValue).length() > 0 && Intrinsics.areEqual((Object)newValue, (Object)oldValue) ^ true) {
            this.getField(bundle2, newValue, false);
            field2.setName(newValue);
        }
        Response response = ResponseUtil.updated((UrlUtil.Url)this.getUrl(field2), (String)oldValue, (String)newValue);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.updated(get\u2026eld), oldValue, newValue)");
        return response;
    }

    @DELETE
    @Path(value="/{bundleName}/{fieldValue}")
    @NotNull
    public final Response deleteBundleNameFieldValue(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="fieldValue") @NotNull String fieldValue) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)fieldValue, (String)"fieldValue");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdEnumFieldsBundle xdEnumFieldsBundle = this.getBundle(bundleName, true);
        if (xdEnumFieldsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdEnumField xdEnumField = this.getField(xdEnumFieldsBundle, fieldValue, true);
        if (xdEnumField == null) {
            Intrinsics.throwNpe();
        }
        Response response = ResponseUtil.deleted((Entity)xdEnumField.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.deleted(\n  \u2026 true)!!.entity\n        )");
        return response;
    }

    private final XdEnumFieldsBundle getBundle(String bundleName, boolean shouldExist) {
        XdEnumFieldsBundle bundle2 = (XdEnumFieldsBundle)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdEnumFieldsBundle.Companion), (Function2)((Function2)new Function2<FilteringContext, XdEnumFieldsBundle, Unit>(bundleName){
            final /* synthetic */ String $bundleName;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdEnumFieldsBundle it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$bundleName));
            }
            {
                this.$bundleName = string;
                super(2);
            }
        })));
        ResponseUtil.assertExist((String)"Enum bundle", (Object)((Object)bundle2), (String)bundleName, (boolean)shouldExist);
        return bundle2;
    }

    private final XdEnumField getField(XdEnumFieldsBundle bundle2, String fieldValue, boolean shouldExist) {
        XdField field2 = (XdField)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)bundle2.getChildren()), (Function2)((Function2)new Function2<FilteringContext, XdField, Unit>(fieldValue){
            final /* synthetic */ String $fieldValue;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdField it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$fieldValue));
            }
            {
                this.$fieldValue = string;
                super(2);
            }
        })));
        ResponseUtil.assertExist((String)"Enum bundle value", (Object)((Object)field2), (String)fieldValue, (boolean)shouldExist);
        return (XdEnumField)field2;
    }

    private final UrlUtil.Url getUrl(XdEnumField field2) {
        UrlUtil.Url url = UrlUtil.getRestPathUri((String[])new String[]{"admin", "customfield", "bundle"});
        String[] stringArray = new String[2];
        XdFieldBundle<? extends XdField> xdFieldBundle = field2.getBundle();
        if (xdFieldBundle == null) {
            Intrinsics.throwNpe();
        }
        stringArray[0] = xdFieldBundle.getName();
        stringArray[1] = field2.getName();
        UrlUtil.Url url2 = url.addPathElements(stringArray).addQueryParameters(new QueryParameter[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"UrlUtil.getRestPathUri(\"\u2026   ).addQueryParameters()");
        return url2;
    }
}

