/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.oldRest.versions;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.customfields.complex.common.RequireBundleIsAccessibleSecurityConstraint;
import jetbrains.charisma.customfields.oldRest.OldRestBundleServiceImplKt;
import jetbrains.charisma.customfields.oldRest.versions.OldRestVersionsBundleResource;
import jetbrains.charisma.customfields.oldRest.versions.ProjectVersionBean;
import jetbrains.charisma.customfields.oldRest.versions.ProjectVersionBundleBean;
import jetbrains.charisma.customfields.oldRest.versions.ProjectVersionBundleRef;
import jetbrains.charisma.customfields.persistence.fields.XdProjectVersion;
import jetbrains.charisma.customfields.persistence.fields.XdProjectVersionsBundle;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.RequireAdminOrCreateProjectPermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeFieldType;
import webr.framework.url.UrlUtil;

@Path(value="/admin/customfield/versionBundle")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u0017\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0007Ji\u0010\u0019\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\fH\u0007\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0011H\u0007JY\u0010$\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\f2\b\b\u0001\u0010 \u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Ljetbrains/charisma/customfields/oldRest/versions/OldRestVersionsBundleResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteBundleName", "Ljavax/ws/rs/core/Response;", "bundleName", "", "deleteBundleNameVersionName", "versionName", "findBundle", "Ljetbrains/charisma/customfields/persistence/fields/XdProjectVersionsBundle;", "shouldExist", "", "get", "", "Ljetbrains/charisma/customfields/oldRest/versions/ProjectVersionBundleRef;", "getBundleName", "Ljetbrains/charisma/customfields/oldRest/versions/ProjectVersionBundleBean;", "getBundleNameVersionName", "Ljetbrains/charisma/customfields/oldRest/versions/ProjectVersionBean;", "getVersion", "Ljetbrains/charisma/customfields/persistence/fields/XdProjectVersion;", "bundle", "postBundleName", "newName", "postBundleNameVersionName", "description", "colorIndex", "", "releaseDate", "", "released", "archived", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Boolean;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "put", "bundleBean", "putBundleNameVersionName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;ZZ)Ljavax/ws/rs/core/Response;", "charisma-customfields"})
public final class OldRestVersionsBundleResource
implements Resource {
    @GET
    @NotNull
    public final List<ProjectVersionBundleRef> get() {
        IsLoggedInSecurityConstraint.check();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdProjectVersionsBundle.Companion.all()), (Function1)get.1.INSTANCE), (Function1)get.2.INSTANCE));
    }

    @GET
    @Path(value="/{bundleName}")
    @NotNull
    public final ProjectVersionBundleBean getBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireBundleIsAccessibleSecurityConstraint.check(bundleName);
        return new ProjectVersionBundleBean(this.findBundle(bundleName, true));
    }

    /*
     * WARNING - void declaration
     */
    @PUT
    @Consumes(value={"application/xml"})
    @NotNull
    public final Response put(@NotNull ProjectVersionBundleBean bundleBean) {
        Intrinsics.checkParameterIsNotNull((Object)bundleBean, (String)"bundleBean");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        String string = bundleBean.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String bundleName = string;
        this.findBundle(bundleName, false);
        XdProjectVersionsBundle bundle2 = (XdProjectVersionsBundle)XdProjectVersionsBundle.Companion.new((Function1)new Function1<XdProjectVersionsBundle, Unit>(bundleName){
            final /* synthetic */ String $bundleName;

            public final void invoke(@NotNull XdProjectVersionsBundle $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setName(this.$bundleName);
            }
            {
                this.$bundleName = string;
                super(1);
            }
        });
        List<ProjectVersionBean> list = bundleBean.getVersion();
        if (list != null) {
            Iterable $receiver$iv = list;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void bean;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                ProjectVersionBean projectVersionBean = (ProjectVersionBean)item$iv;
                int index = n2;
                XdProjectVersion.Companion.new((Function1)new Function1<XdProjectVersion, Unit>((ProjectVersionBean)bean, index, bundle2){
                    final /* synthetic */ ProjectVersionBean $bean;
                    final /* synthetic */ int $index;
                    final /* synthetic */ XdProjectVersionsBundle $bundle$inlined;
                    {
                        this.$bean = projectVersionBean;
                        this.$index = n;
                        this.$bundle$inlined = xdProjectVersionsBundle;
                        super(1);
                    }

                    public final void invoke(@NotNull XdProjectVersion $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                        String string = this.$bean.getValue();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        $receiver.setName(string);
                        $receiver.setBundle(this.$bundle$inlined);
                        $receiver.setDescription(this.$bean.getDescription());
                        Integer n = this.$bean.getColorIndex();
                        $receiver.setColorIndex(n != null ? n : 0);
                        Boolean bl = this.$bean.getReleased();
                        $receiver.setArchived(bl != null ? bl : false);
                        Boolean bl2 = this.$bean.getReleased();
                        $receiver.setReleased(bl2 != null ? bl2 : false);
                        $receiver.setOrdinal(this.$index);
                        $receiver.setReleaseDate($receiver.getReleaseDate());
                    }
                });
            }
        }
        Response response = ResponseUtil.created((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(bundle2));
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.created(old\u2026dleService.urlOf(bundle))");
        return response;
    }

    @POST
    @Path(value="/{bundleName}")
    @NotNull
    public final Response postBundleName(@PathParam(value="bundleName") @NotNull String bundleName, @QueryParam(value="newName") @Nullable String newName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdProjectVersionsBundle xdProjectVersionsBundle = this.findBundle(bundleName, true);
        if (xdProjectVersionsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdProjectVersionsBundle bundle2 = xdProjectVersionsBundle;
        ResponseUtil.isRequired((String)"newName", (String)newName);
        String oldName = bundle2.getName();
        if (Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            String string = newName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.findBundle(string, false);
            bundle2.setName(newName);
        }
        Response response = ResponseUtil.updated((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(bundle2), (String)oldName, (String)newName);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.updated(old\u2026undle), oldName, newName)");
        return response;
    }

    @DELETE
    @Path(value="/{bundleName}")
    @NotNull
    public final Response deleteBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdProjectVersionsBundle xdProjectVersionsBundle = this.findBundle(bundleName, true);
        if (xdProjectVersionsBundle == null) {
            Intrinsics.throwNpe();
        }
        Response response = ResponseUtil.deleted((Entity)xdProjectVersionsBundle.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.deleted(fin\u2026ndleName, true)!!.entity)");
        return response;
    }

    @GET
    @Path(value="/{bundleName}/{versionName}")
    @NotNull
    public final ProjectVersionBean getBundleNameVersionName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="versionName") @NotNull String versionName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)versionName, (String)"versionName");
        IsLoggedInSecurityConstraint.check();
        XdProjectVersionsBundle xdProjectVersionsBundle = this.findBundle(bundleName, true);
        if (xdProjectVersionsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdProjectVersion xdProjectVersion = this.getVersion(xdProjectVersionsBundle, versionName, true);
        if (xdProjectVersion == null) {
            Intrinsics.throwNpe();
        }
        return new ProjectVersionBean(xdProjectVersion);
    }

    @PUT
    @Path(value="/{bundleName}/{versionName}")
    @NotNull
    public final Response putBundleNameVersionName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="versionName") @NotNull String versionName, @QueryParam(value="description") @Nullable String description, @QueryParam(value="colorIndex") @Nullable Integer colorIndex, @QueryParam(value="releaseDate") @Nullable Long releaseDate, @QueryParam(value="released") boolean released, @QueryParam(value="archived") boolean archived) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)versionName, (String)"versionName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdProjectVersionsBundle xdProjectVersionsBundle = this.findBundle(bundleName, true);
        if (xdProjectVersionsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdProjectVersionsBundle bundle2 = xdProjectVersionsBundle;
        this.getVersion(bundle2, versionName, false);
        XdProjectVersion.Companion.new((Function1)new Function1<XdProjectVersion, Unit>(bundle2, versionName, description, releaseDate, released, archived, colorIndex){
            final /* synthetic */ XdProjectVersionsBundle $bundle;
            final /* synthetic */ String $versionName;
            final /* synthetic */ String $description;
            final /* synthetic */ Long $releaseDate;
            final /* synthetic */ boolean $released;
            final /* synthetic */ boolean $archived;
            final /* synthetic */ Integer $colorIndex;

            public final void invoke(@NotNull XdProjectVersion $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                this.$bundle.getChildren().add((XdEntity)$receiver);
                $receiver.setName(this.$versionName);
                $receiver.setDescription(this.$description);
                $receiver.setReleaseDate(this.$releaseDate);
                $receiver.setReleased(this.$released);
                $receiver.setArchived(this.$archived);
                if (this.$colorIndex != null) {
                    $receiver.setColorIndex(this.$colorIndex);
                }
            }
            {
                this.$bundle = xdProjectVersionsBundle;
                this.$versionName = string;
                this.$description = string2;
                this.$releaseDate = l;
                this.$released = bl;
                this.$archived = bl2;
                this.$colorIndex = n;
                super(1);
            }
        });
        Response response = ResponseUtil.created((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(bundle2));
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.created(old\u2026dleService.urlOf(bundle))");
        return response;
    }

    @POST
    @Path(value="/{bundleName}/{versionName}")
    @NotNull
    public final Response postBundleNameVersionName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="versionName") @NotNull String versionName, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="description") @Nullable String description, @QueryParam(value="colorIndex") @Nullable Integer colorIndex, @QueryParam(value="releaseDate") @Nullable Long releaseDate, @QueryParam(value="released") @Nullable Boolean released, @QueryParam(value="archived") @Nullable Boolean archived) {
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)versionName, (String)"versionName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdProjectVersionsBundle xdProjectVersionsBundle = this.findBundle(bundleName, true);
        if (xdProjectVersionsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdProjectVersionsBundle bundle2 = xdProjectVersionsBundle;
        XdProjectVersion xdProjectVersion = this.getVersion(bundle2, versionName, true);
        if (xdProjectVersion == null) {
            Intrinsics.throwNpe();
        }
        XdProjectVersion version2 = xdProjectVersion;
        if (description != null && (charSequence2 = (CharSequence)description).length() > 0) {
            version2.setDescription(description);
        }
        if (DateTimeOperations.compare((Long)releaseDate, (CompareType)CompareType.NE, null, (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            version2.setReleaseDate(releaseDate);
        }
        if (released != null) {
            version2.setReleased(released);
        }
        if (archived != null) {
            version2.setArchived(archived);
        }
        if (colorIndex != null) {
            version2.setColorIndex(colorIndex);
        }
        String oldName = version2.getName();
        if (newName != null && (charSequence = (CharSequence)newName).length() > 0 && Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            this.getVersion(bundle2, newName, false);
            version2.setName(newName);
        }
        Response response = ResponseUtil.updated((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(bundle2), (String)oldName, (String)newName);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.updated(old\u2026undle), oldName, newName)");
        return response;
    }

    @DELETE
    @Path(value="/{bundleName}/{versionName}")
    @NotNull
    public final Response deleteBundleNameVersionName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="versionName") @NotNull String versionName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)versionName, (String)"versionName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdProjectVersionsBundle xdProjectVersionsBundle = this.findBundle(bundleName, true);
        if (xdProjectVersionsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdProjectVersion xdProjectVersion = this.getVersion(xdProjectVersionsBundle, versionName, true);
        if (xdProjectVersion == null) {
            Intrinsics.throwNpe();
        }
        Response response = ResponseUtil.deleted((Entity)xdProjectVersion.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.deleted(get\u2026sionName, true)!!.entity)");
        return response;
    }

    private final XdProjectVersionsBundle findBundle(String bundleName, boolean shouldExist) {
        XdProjectVersionsBundle bundle2 = (XdProjectVersionsBundle)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdProjectVersionsBundle.Companion), (Function2)((Function2)new Function2<FilteringContext, XdProjectVersionsBundle, Unit>(bundleName){
            final /* synthetic */ String $bundleName;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdProjectVersionsBundle it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$bundleName));
            }
            {
                this.$bundleName = string;
                super(2);
            }
        })));
        ResponseUtil.assertExist((String)"Version bundle", (Object)((Object)bundle2), (String)bundleName, (boolean)shouldExist);
        return bundle2;
    }

    private final XdProjectVersion getVersion(XdProjectVersionsBundle bundle2, String versionName, boolean shouldExist) {
        XdProjectVersion field2;
        XdProjectVersion xdProjectVersion = field2 = (XdProjectVersion)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdQueryKt.filterIsInstance((XdQuery)((XdQuery)bundle2.getChildren()), (XdEntityType)((XdEntityType)XdProjectVersion.Companion)), (Function2)((Function2)new Function2<FilteringContext, XdProjectVersion, Unit>(versionName){
            final /* synthetic */ String $versionName;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdProjectVersion it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$versionName));
            }
            {
                this.$versionName = string;
                super(2);
            }
        })));
        ResponseUtil.assertExist((String)"State field", (Object)(xdProjectVersion != null ? xdProjectVersion.getEntity() : null), (String)versionName, (boolean)shouldExist);
        return field2;
    }
}

