cr.setTemplateBind("FloatEditor", function (path) {
  cr.ach(path, "floatValue", "keydown", function (event, data) {
    return event.handleEnterEsc(function () {
      var value = parseFloat(cr.findInHandler(event, "" + "." + "floatValue", []).value);
      if (isNaN(value)) {
        cr.findInHandler(event, "" + "." + "floatValue", []).highlight(l10n('${l10n("FloatEditor.Float_value_expected")}'));
      } else {
        cr.findInHandler(event, "" + "." + "floatValue", []).value = value;
        cr.findInHandler(event, "" + "." + "floatContentInlineEditor", []).submit();
      }

    }, function () {
      cr.findInHandler(event, "" + "." + "floatContentInlineEditor", []).abort();
    });
  });
  cr.ach(path, "clearValue", "click", function (event, data) {
    //Prevent bubbling
    return false;
  });
  cr.ach(path, "floatContentInlineEditor", "createeditor", function (event, data) {
    $(cr.findInHandler(event, "" + "." + "floatField", [])).addClass("cf-edit");
    $(cr.findInHandler(event, "" + "." + "floatField", [])).parent().addClass("cf-visible");
  });
  cr.ach(path, "floatContentInlineEditor", "abort", function (event, data) {
    $(cr.findInHandler(event, "" + "." + "floatField", [])).removeClass("cf-edit");
    $(cr.findInHandler(event, "" + "." + "floatField", [])).parent().removeClass("cf-visible");
  });
  cr.ach(path, "floatContentInlineEditor", "submit", function (event, data) {
    $(cr.findInHandler(event, "" + "." + "floatField", [])).removeClass("cf-edit");
    $(cr.findInHandler(event, "" + "." + "floatField", [])).parent().removeClass("cf-visible");
  });
  cr.ash(path, "clearValue", "click", null);
  cr.ash(path, "floatContentInlineEditor", "createeditor", {preventDoubleSubmit: true});
  cr.ash(path, "floatContentInlineEditor", "submit", {preventDoubleSubmit: true});
  regic(path, "floatContentInlineEditor");
});
